/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.policy.deployment.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import weblogic.management.ManagementException;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.jmx.MBeanServerInvocationHandler;
import weblogic.management.mbeanservers.domainruntime.DomainRuntimeServiceMBean;
import weblogic.management.mbeanservers.edit.ConfigurationManagerMBean;
import weblogic.management.mbeanservers.edit.EditServiceMBean;
import weblogic.management.runtime.DomainRuntimeMBean;
import weblogic.management.runtime.ServerRuntimeMBean;

public class MBeanUtils {
    private static MBeanServerConnection domainEditMBeanServerConnection = null;
    private static MBeanServerConnection domainRuntimeMBeanServerConnection = null;
    private static DomainMBean domainMBean = null;
    private static ConfigurationManagerMBean configurationManagerMBean = null;
    private static DomainRuntimeMBean domainRuntimeMBean = null;
    private static int cachedListenPort = 7001;
    private static String cachedProtocol = null;
    private static String cachedHost = null;
    private static String cachedUser = null;
    private static String cachedUserPassword = null;
    private static String serverTimeout = "240";

    public static ServerRuntimeMBean getServerRuntimeMBean(String string) throws InstanceNotFoundException, ManagementException {
        try {
            ServerRuntimeMBean serverRuntimeMBean = MBeanUtils.getDomainRuntimeServiceMBean().lookupServerRuntime(string);
            return MBeanUtils.isCallableServerRuntimeMBean(serverRuntimeMBean) ? serverRuntimeMBean : null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static boolean isCallableServerRuntimeMBean(ServerRuntimeMBean serverRuntimeMBean) {
        if (serverRuntimeMBean != null) {
            try {
                serverRuntimeMBean.getCurrentDirectory();
                return true;
            }
            catch (Throwable throwable) {
                return false;
            }
        }
        return false;
    }

    public static DomainRuntimeServiceMBean getDomainRuntimeServiceMBean() throws ManagementException {
        DomainRuntimeServiceMBean domainRuntimeServiceMBean = null;
        if (domainRuntimeServiceMBean == null) {
            try {
                MBeanServerConnection mBeanServerConnection = MBeanUtils.getDomainRuntimeMBeanServerConnection();
                domainRuntimeServiceMBean = (DomainRuntimeServiceMBean)MBeanServerInvocationHandler.newProxyInstance((MBeanServerConnection)mBeanServerConnection, (ObjectName)new ObjectName(DomainRuntimeServiceMBean.OBJECT_NAME), DomainRuntimeServiceMBean.class, (boolean)false);
            }
            catch (IOException iOException) {
                throw new ManagementException("Domain Runtime MBean Server is not enabled. You will need to enable it through the JMXMBean.");
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                throw new ManagementException((Throwable)malformedObjectNameException);
            }
            catch (Throwable throwable) {
                throw new ManagementException(throwable);
            }
        }
        if (domainRuntimeServiceMBean == null) {
            throw new ManagementException("DomainRuntimeService is not enabled. You will need to enable it through the JMXMBean.");
        }
        return domainRuntimeServiceMBean;
    }

    public static MBeanServerConnection getDomainRuntimeMBeanServerConnection() throws IOException {
        if (domainRuntimeMBeanServerConnection == null) {
            domainRuntimeMBeanServerConnection = MBeanUtils.lookupMBeanServerConnection("weblogic.management.mbeanservers.domainruntime");
        }
        return domainRuntimeMBeanServerConnection;
    }

    public static EditServiceMBean getEditServiceMBean() throws IOException, ManagementException {
        EditServiceMBean editServiceMBean = null;
        if (editServiceMBean == null) {
            try {
                MBeanServerConnection mBeanServerConnection = MBeanUtils.getDomainEditMBeanServerConnection();
                editServiceMBean = (EditServiceMBean)MBeanServerInvocationHandler.newProxyInstance((MBeanServerConnection)mBeanServerConnection, (ObjectName)new ObjectName(EditServiceMBean.OBJECT_NAME), EditServiceMBean.class, (boolean)false);
            }
            catch (IOException iOException) {
                throw new ManagementException("Edit Server is not enabled. You will need to enable it through the JMXMBean.");
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                throw new ManagementException((Throwable)malformedObjectNameException);
            }
            catch (Throwable throwable) {
                throw new ManagementException(throwable);
            }
        }
        if (editServiceMBean == null) {
            throw new ManagementException("Edit Server is not enabled. You will need to enable it through the JMXMBean.");
        }
        return editServiceMBean;
    }

    private static MBeanServerConnection getDomainEditMBeanServerConnection() throws IOException {
        if (domainEditMBeanServerConnection == null) {
            domainEditMBeanServerConnection = MBeanUtils.lookupMBeanServerConnection("weblogic.management.mbeanservers.edit");
        }
        return domainEditMBeanServerConnection;
    }

    private static MBeanServerConnection lookupMBeanServerConnection(String string) throws IOException {
        int n = 7001;
        String string2 = "localhost";
        String string3 = "wlx";
        if (cachedListenPort != 7001) {
            n = cachedListenPort;
        }
        if (cachedHost != null) {
            string2 = cachedHost;
        }
        if (cachedProtocol != null) {
            string3 = cachedProtocol;
        }
        JMXServiceURL jMXServiceURL = new JMXServiceURL(string3, string2, n, "/jndi/" + string);
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("jmx.remote.protocol.provider.pkgs", "weblogic.management.remote");
        if (cachedUser != null) {
            hashtable.put("java.naming.security.principal", cachedUser);
        }
        if (cachedUserPassword != null) {
            hashtable.put("java.naming.security.credentials", cachedUserPassword);
        }
        long l = Long.parseLong(serverTimeout);
        hashtable.put("jmx.remote.x.request.waiting.timeout", new Long(l *= 1000L));
        JMXConnector jMXConnector = JMXConnectorFactory.connect(jMXServiceURL, hashtable);
        return jMXConnector.getMBeanServerConnection();
    }

    public static DomainMBean getDomainMBean() throws IOException, ManagementException {
        if (domainMBean == null && (domainMBean = MBeanUtils.getEditServiceMBean().getDomainConfiguration()) == null) {
            throw new ManagementException("No DomainMBean is available for this domain. You will need to correct the configuration before continuing.");
        }
        return domainMBean;
    }

    public static ServerRuntimeMBean[] getServerRuntimeMBeans() throws ManagementException {
        ArrayList<ServerRuntimeMBean> arrayList = new ArrayList<ServerRuntimeMBean>();
        for (ServerRuntimeMBean serverRuntimeMBean : MBeanUtils.getDomainRuntimeServiceMBean().getServerRuntimes()) {
            if (!MBeanUtils.isCallableServerRuntimeMBean(serverRuntimeMBean)) continue;
            arrayList.add(serverRuntimeMBean);
        }
        return arrayList.toArray(new ServerRuntimeMBean[arrayList.size()]);
    }

    public static ConfigurationManagerMBean getConfigurationManagerMBean() throws ManagementException {
        if (configurationManagerMBean == null) {
            try {
                configurationManagerMBean = MBeanUtils.getEditServiceMBean().getConfigurationManager();
            }
            catch (IOException iOException) {
                throw new ManagementException((Throwable)iOException);
            }
        }
        return configurationManagerMBean;
    }

    public static DomainRuntimeMBean getDomainRuntimeMBean() throws ManagementException {
        if (domainRuntimeMBean == null) {
            domainRuntimeMBean = MBeanUtils.getDomainRuntimeServiceMBean().getDomainRuntime();
        }
        return domainRuntimeMBean;
    }
}

