/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.policy.deployment.config;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.deploy.model.exceptions.DDBeanCreateException;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceProvider;
import weblogic.deploy.api.model.WebLogicDeployableObject;
import weblogic.deploy.api.spi.DeploymentOptions;
import weblogic.deploy.api.spi.WebLogicDeploymentConfiguration;
import weblogic.deploy.api.spi.WebLogicDeploymentManager;
import weblogic.deploy.api.tools.DeployableObjectInfo;
import weblogic.j2ee.descriptor.EjbJarBean;
import weblogic.j2ee.descriptor.ServletBean;
import weblogic.j2ee.descriptor.WebAppBean;
import weblogic.j2ee.descriptor.WebservicesBean;
import weblogic.j2ee.descriptor.wl.OperationPolicyBean;
import weblogic.j2ee.descriptor.wl.OwsmPolicyBean;
import weblogic.j2ee.descriptor.wl.OwsmSecurityPolicyBean;
import weblogic.j2ee.descriptor.wl.PortInfoBean;
import weblogic.j2ee.descriptor.wl.PortPolicyBean;
import weblogic.j2ee.descriptor.wl.PropertyNamevalueBean;
import weblogic.j2ee.descriptor.wl.ServiceReferenceDescriptionBean;
import weblogic.j2ee.descriptor.wl.WebservicePolicyRefBean;
import weblogic.j2ee.descriptor.wl.WsPolicyBean;
import weblogic.jws.Policies;
import weblogic.jws.Policy;
import weblogic.management.ManagementException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.mbeanservers.edit.ActivationTaskMBean;
import weblogic.management.mbeanservers.edit.ConfigurationManagerMBean;
import weblogic.management.runtime.AppRuntimeStateRuntimeMBean;
import weblogic.management.runtime.DeployerRuntimeMBean;
import weblogic.management.runtime.DeploymentTaskRuntimeMBean;
import weblogic.management.runtime.DomainRuntimeMBean;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.wsee.jws.jaxws.owsm.SecurityPolicies;
import weblogic.wsee.jws.jaxws.owsm.SecurityPolicy;
import weblogic.wsee.policy.deployment.PolicyDeployUtils;
import weblogic.wsee.policy.deployment.WseePolicyReferenceInfo;
import weblogic.wsee.policy.deployment.config.DeploymentConfigurationHelper;
import weblogic.wsee.policy.deployment.config.DeploymentConfigurationManager;
import weblogic.wsee.policy.deployment.config.MBeanUtils;
import weblogic.wsee.policy.deployment.config.PolicyManagementException;
import weblogic.wsee.policy.deployment.config.PolicySubject;
import weblogic.wsee.policy.deployment.config.WebServiceBeanUtils;
import weblogic.wsee.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicyDescriptorUtils {
    String host;
    String port;
    private static final String BOTH = "both";
    private static final String IN = "inbound";
    private static final String OUT = "outbound";
    private static final String ENABLED = "enabled";
    private static final String DISABLED = "disabled";
    private static final String DELETED = "deleted";
    private static final String OWSM = "owsm-security";
    private static final String WLS = "ws-policy";
    private static final Object configLock = new Object();
    private static Map<String, Lock> usedLocks = new HashMap<String, Lock>();
    private static List<Lock> unusedLocks = new ArrayList<Lock>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WseePolicyReferenceInfo[] getPolicyReferenceInfos(String string) throws ManagementException, PolicyManagementException, ConfigurationException {
        Object object;
        PolicySubject policySubject = PolicyDescriptorUtils.parsePolicySubject(string);
        Map<String, WseePolicyReferenceInfo> map = null;
        Object object2 = object = PolicyDescriptorUtils.getLock(PolicyDescriptorUtils.getAppName(policySubject));
        synchronized (object2) {
            map = PolicyDescriptorUtils.isClientType(policySubject) ? PolicyDescriptorUtils.getClientPolicyReferenceInfos(policySubject) : PolicyDescriptorUtils.getServicePolicyReferenceInfos(policySubject);
        }
        PolicyDescriptorUtils.releaseLock(PolicyDescriptorUtils.getAppName(policySubject), object);
        return map.values().toArray(new WseePolicyReferenceInfo[map.size()]);
    }

    private static Map<String, WseePolicyReferenceInfo> getClientPolicyReferenceInfos(PolicySubject policySubject) throws PolicyManagementException, ManagementException {
        if (PolicyDescriptorUtils.isOperationType(policySubject)) {
            throw new PolicyManagementException("Operation level policy management is not supported for clients.");
        }
        DeploymentConfigurationHelper deploymentConfigurationHelper = PolicyDescriptorUtils.getDCH(PolicyDescriptorUtils.getAppName(policySubject));
        ServiceReferenceDescriptionBean serviceReferenceDescriptionBean = PolicyDescriptorUtils.getServiceRefDescriptor(PolicyDescriptorUtils.getModuleName(policySubject), PolicyDescriptorUtils.getEJBName(policySubject), PolicyDescriptorUtils.getServiceRefName(policySubject), deploymentConfigurationHelper);
        return PolicyDescriptorUtils.getPolicies(PolicyDescriptorUtils.getSubjectName(policySubject), serviceReferenceDescriptionBean);
    }

    private static Map<String, WseePolicyReferenceInfo> getServicePolicyReferenceInfos(PolicySubject policySubject) throws ManagementException, PolicyManagementException, ConfigurationException {
        DeploymentConfigurationHelper deploymentConfigurationHelper = PolicyDescriptorUtils.getDCH(PolicyDescriptorUtils.getAppName(policySubject));
        Class clazz = PolicyDescriptorUtils.getServiceClass(PolicyDescriptorUtils.getModuleName(policySubject), PolicyDescriptorUtils.getServiceName(policySubject), PolicyDescriptorUtils.getPortName(policySubject), deploymentConfigurationHelper);
        WebservicePolicyRefBean webservicePolicyRefBean = PolicyDescriptorUtils.getPolicyDescriptor(PolicyDescriptorUtils.getModuleName(policySubject), deploymentConfigurationHelper);
        return PolicyDescriptorUtils.getPolicies(PolicyDescriptorUtils.getSubjectName(policySubject), PolicyDescriptorUtils.isOperationType(policySubject), clazz, webservicePolicyRefBean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPolicyReferenceInfos(String string, WseePolicyReferenceInfo[] wseePolicyReferenceInfoArray) throws ManagementException, PolicyManagementException, ConfigurationException, IOException {
        Object object;
        if (wseePolicyReferenceInfoArray == null || wseePolicyReferenceInfoArray.length == 0) {
            return;
        }
        PolicySubject policySubject = PolicyDescriptorUtils.parsePolicySubject(string);
        Object object2 = object = PolicyDescriptorUtils.getLock(PolicyDescriptorUtils.getAppName(policySubject));
        synchronized (object2) {
            DeploymentConfigurationHelper deploymentConfigurationHelper = PolicyDescriptorUtils.getDCH(PolicyDescriptorUtils.getAppName(policySubject));
            if (PolicyDescriptorUtils.isClientType(policySubject)) {
                PolicyDescriptorUtils.setClientPolicyReferenceInfos(policySubject, wseePolicyReferenceInfoArray, deploymentConfigurationHelper);
            } else {
                PolicyDescriptorUtils.setServicePolicyReferenceInfos(policySubject, wseePolicyReferenceInfoArray, deploymentConfigurationHelper);
            }
            PolicyDescriptorUtils.save(PolicyDescriptorUtils.getAppName(policySubject), deploymentConfigurationHelper);
        }
        PolicyDescriptorUtils.releaseLock(PolicyDescriptorUtils.getAppName(policySubject), object);
    }

    private static void setClientPolicyReferenceInfos(PolicySubject policySubject, WseePolicyReferenceInfo[] wseePolicyReferenceInfoArray, DeploymentConfigurationHelper deploymentConfigurationHelper) throws PolicyManagementException, ManagementException {
        if (PolicyDescriptorUtils.isOperationType(policySubject)) {
            throw new PolicyManagementException("Operation level policy management is not supported for clients.");
        }
        ServiceReferenceDescriptionBean serviceReferenceDescriptionBean = PolicyDescriptorUtils.getServiceRefDescriptor(PolicyDescriptorUtils.getModuleName(policySubject), PolicyDescriptorUtils.getEJBName(policySubject), PolicyDescriptorUtils.getServiceRefName(policySubject), deploymentConfigurationHelper);
        Map<String, WseePolicyReferenceInfo> map = PolicyDescriptorUtils.getPolicies(PolicyDescriptorUtils.getSubjectName(policySubject), serviceReferenceDescriptionBean);
        for (String string : map.keySet()) {
            WseePolicyReferenceInfo wseePolicyReferenceInfo = map.get(string);
            if (wseePolicyReferenceInfo.getStatus().equals(DELETED)) continue;
            PolicyDescriptorUtils.remove(string, map, serviceReferenceDescriptionBean, PolicyDescriptorUtils.getSubjectName(policySubject));
        }
        for (int i = 0; i < wseePolicyReferenceInfoArray.length; ++i) {
            PolicyDescriptorUtils.attach(wseePolicyReferenceInfoArray[i], map, serviceReferenceDescriptionBean, PolicyDescriptorUtils.getSubjectName(policySubject));
        }
    }

    private static void setServicePolicyReferenceInfos(PolicySubject policySubject, WseePolicyReferenceInfo[] wseePolicyReferenceInfoArray, DeploymentConfigurationHelper deploymentConfigurationHelper) throws ManagementException, PolicyManagementException, ConfigurationException {
        Class clazz = PolicyDescriptorUtils.getServiceClass(PolicyDescriptorUtils.getModuleName(policySubject), PolicyDescriptorUtils.getServiceName(policySubject), PolicyDescriptorUtils.getPortName(policySubject), deploymentConfigurationHelper);
        WebservicePolicyRefBean webservicePolicyRefBean = PolicyDescriptorUtils.getPolicyDescriptor(PolicyDescriptorUtils.getModuleName(policySubject), deploymentConfigurationHelper);
        Map<String, WseePolicyReferenceInfo> map = PolicyDescriptorUtils.getPolicies(PolicyDescriptorUtils.getSubjectName(policySubject), PolicyDescriptorUtils.isOperationType(policySubject), clazz, webservicePolicyRefBean);
        String string = null;
        string = PolicyDescriptorUtils.getServiceLink(policySubject, deploymentConfigurationHelper);
        for (String string2 : map.keySet()) {
            WseePolicyReferenceInfo wseePolicyReferenceInfo = map.get(string2);
            if (wseePolicyReferenceInfo.getStatus().equals(DELETED)) continue;
            PolicyDescriptorUtils.remove(string2, map, webservicePolicyRefBean, clazz, PolicyDescriptorUtils.getSubjectName(policySubject), PolicyDescriptorUtils.isOperationType(policySubject), string);
        }
        for (int i = 0; i < wseePolicyReferenceInfoArray.length; ++i) {
            PolicyDescriptorUtils.attach(wseePolicyReferenceInfoArray[i], map, PolicyDescriptorUtils.getPolicies(PolicyDescriptorUtils.getSubjectName(policySubject), PolicyDescriptorUtils.isOperationType(policySubject), clazz), webservicePolicyRefBean, PolicyDescriptorUtils.getSubjectName(policySubject), PolicyDescriptorUtils.isOperationType(policySubject), string);
        }
    }

    public void setPolicyReferenceInfos(String string, WseePolicyReferenceInfo[] wseePolicyReferenceInfoArray, String string2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPolicyReferenceInfo(String string, WseePolicyReferenceInfo wseePolicyReferenceInfo) throws ManagementException, PolicyManagementException, ConfigurationException, IOException {
        Object object;
        PolicySubject policySubject = PolicyDescriptorUtils.parsePolicySubject(string);
        Object object2 = object = PolicyDescriptorUtils.getLock(PolicyDescriptorUtils.getAppName(policySubject));
        synchronized (object2) {
            DeploymentConfigurationHelper deploymentConfigurationHelper = PolicyDescriptorUtils.getDCH(PolicyDescriptorUtils.getAppName(policySubject));
            if (PolicyDescriptorUtils.isClientType(policySubject)) {
                PolicyDescriptorUtils.removeClientPolicyReference(wseePolicyReferenceInfo.getUri(), policySubject, deploymentConfigurationHelper);
                PolicyDescriptorUtils.attachClientPolicyReference(policySubject, wseePolicyReferenceInfo, deploymentConfigurationHelper);
            } else {
                PolicyDescriptorUtils.removeServicePolicyReference(wseePolicyReferenceInfo.getUri(), policySubject, deploymentConfigurationHelper);
                PolicyDescriptorUtils.attachServicePolicyReference(wseePolicyReferenceInfo, policySubject, deploymentConfigurationHelper);
            }
            PolicyDescriptorUtils.save(PolicyDescriptorUtils.getAppName(policySubject), deploymentConfigurationHelper);
        }
        PolicyDescriptorUtils.releaseLock(PolicyDescriptorUtils.getAppName(policySubject), object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void attachPolicyReference(String string, WseePolicyReferenceInfo wseePolicyReferenceInfo) throws ManagementException, PolicyManagementException, ConfigurationException, IOException {
        Object object;
        PolicySubject policySubject = PolicyDescriptorUtils.parsePolicySubject(string);
        Object object2 = object = PolicyDescriptorUtils.getLock(PolicyDescriptorUtils.getAppName(policySubject));
        synchronized (object2) {
            DeploymentConfigurationHelper deploymentConfigurationHelper = PolicyDescriptorUtils.getDCH(PolicyDescriptorUtils.getAppName(policySubject));
            if (PolicyDescriptorUtils.isClientType(policySubject)) {
                PolicyDescriptorUtils.attachClientPolicyReference(policySubject, wseePolicyReferenceInfo, deploymentConfigurationHelper);
            } else {
                PolicyDescriptorUtils.attachServicePolicyReference(wseePolicyReferenceInfo, policySubject, deploymentConfigurationHelper);
            }
            PolicyDescriptorUtils.save(PolicyDescriptorUtils.getAppName(policySubject), deploymentConfigurationHelper);
        }
        PolicyDescriptorUtils.releaseLock(PolicyDescriptorUtils.getAppName(policySubject), object);
    }

    private static void attachClientPolicyReference(PolicySubject policySubject, WseePolicyReferenceInfo wseePolicyReferenceInfo, DeploymentConfigurationHelper deploymentConfigurationHelper) throws PolicyManagementException, ManagementException {
        if (PolicyDescriptorUtils.isOperationType(policySubject)) {
            throw new PolicyManagementException("Operation level policy management is not supported for clients.");
        }
        ServiceReferenceDescriptionBean serviceReferenceDescriptionBean = PolicyDescriptorUtils.getServiceRefDescriptor(PolicyDescriptorUtils.getModuleName(policySubject), PolicyDescriptorUtils.getEJBName(policySubject), PolicyDescriptorUtils.getServiceRefName(policySubject), deploymentConfigurationHelper);
        Map<String, WseePolicyReferenceInfo> map = PolicyDescriptorUtils.getPolicies(PolicyDescriptorUtils.getSubjectName(policySubject), serviceReferenceDescriptionBean);
        PolicyDescriptorUtils.attach(wseePolicyReferenceInfo, map, serviceReferenceDescriptionBean, PolicyDescriptorUtils.getSubjectName(policySubject));
    }

    private static void attachServicePolicyReference(WseePolicyReferenceInfo wseePolicyReferenceInfo, PolicySubject policySubject, DeploymentConfigurationHelper deploymentConfigurationHelper) throws ManagementException, PolicyManagementException, ConfigurationException {
        Class clazz = PolicyDescriptorUtils.getServiceClass(PolicyDescriptorUtils.getModuleName(policySubject), PolicyDescriptorUtils.getServiceName(policySubject), PolicyDescriptorUtils.getPortName(policySubject), deploymentConfigurationHelper);
        WebservicePolicyRefBean webservicePolicyRefBean = PolicyDescriptorUtils.getPolicyDescriptor(PolicyDescriptorUtils.getModuleName(policySubject), deploymentConfigurationHelper);
        Map<String, WseePolicyReferenceInfo> map = PolicyDescriptorUtils.getPolicies(PolicyDescriptorUtils.getSubjectName(policySubject), PolicyDescriptorUtils.isOperationType(policySubject), clazz, webservicePolicyRefBean);
        PolicyDescriptorUtils.attach(wseePolicyReferenceInfo, map, PolicyDescriptorUtils.getPolicies(PolicyDescriptorUtils.getSubjectName(policySubject), PolicyDescriptorUtils.isOperationType(policySubject), clazz), webservicePolicyRefBean, PolicyDescriptorUtils.getSubjectName(policySubject), PolicyDescriptorUtils.isOperationType(policySubject), PolicyDescriptorUtils.getServiceLink(policySubject, deploymentConfigurationHelper));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void save(String string, DeploymentConfigurationHelper deploymentConfigurationHelper) throws ManagementException, IOException, ConfigurationException, PolicyManagementException {
        AppDeploymentMBean appDeploymentMBean = DeploymentConfigurationHelper.getAppDeploymentMBean(string);
        ConfigurationManagerMBean configurationManagerMBean = MBeanUtils.getConfigurationManagerMBean();
        Object object = configLock;
        synchronized (object) {
            int n = !configurationManagerMBean.haveUnactivatedChanges() ? 10000 : -1;
            MBeanUtils.getConfigurationManagerMBean().startEdit(-1, n);
            String string2 = deploymentConfigurationHelper.getPlanPath();
            if (deploymentConfigurationHelper.isNewPlan()) {
                String string3 = deploymentConfigurationHelper.getSourcePath();
                File file = new File(string3);
                while (file.getParent() != null && PolicyDescriptorUtils.noSelectableContents(file)) {
                    file = file.getParentFile();
                }
                string2 = file.getPath() + File.separator + "Plan.xml";
                deploymentConfigurationHelper.setPlanPath(string2);
            }
            deploymentConfigurationHelper.save();
            PolicyDescriptorUtils.updateConfig(appDeploymentMBean, string2);
        }
    }

    private static void updateConfig(AppDeploymentMBean appDeploymentMBean, String string) throws ManagementException, PolicyManagementException {
        PolicyDescriptorUtils.redeployPlan(appDeploymentMBean, string);
        MBeanUtils.getConfigurationManagerMBean().save();
        boolean bl = false;
        long l = bl ? 0L : -1L;
        ActivationTaskMBean activationTaskMBean = MBeanUtils.getConfigurationManagerMBean().activate(l);
        Exception exception = activationTaskMBean.getError();
        if (exception != null) {
            throw new PolicyManagementException("Could not activate plan: " + exception.getMessage());
        }
    }

    private static boolean noSelectableContents(File file) {
        if (file.isDirectory() && !file.isHidden()) {
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                return true;
            }
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (!file2.isDirectory() || file2.isHidden()) continue;
                return false;
            }
        }
        return true;
    }

    public void attachPolicyReference(String string, WseePolicyReferenceInfo wseePolicyReferenceInfo, String string2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removePolicyReference(String string, String string2) throws ManagementException, PolicyManagementException, ConfigurationException, IOException {
        Object object;
        PolicySubject policySubject = PolicyDescriptorUtils.parsePolicySubject(string);
        Object object2 = object = PolicyDescriptorUtils.getLock(PolicyDescriptorUtils.getAppName(policySubject));
        synchronized (object2) {
            DeploymentConfigurationHelper deploymentConfigurationHelper = PolicyDescriptorUtils.getDCH(PolicyDescriptorUtils.getAppName(policySubject));
            if (PolicyDescriptorUtils.isClientType(policySubject)) {
                PolicyDescriptorUtils.removeClientPolicyReference(string2, policySubject, deploymentConfigurationHelper);
            } else {
                PolicyDescriptorUtils.removeServicePolicyReference(string2, policySubject, deploymentConfigurationHelper);
            }
            PolicyDescriptorUtils.save(PolicyDescriptorUtils.getAppName(policySubject), deploymentConfigurationHelper);
        }
        PolicyDescriptorUtils.releaseLock(PolicyDescriptorUtils.getAppName(policySubject), object);
    }

    private static void removeClientPolicyReference(String string, PolicySubject policySubject, DeploymentConfigurationHelper deploymentConfigurationHelper) throws PolicyManagementException, ManagementException {
        if (PolicyDescriptorUtils.isOperationType(policySubject)) {
            throw new PolicyManagementException("Operation level policy management is not supported for clients.");
        }
        ServiceReferenceDescriptionBean serviceReferenceDescriptionBean = PolicyDescriptorUtils.getServiceRefDescriptor(PolicyDescriptorUtils.getModuleName(policySubject), PolicyDescriptorUtils.getEJBName(policySubject), PolicyDescriptorUtils.getServiceRefName(policySubject), deploymentConfigurationHelper);
        Map<String, WseePolicyReferenceInfo> map = PolicyDescriptorUtils.getPolicies(PolicyDescriptorUtils.getSubjectName(policySubject), serviceReferenceDescriptionBean);
        PolicyDescriptorUtils.remove(string, map, serviceReferenceDescriptionBean, PolicyDescriptorUtils.getSubjectName(policySubject));
    }

    private static void removeServicePolicyReference(String string, PolicySubject policySubject, DeploymentConfigurationHelper deploymentConfigurationHelper) throws ManagementException, PolicyManagementException, ConfigurationException {
        Class clazz = PolicyDescriptorUtils.getServiceClass(PolicyDescriptorUtils.getModuleName(policySubject), PolicyDescriptorUtils.getServiceName(policySubject), PolicyDescriptorUtils.getPortName(policySubject), deploymentConfigurationHelper);
        WebservicePolicyRefBean webservicePolicyRefBean = PolicyDescriptorUtils.getPolicyDescriptor(PolicyDescriptorUtils.getModuleName(policySubject), deploymentConfigurationHelper);
        Map<String, WseePolicyReferenceInfo> map = PolicyDescriptorUtils.getPolicies(PolicyDescriptorUtils.getSubjectName(policySubject), PolicyDescriptorUtils.isOperationType(policySubject), clazz, webservicePolicyRefBean);
        PolicyDescriptorUtils.remove(string, map, webservicePolicyRefBean, clazz, PolicyDescriptorUtils.getSubjectName(policySubject), PolicyDescriptorUtils.isOperationType(policySubject), PolicyDescriptorUtils.getServiceLink(policySubject, deploymentConfigurationHelper));
    }

    public void removePolicyReference(String string, String string2, String string3) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPolicyRefStatus(String string, String string2) throws ManagementException, PolicyManagementException, ConfigurationException {
        Object object;
        PolicySubject policySubject = PolicyDescriptorUtils.parsePolicySubject(string);
        WseePolicyReferenceInfo wseePolicyReferenceInfo = null;
        Object object2 = object = PolicyDescriptorUtils.getLock(PolicyDescriptorUtils.getAppName(policySubject));
        synchronized (object2) {
            Map<String, WseePolicyReferenceInfo> map = null;
            map = PolicyDescriptorUtils.isClientType(policySubject) ? PolicyDescriptorUtils.getClientPolicyReferenceInfos(policySubject) : PolicyDescriptorUtils.getServicePolicyReferenceInfos(policySubject);
            wseePolicyReferenceInfo = map.get(string2);
        }
        PolicyDescriptorUtils.releaseLock(PolicyDescriptorUtils.getAppName(policySubject), object);
        return wseePolicyReferenceInfo == null ? null : wseePolicyReferenceInfo.getStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPolicyRefStatus(String string, String string2, boolean bl) throws ManagementException, PolicyManagementException, ConfigurationException, IOException {
        Object object;
        PolicySubject policySubject = PolicyDescriptorUtils.parsePolicySubject(string);
        Object object2 = object = PolicyDescriptorUtils.getLock(PolicyDescriptorUtils.getAppName(policySubject));
        synchronized (object2) {
            DeploymentConfigurationHelper deploymentConfigurationHelper = PolicyDescriptorUtils.getDCH(PolicyDescriptorUtils.getAppName(policySubject));
            if (PolicyDescriptorUtils.isClientType(policySubject)) {
                PolicyDescriptorUtils.setClientPolicyRefStatus(string2, bl, policySubject, deploymentConfigurationHelper);
            } else {
                PolicyDescriptorUtils.setServicePolicyRefStatus(string2, bl, policySubject, deploymentConfigurationHelper);
            }
            PolicyDescriptorUtils.save(PolicyDescriptorUtils.getAppName(policySubject), deploymentConfigurationHelper);
        }
        PolicyDescriptorUtils.releaseLock(PolicyDescriptorUtils.getAppName(policySubject), object);
    }

    private static void setClientPolicyRefStatus(String string, boolean bl, PolicySubject policySubject, DeploymentConfigurationHelper deploymentConfigurationHelper) throws PolicyManagementException, ManagementException {
        if (PolicyDescriptorUtils.isOperationType(policySubject)) {
            throw new PolicyManagementException("Operation level policy management is not supported for clients.");
        }
        ServiceReferenceDescriptionBean serviceReferenceDescriptionBean = PolicyDescriptorUtils.getServiceRefDescriptor(PolicyDescriptorUtils.getModuleName(policySubject), PolicyDescriptorUtils.getEJBName(policySubject), PolicyDescriptorUtils.getServiceRefName(policySubject), deploymentConfigurationHelper);
        Map<String, WseePolicyReferenceInfo> map = PolicyDescriptorUtils.getPolicies(PolicyDescriptorUtils.getSubjectName(policySubject), serviceReferenceDescriptionBean);
        PolicyDescriptorUtils.setStatus(string, map, serviceReferenceDescriptionBean, PolicyDescriptorUtils.getSubjectName(policySubject), bl);
    }

    private static void setServicePolicyRefStatus(String string, boolean bl, PolicySubject policySubject, DeploymentConfigurationHelper deploymentConfigurationHelper) throws ManagementException, PolicyManagementException, ConfigurationException {
        Class clazz = PolicyDescriptorUtils.getServiceClass(PolicyDescriptorUtils.getModuleName(policySubject), PolicyDescriptorUtils.getServiceName(policySubject), PolicyDescriptorUtils.getPortName(policySubject), deploymentConfigurationHelper);
        WebservicePolicyRefBean webservicePolicyRefBean = PolicyDescriptorUtils.getPolicyDescriptor(PolicyDescriptorUtils.getModuleName(policySubject), deploymentConfigurationHelper);
        Map<String, WseePolicyReferenceInfo> map = PolicyDescriptorUtils.getPolicies(PolicyDescriptorUtils.getSubjectName(policySubject), PolicyDescriptorUtils.isOperationType(policySubject), clazz, webservicePolicyRefBean);
        PolicyDescriptorUtils.setStatus(string, map, webservicePolicyRefBean, clazz, PolicyDescriptorUtils.getSubjectName(policySubject), PolicyDescriptorUtils.isOperationType(policySubject), PolicyDescriptorUtils.getServiceLink(policySubject, deploymentConfigurationHelper), bl);
    }

    private static String getServiceLink(PolicySubject policySubject, DeploymentConfigurationHelper deploymentConfigurationHelper) throws PolicyManagementException, ManagementException {
        if (PolicyDescriptorUtils.isOperationType(policySubject)) {
            return PolicyDescriptorUtils.getServiceLink(PolicyDescriptorUtils.getModuleName(policySubject), PolicyDescriptorUtils.getServiceName(policySubject), PolicyDescriptorUtils.getPortName(policySubject), deploymentConfigurationHelper);
        }
        return null;
    }

    public void setPolicyRefStatus(String string, String string2, boolean bl, String string3) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isOWSMAttachable(String string) throws ManagementException, PolicyManagementException, ConfigurationException {
        Object object;
        PolicySubject policySubject = PolicyDescriptorUtils.parsePolicySubject(string);
        String string2 = null;
        Object object2 = object = PolicyDescriptorUtils.getLock(PolicyDescriptorUtils.getAppName(policySubject));
        synchronized (object2) {
            Map<String, WseePolicyReferenceInfo> map = null;
            map = PolicyDescriptorUtils.isClientType(policySubject) ? PolicyDescriptorUtils.getClientPolicyReferenceInfos(policySubject) : PolicyDescriptorUtils.getServicePolicyReferenceInfos(policySubject);
            string2 = PolicyDescriptorUtils.effectiveCategory(map);
        }
        PolicyDescriptorUtils.releaseLock(PolicyDescriptorUtils.getAppName(policySubject), object);
        return string2 == null ? true : string2.equals(OWSM);
    }

    private static PolicySubject parsePolicySubject(String string) {
        return new PolicySubject(string);
    }

    private static String getAppName(PolicySubject policySubject) {
        return policySubject.getAppName();
    }

    private static String getModuleName(PolicySubject policySubject) {
        return policySubject.getModuleName();
    }

    private static String getEJBName(PolicySubject policySubject) {
        return policySubject.getEJBName();
    }

    private static String getServiceRefName(PolicySubject policySubject) {
        return policySubject.getServiceRefName();
    }

    private static String getServiceName(PolicySubject policySubject) {
        return policySubject.getServiceName();
    }

    private static String getSubjectName(PolicySubject policySubject) {
        return policySubject.getSubjectName();
    }

    private static String getPortName(PolicySubject policySubject) {
        return policySubject.getPortName();
    }

    private static boolean isOperationType(PolicySubject policySubject) {
        return policySubject.isOperationType();
    }

    private static boolean isClientType(PolicySubject policySubject) {
        return policySubject.isClientType();
    }

    private static Map<String, WseePolicyReferenceInfo> getPolicies(String string, boolean bl, Class clazz, WebservicePolicyRefBean webservicePolicyRefBean) {
        Map<String, WseePolicyReferenceInfo> map;
        block4: {
            block3: {
                map = PolicyDescriptorUtils.getPolicies(string, bl, clazz);
                if (!bl) break block3;
                OperationPolicyBean[] operationPolicyBeanArray = webservicePolicyRefBean.getOperationPolicy();
                if (operationPolicyBeanArray == null) break block4;
                for (OperationPolicyBean operationPolicyBean : operationPolicyBeanArray) {
                    if (!operationPolicyBean.getOperationName().equals(string)) continue;
                    PolicyDescriptorUtils.updatePolicies(map, operationPolicyBean.getWsPolicy());
                }
                break block4;
            }
            PortPolicyBean[] portPolicyBeanArray = webservicePolicyRefBean.getPortPolicy();
            if (portPolicyBeanArray != null) {
                for (PortPolicyBean portPolicyBean : portPolicyBeanArray) {
                    if (!portPolicyBean.getPortName().equals(string)) continue;
                    PolicyDescriptorUtils.updatePolicies(map, portPolicyBean.getOwsmSecurityPolicy());
                    PolicyDescriptorUtils.updatePolicies(map, portPolicyBean.getWsPolicy());
                }
            }
        }
        return map;
    }

    private static Map<String, WseePolicyReferenceInfo> getPolicies(String string, boolean bl, Class clazz) {
        Object object;
        ArrayList<WseePolicyReferenceInfo> arrayList = null;
        if (bl) {
            object = PolicyDeployUtils.findWebMethodFromService(clazz, string);
            arrayList = PolicyDescriptorUtils.getPoliciesFromAnnotatedElement((AnnotatedElement)object);
        } else {
            arrayList = PolicyDescriptorUtils.getPoliciesFromAnnotatedElement(clazz);
        }
        object = PolicyDescriptorUtils.getPolicyRefInfoMap(arrayList);
        return object;
    }

    private static Map<String, WseePolicyReferenceInfo> getPolicies(String string, ServiceReferenceDescriptionBean serviceReferenceDescriptionBean) {
        PortInfoBean[] portInfoBeanArray;
        HashMap<String, WseePolicyReferenceInfo> hashMap = new HashMap<String, WseePolicyReferenceInfo>();
        if (serviceReferenceDescriptionBean != null && (portInfoBeanArray = serviceReferenceDescriptionBean.getPortInfos()) != null) {
            for (PortInfoBean portInfoBean : portInfoBeanArray) {
                OwsmPolicyBean[] owsmPolicyBeanArray;
                if (!portInfoBean.getPortName().equals(string) || (owsmPolicyBeanArray = portInfoBean.getOwsmPolicy()) == null) continue;
                for (OwsmPolicyBean owsmPolicyBean : owsmPolicyBeanArray) {
                    hashMap.put(owsmPolicyBean.getUri(), new WseePolicyReferenceInfo(OWSM, owsmPolicyBean.getUri(), owsmPolicyBean.getStatus(), PolicyDescriptorUtils.getOverrides(owsmPolicyBean)));
                }
            }
        }
        return hashMap;
    }

    private static Map<String, String> getOverrides(OwsmPolicyBean owsmPolicyBean) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        PropertyNamevalueBean[] propertyNamevalueBeanArray = owsmPolicyBean.getSecurityConfigurationProperties();
        if (propertyNamevalueBeanArray != null) {
            for (PropertyNamevalueBean propertyNamevalueBean : propertyNamevalueBeanArray) {
                hashMap.put(propertyNamevalueBean.getName(), propertyNamevalueBean.getValue());
            }
        }
        return hashMap;
    }

    private static Map<String, WseePolicyReferenceInfo> getPolicyRefInfoMap(ArrayList<WseePolicyReferenceInfo> arrayList) {
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        HashMap<String, WseePolicyReferenceInfo> hashMap = new HashMap<String, WseePolicyReferenceInfo>();
        for (WseePolicyReferenceInfo wseePolicyReferenceInfo : arrayList) {
            hashMap.put(wseePolicyReferenceInfo.getUri(), wseePolicyReferenceInfo);
        }
        return hashMap;
    }

    private static void updatePolicies(Map<String, WseePolicyReferenceInfo> map, OwsmSecurityPolicyBean[] owsmSecurityPolicyBeanArray) {
        for (OwsmSecurityPolicyBean owsmSecurityPolicyBean : owsmSecurityPolicyBeanArray) {
            if (!map.containsKey(owsmSecurityPolicyBean.getUri())) {
                PolicyDescriptorUtils.addPolicy(map, owsmSecurityPolicyBean);
                continue;
            }
            WseePolicyReferenceInfo wseePolicyReferenceInfo = map.get(owsmSecurityPolicyBean.getUri());
            if (owsmSecurityPolicyBean.getStatus().equals(DELETED)) {
                map.remove(wseePolicyReferenceInfo.getUri());
                continue;
            }
            wseePolicyReferenceInfo.setStatus(owsmSecurityPolicyBean.getStatus());
        }
    }

    private static void updatePolicies(Map<String, WseePolicyReferenceInfo> map, WsPolicyBean[] wsPolicyBeanArray) {
        for (WsPolicyBean wsPolicyBean : wsPolicyBeanArray) {
            if (!map.containsKey(wsPolicyBean.getUri())) {
                PolicyDescriptorUtils.addPolicy(map, wsPolicyBean);
                continue;
            }
            String string = wsPolicyBean.getUri();
            String string2 = wsPolicyBean.getDirection();
            if (string2 == null) {
                string2 = BOTH;
            }
            String string3 = wsPolicyBean.getStatus();
            WseePolicyReferenceInfo wseePolicyReferenceInfo = map.get(string);
            if (string3.equals(ENABLED)) {
                if (string2.equals(wseePolicyReferenceInfo.getDirection())) continue;
                wseePolicyReferenceInfo.setDirection(string2);
                continue;
            }
            if (string3.equals(DELETED)) {
                if (string2.equals(BOTH) || string2.equals(wseePolicyReferenceInfo.getDirection())) {
                    map.remove(wsPolicyBean.getUri());
                    continue;
                }
                if (!wseePolicyReferenceInfo.getDirection().equals(BOTH)) continue;
                PolicyDescriptorUtils.switchDirection(wseePolicyReferenceInfo, string2);
                continue;
            }
            if (!string3.equals(DISABLED)) continue;
            wseePolicyReferenceInfo.setStatus(string3);
            wseePolicyReferenceInfo.setDirection(BOTH);
        }
    }

    private static void switchDirection(WseePolicyReferenceInfo wseePolicyReferenceInfo, String string) {
        if (string.equals(IN)) {
            wseePolicyReferenceInfo.setDirection(OUT);
        } else {
            wseePolicyReferenceInfo.setDirection(IN);
        }
    }

    private static void addPolicy(Map<String, WseePolicyReferenceInfo> map, WsPolicyBean wsPolicyBean) {
        map.put(wsPolicyBean.getUri(), new WseePolicyReferenceInfo(WLS, wsPolicyBean.getUri(), wsPolicyBean.getStatus(), wsPolicyBean.getDirection()));
    }

    private static void addPolicy(Map<String, WseePolicyReferenceInfo> map, OwsmSecurityPolicyBean owsmSecurityPolicyBean) {
        map.put(owsmSecurityPolicyBean.getUri(), new WseePolicyReferenceInfo(OWSM, owsmSecurityPolicyBean.getUri(), owsmSecurityPolicyBean.getStatus()));
    }

    private static String effectiveCategory(Map<String, WseePolicyReferenceInfo> map) {
        String string = null;
        for (WseePolicyReferenceInfo wseePolicyReferenceInfo : map.values()) {
            if (!wseePolicyReferenceInfo.getStatus().equals(ENABLED)) continue;
            string = wseePolicyReferenceInfo.getCategory();
            break;
        }
        return string;
    }

    private static void attach(WseePolicyReferenceInfo wseePolicyReferenceInfo, Map<String, WseePolicyReferenceInfo> map, Map<String, WseePolicyReferenceInfo> map2, WebservicePolicyRefBean webservicePolicyRefBean, String string, boolean bl, String string2) {
        String string3;
        if (wseePolicyReferenceInfo.getStatus().equals(DELETED)) {
            throw new IllegalArgumentException("Status deleted is invalid for this method");
        }
        if (wseePolicyReferenceInfo.getStatus().equals(ENABLED) && (string3 = PolicyDescriptorUtils.effectiveCategory(map)) != null && !string3.equals(wseePolicyReferenceInfo.getCategory())) {
            throw new IllegalArgumentException("Invalid category " + string3 + " to attach to existing policies.");
        }
        if (map.containsKey(wseePolicyReferenceInfo.getUri())) {
            if (bl) {
                string3 = PolicyDescriptorUtils.getOperationPolicyBean(wseePolicyReferenceInfo, webservicePolicyRefBean, string);
                if (string3 != null) {
                    string3.setStatus(wseePolicyReferenceInfo.getStatus());
                    string3.setDirection(wseePolicyReferenceInfo.getDirection());
                } else {
                    PolicyDeployUtils.addPolicyToOperation(webservicePolicyRefBean, string, wseePolicyReferenceInfo.getUri(), wseePolicyReferenceInfo.getDirection(), string2);
                }
            } else if (wseePolicyReferenceInfo.getCategory().equals(OWSM)) {
                string3 = PolicyDescriptorUtils.getOWSMPolicyBean(wseePolicyReferenceInfo, webservicePolicyRefBean, string);
                if (string3 != null) {
                    string3.setStatus(wseePolicyReferenceInfo.getStatus());
                } else {
                    PolicyDeployUtils.addOwsmSecurityPolicyToPort(webservicePolicyRefBean, string, wseePolicyReferenceInfo.getUri(), wseePolicyReferenceInfo.getStatus());
                }
            } else {
                string3 = PolicyDescriptorUtils.getPortPolicyBean(wseePolicyReferenceInfo, webservicePolicyRefBean, string);
                if (string3 != null) {
                    string3.setStatus(wseePolicyReferenceInfo.getStatus());
                    string3.setDirection(wseePolicyReferenceInfo.getDirection());
                } else {
                    PolicyDeployUtils.addPolicyToPort(webservicePolicyRefBean, string, wseePolicyReferenceInfo.getUri(), wseePolicyReferenceInfo.getDirection(), wseePolicyReferenceInfo.getStatus());
                }
            }
        } else if (wseePolicyReferenceInfo.getCategory().equals(OWSM)) {
            if (map2.containsValue(wseePolicyReferenceInfo)) {
                PolicyDeployUtils.removeOwsmSecurityPolicyFromPort(webservicePolicyRefBean, string, wseePolicyReferenceInfo.getUri());
            } else {
                PolicyDeployUtils.addOwsmSecurityPolicyToPort(webservicePolicyRefBean, string, wseePolicyReferenceInfo.getUri(), wseePolicyReferenceInfo.getStatus());
            }
        } else if (bl) {
            if (map2.containsValue(wseePolicyReferenceInfo)) {
                PolicyDeployUtils.removePolicyFromOperation(webservicePolicyRefBean, string, wseePolicyReferenceInfo.getUri());
            } else {
                PolicyDeployUtils.addPolicyToOperation(webservicePolicyRefBean, string, wseePolicyReferenceInfo.getUri(), wseePolicyReferenceInfo.getDirection(), string2);
            }
        } else if (map2.containsValue(wseePolicyReferenceInfo)) {
            PolicyDeployUtils.removePolicyFromPort(webservicePolicyRefBean, string, wseePolicyReferenceInfo.getUri());
        } else {
            PolicyDeployUtils.addPolicyToPort(webservicePolicyRefBean, string, wseePolicyReferenceInfo.getUri(), wseePolicyReferenceInfo.getDirection(), wseePolicyReferenceInfo.getStatus());
        }
    }

    private static void attach(WseePolicyReferenceInfo wseePolicyReferenceInfo, Map<String, WseePolicyReferenceInfo> map, ServiceReferenceDescriptionBean serviceReferenceDescriptionBean, String string) {
        if (wseePolicyReferenceInfo.getStatus().equals(DELETED)) {
            throw new IllegalArgumentException("Status deleted is invalid for this method");
        }
        if (wseePolicyReferenceInfo.getStatus().equals(ENABLED) && wseePolicyReferenceInfo.getCategory().equals(WLS)) {
            throw new IllegalArgumentException("Invalid policy category ws-policy to attach to client.");
        }
        if (map.containsKey(wseePolicyReferenceInfo.getUri())) {
            OwsmPolicyBean owsmPolicyBean = PolicyDescriptorUtils.getOWSMPolicyBean(wseePolicyReferenceInfo, serviceReferenceDescriptionBean, string);
            if (owsmPolicyBean != null) {
                owsmPolicyBean.setStatus(wseePolicyReferenceInfo.getStatus());
                PolicyDescriptorUtils.setOverrides(wseePolicyReferenceInfo, owsmPolicyBean);
            } else {
                PolicyDescriptorUtils.addOwsmSecurityPolicyToPort(serviceReferenceDescriptionBean, string, wseePolicyReferenceInfo);
            }
        } else {
            PolicyDescriptorUtils.addOwsmSecurityPolicyToPort(serviceReferenceDescriptionBean, string, wseePolicyReferenceInfo);
        }
    }

    private static void setOverrides(WseePolicyReferenceInfo wseePolicyReferenceInfo, OwsmPolicyBean owsmPolicyBean) {
        Object object;
        Object object2;
        PropertyNamevalueBean[] propertyNamevalueBeanArray = owsmPolicyBean.getSecurityConfigurationProperties();
        if (propertyNamevalueBeanArray != null) {
            object2 = propertyNamevalueBeanArray;
            int n = ((PropertyNamevalueBean[])object2).length;
            for (int i = 0; i < n; ++i) {
                object = object2[i];
                owsmPolicyBean.destroySecurityConfigurationProperty((PropertyNamevalueBean)object);
            }
        }
        if ((object2 = wseePolicyReferenceInfo.getOverrides()) != null) {
            for (String string : object2.keySet()) {
                object = owsmPolicyBean.createSecurityConfigurationProperty();
                object.setName(string);
                object.setValue((String)object2.get(string));
            }
        }
    }

    private static void addOwsmSecurityPolicyToPort(ServiceReferenceDescriptionBean serviceReferenceDescriptionBean, String string, WseePolicyReferenceInfo wseePolicyReferenceInfo) {
        PortInfoBean portInfoBean = serviceReferenceDescriptionBean.getPortInfos();
        if (portInfoBean != null) {
            for (PortInfoBean portInfoBean2 : portInfoBean) {
                if (!portInfoBean2.getPortName().equals(string)) continue;
                OwsmPolicyBean owsmPolicyBean = PolicyDescriptorUtils.createOwsmPolicy(wseePolicyReferenceInfo.getUri(), wseePolicyReferenceInfo.getStatus(), portInfoBean2);
                PolicyDescriptorUtils.setOverrides(wseePolicyReferenceInfo, owsmPolicyBean);
                return;
            }
        }
        PortInfoBean portInfoBean3 = serviceReferenceDescriptionBean.createPortInfo();
        portInfoBean3.setPortName(string);
        OwsmPolicyBean owsmPolicyBean = PolicyDescriptorUtils.createOwsmPolicy(wseePolicyReferenceInfo.getUri(), wseePolicyReferenceInfo.getStatus(), portInfoBean3);
        PolicyDescriptorUtils.setOverrides(wseePolicyReferenceInfo, owsmPolicyBean);
    }

    private static OwsmPolicyBean createOwsmPolicy(String string, String string2, PortInfoBean portInfoBean) {
        OwsmPolicyBean owsmPolicyBean = portInfoBean.createOwsmPolicy();
        owsmPolicyBean.setUri(string);
        owsmPolicyBean.setCategory(OWSM);
        owsmPolicyBean.setStatus(string2);
        return owsmPolicyBean;
    }

    private static void remove(String string, Map<String, WseePolicyReferenceInfo> map, WebservicePolicyRefBean webservicePolicyRefBean, Class clazz, String string2, boolean bl, String string3) {
        if (!map.containsKey(string)) {
            return;
        }
        WseePolicyReferenceInfo wseePolicyReferenceInfo = map.get(string);
        if (bl) {
            PolicyDeployUtils.removePolicyFromOperation(webservicePolicyRefBean, string2, string, BOTH, string3);
        } else {
            String string4 = wseePolicyReferenceInfo.getCategory();
            if (OWSM.equals(string4)) {
                PolicyDeployUtils.removeOwsmSecurityPolicyFromPort(webservicePolicyRefBean, string2, string);
            } else {
                PolicyDeployUtils.removePolicyFromPort(webservicePolicyRefBean, string2, string);
            }
        }
    }

    private static void remove(String string, Map<String, WseePolicyReferenceInfo> map, ServiceReferenceDescriptionBean serviceReferenceDescriptionBean, String string2) throws PolicyManagementException {
        if (!map.containsKey(string)) {
            return;
        }
        PolicyDescriptorUtils.removeOwsmSecurityPolicyFromPort(serviceReferenceDescriptionBean, string2, string);
    }

    private static void removeOwsmSecurityPolicyFromPort(ServiceReferenceDescriptionBean serviceReferenceDescriptionBean, String string, String string2) {
        PortInfoBean[] portInfoBeanArray = serviceReferenceDescriptionBean.getPortInfos();
        if (portInfoBeanArray != null) {
            for (PortInfoBean portInfoBean : portInfoBeanArray) {
                OwsmPolicyBean[] owsmPolicyBeanArray;
                if (!portInfoBean.getPortName().equals(string) || (owsmPolicyBeanArray = portInfoBean.getOwsmPolicy()) == null) continue;
                for (OwsmPolicyBean owsmPolicyBean : owsmPolicyBeanArray) {
                    if (!owsmPolicyBean.getUri().equals(string2)) continue;
                    portInfoBean.destroyOwsmPolicy(owsmPolicyBean);
                }
            }
        }
    }

    private static void setStatus(String string, Map<String, WseePolicyReferenceInfo> map, ServiceReferenceDescriptionBean serviceReferenceDescriptionBean, String string2, boolean bl) {
        WseePolicyReferenceInfo wseePolicyReferenceInfo = map.get(string);
        if (wseePolicyReferenceInfo == null) {
            throw new IllegalArgumentException("Policy " + string + " is not attached, status can not be set.");
        }
        boolean bl2 = wseePolicyReferenceInfo.getStatus().equals(ENABLED);
        if (!(bl ^ bl2)) {
            return;
        }
        OwsmPolicyBean owsmPolicyBean = PolicyDescriptorUtils.getOWSMPolicyBean(string, serviceReferenceDescriptionBean, string2);
        owsmPolicyBean.setStatus(bl ? ENABLED : DISABLED);
    }

    private static void setStatus(String string, Map<String, WseePolicyReferenceInfo> map, WebservicePolicyRefBean webservicePolicyRefBean, Class clazz, String string2, boolean bl, String string3, boolean bl2) {
        WseePolicyReferenceInfo wseePolicyReferenceInfo = map.get(string);
        if (wseePolicyReferenceInfo == null) {
            throw new IllegalArgumentException("Policy " + string + " is not attached, status can not be set.");
        }
        boolean bl3 = wseePolicyReferenceInfo.getStatus().equals(ENABLED);
        if (!(bl2 ^ bl3)) {
            return;
        }
        boolean bl4 = wseePolicyReferenceInfo.getCategory().equals(OWSM);
        if (bl4) {
            PolicyDescriptorUtils.setStatus(webservicePolicyRefBean, string2, string, bl2);
        } else {
            PolicyDescriptorUtils.setStatus(webservicePolicyRefBean, clazz, string2, string, bl, string3, bl2);
        }
    }

    private static void setStatus(WebservicePolicyRefBean webservicePolicyRefBean, String string, String string2, boolean bl) {
        OwsmSecurityPolicyBean owsmSecurityPolicyBean = PolicyDescriptorUtils.getOWSMPolicyBean(string2, webservicePolicyRefBean, string);
        if (owsmSecurityPolicyBean == null) {
            PolicyDeployUtils.addOwsmSecurityPolicyToPort(webservicePolicyRefBean, string, string2, bl ? ENABLED : DISABLED);
        } else {
            owsmSecurityPolicyBean.setStatus(bl ? ENABLED : DISABLED);
        }
    }

    private static void setStatus(WebservicePolicyRefBean webservicePolicyRefBean, Class clazz, String string, String string2, boolean bl, String string3, boolean bl2) {
        String string4 = bl2 ? ENABLED : DISABLED;
        WsPolicyBean wsPolicyBean = null;
        wsPolicyBean = bl ? PolicyDescriptorUtils.getOperationPolicyBean(string2, webservicePolicyRefBean, string) : PolicyDescriptorUtils.getPortPolicyBean(string2, webservicePolicyRefBean, string);
        if (wsPolicyBean == null) {
            if (bl) {
                PolicyDeployUtils.addPolicyToOperation(webservicePolicyRefBean, string, string2, BOTH, string3);
            } else {
                PolicyDeployUtils.addPolicyToPort(webservicePolicyRefBean, string, string2, BOTH, string4);
            }
        } else {
            wsPolicyBean.setStatus(bl2 ? ENABLED : DISABLED);
        }
    }

    private static WsPolicyBean getOperationPolicyBean(WseePolicyReferenceInfo wseePolicyReferenceInfo, WebservicePolicyRefBean webservicePolicyRefBean, String string) {
        return PolicyDescriptorUtils.getOperationPolicyBean(wseePolicyReferenceInfo.getUri(), webservicePolicyRefBean, string);
    }

    private static WsPolicyBean getOperationPolicyBean(String string, WebservicePolicyRefBean webservicePolicyRefBean, String string2) {
        OperationPolicyBean[] operationPolicyBeanArray = webservicePolicyRefBean.getOperationPolicy();
        if (operationPolicyBeanArray != null) {
            for (OperationPolicyBean operationPolicyBean : operationPolicyBeanArray) {
                WsPolicyBean[] wsPolicyBeanArray;
                if (!operationPolicyBean.getOperationName().equals(string2)) continue;
                for (WsPolicyBean wsPolicyBean : wsPolicyBeanArray = operationPolicyBean.getWsPolicy()) {
                    if (!wsPolicyBean.getUri().equals(string)) continue;
                    return wsPolicyBean;
                }
            }
        }
        return null;
    }

    private static OwsmSecurityPolicyBean getOWSMPolicyBean(WseePolicyReferenceInfo wseePolicyReferenceInfo, WebservicePolicyRefBean webservicePolicyRefBean, String string) {
        return PolicyDescriptorUtils.getOWSMPolicyBean(wseePolicyReferenceInfo.getUri(), webservicePolicyRefBean, string);
    }

    private static OwsmPolicyBean getOWSMPolicyBean(WseePolicyReferenceInfo wseePolicyReferenceInfo, ServiceReferenceDescriptionBean serviceReferenceDescriptionBean, String string) {
        return PolicyDescriptorUtils.getOWSMPolicyBean(wseePolicyReferenceInfo.getUri(), serviceReferenceDescriptionBean, string);
    }

    private static OwsmSecurityPolicyBean getOWSMPolicyBean(String string, WebservicePolicyRefBean webservicePolicyRefBean, String string2) {
        PortPolicyBean[] portPolicyBeanArray = webservicePolicyRefBean.getPortPolicy();
        if (portPolicyBeanArray != null) {
            for (PortPolicyBean portPolicyBean : portPolicyBeanArray) {
                OwsmSecurityPolicyBean[] owsmSecurityPolicyBeanArray;
                if (!portPolicyBean.getPortName().equals(string2)) continue;
                for (OwsmSecurityPolicyBean owsmSecurityPolicyBean : owsmSecurityPolicyBeanArray = portPolicyBean.getOwsmSecurityPolicy()) {
                    if (!owsmSecurityPolicyBean.getUri().equals(string)) continue;
                    return owsmSecurityPolicyBean;
                }
            }
        }
        return null;
    }

    private static OwsmPolicyBean getOWSMPolicyBean(String string, ServiceReferenceDescriptionBean serviceReferenceDescriptionBean, String string2) {
        PortInfoBean[] portInfoBeanArray = serviceReferenceDescriptionBean.getPortInfos();
        if (portInfoBeanArray != null) {
            for (PortInfoBean portInfoBean : portInfoBeanArray) {
                OwsmPolicyBean[] owsmPolicyBeanArray;
                if (!portInfoBean.getPortName().equals(string2)) continue;
                for (OwsmPolicyBean owsmPolicyBean : owsmPolicyBeanArray = portInfoBean.getOwsmPolicy()) {
                    if (!owsmPolicyBean.getUri().equals(string)) continue;
                    return owsmPolicyBean;
                }
            }
        }
        return null;
    }

    private static WsPolicyBean getPortPolicyBean(WseePolicyReferenceInfo wseePolicyReferenceInfo, WebservicePolicyRefBean webservicePolicyRefBean, String string) {
        return PolicyDescriptorUtils.getPortPolicyBean(wseePolicyReferenceInfo.getUri(), webservicePolicyRefBean, string);
    }

    private static WsPolicyBean getPortPolicyBean(String string, WebservicePolicyRefBean webservicePolicyRefBean, String string2) {
        PortPolicyBean[] portPolicyBeanArray = webservicePolicyRefBean.getPortPolicy();
        if (portPolicyBeanArray != null) {
            for (PortPolicyBean portPolicyBean : portPolicyBeanArray) {
                WsPolicyBean[] wsPolicyBeanArray;
                if (!portPolicyBean.getPortName().equals(string2)) continue;
                for (WsPolicyBean wsPolicyBean : wsPolicyBeanArray = portPolicyBean.getWsPolicy()) {
                    if (!wsPolicyBean.getUri().equals(string)) continue;
                    return wsPolicyBean;
                }
            }
        }
        return null;
    }

    private static ArrayList<WseePolicyReferenceInfo> getPoliciesFromAnnotatedElement(AnnotatedElement annotatedElement) {
        ArrayList<WseePolicyReferenceInfo> arrayList = new ArrayList<WseePolicyReferenceInfo>();
        if (!PolicyDescriptorUtils.getWLSPolicies(annotatedElement, arrayList)) {
            PolicyDescriptorUtils.getOWSMPolicies(annotatedElement, arrayList);
        }
        return arrayList;
    }

    private static boolean getWLSPolicies(AnnotatedElement annotatedElement, ArrayList<WseePolicyReferenceInfo> arrayList) {
        boolean bl = false;
        Policies policies = annotatedElement.getAnnotation(Policies.class);
        if (policies != null) {
            for (Policy policy : policies.value()) {
                PolicyDescriptorUtils.addPolicyRefInfo(arrayList, policy);
            }
            bl = true;
        } else {
            Policy policy = annotatedElement.getAnnotation(Policy.class);
            if (policy != null) {
                PolicyDescriptorUtils.addPolicyRefInfo(arrayList, policy);
                bl = true;
            }
        }
        return bl;
    }

    private static boolean getOWSMPolicies(AnnotatedElement annotatedElement, ArrayList<WseePolicyReferenceInfo> arrayList) {
        boolean bl = false;
        SecurityPolicies securityPolicies = annotatedElement.getAnnotation(SecurityPolicies.class);
        if (securityPolicies != null) {
            for (SecurityPolicy securityPolicy : securityPolicies.value()) {
                PolicyDescriptorUtils.addPolicyRefInfo(arrayList, securityPolicy);
            }
            bl = true;
        } else {
            SecurityPolicy securityPolicy = annotatedElement.getAnnotation(SecurityPolicy.class);
            if (securityPolicy != null) {
                PolicyDescriptorUtils.addPolicyRefInfo(arrayList, securityPolicy);
                bl = true;
            }
        }
        return bl;
    }

    private static void addPolicyRefInfo(ArrayList<WseePolicyReferenceInfo> arrayList, Policy policy) {
        arrayList.add(new WseePolicyReferenceInfo(WLS, policy.uri(), ENABLED, policy.direction().toString()));
    }

    private static void addPolicyRefInfo(ArrayList<WseePolicyReferenceInfo> arrayList, SecurityPolicy securityPolicy) {
        arrayList.add(new WseePolicyReferenceInfo(OWSM, securityPolicy.uri()));
    }

    private static Class getServiceClass(String string, String string2, String string3, DeploymentConfigurationHelper deploymentConfigurationHelper) throws ManagementException, PolicyManagementException, ConfigurationException {
        return PolicyDescriptorUtils.loadServiceClass(deploymentConfigurationHelper, string, string2, new QName(string3));
    }

    private static Class loadServiceClass(DeploymentConfigurationHelper deploymentConfigurationHelper, String string, String string2) {
        WebLogicDeployableObject webLogicDeployableObject = deploymentConfigurationHelper.getDeployableObject(string);
        return webLogicDeployableObject.getClassFromScope(string2);
    }

    private static String getServiceLink(String string, String string2, String string3, DeploymentConfigurationHelper deploymentConfigurationHelper) throws PolicyManagementException, ManagementException {
        WebAppBean webAppBean = WebServiceBeanUtils.getWebAppBean(deploymentConfigurationHelper, string);
        boolean bl = webAppBean != null;
        WebservicesBean webservicesBean = WebServiceBeanUtils.getWebservicesBean(deploymentConfigurationHelper, string, bl);
        return WebServiceBeanUtils.getLinkName(webservicesBean, string2, new QName(string3), bl);
    }

    private static Class loadServiceClass(DeploymentConfigurationHelper deploymentConfigurationHelper, String string, String string2, QName qName) throws PolicyManagementException, ConfigurationException {
        WebservicesBean webservicesBean;
        WebAppBean webAppBean = WebServiceBeanUtils.getWebAppBean(deploymentConfigurationHelper, string);
        EjbJarBean ejbJarBean = null;
        boolean bl = true;
        if (webAppBean == null) {
            bl = false;
            ejbJarBean = WebServiceBeanUtils.getEjbBean(deploymentConfigurationHelper, string);
        }
        if ((webservicesBean = WebServiceBeanUtils.getWebservicesBean(deploymentConfigurationHelper, string, bl)) == null) {
            throw new PolicyManagementException("There was an error getting the webservice bean");
        }
        String string3 = WebServiceBeanUtils.getServiceClassName(string2, webservicesBean, qName, bl, webAppBean, ejbJarBean);
        Class clazz = null;
        if (string3 == null && bl) {
            ServletBean[] servletBeanArray = webAppBean.getServlets();
            for (int i = 0; i < servletBeanArray.length; ++i) {
                String string4 = servletBeanArray[i].getServletClass();
                Class clazz2 = WebServiceBeanUtils.loadServiceClass(deploymentConfigurationHelper, string, string4);
                if (clazz2 == null) continue;
                String string5 = null;
                String string6 = null;
                WebService webService = clazz2.getAnnotation(WebService.class);
                if (webService != null) {
                    string5 = webService.serviceName();
                    string6 = webService.portName();
                } else {
                    WebServiceProvider webServiceProvider = clazz2.getAnnotation(WebServiceProvider.class);
                    if (webServiceProvider != null) {
                        string5 = webServiceProvider.serviceName();
                        string6 = webServiceProvider.portName();
                    }
                }
                if (string5 == null || string5.length() == 0) {
                    string5 = clazz2.getSimpleName() + "Service";
                }
                if (string6 == null || string6.length() == 0) {
                    string6 = (webService != null && webService.name() != null && webService.name().length() > 0 ? webService.name() : clazz2.getSimpleName()) + "Port";
                }
                if (!string2.equals(string5) || !qName.equals(string6)) continue;
                string3 = string4;
                clazz = clazz2;
                break;
            }
            if (string3 == null) {
                throw new PolicyManagementException("webservice.webservicepoliciestable.unabletogetclassname");
            }
        }
        if (clazz == null && string3 != null) {
            clazz = PolicyDescriptorUtils.loadServiceClass(deploymentConfigurationHelper, string, string3);
        }
        if (string3 != null && clazz == null) {
            throw new PolicyManagementException("webservice.webservicepoliciestable.unabletoloadclass" + string3);
        }
        return clazz;
    }

    private static WebservicePolicyRefBean loadPolicyDescriptor(DeploymentConfigurationHelper deploymentConfigurationHelper, String string) throws ManagementException {
        try {
            return deploymentConfigurationHelper.getWebservicePolicies(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ManagementException((Throwable)fileNotFoundException);
        }
        catch (DDBeanCreateException dDBeanCreateException) {
            throw new ManagementException((Throwable)dDBeanCreateException);
        }
        catch (ConfigurationException configurationException) {
            throw new ManagementException((Throwable)configurationException);
        }
    }

    private static ServiceReferenceDescriptionBean loadServiceRefDescriptor(DeploymentConfigurationHelper deploymentConfigurationHelper, String string, String string2, String string3) throws ManagementException {
        try {
            return deploymentConfigurationHelper.getServiceRefPolicies(string, string2, string3);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ManagementException((Throwable)fileNotFoundException);
        }
        catch (DDBeanCreateException dDBeanCreateException) {
            throw new ManagementException((Throwable)dDBeanCreateException);
        }
        catch (ConfigurationException configurationException) {
            throw new ManagementException((Throwable)configurationException);
        }
    }

    private static WebservicePolicyRefBean getPolicyDescriptor(String string, DeploymentConfigurationHelper deploymentConfigurationHelper) throws ManagementException {
        return PolicyDescriptorUtils.loadPolicyDescriptor(deploymentConfigurationHelper, string);
    }

    private static ServiceReferenceDescriptionBean getServiceRefDescriptor(String string, String string2, String string3, DeploymentConfigurationHelper deploymentConfigurationHelper) throws ManagementException {
        return PolicyDescriptorUtils.loadServiceRefDescriptor(deploymentConfigurationHelper, string, string2, string3);
    }

    private static DeploymentConfigurationHelper getDCH(String string) throws ManagementException {
        AppDeploymentMBean appDeploymentMBean = DeploymentConfigurationHelper.getAppDeploymentMBean(string);
        return PolicyDescriptorUtils.getDCH(appDeploymentMBean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DeploymentConfigurationHelper getDCH(AppDeploymentMBean appDeploymentMBean) throws ManagementException {
        Object object = configLock;
        synchronized (object) {
            return DeploymentConfigurationManager.getInstance().getDeploymentConfiguration(appDeploymentMBean);
        }
    }

    public static void redeployPlan(AppDeploymentMBean appDeploymentMBean, String string) throws ManagementException {
        try {
            File file = null;
            if (!StringUtil.isEmpty(string)) {
                file = new File(string);
            }
            WebLogicDeploymentManager webLogicDeploymentManager = DeploymentConfigurationHelper.getTmpDeploymentManager();
            TargetModuleID[] targetModuleIDArray = webLogicDeploymentManager.getModules(appDeploymentMBean);
            File file2 = new File(appDeploymentMBean.getAbsoluteSourcePath());
            if (PolicyDescriptorUtils.isDeploymentActive(appDeploymentMBean)) {
                webLogicDeploymentManager.redeploy(targetModuleIDArray, file2, file, PolicyDescriptorUtils.createDeploymentOptions());
            } else if (PolicyDescriptorUtils.isDeployPending(appDeploymentMBean)) {
                webLogicDeploymentManager.deploy(targetModuleIDArray, file2, file, PolicyDescriptorUtils.createDeploymentOptions());
            } else {
                webLogicDeploymentManager.distribute(targetModuleIDArray, file2, file, PolicyDescriptorUtils.createDeploymentOptions());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static DeploymentOptions createDeploymentOptions() {
        DeploymentOptions deploymentOptions = new DeploymentOptions();
        deploymentOptions.setUseExpiredLock(true);
        return deploymentOptions;
    }

    public static boolean isDeploymentActive(AppDeploymentMBean appDeploymentMBean) {
        try {
            DomainRuntimeMBean domainRuntimeMBean = MBeanUtils.getDomainRuntimeMBean();
            AppRuntimeStateRuntimeMBean appRuntimeStateRuntimeMBean = domainRuntimeMBean.getAppRuntimeStateRuntime();
            ServerRuntimeMBean[] serverRuntimeMBeanArray = MBeanUtils.getServerRuntimeMBeans();
            for (int i = 0; i < serverRuntimeMBeanArray.length; ++i) {
                String string = appRuntimeStateRuntimeMBean.getCurrentState(appDeploymentMBean.getName(), serverRuntimeMBeanArray[i].getName());
                if (string == null || !string.equals("STATE_ADMIN") && !string.equals("STATE_ACTIVE") && !string.equals("STATE_PREPARED")) continue;
                return true;
            }
        }
        catch (ManagementException managementException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isDeployPending(AppDeploymentMBean appDeploymentMBean) throws ManagementException {
        String string;
        DeploymentTaskRuntimeMBean deploymentTaskRuntimeMBean = PolicyDescriptorUtils.getLastDeploymentTaskRuntimeMBean(appDeploymentMBean);
        return deploymentTaskRuntimeMBean != null && deploymentTaskRuntimeMBean.isRunning() && (string = deploymentTaskRuntimeMBean.getStatus()).indexOf("deploy Initializing") >= 0;
    }

    public static DeploymentTaskRuntimeMBean getLastDeploymentTaskRuntimeMBean(AppDeploymentMBean appDeploymentMBean) throws ManagementException {
        DeploymentTaskRuntimeMBean deploymentTaskRuntimeMBean = null;
        String string = appDeploymentMBean.getApplicationName();
        String string2 = appDeploymentMBean.getVersionIdentifier();
        DeployerRuntimeMBean deployerRuntimeMBean = MBeanUtils.getDomainRuntimeMBean().getDeployerRuntime();
        for (DeploymentTaskRuntimeMBean deploymentTaskRuntimeMBean2 : deployerRuntimeMBean.getDeploymentTaskRuntimes()) {
            try {
                if (deploymentTaskRuntimeMBean2 == null || !deploymentTaskRuntimeMBean2.getApplicationName().equals(string)) continue;
                String string3 = deploymentTaskRuntimeMBean2.getApplicationVersionIdentifier();
                if (!StringUtil.isEmpty(string2) && (string3 == null || !string3.equals(string2))) continue;
                if (deploymentTaskRuntimeMBean2.getBeginTime() == 0L && deploymentTaskRuntimeMBean2.getEndTime() == 0L) {
                    return deploymentTaskRuntimeMBean2;
                }
                if (deploymentTaskRuntimeMBean != null && deploymentTaskRuntimeMBean.getBeginTime() >= deploymentTaskRuntimeMBean2.getBeginTime()) continue;
                deploymentTaskRuntimeMBean = deploymentTaskRuntimeMBean2;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return deploymentTaskRuntimeMBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object getLock(String string) {
        Lock lock = null;
        Map<String, Lock> map = usedLocks;
        synchronized (map) {
            List<Lock> list = unusedLocks;
            synchronized (list) {
                if (usedLocks.containsKey(string)) {
                    lock = usedLocks.get(string);
                    lock.add();
                    return lock;
                }
                int n = unusedLocks.size();
                if (n == 0) {
                    unusedLocks.add(new Lock());
                }
                if (unusedLocks.size() > 16) {
                    unusedLocks.removeAll(unusedLocks.subList(16, n - 1));
                }
                n = unusedLocks.size();
                lock = unusedLocks.remove(n - 1);
                usedLocks.put(string, lock);
                lock.add();
            }
        }
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void releaseLock(String string, Object object) {
        Map<String, Lock> map = usedLocks;
        synchronized (map) {
            List<Lock> list = unusedLocks;
            synchronized (list) {
                Lock lock = (Lock)object;
                lock.remove();
                if (lock.isEmpty()) {
                    usedLocks.remove(string);
                    unusedLocks.add(lock);
                }
            }
        }
    }

    private static class Lock {
        int counter = 0;

        private Lock() {
        }

        public void add() {
            ++this.counter;
        }

        public void remove() {
            --this.counter;
        }

        public boolean isEmpty() {
            return this.counter == 0;
        }
    }

    public class DeployableObjectInfoWrapper
    extends DeployableObjectInfo {
        public DeployableObjectInfoWrapper(WebLogicDeployableObject webLogicDeployableObject, WebLogicDeploymentConfiguration webLogicDeploymentConfiguration, String string) throws IOException, ConfigurationException {
            super(webLogicDeployableObject, webLogicDeploymentConfiguration, string);
        }
    }
}

