/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.policy.deployment.config;

public class PolicySubject {
    private static String WEB = "/WEBs/";
    private static String EJB = "/EJBs/";
    private static String SERVICE = "/WLSWEBSERVICEs/";
    private static String CLIENT = "/WLSWEBSERVICECLIENTs/";
    private static String PORT = "/PORTs/";
    private static String OPERATION = "/OPERATIONs/";
    private static String DELIMITER = "/";
    private String policySubject = null;
    private Boolean isClient = false;
    private Boolean isEJB = false;
    private Boolean isOperation = false;
    private String app = null;
    private String module = null;
    private String service = null;
    private String serviceRef = null;
    private String ejb = null;
    private String subject = null;
    private String operation = null;
    private String port = null;

    public PolicySubject(String string) {
        this.policySubject = string;
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Invalid policy subject pattern: " + string);
        }
        this.init();
    }

    private void init() {
        int n = this.getNextIndex(0, WEB, EJB);
        int n2 = this.getNextIndex(n, SERVICE, CLIENT);
        int n3 = this.getNextIndex(n2, PORT, OPERATION);
        this.isEJB = this.policySubject.contains(EJB);
        String string = this.isEJB != false ? EJB : WEB;
        this.isClient = this.policySubject.contains(CLIENT);
        String string2 = this.isClient != false ? CLIENT : SERVICE;
        this.isOperation = this.policySubject.contains(OPERATION);
        String string3 = PORT;
        this.app = this.getApp(this.policySubject.substring(0, n));
        this.module = this.policySubject.substring(n + string.length(), n2);
        this.service = this.policySubject.substring(n2 + string2.length(), n3);
        this.subject = this.policySubject.substring(n3 + string3.length());
        if (this.isOperation.booleanValue()) {
            this.initOperation();
        } else {
            this.port = this.subject;
        }
        if (this.isClient.booleanValue()) {
            this.initClient();
        }
    }

    private int getNextIndex(int n, String string, String string2) {
        int n2 = this.policySubject.indexOf(string, n);
        if (n2 == -1 && (n2 = this.policySubject.indexOf(string2, n)) == -1) {
            throw new IllegalArgumentException("Invalid policy subject pattern: " + this.policySubject);
        }
        return n2;
    }

    private String getApp(String string) {
        String[] stringArray = string.split(DELIMITER);
        if (stringArray == null || stringArray.length != 4) {
            throw new IllegalArgumentException("Invalid policy subject pattern: " + this.policySubject);
        }
        return stringArray[3];
    }

    private void initClient() {
        if (this.isEJB.booleanValue()) {
            int n = this.service.indexOf(DELIMITER);
            if (n == -1) {
                throw new IllegalArgumentException("Invalid policy subject pattern: " + this.policySubject);
            }
            this.ejb = this.service.substring(0, n);
            this.serviceRef = this.service.substring(n + DELIMITER.length());
        } else {
            this.serviceRef = this.service;
        }
        this.service = null;
    }

    private void initOperation() {
        int n = this.subject.indexOf(OPERATION);
        this.port = this.subject.substring(0, n);
        this.subject = this.operation = this.subject.substring(n + OPERATION.length());
    }

    public String getAppName() {
        return this.app;
    }

    public String getModuleName() {
        return this.module;
    }

    public String getServiceName() {
        if (this.isClient.booleanValue()) {
            return null;
        }
        return this.service;
    }

    public String getServiceRefName() {
        if (this.isClient.booleanValue()) {
            return this.serviceRef;
        }
        return null;
    }

    public String getEJBName() {
        if (this.isClient.booleanValue()) {
            return this.ejb;
        }
        return null;
    }

    public String getSubjectName() {
        return this.subject;
    }

    public String getPortName() {
        return this.port;
    }

    public String getOperationName() {
        return this.operation;
    }

    public boolean isOperationType() {
        return this.isOperation;
    }

    public boolean isClientType() {
        return this.isClient;
    }
}

