/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.policy.deployment.config;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.enterprise.deploy.model.DDBeanRoot;
import javax.enterprise.deploy.model.exceptions.DDBeanCreateException;
import javax.enterprise.deploy.spi.DConfigBeanRoot;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.xml.namespace.QName;
import weblogic.deploy.api.model.WebLogicDDBeanRoot;
import weblogic.deploy.api.model.WebLogicDeployableObject;
import weblogic.j2ee.descriptor.EjbJarBean;
import weblogic.j2ee.descriptor.EnterpriseBeansBean;
import weblogic.j2ee.descriptor.EntityBeanBean;
import weblogic.j2ee.descriptor.PortComponentBean;
import weblogic.j2ee.descriptor.ServiceImplBeanBean;
import weblogic.j2ee.descriptor.ServletBean;
import weblogic.j2ee.descriptor.SessionBeanBean;
import weblogic.j2ee.descriptor.WebAppBean;
import weblogic.j2ee.descriptor.WebservicesBean;
import weblogic.j2ee.descriptor.wl.WeblogicWebservicesBean;
import weblogic.j2ee.descriptor.wl.WeblogicWebservicesBeanDConfig;
import weblogic.j2ee.descriptor.wl.WebserviceDescriptionBean;
import weblogic.j2ee.descriptor.wl.WebservicePolicyRefBean;
import weblogic.management.runtime.WseeV2RuntimeMBean;
import weblogic.wsee.policy.deployment.config.DeploymentConfigurationHelper;
import weblogic.wsee.policy.deployment.config.PolicyManagementException;

public class WebServiceBeanUtils {
    public static final String DIRECTION_BOTH = "both";
    public static final String DIRECTION_INBOUND = "inbound";
    public static final String DIRECTION_OUTBOUND = "outbound";
    public static final String POLICY_TYPE_WLS = "wls";
    public static final String POLICY_TYPE_OWSM = "owsm";
    public static final String POLICY_TYPE_UNKNOWN = "unknown";
    private static WebservicePolicyRefBean policyRefBean;

    public static String getServiceName(WseeV2RuntimeMBean wseeV2RuntimeMBean) {
        String string = wseeV2RuntimeMBean.getServiceName();
        int n = string.indexOf(33);
        if (n > 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public static String[] getServletMappingUris(WseeV2RuntimeMBean wseeV2RuntimeMBean) {
        if (wseeV2RuntimeMBean == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(wseeV2RuntimeMBean.getURI(), ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static WebAppBean getWebAppBean(DeploymentConfigurationHelper deploymentConfigurationHelper, String string) throws PolicyManagementException {
        WebAppBean webAppBean = null;
        try {
            WebLogicDeployableObject webLogicDeployableObject = deploymentConfigurationHelper.getDeployableObject(string);
            DDBeanRoot dDBeanRoot = webLogicDeployableObject.getDDBeanRoot("WEB-INF/web.xml");
            if (dDBeanRoot != null) {
                WebLogicDDBeanRoot webLogicDDBeanRoot = (WebLogicDDBeanRoot)dDBeanRoot;
                webAppBean = (WebAppBean)webLogicDDBeanRoot.getDescriptorBean();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (DDBeanCreateException dDBeanCreateException) {
            throw new PolicyManagementException(dDBeanCreateException);
        }
        catch (IOException iOException) {
            throw new PolicyManagementException(iOException);
        }
        return webAppBean;
    }

    public static EjbJarBean getEjbBean(DeploymentConfigurationHelper deploymentConfigurationHelper, String string) throws PolicyManagementException {
        EjbJarBean ejbJarBean = null;
        try {
            WebLogicDeployableObject webLogicDeployableObject = deploymentConfigurationHelper.getDeployableObject(string);
            DDBeanRoot dDBeanRoot = webLogicDeployableObject.getDDBeanRoot("META-INF/ejb-jar.xml");
            WebLogicDDBeanRoot webLogicDDBeanRoot = (WebLogicDDBeanRoot)dDBeanRoot;
            ejbJarBean = (EjbJarBean)webLogicDDBeanRoot.getDescriptorBean();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (DDBeanCreateException dDBeanCreateException) {
            throw new PolicyManagementException(dDBeanCreateException);
        }
        catch (IOException iOException) {
            throw new PolicyManagementException(iOException);
        }
        return ejbJarBean;
    }

    public static String getServiceClassName(String string, WebservicesBean webservicesBean, QName qName, boolean bl, WebAppBean webAppBean, EjbJarBean ejbJarBean) throws PolicyManagementException {
        String string2 = WebServiceBeanUtils.getLinkName(webservicesBean, string, qName, bl);
        String string3 = null;
        if (string2 != null) {
            string3 = bl ? WebServiceBeanUtils.getClassNameFromWebApp(string2, webAppBean) : WebServiceBeanUtils.getClassNameFromEJB(string2, ejbJarBean);
            if (string3 == null) {
                throw new PolicyManagementException("Could not get the class name");
            }
        } else {
            throw new PolicyManagementException("Could not find the link name");
        }
        return string3;
    }

    private static String getClassNameFromEJB(String string, EjbJarBean ejbJarBean) {
        String string2 = null;
        EnterpriseBeansBean enterpriseBeansBean = ejbJarBean.getEnterpriseBeans();
        SessionBeanBean[] sessionBeanBeanArray = enterpriseBeansBean.getSessions();
        for (int i = 0; sessionBeanBeanArray != null && i < sessionBeanBeanArray.length; ++i) {
            if (!string.equals(sessionBeanBeanArray[i].getEjbName())) continue;
            string2 = sessionBeanBeanArray[i].getEjbClass();
            break;
        }
        if (string2 == null) {
            EntityBeanBean[] entityBeanBeanArray = enterpriseBeansBean.getEntities();
            for (int i = 0; entityBeanBeanArray != null && i < entityBeanBeanArray.length; ++i) {
                if (!string.equals(entityBeanBeanArray[i].getEjbName())) continue;
                string2 = entityBeanBeanArray[i].getEjbClass();
                break;
            }
        }
        return string2;
    }

    private static String getClassNameFromWebApp(String string, WebAppBean webAppBean) {
        String string2 = null;
        ServletBean[] servletBeanArray = webAppBean.getServlets();
        for (int i = 0; servletBeanArray != null && i < servletBeanArray.length; ++i) {
            if (!string.equals(servletBeanArray[i].getServletName())) continue;
            string2 = servletBeanArray[i].getServletClass();
            break;
        }
        return string2;
    }

    public static WebservicesBean getWebservicesBean(DeploymentConfigurationHelper deploymentConfigurationHelper, String string, boolean bl) throws PolicyManagementException {
        try {
            WebservicesBean webservicesBean = null;
            WebLogicDeployableObject webLogicDeployableObject = deploymentConfigurationHelper.getDeployableObject(string);
            DDBeanRoot dDBeanRoot = null;
            dDBeanRoot = bl ? webLogicDeployableObject.getDDBeanRoot("WEB-INF/webservices.xml") : webLogicDeployableObject.getDDBeanRoot("META-INF/webservices.xml");
            if (dDBeanRoot != null) {
                WebLogicDDBeanRoot webLogicDDBeanRoot = (WebLogicDDBeanRoot)dDBeanRoot;
                webservicesBean = (WebservicesBean)webLogicDDBeanRoot.getDescriptorBean();
            }
            return webservicesBean;
        }
        catch (Exception exception) {
            throw new PolicyManagementException(exception);
        }
    }

    public static WeblogicWebservicesBean getWeblogicWebservicesBean(DeploymentConfigurationHelper deploymentConfigurationHelper, String string, boolean bl) throws PolicyManagementException {
        try {
            WeblogicWebservicesBeanDConfig weblogicWebservicesBeanDConfig;
            WebLogicDeployableObject webLogicDeployableObject = deploymentConfigurationHelper.getDeployableObject(string);
            DConfigBeanRoot dConfigBeanRoot = deploymentConfigurationHelper.getDeploymentConfiguration().getDConfigBeanRoot(webLogicDeployableObject.getDDBeanRoot());
            WeblogicWebservicesBean weblogicWebservicesBean = null;
            DDBeanRoot dDBeanRoot = null;
            dDBeanRoot = bl ? webLogicDeployableObject.getDDBeanRoot("WEB-INF/webservices.xml") : webLogicDeployableObject.getDDBeanRoot("META-INF/webservices.xml");
            if (dDBeanRoot != null && (weblogicWebservicesBeanDConfig = (WeblogicWebservicesBeanDConfig)dConfigBeanRoot.getDConfigBean(dDBeanRoot)) != null) {
                weblogicWebservicesBean = (WeblogicWebservicesBean)weblogicWebservicesBeanDConfig.getDescriptorBean();
            }
            return weblogicWebservicesBean;
        }
        catch (Exception exception) {
            throw new PolicyManagementException(exception);
        }
    }

    public static WebserviceDescriptionBean getWeblogicWebserviceDescriptionBean(DeploymentConfigurationHelper deploymentConfigurationHelper, String string, boolean bl, String string2) throws ConfigurationException, PolicyManagementException {
        WeblogicWebservicesBean weblogicWebservicesBean = WebServiceBeanUtils.getWeblogicWebservicesBean(deploymentConfigurationHelper, string, bl);
        if (weblogicWebservicesBean != null) {
            WebserviceDescriptionBean[] webserviceDescriptionBeanArray = weblogicWebservicesBean.getWebserviceDescriptions();
            for (int i = 0; webserviceDescriptionBeanArray != null && i < webserviceDescriptionBeanArray.length; ++i) {
                if (!webserviceDescriptionBeanArray[i].getWebserviceDescriptionName().equals(string2)) continue;
                return webserviceDescriptionBeanArray[i];
            }
        }
        return null;
    }

    public static String getWebServiceDescriptionName(DeploymentConfigurationHelper deploymentConfigurationHelper, String string, boolean bl, String string2) throws PolicyManagementException, ConfigurationException {
        WebserviceDescriptionBean webserviceDescriptionBean = WebServiceBeanUtils.getWeblogicWebserviceDescriptionBean(deploymentConfigurationHelper, string, bl, string2);
        return webserviceDescriptionBean != null ? webserviceDescriptionBean.getWebserviceDescriptionName() : null;
    }

    public static String getLinkName(WebservicesBean webservicesBean, String string, QName qName, boolean bl) {
        weblogic.j2ee.descriptor.WebserviceDescriptionBean[] webserviceDescriptionBeanArray = webservicesBean.getWebserviceDescriptions();
        String string2 = null;
        block0: for (int i = 0; webserviceDescriptionBeanArray != null && i < webserviceDescriptionBeanArray.length; ++i) {
            if (!string.equals(webserviceDescriptionBeanArray[i].getWebserviceDescriptionName())) continue;
            PortComponentBean[] portComponentBeanArray = webserviceDescriptionBeanArray[i].getPortComponents();
            for (int j = 0; portComponentBeanArray != null && j < portComponentBeanArray.length; ++j) {
                if (!qName.getLocalPart().equals(portComponentBeanArray[j].getWsdlPort().getLocalPart())) continue;
                ServiceImplBeanBean serviceImplBeanBean = portComponentBeanArray[j].getServiceImplBean();
                if (serviceImplBeanBean == null) break block0;
                if (bl) {
                    string2 = serviceImplBeanBean.getServletLink();
                    break block0;
                }
                string2 = serviceImplBeanBean.getEjbLink();
                break block0;
            }
            break;
        }
        return string2;
    }

    public static Class loadServiceClass(DeploymentConfigurationHelper deploymentConfigurationHelper, String string, String string2) throws PolicyManagementException {
        try {
            WebLogicDeployableObject webLogicDeployableObject = deploymentConfigurationHelper.getDeployableObject(string);
            return webLogicDeployableObject.getClassFromScope(string2);
        }
        catch (Exception exception) {
            throw new PolicyManagementException(exception);
        }
    }
}

