/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.policy.framework;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weblogic.utils.StackTraceUtils;
import weblogic.wsee.util.StringUtil;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.wss.Base64Encoding;
import weblogic.xml.dom.NamespaceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOMUtils {
    public static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    public static final String WS_POLICY_SCHEMA = "/weblogic/wsee/policy/schema/ws-policy.xsd";
    private static final boolean verbose = Verbose.isVerbose(DOMUtils.class);
    private static final boolean debug = false;

    public static boolean equalsQName(Node node, QName qName) {
        return weblogic.xml.dom.DOMUtils.equalsQName(node, qName);
    }

    public static QName getQNameOf(Node node) {
        if (node.getNamespaceURI() == null) {
            return new QName(node.getNodeName());
        }
        return new QName(node.getNamespaceURI(), node.getLocalName());
    }

    public static String getPathOf(Node node) {
        if (node == null) {
            throw new AssertionError();
        }
        StringBuffer stringBuffer = new StringBuffer(DOMUtils.getQNameOf(node).toString());
        for (Node node2 = node.getParentNode(); node2 != null && node2.getNodeType() == 1; node2 = node2.getParentNode()) {
            stringBuffer.insert(0, '/');
            stringBuffer.insert(0, DOMUtils.getQNameOf(node2).toString());
        }
        return stringBuffer.toString();
    }

    public static QName getQNameOf(String string, Node node, Map map) {
        String string2;
        String string3 = string.trim();
        int n = string3.indexOf(58);
        String string4 = null;
        String string5 = string3;
        if (n >= 0) {
            if (n == 0 || string3.length() - n <= 1) {
                throw new IllegalArgumentException("Malformed QName: '" + string + "'");
            }
            string4 = string3.substring(0, n);
            string5 = string3.substring(n + 1);
        }
        if (node.getNodeType() != 1) {
            node = node.getParentNode();
        }
        if ((string2 = DOMUtils.getNamespace(string4, (Element)node)) == null && map != null) {
            string2 = (String)map.get(string4);
        }
        if (string2 == null) {
            return new QName(string5);
        }
        return new QName(string2, string5, string4);
    }

    public static String getAttributeValueAsString(Element element, QName qName) {
        String string = weblogic.xml.dom.DOMUtils.getAttributeValueAsString(element, qName);
        return string;
    }

    public static QName getAttributeValueAsQName(Element element, QName qName) {
        String string = DOMUtils.getAttributeValueAsString(element, qName);
        if (string == null || string.length() == 0) {
            return null;
        }
        int n = string.indexOf(58);
        if (n >= 0) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            String string4 = DOMUtils.getNamespace(string2, element);
            return new QName(string4, string3, string2);
        }
        return new QName(string);
    }

    public static Boolean getAttributeValueAsBoolean(Element element, QName qName) {
        String string = DOMUtils.getAttributeValueAsString(element, qName).trim();
        if (string == null || string.length() == 0) {
            return null;
        }
        return string.equalsIgnoreCase("true") || string.equals("1");
    }

    public static URI getAttributeValueAsURI(Element element, QName qName) throws URISyntaxException {
        String string = DOMUtils.getAttributeValueAsString(element, qName).trim();
        if (string == null) {
            return null;
        }
        return new URI(string);
    }

    public static byte[] getAttributeValueAsByteArray(Element element, QName qName) {
        byte[] byArray = null;
        String string = DOMUtils.getAttributeValueAsString(element, qName).trim();
        if (string != null && string.length() > 0) {
            try {
                byArray = new Base64Encoding().decode(string);
            }
            catch (Throwable throwable) {
                throw new NumberFormatException("Could not decode attribute as a base64 encoded byte array: " + StackTraceUtils.throwable2StackTrace((Throwable)throwable));
            }
        }
        return byArray;
    }

    public static Map<String, String> getAttributeMap(Node node) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                hashMap.put(attr.getName(), attr.getValue());
            }
        }
        return hashMap;
    }

    public static String getTextContent(Element element, boolean bl) {
        String string = weblogic.xml.dom.DOMUtils.getTextContent(element, bl);
        if (verbose) {
            Verbose.log("text content of " + element + " is " + string);
        }
        return string;
    }

    public static QName getQNameContent(Element element) {
        String string = DOMUtils.getTextContent(element, true);
        int n = string.indexOf(58);
        if (n >= 0) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            String string4 = DOMUtils.getNamespace(string2, element);
            return new QName(string4, string3, string2);
        }
        return new QName(string);
    }

    public static String getNamespace(String string, Element element) {
        Node node;
        String string2;
        String string3 = null;
        String string4 = string2 = string == null ? "xmlns" : "xmlns:" + string;
        do {
            if ((string3 = element.getAttribute(string2)) == null || string3.equals("")) continue;
            return string3;
        } while ((node = element.getParentNode()).getNodeType() == 1 && (element = (Element)node) != null);
        return null;
    }

    public static Map<String, String> getNamespaceMapping(Node node) {
        Map<String, String> map = new HashMap<String, String>();
        while (node != null) {
            map = DOMUtils.getNodeNamespaceMapping(node, map);
            node = node.getParentNode();
        }
        return map;
    }

    public static Map<String, String> getNodeNamespaceMapping(Node node, Map<String, String> map) {
        NamedNodeMap namedNodeMap;
        if (map == null) {
            map = new HashMap<String, String>();
        }
        if (node != null && (namedNodeMap = node.getAttributes()) != null) {
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                String string = attr.getName();
                String string2 = null;
                if (string.startsWith("xmlns:")) {
                    string2 = string.substring(6);
                } else if (string.equals("xmlns")) {
                    string2 = "";
                }
                if (string2 == null || map.containsKey(string2)) continue;
                map.put(string2, attr.getValue());
            }
        }
        return map;
    }

    public static String getPrefix(String string, Element element) {
        assert (string != null);
        assert (element != null);
        do {
            NamedNodeMap namedNodeMap = element.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                String string2;
                Node node = namedNodeMap.item(i);
                String string3 = node.getNodeName();
                if (!string3.startsWith("xmlns:") || !string.equals(string2 = node.getNodeValue())) continue;
                return string3.substring(7);
            }
        } while ((element = (Element)element.getParentNode()) != null);
        return null;
    }

    public static Element createElement(QName qName, Document document) {
        Element element = null;
        String string = qName.getNamespaceURI();
        element = string.length() > 0 ? document.createElementNS(string, qName.getLocalPart()) : document.createElement(qName.getLocalPart());
        return element;
    }

    public static Element createElement(QName qName, Document document, String string) {
        Element element = null;
        String string2 = qName.getNamespaceURI();
        if (string2.length() > 0) {
            String string3 = qName.getLocalPart();
            if (!StringUtil.isEmpty(string)) {
                string3 = string + ":" + string3;
            }
            element = document.createElementNS(string2, string3);
        } else {
            element = document.createElement(qName.getLocalPart());
        }
        return element;
    }

    public static void addAttribute(Element element, QName qName, String string) {
        String string2 = qName.getNamespaceURI();
        if (string2.length() > 0) {
            element.setAttributeNS(string2, qName.getLocalPart(), string);
        } else {
            element.setAttribute(qName.getLocalPart(), string);
        }
    }

    public static void addPrefixedAttribute(Element element, QName qName, String string, String string2) {
        element.setAttributeNS(qName.getNamespaceURI(), string + ":" + qName.getLocalPart(), string2);
    }

    public static void addAttribute(Element element, QName qName, QName qName2) {
        String string = qName2.getNamespaceURI();
        if (string != null && string.length() > 0) {
            String string2 = DOMUtils.getPrefix(string, element);
            if (string2 == null) {
                string2 = qName2.getLocalPart() + "-ns";
                NamespaceUtils.defineNamespace((Element)element, (String)string2, (String)string);
            }
            DOMUtils.addAttribute(element, qName, string2 + ":" + qName2.getLocalPart());
        } else {
            DOMUtils.addAttribute(element, qName, qName2.toString());
        }
    }

    public static DocumentBuilder getParser() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            return documentBuilderFactory.newDocumentBuilder();
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new AssertionError((Object)factoryConfigurationError);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new AssertionError((Object)parserConfigurationException);
        }
    }

    public static void xml2Stream(Node node, Writer writer) throws IOException {
        block5: {
            Transformer transformer = null;
            try {
                transformer = TransformerFactory.newInstance().newTransformer();
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                throw new AssertionError((Object)transformerConfigurationException);
            }
            catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
                throw new AssertionError((Object)transformerFactoryConfigurationError);
            }
            try {
                transformer.transform(new DOMSource(node), new StreamResult(writer));
            }
            catch (TransformerException transformerException) {
                if (!verbose) break block5;
                Verbose.log(transformerException);
            }
        }
        writer.flush();
    }

    public static String toXMLString(Node node) {
        CharArrayWriter charArrayWriter;
        block2: {
            charArrayWriter = new CharArrayWriter();
            try {
                DOMUtils.xml2Stream(node, charArrayWriter);
            }
            catch (IOException iOException) {
                if (!verbose) break block2;
                Verbose.log(iOException);
            }
        }
        return charArrayWriter.toString();
    }

    public static List computeContent(List list) {
        ArrayList<NodeList> arrayList = new ArrayList<NodeList>();
        for (Node node : list) {
            ArrayList<Node> arrayList2 = new ArrayList<Node>();
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                arrayList2.add(node2);
            }
            if (arrayList2.size() <= 0) continue;
            arrayList.add(DOMUtils.newNodeListFromArrayOfNodes(arrayList2));
        }
        return arrayList;
    }

    private static NodeList newNodeListFromArrayOfNodes(final List list) {
        return new NodeList(){

            public Node item(int n) {
                return (Node)list.get(n);
            }

            public int getLength() {
                return list.size();
            }
        };
    }

    public static Node toXMLNode(String string) {
        if (StringUtil.isEmpty(string)) {
            return null;
        }
        Transformer transformer = null;
        try {
            transformer = TransformerFactory.newInstance().newTransformer();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new AssertionError((Object)transformerConfigurationException);
        }
        catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
            throw new AssertionError((Object)transformerFactoryConfigurationError);
        }
        try {
            DOMResult dOMResult = new DOMResult();
            transformer.transform(new StreamSource(new StringReader(string)), dOMResult);
            return dOMResult.getNode();
        }
        catch (TransformerException transformerException) {
            if (verbose) {
                Verbose.log(transformerException);
            }
            throw new AssertionError((Object)transformerException);
        }
    }
}

