/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.policy.framework;

import com.bea.xml.XmlException;
import com.bea.xml.XmlObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import weblogic.wsee.policy.deployment.ProviderRegistry;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyAlternative;
import weblogic.wsee.policy.framework.PolicyAssertion;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.framework.PolicyStatement;

public class ExternalizationUtils {
    private static final byte EXTVERSION_90 = 0;
    public static final byte EXTVERSION = 0;
    private static HashMap nameToClassMap = new HashMap();

    public static byte getExtVersion(ObjectInput objectInput) throws IOException {
        return objectInput.readByte();
    }

    public static void writeExtVersion(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(0);
    }

    public static void checkVersion(ObjectInput objectInput, byte by) throws IOException {
        if (by != 0) {
            throw new IOException("Policy version mis-matched");
        }
    }

    public static void registerExternalizable(QName qName, String string) {
        nameToClassMap.put(qName, string);
    }

    public static void writeQName(QName qName, ObjectOutput objectOutput) throws IOException {
        if (qName == null) {
            objectOutput.writeBoolean(false);
        } else {
            objectOutput.writeBoolean(true);
            objectOutput.writeUTF(qName.getNamespaceURI());
            objectOutput.writeUTF(qName.getLocalPart());
            objectOutput.writeUTF(qName.getPrefix());
        }
    }

    public static QName readQName(ObjectInput objectInput) throws IOException {
        if (objectInput.readBoolean()) {
            return new QName(objectInput.readUTF(), objectInput.readUTF(), objectInput.readUTF());
        }
        return null;
    }

    public static String getClassNameFromMap(QName qName) {
        return (String)nameToClassMap.get(qName);
    }

    public static void writeAssertions(Set set, ObjectOutput objectOutput) throws IOException {
        ArrayList<PolicyAssertion> arrayList = new ArrayList<PolicyAssertion>();
        for (PolicyAssertion policyAssertion : set) {
            String string;
            if (policyAssertion == null || (string = ExternalizationUtils.getClassNameFromMap(policyAssertion.getName())) == null) continue;
            arrayList.add(policyAssertion);
        }
        int n = arrayList.size();
        objectOutput.writeInt(n);
        for (int i = 0; i < n; ++i) {
            PolicyAssertion policyAssertion = (PolicyAssertion)arrayList.get(i);
            ExternalizationUtils.writeQName(policyAssertion.getName(), objectOutput);
            policyAssertion.writeExternal(objectOutput);
        }
    }

    public static Set readAssertions(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        LinkedHashSet<PolicyAssertion> linkedHashSet = new LinkedHashSet<PolicyAssertion>();
        for (int i = 0; i < n; ++i) {
            QName qName = ExternalizationUtils.readQName(objectInput);
            String string = ExternalizationUtils.getClassNameFromMap(qName);
            if (string == null) {
                throw new IOException("Need to register " + qName + " for externalization");
            }
            PolicyAssertion policyAssertion = null;
            try {
                policyAssertion = (PolicyAssertion)Class.forName(string).newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new IOException(instantiationException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IOException(illegalAccessException.getMessage());
            }
            policyAssertion.readExternal(objectInput);
            linkedHashSet.add(policyAssertion);
        }
        return linkedHashSet;
    }

    public static byte[] toByteArray(PolicyAlternative policyAlternative) throws IOException {
        if (null == policyAlternative) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        policyAlternative.writeExternal(objectOutputStream);
        objectOutputStream.flush();
        objectOutputStream.close();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static void writeAlternative(PolicyAlternative policyAlternative, ObjectOutput objectOutput) throws IOException {
        assert (policyAlternative != null);
        ExternalizationUtils.writeAssertions(policyAlternative.getAssertions(), objectOutput);
    }

    public static void writeAlternatives(Set set, ObjectOutput objectOutput) throws IOException {
        assert (set != null);
        int n = set.size();
        objectOutput.writeInt(n);
        for (PolicyAlternative policyAlternative : set) {
            ExternalizationUtils.writeAssertions(policyAlternative.getAssertions(), objectOutput);
        }
    }

    public static Set readAlternatives(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        LinkedHashSet<PolicyAlternative> linkedHashSet = new LinkedHashSet<PolicyAlternative>();
        int n = objectInput.readInt();
        for (int i = 0; i < n; ++i) {
            PolicyAlternative policyAlternative = new PolicyAlternative();
            policyAlternative.addAssertions(ExternalizationUtils.readAssertions(objectInput));
            linkedHashSet.add(policyAlternative);
        }
        return linkedHashSet;
    }

    public static byte[] readByteArray(ObjectInput objectInput) throws IOException {
        int n = objectInput.readInt();
        if (n > 0) {
            byte[] byArray = new byte[n];
            int n2 = 0;
            for (int i = 0; i < n; i += n2) {
                n2 = objectInput.read(byArray, i, n - i);
            }
            return byArray;
        }
        return null;
    }

    public static void writeXmlObject(XmlObject xmlObject, ObjectOutput objectOutput) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        xmlObject.save((OutputStream)byteArrayOutputStream);
        byteArrayOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        objectOutput.writeInt(byArray.length);
        objectOutput.write(byArray);
    }

    public static XmlObject readXmlObject(ObjectInput objectInput) throws IOException {
        byte[] byArray = ExternalizationUtils.readByteArray(objectInput);
        if (byArray == null) {
            return null;
        }
        try {
            return XmlObject.Factory.parse((InputStream)new ByteArrayInputStream(byArray));
        }
        catch (XmlException xmlException) {
            throw new IOException(xmlException.getMessage());
        }
    }

    public static void writePolicyStatement(PolicyStatement policyStatement, ObjectOutput objectOutput) throws IOException {
        if (policyStatement == null) {
            objectOutput.writeBoolean(false);
        } else {
            objectOutput.writeBoolean(true);
            policyStatement.writeExternal(objectOutput);
        }
    }

    public static PolicyStatement readPolicyStatement(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        if (objectInput.readBoolean()) {
            PolicyStatement policyStatement = new PolicyStatement();
            policyStatement.readExternal(objectInput);
            return policyStatement;
        }
        return null;
    }

    public static void writeNormalizedExpression(NormalizedExpression normalizedExpression, ObjectOutput objectOutput) throws IOException {
        if (normalizedExpression == null || normalizedExpression.isUninitialized()) {
            objectOutput.writeBoolean(false);
        } else {
            objectOutput.writeBoolean(true);
            normalizedExpression.writeExternal(objectOutput);
        }
    }

    public static NormalizedExpression readNormalizedExpression(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        if (objectInput.readBoolean()) {
            NormalizedExpression normalizedExpression = new NormalizedExpression();
            normalizedExpression.readExternal(objectInput);
            return normalizedExpression;
        }
        return null;
    }

    static {
        try {
            ProviderRegistry.getTheRegistry();
        }
        catch (PolicyException policyException) {
            throw new AssertionError((Object)policyException);
        }
    }
}

