/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.policy.framework;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weblogic.wsee.policy.framework.DOMUtils;
import weblogic.wsee.policy.framework.ExternalizationUtils;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.OperatorType;
import weblogic.wsee.policy.framework.PolicyAlternative;
import weblogic.wsee.policy.framework.PolicyAssertion;
import weblogic.wsee.policy.framework.PolicyConstants;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.framework.PolicyExpression;
import weblogic.wsee.policy.framework.PolicyStatement;
import weblogic.xml.dom.DOMProcessingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NestedPolicyAssertion
extends PolicyAssertion
implements Cloneable {
    private static final long serialVersionUID = 5657389624647138838L;
    protected NormalizedExpression nestedPolicy;

    public NormalizedExpression getNestedPolicy() {
        return this.nestedPolicy;
    }

    public void setNestedPolicy(NormalizedExpression normalizedExpression) {
        this.nestedPolicy = normalizedExpression;
    }

    protected void init(Element element) throws PolicyException {
        try {
            Element element2 = weblogic.xml.dom.DOMUtils.getOptionalElementByTagNameNS(element, "http://schemas.xmlsoap.org/ws/2004/09/policy", "Policy");
            if (element2 == null) {
                element2 = weblogic.xml.dom.DOMUtils.getOptionalElementByTagNameNS(element, "http://www.w3.org/ns/ws-policy", "Policy");
                if (null != element2) {
                    this.setPolicyNamespaceUri("http://www.w3.org/ns/ws-policy");
                }
            } else {
                this.setPolicyNamespaceUri("http://schemas.xmlsoap.org/ws/2004/09/policy");
            }
            if (element2 != null) {
                this.nestedPolicy = this.readPolicyStatement(element2).internalNormalize();
            }
        }
        catch (DOMProcessingException dOMProcessingException) {
            throw new PolicyException((Throwable)((Object)dOMProcessingException));
        }
    }

    protected NormalizedExpression addNestedPolicy(Set<PolicyAssertion> set) {
        PolicyAlternative policyAlternative = new PolicyAlternative();
        policyAlternative.addAssertions(set);
        NormalizedExpression normalizedExpression = new NormalizedExpression();
        normalizedExpression.addAlternative(policyAlternative);
        return normalizedExpression;
    }

    public abstract Set<PolicyAssertion> readNestedAssertion(Element var1) throws PolicyException;

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.nestedPolicy = ExternalizationUtils.readNormalizedExpression(objectInput);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        ExternalizationUtils.writeNormalizedExpression(this.nestedPolicy, objectOutput);
    }

    protected PolicyAssertion getNestedAssertion(Class clazz) {
        if (this.nestedPolicy != null) {
            return this.nestedPolicy.getPolicyAssertion(clazz);
        }
        return null;
    }

    protected Set<PolicyAssertion> getNestedAssertions(Class clazz) {
        LinkedHashSet<PolicyAssertion> linkedHashSet = new LinkedHashSet<PolicyAssertion>();
        Set set = this.nestedPolicy.getPolicyAlternatives();
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Iterator iterator2 = ((PolicyAlternative)iterator.next()).getAssertions(clazz).iterator();
                while (iterator2.hasNext()) {
                    linkedHashSet.add((PolicyAssertion)iterator2.next());
                }
            }
        }
        return linkedHashSet;
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return object;
    }

    private PolicyExpression readExpression(Element element) throws PolicyException {
        PolicyExpression policyExpression = null;
        OperatorType operatorType2 = null;
        if (PolicyConstants.ALL.getLocalPart().equals(element.getLocalName())) {
            operatorType2 = OperatorType.ALL;
        } else if (PolicyConstants.ONE_OR_MORE.getLocalPart().equals(element.getLocalName())) {
            operatorType2 = OperatorType.ONE_OR_MORE;
        } else if (PolicyConstants.EXACTLY_ONE.getLocalPart().equals(element.getLocalName())) {
            operatorType2 = OperatorType.EXACTLY_ONE;
        }
        policyExpression = operatorType2 != null ? this.readOperatorExpression(element, PolicyExpression.createExpression(operatorType2)) : (DOMUtils.equalsQName(element, PolicyConstants.POLICY_STATEMENT_ELEMENT) || DOMUtils.equalsQName(element, PolicyConstants.POLICY_STATEMENT_ELEMENT_15) ? this.readPolicyStatement(element) : this.readAssertionExpression(element));
        policyExpression.setPolicyNamespaceUri(this.policyNamespaceUri);
        return policyExpression;
    }

    private PolicyStatement readPolicyStatement(Element element) throws PolicyException {
        PolicyStatement policyStatement = PolicyStatement.createPolicyStatement(null);
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            PolicyExpression policyExpression = this.readExpression((Element)node);
            policyStatement.addExpression(policyExpression);
        }
        policyStatement.setPolicyNamespaceUri(this.policyNamespaceUri);
        return policyStatement;
    }

    private PolicyExpression readOperatorExpression(Element element, PolicyExpression policyExpression) throws PolicyException {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            policyExpression.addExpression(this.readExpression((Element)node));
        }
        policyExpression.setPolicyNamespaceUri(this.policyNamespaceUri);
        return policyExpression;
    }

    private PolicyExpression readAssertionExpression(Element element) throws PolicyException {
        Set<PolicyAssertion> set = this.readNestedAssertion(element);
        PolicyExpression policyExpression = null;
        if (set.size() > 1) {
            policyExpression = PolicyExpression.createExpression(OperatorType.EXACTLY_ONE);
            for (PolicyAssertion policyAssertion : set) {
                policyExpression.addExpression(PolicyExpression.createTerminal(policyAssertion));
            }
        } else {
            PolicyAssertion policyAssertion = set.iterator().next();
            if (null != policyAssertion) {
                policyAssertion.setPolicyNamespaceUri(this.policyNamespaceUri);
            }
            policyExpression = PolicyExpression.createTerminal(policyAssertion);
        }
        policyExpression.setPolicyNamespaceUri(this.policyNamespaceUri);
        return policyExpression;
    }
}

