/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.policy.framework;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import weblogic.wsee.mc.internal.MCSupported;
import weblogic.wsee.policy.framework.ExternalizationUtils;
import weblogic.wsee.policy.framework.NestedPolicyAssertion;
import weblogic.wsee.policy.framework.OperatorType;
import weblogic.wsee.policy.framework.PolicyAlternative;
import weblogic.wsee.policy.framework.PolicyAssertion;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.framework.PolicyExpression;
import weblogic.wsee.policy.framework.PolicyMath;
import weblogic.wsee.policy.framework.PolicyStatement;
import weblogic.wsee.policy.util.PolicyHelper;

public class NormalizedExpression
implements Externalizable {
    private static final long serialVersionUID = 68366604685464881L;
    private static final boolean debug = false;
    protected String policyNamespaceUri = "http://schemas.xmlsoap.org/ws/2004/09/policy";
    private Set alts = null;

    public NormalizedExpression() {
    }

    public NormalizedExpression(String string) {
        this.policyNamespaceUri = string;
    }

    public String getPolicyNamespaceUri() {
        return this.policyNamespaceUri;
    }

    public void setPolicyNamespaceUri(String string) {
        this.policyNamespaceUri = string;
    }

    public static NormalizedExpression createFromPolicyAlternatives(Set set) {
        assert (set != null);
        NormalizedExpression normalizedExpression = new NormalizedExpression();
        normalizedExpression.addAlternatives(set);
        normalizedExpression.setPolicyNamespaceUri(PolicyHelper.getPolicyNamespaceUri(set));
        return normalizedExpression;
    }

    public static NormalizedExpression createEmptyExpression() {
        return NormalizedExpression.createFromPolicyAlternatives(new LinkedHashSet());
    }

    public static NormalizedExpression createUnitializedExpression() {
        return new NormalizedExpression();
    }

    static NormalizedExpression createFromPolicyExpression(PolicyExpression policyExpression) throws PolicyException {
        NormalizedExpression normalizedExpression = NormalizedExpression.createUnitializedExpression();
        if (policyExpression.assertion != null && NestedPolicyAssertion.class.isAssignableFrom(policyExpression.assertion.getClass()) && policyExpression.operator == OperatorType.TERMINAL) {
            NestedPolicyAssertion nestedPolicyAssertion = (NestedPolicyAssertion)policyExpression.assertion;
            NormalizedExpression normalizedExpression2 = nestedPolicyAssertion.nestedPolicy;
            if (normalizedExpression2 != null && normalizedExpression2.getPolicyAlternatives() != null && normalizedExpression2.getPolicyAlternatives().size() > 1) {
                Iterator iterator = normalizedExpression2.getPolicyAlternatives().iterator();
                while (iterator.hasNext()) {
                    LinkedHashSet linkedHashSet = new LinkedHashSet();
                    linkedHashSet.add(iterator.next());
                    NestedPolicyAssertion nestedPolicyAssertion2 = (NestedPolicyAssertion)nestedPolicyAssertion.clone();
                    nestedPolicyAssertion2.setNestedPolicy(NormalizedExpression.createFromPolicyAlternatives(linkedHashSet));
                    normalizedExpression.addAlternative(new PolicyAlternative(new PolicyAssertion[]{nestedPolicyAssertion2}));
                }
            } else {
                PolicyAlternative policyAlternative = new PolicyAlternative(new PolicyAssertion[]{policyExpression.assertion});
                normalizedExpression.addAlternative(policyAlternative);
            }
            if (policyExpression.assertion != null && policyExpression.assertion.getOptional()) {
                normalizedExpression.addAlternative(PolicyAlternative.EMPTY_ALTERNATIVE);
            }
        } else if (policyExpression.operator == OperatorType.TERMINAL) {
            PolicyAlternative policyAlternative = new PolicyAlternative(new PolicyAssertion[]{policyExpression.assertion});
            normalizedExpression.addAlternative(policyAlternative);
            if (policyExpression.assertion != null && policyExpression.assertion.getOptional() && !(policyExpression.assertion instanceof MCSupported)) {
                normalizedExpression.addAlternative(PolicyAlternative.EMPTY_ALTERNATIVE);
            }
        } else {
            Iterator iterator = policyExpression.expressions.iterator();
            NormalizedExpression normalizedExpression3 = null;
            if (policyExpression.operator == OperatorType.EXACTLY_ONE && !iterator.hasNext()) {
                normalizedExpression = NormalizedExpression.createEmptyExpression();
                normalizedExpression.setPolicyNamespaceUri(policyExpression.getPolicyNamespaceUri());
            } else {
                normalizedExpression3 = NormalizedExpression.createUnitializedExpression();
                normalizedExpression3.setPolicyNamespaceUri(policyExpression.getPolicyNamespaceUri());
                while (iterator.hasNext()) {
                    PolicyExpression policyExpression2 = (PolicyExpression)iterator.next();
                    NormalizedExpression normalizedExpression4 = policyExpression2.normalize();
                    if (normalizedExpression3 == null) {
                        normalizedExpression3 = normalizedExpression4;
                        continue;
                    }
                    if (policyExpression.operator == OperatorType.ALL) {
                        normalizedExpression3 = PolicyMath.all(normalizedExpression3, normalizedExpression4);
                        continue;
                    }
                    if (policyExpression.operator == OperatorType.EXACTLY_ONE) {
                        normalizedExpression3 = PolicyMath.exactlyOne(normalizedExpression3, normalizedExpression4);
                        continue;
                    }
                    if (policyExpression.operator == OperatorType.ONE_OR_MORE) {
                        normalizedExpression3 = PolicyMath.oneOrMore(normalizedExpression3, normalizedExpression4);
                        continue;
                    }
                    throw new AssertionError((Object)("Unknown operator type: " + policyExpression.operator));
                }
                normalizedExpression = normalizedExpression3;
            }
        }
        normalizedExpression.setPolicyNamespaceUri(policyExpression.getPolicyNamespaceUri());
        return normalizedExpression;
    }

    static NormalizedExpression createFromPolicyExpressionInternal(PolicyExpression policyExpression) throws PolicyException {
        NormalizedExpression normalizedExpression = NormalizedExpression.createUnitializedExpression();
        if (policyExpression.operator == OperatorType.TERMINAL) {
            PolicyAlternative policyAlternative = new PolicyAlternative(new PolicyAssertion[]{policyExpression.assertion});
            normalizedExpression.addAlternative(policyAlternative);
        } else {
            Iterator iterator = policyExpression.expressions.iterator();
            NormalizedExpression normalizedExpression2 = null;
            if (policyExpression.operator == OperatorType.EXACTLY_ONE && !iterator.hasNext()) {
                normalizedExpression = NormalizedExpression.createEmptyExpression();
                normalizedExpression.setPolicyNamespaceUri(policyExpression.getPolicyNamespaceUri());
            } else {
                normalizedExpression2 = NormalizedExpression.createUnitializedExpression();
                normalizedExpression2.setPolicyNamespaceUri(policyExpression.getPolicyNamespaceUri());
                while (iterator.hasNext()) {
                    PolicyExpression policyExpression2 = (PolicyExpression)iterator.next();
                    NormalizedExpression normalizedExpression3 = policyExpression2.internalNormalize();
                    if (normalizedExpression2 == null) {
                        normalizedExpression2 = normalizedExpression3;
                        continue;
                    }
                    if (policyExpression.operator == OperatorType.ALL) {
                        normalizedExpression2 = PolicyMath.all(normalizedExpression2, normalizedExpression3);
                        continue;
                    }
                    if (policyExpression.operator == OperatorType.EXACTLY_ONE) {
                        normalizedExpression2 = PolicyMath.exactlyOne(normalizedExpression2, normalizedExpression3);
                        continue;
                    }
                    if (policyExpression.operator == OperatorType.ONE_OR_MORE) {
                        normalizedExpression2 = PolicyMath.oneOrMore(normalizedExpression2, normalizedExpression3);
                        continue;
                    }
                    throw new AssertionError((Object)("Unknown operator type: " + policyExpression.operator));
                }
                normalizedExpression = normalizedExpression2;
            }
        }
        normalizedExpression.setPolicyNamespaceUri(policyExpression.getPolicyNamespaceUri());
        return normalizedExpression;
    }

    public void addAlternative(PolicyAlternative policyAlternative) {
        assert (policyAlternative != null);
        if (this.alts == null) {
            this.alts = new LinkedHashSet();
        }
        this.alts.add(policyAlternative);
    }

    public void addAlternatives(Set set) {
        assert (set != null);
        if (this.alts == null) {
            this.alts = new LinkedHashSet();
        }
        this.alts.addAll(set);
    }

    public boolean isEmpty() {
        return this.alts != null && this.alts.size() == 0;
    }

    public boolean isUninitialized() {
        return this.alts == null;
    }

    public Set getPolicyAlternatives() {
        return this.alts == null ? null : new LinkedHashSet(this.alts);
    }

    public PolicyAlternative getPolicyAlternative() {
        if (this.alts == null || this.alts.size() == 0) {
            return null;
        }
        return (PolicyAlternative)this.alts.iterator().next();
    }

    public Set getPolicyAlternatives(PolicyAssertion policyAssertion) {
        if (this.alts == null) {
            return null;
        }
        LinkedHashSet<PolicyAlternative> linkedHashSet = new LinkedHashSet<PolicyAlternative>();
        for (PolicyAlternative policyAlternative : this.alts) {
            if (!policyAlternative.isTrue(policyAssertion)) continue;
            linkedHashSet.add(policyAlternative);
        }
        return linkedHashSet;
    }

    public Set getPolicyAlternatives(Class clazz) {
        if (this.alts == null) {
            return null;
        }
        LinkedHashSet<PolicyAlternative> linkedHashSet = new LinkedHashSet<PolicyAlternative>();
        for (PolicyAlternative policyAlternative : this.alts) {
            if (policyAlternative.getAssertions(clazz).size() <= 0) continue;
            linkedHashSet.add(policyAlternative);
        }
        return linkedHashSet;
    }

    public boolean containsPolicyAssertion(Class clazz) {
        return !this.isUninitialized() && !this.isEmpty() && this.getPolicyAlternatives(clazz).size() > 0;
    }

    public PolicyAssertion getPolicyAssertion(Class clazz) {
        if (this.alts != null) {
            LinkedHashSet linkedHashSet = new LinkedHashSet();
            for (PolicyAlternative policyAlternative : this.alts) {
                Set set = policyAlternative.getAssertions(clazz);
                if (set.isEmpty()) continue;
                return (PolicyAssertion)set.iterator().next();
            }
        }
        return null;
    }

    public String toString() {
        return this.toCompactForm(null).toString();
    }

    public PolicyStatement toCompactForm(String string) {
        PolicyStatement policyStatement = new PolicyStatement(null, this.policyNamespaceUri);
        if (this.alts == null) {
            PolicyExpression policyExpression = PolicyExpression.createExpression(OperatorType.ALL);
            policyExpression.setPolicyNamespaceUri(this.policyNamespaceUri);
            PolicyExpression policyExpression2 = PolicyExpression.createExpression(OperatorType.EXACTLY_ONE);
            policyExpression2.setPolicyNamespaceUri(this.policyNamespaceUri);
            policyExpression2.addExpression(policyExpression);
            policyStatement.addExpression(policyExpression2);
        } else {
            PolicyExpression policyExpression = new PolicyExpression(OperatorType.EXACTLY_ONE);
            policyExpression.setPolicyNamespaceUri(this.policyNamespaceUri);
            for (PolicyAlternative policyAlternative : this.alts) {
                PolicyExpression policyExpression3 = new PolicyExpression(OperatorType.ALL);
                policyExpression3.setPolicyNamespaceUri(this.policyNamespaceUri);
                for (PolicyAssertion policyAssertion : policyAlternative.getAssertions()) {
                    policyExpression3.addExpression(new PolicyExpression(OperatorType.TERMINAL, policyAssertion));
                }
                policyExpression.addExpression(policyExpression3);
            }
            policyStatement.addExpression(policyExpression);
        }
        return policyStatement;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof NormalizedExpression)) {
            return false;
        }
        NormalizedExpression normalizedExpression = (NormalizedExpression)object;
        return this.alts == null && normalizedExpression.alts == null || ((Object)this.alts).equals(normalizedExpression.alts);
    }

    public int hashCode() {
        if (this.alts == null) {
            return this.getClass().hashCode();
        }
        return ((Object)this.alts).hashCode();
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.alts = ExternalizationUtils.readAlternatives(objectInput);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        LinkedHashSet linkedHashSet = this.alts;
        if (linkedHashSet == null) {
            linkedHashSet = new LinkedHashSet();
        }
        ExternalizationUtils.writeAlternatives(linkedHashSet, objectOutput);
    }
}

