/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.policy.framework;

import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import weblogic.wsee.policy.framework.ExternalizationUtils;
import weblogic.wsee.policy.framework.PolicyAssertion;
import weblogic.wsee.util.Verbose;

public class PolicyAlternative
implements Externalizable {
    private static final long serialVersionUID = -5879815143243327105L;
    public static final PolicyAlternative EMPTY_ALTERNATIVE = new PolicyAlternative();
    private static final boolean verbose = Verbose.isVerbose(PolicyAlternative.class);
    private static final boolean debug = false;
    private Set assertions = new LinkedHashSet();
    private Set cacheClasses = new HashSet();
    private HashMap cacheClassAssertions = new HashMap();

    public PolicyAlternative() {
    }

    PolicyAlternative(PolicyAssertion[] policyAssertionArray) {
        this.assertions.addAll(Arrays.asList((Object[])policyAssertionArray));
    }

    void addAssertions(Set set) {
        assert (set != null);
        this.assertions.addAll(set);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            this.removeCachedKeys((PolicyAssertion)iterator.next());
        }
    }

    void addAssertion(PolicyAssertion policyAssertion) {
        assert (policyAssertion != null);
        this.assertions.add(policyAssertion);
        this.removeCachedKeys(policyAssertion);
    }

    void removeAssertion(PolicyAssertion policyAssertion) {
        assert (policyAssertion != null);
        this.assertions.remove(policyAssertion);
        this.removeCachedKeys(policyAssertion);
    }

    void removeCachedKeys(PolicyAssertion policyAssertion) {
        Iterator iterator = this.cacheClassAssertions.keySet().iterator();
        Class clazz = null;
        while (iterator.hasNext()) {
            clazz = (Class)iterator.next();
            if (!clazz.isInstance(policyAssertion)) continue;
            this.cacheClassAssertions.remove(clazz);
        }
    }

    void clearAssertions() {
        this.assertions.clear();
        this.cacheClassAssertions.clear();
    }

    public Set getAssertions() {
        return this.assertions;
    }

    public boolean isTrue(PolicyAssertion policyAssertion) {
        assert (policyAssertion != null);
        return this.assertions.contains(policyAssertion);
    }

    public Set getAssertions(Class clazz) {
        assert (clazz != null);
        if (this.cacheClassAssertions.containsKey(clazz)) {
            return (Set)this.cacheClassAssertions.get(clazz);
        }
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        for (Object e : this.assertions) {
            if (!clazz.isInstance(e)) continue;
            linkedHashSet.add(e);
        }
        this.cacheClassAssertions.put(clazz, linkedHashSet);
        return linkedHashSet;
    }

    public boolean isEmpty() {
        return this.assertions.isEmpty();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        Iterator iterator = this.assertions.iterator();
        if (iterator.hasNext()) {
            stringBuffer.append(iterator.next().toString());
        }
        while (iterator.hasNext()) {
            stringBuffer.append(',');
            stringBuffer.append(iterator.next().toString());
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PolicyAlternative)) {
            return false;
        }
        PolicyAlternative policyAlternative = (PolicyAlternative)object;
        return ((Object)this.assertions).equals(policyAlternative.assertions);
    }

    public int hashCode() {
        return ((Object)this.assertions).hashCode();
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.assertions = ExternalizationUtils.readAssertions(objectInput);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        ExternalizationUtils.writeAssertions(this.assertions, objectOutput);
    }

    public PolicyAlternative clone() {
        try {
            byte[] byArray = ExternalizationUtils.toByteArray(this);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            PolicyAlternative policyAlternative = new PolicyAlternative();
            policyAlternative.readExternal(objectInputStream);
            return policyAlternative;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            Verbose.log((Object)"Clone policy IO Error", iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            Verbose.log((Object)"Clone policy ClassNotFoundException Error", classNotFoundException);
        }
        return null;
    }
}

