/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.policy.framework;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import weblogic.wsee.policy.framework.ExternalizationUtils;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.wsdl.WsdlWriter;

public abstract class PolicyAssertion
implements Externalizable {
    private static final long serialVersionUID = 6865802012902454676L;
    private byte version;
    protected boolean optional = false;
    private PolicySubject subject = PolicySubject.undefined;
    protected String policyNamespaceUri = "http://schemas.xmlsoap.org/ws/2004/09/policy";

    public boolean getOptional() {
        return this.optional;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean bl) {
        this.optional = bl;
    }

    public void setPolicySubject(PolicySubject policySubject) {
        this.subject = policySubject;
    }

    public String getPolicyNamespaceUri() {
        return this.policyNamespaceUri;
    }

    public void setPolicyNamespaceUri(String string) {
        this.policyNamespaceUri = string;
    }

    public PolicySubject getPolicySubject() {
        return this.subject;
    }

    public abstract Element serialize(Document var1) throws PolicyException;

    public abstract QName getName();

    protected void write(Element element, WsdlWriter wsdlWriter) {
        try {
            element.appendChild(this.serialize(element.getOwnerDocument()));
        }
        catch (PolicyException policyException) {
            throw new AssertionError((Object)policyException);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.version = ExternalizationUtils.getExtVersion(objectInput);
        ExternalizationUtils.checkVersion(objectInput, this.version);
        this.optional = objectInput.readBoolean();
        this.subject = (PolicySubject)((Object)objectInput.readObject());
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        ExternalizationUtils.writeExtVersion(objectOutput);
        objectOutput.writeBoolean(this.optional);
        objectOutput.writeObject((Object)this.subject);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PolicySubject {
        undefined,
        message,
        operation,
        endpoint;

    }
}

