/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.policy.framework;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import weblogic.wsee.policy.framework.DOMUtils;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.OperatorType;
import weblogic.wsee.policy.framework.PolicyAssertion;
import weblogic.wsee.policy.framework.PolicyConstants;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.util.PolicyHelper;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.wsdl.WsdlWriter;

public class PolicyExpression
implements Externalizable {
    private static final long serialVersionUID = -6972053942488988205L;
    private static final boolean verbose = Verbose.isVerbose(PolicyExpression.class);
    private static final boolean debug = false;
    protected OperatorType operator;
    protected List expressions = new ArrayList();
    protected PolicyAssertion assertion;
    protected String policyNamespaceUri = "http://schemas.xmlsoap.org/ws/2004/09/policy";

    public PolicyExpression() {
    }

    protected PolicyExpression(OperatorType operatorType2) {
        assert (operatorType2 != null && operatorType2 != OperatorType.TERMINAL);
        this.operator = operatorType2;
    }

    protected PolicyExpression(OperatorType operatorType2, PolicyAssertion policyAssertion) {
        assert (operatorType2 == OperatorType.TERMINAL);
        this.operator = operatorType2;
        this.assertion = policyAssertion;
    }

    public PolicyAssertion getAssertion() {
        assert (this.operator == OperatorType.TERMINAL);
        return this.assertion;
    }

    public String getPolicyNamespaceUri() {
        return this.policyNamespaceUri;
    }

    public void setPolicyNamespaceUri(String string) {
        this.policyNamespaceUri = string;
    }

    public void setAssertion(PolicyAssertion policyAssertion) {
        assert (this.operator == OperatorType.TERMINAL);
        this.assertion = policyAssertion;
    }

    public List getExpressions() {
        assert (this.operator != null && this.operator != OperatorType.TERMINAL);
        return this.expressions;
    }

    public void addExpression(PolicyExpression policyExpression) {
        assert (this.operator != null && this.operator != OperatorType.TERMINAL);
        this.expressions.add(policyExpression);
    }

    public void addExpressions(Collection collection) {
        assert (this.operator != null && this.operator != OperatorType.TERMINAL);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.addExpression((PolicyExpression)iterator.next());
        }
    }

    public NormalizedExpression normalize() throws PolicyException {
        return NormalizedExpression.createFromPolicyExpression(this);
    }

    NormalizedExpression internalNormalize() throws PolicyException {
        return NormalizedExpression.createFromPolicyExpressionInternal(this);
    }

    public void resetExpressions() {
        assert (this.operator != null && this.operator != OperatorType.TERMINAL);
        this.expressions.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Element toXML(Document document) throws PolicyException {
        Element element = null;
        if (this.operator == OperatorType.TERMINAL) {
            element = this.assertion.serialize(document);
            PolicyHelper.checkOptionNamespaceUri(element, this.getPolicyNamespaceUri());
        } else {
            if ("http://www.w3.org/ns/ws-policy".equals(this.getPolicyNamespaceUri())) {
                if (this.operator == OperatorType.EXACTLY_ONE) {
                    element = DOMUtils.createElement(PolicyConstants.EXACTLY_ONE_15, document);
                } else if (this.operator == OperatorType.ONE_OR_MORE) {
                    element = DOMUtils.createElement(PolicyConstants.ONE_OR_MORE_15, document);
                } else {
                    if (this.operator != OperatorType.ALL) throw new AssertionError((Object)("Unrecognized operator type: " + this.operator));
                    element = DOMUtils.createElement(PolicyConstants.ALL_15, document);
                }
            } else if (this.operator == OperatorType.EXACTLY_ONE) {
                element = DOMUtils.createElement(PolicyConstants.EXACTLY_ONE, document);
            } else if (this.operator == OperatorType.ONE_OR_MORE) {
                element = DOMUtils.createElement(PolicyConstants.ONE_OR_MORE, document);
            } else {
                if (this.operator != OperatorType.ALL) throw new AssertionError((Object)("Unrecognized operator type: " + this.operator));
                element = DOMUtils.createElement(PolicyConstants.ALL, document);
            }
            for (PolicyExpression policyExpression : this.expressions) {
                element.appendChild(policyExpression.toXML(document));
            }
        }
        if (element != null) return element;
        throw new AssertionError((Object)("toXML() incorrectly returned null: operator=" + this.operator + ", assertion=" + this.assertion));
    }

    protected void write(Element element, WsdlWriter wsdlWriter) {
        Element element2 = null;
        if (this.operator == OperatorType.TERMINAL) {
            this.assertion.write(element, wsdlWriter);
        } else {
            if (this.operator == OperatorType.EXACTLY_ONE) {
                element2 = wsdlWriter.addChild(element, PolicyConstants.EXACTLY_ONE.getLocalPart(), this.policyNamespaceUri);
            } else if (this.operator == OperatorType.ONE_OR_MORE) {
                element2 = wsdlWriter.addChild(element, PolicyConstants.ONE_OR_MORE.getLocalPart(), this.policyNamespaceUri);
            } else if (this.operator == OperatorType.ALL) {
                element2 = wsdlWriter.addChild(element, PolicyConstants.ALL.getLocalPart(), this.policyNamespaceUri);
            } else {
                throw new AssertionError((Object)("Unrecognized operator type: " + this.operator));
            }
            for (PolicyExpression policyExpression : this.expressions) {
                policyExpression.write(element2, wsdlWriter);
            }
        }
    }

    public String toString() {
        return "EXPR[" + this.hashCode() + "]";
    }

    public static PolicyExpression createTerminal(PolicyAssertion policyAssertion) {
        return new PolicyExpression(OperatorType.TERMINAL, policyAssertion);
    }

    public static PolicyExpression createExpression(OperatorType operatorType2) {
        return new PolicyExpression(operatorType2);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.operator = (OperatorType)objectInput.readObject();
        this.expressions = (ArrayList)objectInput.readObject();
        this.assertion = (PolicyAssertion)objectInput.readObject();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.operator);
        objectOutput.writeObject(this.expressions);
        objectOutput.writeObject(this.assertion);
    }
}

