/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.policy.framework;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyAlternative;
import weblogic.wsee.policy.framework.PolicyAssertion;

public class PolicyMath {
    private static final boolean debug = false;

    public static NormalizedExpression merge(NormalizedExpression normalizedExpression, NormalizedExpression normalizedExpression2) {
        return PolicyMath.all(normalizedExpression, normalizedExpression2);
    }

    public static NormalizedExpression intersect(NormalizedExpression normalizedExpression, NormalizedExpression normalizedExpression2) {
        NormalizedExpression normalizedExpression3 = NormalizedExpression.createUnitializedExpression();
        NormalizedExpression normalizedExpression4 = NormalizedExpression.createUnitializedExpression();
        Set set = normalizedExpression.getPolicyAlternatives();
        Set set2 = normalizedExpression2.getPolicyAlternatives();
        if (set != null && set2 != null) {
            PolicyAlternative[] policyAlternativeArray = set.toArray(new PolicyAlternative[0]);
            PolicyAlternative[] policyAlternativeArray2 = set2.toArray(new PolicyAlternative[0]);
            for (int i = 0; i < policyAlternativeArray.length; ++i) {
                for (int j = 0; j < policyAlternativeArray2.length; ++j) {
                    if (!PolicyMath.isSameVocabulary(policyAlternativeArray[i], policyAlternativeArray2[j])) continue;
                    normalizedExpression3.addAlternative(policyAlternativeArray[i]);
                    normalizedExpression4.addAlternative(policyAlternativeArray2[j]);
                }
            }
        }
        return PolicyMath.all(normalizedExpression3, normalizedExpression4);
    }

    public static boolean isSameVocabulary(PolicyAlternative policyAlternative, PolicyAlternative policyAlternative2) {
        int n;
        if (policyAlternative.getAssertions().size() != policyAlternative2.getAssertions().size()) {
            return false;
        }
        PolicyAssertion[] policyAssertionArray = policyAlternative.getAssertions().toArray(new PolicyAssertion[0]);
        PolicyAssertion[] policyAssertionArray2 = policyAlternative2.getAssertions().toArray(new PolicyAssertion[0]);
        HashMap<QName, PolicyAssertion> hashMap = new HashMap<QName, PolicyAssertion>();
        for (n = 0; n < policyAssertionArray.length; ++n) {
            if (policyAssertionArray[n].getName() == null) continue;
            hashMap.put(policyAssertionArray[n].getName(), policyAssertionArray[n]);
        }
        for (n = 0; n < policyAssertionArray2.length; ++n) {
            if (hashMap.get(policyAssertionArray2[n].getName()) != null) continue;
            return false;
        }
        return true;
    }

    public static NormalizedExpression all(NormalizedExpression normalizedExpression, NormalizedExpression normalizedExpression2) {
        LinkedHashSet<PolicyAlternative> linkedHashSet = null;
        Set set = normalizedExpression.getPolicyAlternatives();
        LinkedHashSet<PolicyAlternative> linkedHashSet2 = normalizedExpression2.getPolicyAlternatives();
        if (normalizedExpression.isEmpty() || normalizedExpression2.isEmpty()) {
            return NormalizedExpression.createEmptyExpression();
        }
        if (set == null) {
            if (linkedHashSet2 == null) {
                return NormalizedExpression.createUnitializedExpression();
            }
            linkedHashSet = linkedHashSet2;
        } else if (linkedHashSet2 == null) {
            linkedHashSet = set;
        } else {
            linkedHashSet = new LinkedHashSet<PolicyAlternative>();
            for (PolicyAlternative policyAlternative : set) {
                for (PolicyAlternative policyAlternative2 : linkedHashSet2) {
                    PolicyAlternative policyAlternative3 = new PolicyAlternative();
                    policyAlternative3.addAssertions(policyAlternative.getAssertions());
                    policyAlternative3.addAssertions(policyAlternative2.getAssertions());
                    linkedHashSet.add(policyAlternative3);
                }
            }
        }
        return NormalizedExpression.createFromPolicyAlternatives(linkedHashSet);
    }

    public static NormalizedExpression exactlyOne(NormalizedExpression normalizedExpression, NormalizedExpression normalizedExpression2) {
        Set set = normalizedExpression.getPolicyAlternatives();
        Set set2 = normalizedExpression2.getPolicyAlternatives();
        if (normalizedExpression.isEmpty() || normalizedExpression2.isEmpty()) {
            return NormalizedExpression.createEmptyExpression();
        }
        if (normalizedExpression.isUninitialized() && normalizedExpression2.isUninitialized()) {
            return NormalizedExpression.createUnitializedExpression();
        }
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        if (set != null) {
            linkedHashSet.addAll(set);
        }
        if (set2 != null) {
            linkedHashSet.addAll(set2);
        }
        return NormalizedExpression.createFromPolicyAlternatives(linkedHashSet);
    }

    public static NormalizedExpression oneOrMore(NormalizedExpression normalizedExpression, NormalizedExpression normalizedExpression2) {
        NormalizedExpression normalizedExpression3 = PolicyMath.exactlyOne(normalizedExpression, normalizedExpression2);
        NormalizedExpression normalizedExpression4 = PolicyMath.all(normalizedExpression, normalizedExpression2);
        return PolicyMath.exactlyOne(normalizedExpression3, normalizedExpression4);
    }
}

