/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.policy.framework;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import weblogic.wsee.policy.framework.DOMUtils;
import weblogic.wsee.policy.framework.OperatorType;
import weblogic.wsee.policy.framework.PolicyConstants;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.framework.PolicyExpression;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.wsdl.WsdlWriter;

public class PolicyStatement
extends PolicyExpression
implements Externalizable {
    private static final long serialVersionUID = -3722431287020676872L;
    private static final boolean verbose = Verbose.isVerbose(PolicyStatement.class);
    protected String id;

    public PolicyStatement() {
    }

    protected PolicyStatement(String string) {
        super(OperatorType.ALL);
        this.id = string;
    }

    public PolicyStatement(String string, String string2) {
        this(string);
        this.policyNamespaceUri = string2;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public static PolicyStatement createPolicyStatement(String string) {
        return new PolicyStatement(string);
    }

    public Element toXML(Document document) throws PolicyException {
        Element element = "http://schemas.xmlsoap.org/ws/2004/09/policy".equals(this.policyNamespaceUri) ? DOMUtils.createElement(PolicyConstants.POLICY_STATEMENT_ELEMENT, document, "wsp") : DOMUtils.createElement(PolicyConstants.POLICY_STATEMENT_ELEMENT_15, document, "wsp");
        if (this.id != null && this.id.length() > 0) {
            DOMUtils.addAttribute(element, PolicyConstants.POLICY_STATEMENT_ID_ATTRIBUTE, this.id);
        }
        for (PolicyExpression policyExpression : this.expressions) {
            element.appendChild(policyExpression.toXML(document));
        }
        return element;
    }

    public void write(Element element, WsdlWriter wsdlWriter) {
        Element element2 = wsdlWriter.addChild(element, "Policy", this.policyNamespaceUri);
        if (this.id != null) {
            wsdlWriter.setAttribute(element2, PolicyConstants.POLICY_STATEMENT_ID_ATTRIBUTE.getLocalPart(), "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", this.id);
        }
        for (PolicyExpression policyExpression : this.expressions) {
            policyExpression.write(element2, wsdlWriter);
        }
    }

    public Element toXML() throws PolicyException {
        return this.toXML(DOMUtils.getParser().newDocument());
    }

    public String toString() {
        DocumentBuilder documentBuilder = DOMUtils.getParser();
        Document document = documentBuilder.newDocument();
        Element element = null;
        try {
            element = this.toXML(document);
        }
        catch (PolicyException policyException) {
            if (verbose) {
                Verbose.log(policyException);
            }
            return null;
        }
        document.appendChild(element);
        return DOMUtils.toXMLString(document);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.id = objectInput.readUTF();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeUTF(this.id);
    }

    public boolean equals(Object object) {
        PolicyStatement policyStatement;
        if (this == object) {
            return true;
        }
        if (object instanceof PolicyStatement && (policyStatement = (PolicyStatement)object).getId() != null && this.getId() != null) {
            return policyStatement.getId().equals(this.getId());
        }
        return false;
    }
}

