/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.policy.runtime;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.framework.PolicyStatement;
import weblogic.wsee.policy.runtime.PolicyFinder;
import weblogic.wsee.policy.runtime.schema.BuiltinPolicyList;
import weblogic.wsee.policy.runtime.schema.BuiltinPolicyListFactory;
import weblogic.wsee.util.Verbose;

public class BuiltinPolicyFinder
extends PolicyFinder {
    private static final boolean verbose = Verbose.isVerbose(BuiltinPolicyFinder.class);
    private static final boolean debug = false;
    public static final String WLS92_POLICY = "WLS 9.2 Policy";
    public static final String WSSP12_POLICY = "WSSP12 Policy 2005/12";
    public static final String WSSP12_POLICY_2007 = "WSSP12 Policy 2007/02";
    public static final String RM_POLICY = "WS_RM";
    public static final String WSRM_POLICY = "WS_RM";
    public static final String SAML_POLICY = "Saml";
    public static final String MTOM_POLICY = "Mtom";
    public static final String MC_POLICY = "Make Connection";
    public static final String WSSC_POLICY = "WS-SecureConversation";
    public static final String WSSC13_POLICY = "WS-SecureConversation 1.3";
    private static final String[] CANNED_POLICY_TYPES = new String[]{"WSSP12 Policy 2007/02", "WLS 9.2 Policy", "WSSP12 Policy 2005/12", "WS_RM", "Saml", "Mtom", "Make Connection", "WS-SecureConversation", "WS-SecureConversation 1.3"};
    private static BuiltinPolicyFinder singleton = new BuiltinPolicyFinder();
    private static final String DEFAULT_RELIABILITY_XML = "DefaultReliability.xml";
    private static final String LONG_RUNNING_RELIABILITY_XML = "LongRunningReliability.xml";
    public static final boolean IS_FARALLON = false;

    private BuiltinPolicyFinder() {
    }

    public static PolicyFinder getInstance() {
        return singleton;
    }

    public PolicyStatement findPolicy(String string, String string2) throws PolicyException {
        InputStream inputStream;
        PolicyStatement policyStatement = null;
        string = BuiltinPolicyFinder.checkFileExtension(string);
        BuiltinPolicyList builtinPolicyList = BuiltinPolicyListFactory.getBuiltinPolicyList();
        if (!builtinPolicyList.containsPolicy(string)) {
            if (verbose) {
                Verbose.log("Unable to find a built-in policy with name = " + string);
            }
            return null;
        }
        String string3 = '/' + this.getClass().getPackage().getName().replace('.', '/') + '/' + string;
        if (verbose) {
            Verbose.log("Looking for a built-in policy with name = " + string3);
        }
        if ((inputStream = this.getClass().getResourceAsStream(string3)) != null) {
            policyStatement = BuiltinPolicyFinder.readPolicyFromStream(string, inputStream);
        }
        return policyStatement;
    }

    public static String[] getAllCannedPolicyNames() {
        BuiltinPolicyList builtinPolicyList = BuiltinPolicyListFactory.getBuiltinPolicyList();
        return builtinPolicyList.getNonInternalCannedPolicyNames();
    }

    public static String[] getAllNon92CannedPolicyNames() {
        BuiltinPolicyList builtinPolicyList = BuiltinPolicyListFactory.getBuiltinPolicyList();
        return builtinPolicyList.getAllNon92CannedPolicyNames();
    }

    public static boolean is92SecurityPolicy(String string) {
        if (DEFAULT_RELIABILITY_XML.equals(string) || LONG_RUNNING_RELIABILITY_XML.equals(string)) {
            return false;
        }
        BuiltinPolicyList builtinPolicyList = BuiltinPolicyListFactory.getBuiltinPolicyList();
        String[] stringArray = builtinPolicyList.get92CannedPolicyNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean isWsrmPolicy(String string) {
        BuiltinPolicyList builtinPolicyList = BuiltinPolicyListFactory.getBuiltinPolicyList();
        String[] stringArray = builtinPolicyList.getWsrmCannedPolicyNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public static String[] getCannedPolicyNames() {
        BuiltinPolicyList builtinPolicyList = BuiltinPolicyListFactory.getBuiltinPolicyList();
        return builtinPolicyList.get92CannedPolicyNames();
    }

    public static String[] getCannedPolicyTypes() {
        return CANNED_POLICY_TYPES;
    }

    public static String[] getCannedPolicyNames(String string) {
        if (null == string) {
            BuiltinPolicyList builtinPolicyList = BuiltinPolicyListFactory.getBuiltinPolicyList();
            return builtinPolicyList.getAllPolices();
        }
        if (WSSP12_POLICY.equals(string)) {
            return BuiltinPolicyFinder.getWssp12CannedPolicyNames();
        }
        if (WLS92_POLICY.equals(string)) {
            return BuiltinPolicyFinder.get92CannedPolicyNames();
        }
        if (SAML_POLICY.equals(string)) {
            return BuiltinPolicyFinder.getSamlCannedPolicyNames();
        }
        if (MTOM_POLICY.equals(string)) {
            return BuiltinPolicyFinder.getMtomCannedPolicyNames();
        }
        if (MC_POLICY.equals(string)) {
            return BuiltinPolicyFinder.getMcCannedPolicyNames();
        }
        if (WSSC_POLICY.equals(string)) {
            return BuiltinPolicyFinder.getWsscCannedPolicyNames();
        }
        if (WSSC13_POLICY.equals(string)) {
            return BuiltinPolicyFinder.getWssc13CannedPolicyNames();
        }
        if ("WS_RM".equals(string)) {
            return BuiltinPolicyFinder.getWsrmCannedPolicyNames();
        }
        return BuiltinPolicyFinder.getCannedPolicyLike(string);
    }

    public static String[] get92CannedPolicyNames() {
        BuiltinPolicyList builtinPolicyList = BuiltinPolicyListFactory.getBuiltinPolicyList();
        return builtinPolicyList.get92CannedPolicyNames();
    }

    public static String[] getWssp12CannedPolicyNames() {
        BuiltinPolicyList builtinPolicyList = BuiltinPolicyListFactory.getBuiltinPolicyList();
        return builtinPolicyList.getWssp12CannedPolicyNames();
    }

    public static String[] getWssp12_2007_CannedPolicyNames() {
        BuiltinPolicyList builtinPolicyList = BuiltinPolicyListFactory.getBuiltinPolicyList();
        return builtinPolicyList.getWssp12_2007_CannedPolicyNames();
    }

    public static String[] getSamlCannedPolicyNames() {
        BuiltinPolicyList builtinPolicyList = BuiltinPolicyListFactory.getBuiltinPolicyList();
        return builtinPolicyList.getSamlCannedPolicyNames();
    }

    public static String[] getMcCannedPolicyNames() {
        BuiltinPolicyList builtinPolicyList = BuiltinPolicyListFactory.getBuiltinPolicyList();
        return builtinPolicyList.getMcCannedPolicyNames();
    }

    public static String[] getMtomCannedPolicyNames() {
        BuiltinPolicyList builtinPolicyList = BuiltinPolicyListFactory.getBuiltinPolicyList();
        return builtinPolicyList.getMtomCannedPolicyNames();
    }

    public static String[] getProtectionCannedPolicyNames() {
        BuiltinPolicyList builtinPolicyList = BuiltinPolicyListFactory.getBuiltinPolicyList();
        return builtinPolicyList.getProtectionCannedPolicyNames();
    }

    public static String[] getWsscCannedPolicyNames() {
        BuiltinPolicyList builtinPolicyList = BuiltinPolicyListFactory.getBuiltinPolicyList();
        return builtinPolicyList.getWsscCannedPolicyNames();
    }

    public static String[] getWssc13CannedPolicyNames() {
        BuiltinPolicyList builtinPolicyList = BuiltinPolicyListFactory.getBuiltinPolicyList();
        return builtinPolicyList.getWssc13CannedPolicyNames();
    }

    public static String[] getWssc14CannedPolicyNames() {
        BuiltinPolicyList builtinPolicyList = BuiltinPolicyListFactory.getBuiltinPolicyList();
        return builtinPolicyList.getWssc14CannedPolicyNames();
    }

    public static String[] getWsrmCannedPolicyNames() {
        BuiltinPolicyList builtinPolicyList = BuiltinPolicyListFactory.getBuiltinPolicyList();
        return builtinPolicyList.getWsrmCannedPolicyNames();
    }

    public static String[] getWsp15CannedPolicyNames() {
        BuiltinPolicyList builtinPolicyList = BuiltinPolicyListFactory.getBuiltinPolicyList();
        return builtinPolicyList.getWsp15CannedPolicyNames();
    }

    public static String[] getWss10CannedPolicyNames() {
        BuiltinPolicyList builtinPolicyList = BuiltinPolicyListFactory.getBuiltinPolicyList();
        return builtinPolicyList.getWss10CannedPolicyNames();
    }

    public static String[] getWss11CannedPolicyNames() {
        BuiltinPolicyList builtinPolicyList = BuiltinPolicyListFactory.getBuiltinPolicyList();
        return builtinPolicyList.getWss11CannedPolicyNames();
    }

    public static String[] getTransportCannedPolicyNames() {
        BuiltinPolicyList builtinPolicyList = BuiltinPolicyListFactory.getBuiltinPolicyList();
        return builtinPolicyList.getTransportCannedPolicyNames();
    }

    public static String[] getCannedPolicyLike(String string) {
        BuiltinPolicyList builtinPolicyList = BuiltinPolicyListFactory.getBuiltinPolicyList();
        if (null == string || string.length() == 0) {
            return builtinPolicyList.getAllPolices();
        }
        return BuiltinPolicyFinder.getCannedPolicyLike(builtinPolicyList.getAllPolices(), string);
    }

    private static String[] getCannedPolicyLike(String[] stringArray, String string) {
        string = string.toLowerCase(Locale.ENGLISH);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (-1 == stringArray[i].toLowerCase(Locale.ENGLISH).indexOf(string)) continue;
            arrayList.add(stringArray[i]);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        String[] stringArray2 = new String[arrayList.size()];
        Iterator iterator = arrayList.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            stringArray2[n++] = (String)iterator.next();
        }
        return stringArray2;
    }
}

