/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.policy.runtime;

import com.sun.xml.ws.api.pipe.Fiber;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.MessageContext;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.policy.deployment.WsdlPolicySubject;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.framework.PolicyMath;
import weblogic.wsee.policy.runtime.PolicyServer;
import weblogic.wsee.ws.WsMethod;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.dispatch.Dispatcher;
import weblogic.wsee.wsdl.WsdlBinding;
import weblogic.wsee.wsdl.WsdlBindingOperation;
import weblogic.wsee.wsdl.WsdlOperation;
import weblogic.wsee.wsdl.WsdlPort;

public class PolicyContext {
    public static final String EFFECTIVE_REQ_POLICY = "weblogic.wsee.policy.effectiveRequestPolicy";
    public static final String EFFECTIVE_RES_POLICY = "weblogic.wsee.policy.effectiveResponsePolicy";
    private static final String IGNORE_POLICY = "weblogic.wsee.policy.ignorePolicy";
    private static ThreadLocal<Boolean> ignoringStatus = null;
    private static NormalizedExpression empty = new NormalizedExpression();

    private PolicyContext() {
    }

    public static NormalizedExpression getRequestEffectivePolicy(WsPort wsPort, WsMethod wsMethod, PolicyServer policyServer, Map map) throws PolicyException {
        if (PolicyContext.isPolicyIgnored()) {
            return empty;
        }
        if (wsMethod == null) {
            return WsdlPolicySubject.getEndpointPolicySubject(policyServer, wsPort.getWsdlPort(), map);
        }
        NormalizedExpression normalizedExpression = wsMethod.getCachedEffectiveInboundPolicy();
        QName qName = wsMethod.getOperationName();
        if (normalizedExpression == null) {
            WsdlPort wsdlPort = wsPort.getWsdlPort();
            WsdlOperation wsdlOperation = wsdlPort.getPortType().getOperations().get(qName);
            WsdlBindingOperation wsdlBindingOperation = wsdlPort.getBinding().getOperations().get(qName);
            normalizedExpression = PolicyContext.getRequestEffectivePolicy(wsdlPort, wsdlOperation, wsdlBindingOperation, policyServer, map);
            wsMethod.setCachedEffectiveInboundPolicy(normalizedExpression);
        }
        return normalizedExpression;
    }

    public static NormalizedExpression getRequestEffectivePolicy(WsdlPort wsdlPort, WsdlOperation wsdlOperation, WsdlBindingOperation wsdlBindingOperation, PolicyServer policyServer, Map map) throws PolicyException {
        if (PolicyContext.isPolicyIgnored()) {
            return empty;
        }
        NormalizedExpression normalizedExpression = null;
        normalizedExpression = WsdlPolicySubject.getMessagePolicySubject(policyServer, wsdlOperation.getInput(), wsdlBindingOperation.getInput(), wsdlOperation.getInputPolicyUris(), map);
        normalizedExpression = PolicyMath.merge(normalizedExpression, WsdlPolicySubject.getOperationPolicySubject(policyServer, wsdlOperation, wsdlBindingOperation, map));
        normalizedExpression = PolicyMath.merge(normalizedExpression, WsdlPolicySubject.getEndpointPolicySubject(policyServer, wsdlPort, map));
        return normalizedExpression;
    }

    public static NormalizedExpression getRequestEffectivePolicy(WsdlOperation wsdlOperation, WsdlBindingOperation wsdlBindingOperation, PolicyServer policyServer, Map map) throws PolicyException {
        if (PolicyContext.isPolicyIgnored()) {
            return empty;
        }
        NormalizedExpression normalizedExpression = null;
        normalizedExpression = WsdlPolicySubject.getMessagePolicySubject(policyServer, wsdlOperation.getInput(), wsdlBindingOperation.getInput(), wsdlOperation.getInputPolicyUris(), map);
        normalizedExpression = PolicyMath.merge(normalizedExpression, WsdlPolicySubject.getOperationPolicySubject(policyServer, wsdlOperation, wsdlBindingOperation, map));
        WsdlBinding wsdlBinding = wsdlBindingOperation.getBinding();
        normalizedExpression = PolicyMath.merge(normalizedExpression, WsdlPolicySubject.getEndpointPolicySubject(policyServer, wsdlBinding, map));
        return normalizedExpression;
    }

    public static NormalizedExpression getResponseEffectivePolicy(WsPort wsPort, WsMethod wsMethod, PolicyServer policyServer, Map map) throws PolicyException {
        if (PolicyContext.isPolicyIgnored()) {
            return empty;
        }
        if (wsMethod == null) {
            return WsdlPolicySubject.getEndpointPolicySubject(policyServer, wsPort.getWsdlPort(), map);
        }
        NormalizedExpression normalizedExpression = wsMethod.getCachedEffectiveOutboundPolicy();
        QName qName = wsMethod.getOperationName();
        if (normalizedExpression == null) {
            WsdlPort wsdlPort = wsPort.getWsdlPort();
            WsdlOperation wsdlOperation = wsdlPort.getPortType().getOperations().get(qName);
            WsdlBindingOperation wsdlBindingOperation = wsdlPort.getBinding().getOperations().get(qName);
            normalizedExpression = PolicyContext.getResponseEffectivePolicy(wsdlPort, wsdlOperation, wsdlBindingOperation, policyServer, map);
            wsMethod.setCachedEffectiveOutboundPolicy(normalizedExpression);
        }
        return normalizedExpression;
    }

    public static NormalizedExpression getResponseEffectivePolicy(WsdlPort wsdlPort, WsdlOperation wsdlOperation, WsdlBindingOperation wsdlBindingOperation, PolicyServer policyServer, Map map) throws PolicyException {
        if (PolicyContext.isPolicyIgnored()) {
            return empty;
        }
        NormalizedExpression normalizedExpression = null;
        normalizedExpression = WsdlPolicySubject.getMessagePolicySubject(policyServer, wsdlOperation.getOutput(), wsdlBindingOperation.getOutput(), wsdlOperation.getOutputPolicyUris(), map);
        normalizedExpression = PolicyMath.merge(normalizedExpression, WsdlPolicySubject.getOperationPolicySubject(policyServer, wsdlOperation, wsdlBindingOperation, map));
        normalizedExpression = PolicyMath.merge(normalizedExpression, WsdlPolicySubject.getEndpointPolicySubject(policyServer, wsdlPort, map));
        return normalizedExpression;
    }

    public static NormalizedExpression getResponseEffectivePolicy(WsdlOperation wsdlOperation, WsdlBindingOperation wsdlBindingOperation, PolicyServer policyServer, Map map) throws PolicyException {
        if (PolicyContext.isPolicyIgnored()) {
            return empty;
        }
        NormalizedExpression normalizedExpression = null;
        normalizedExpression = WsdlPolicySubject.getMessagePolicySubject(policyServer, wsdlOperation.getOutput(), wsdlBindingOperation.getOutput(), wsdlOperation.getOutputPolicyUris(), map);
        normalizedExpression = PolicyMath.merge(normalizedExpression, WsdlPolicySubject.getOperationPolicySubject(policyServer, wsdlOperation, wsdlBindingOperation, map));
        WsdlBinding wsdlBinding = wsdlBindingOperation.getBinding();
        normalizedExpression = PolicyMath.merge(normalizedExpression, WsdlPolicySubject.getEndpointPolicySubject(policyServer, wsdlBinding, map));
        return normalizedExpression;
    }

    public static NormalizedExpression getRequestEffectivePolicy(MessageContext messageContext) throws PolicyException {
        if (PolicyContext.isPolicyIgnored()) {
            return empty;
        }
        Object object = messageContext.getProperty(EFFECTIVE_REQ_POLICY);
        if (object != null) {
            assert (object instanceof NormalizedExpression);
            return (NormalizedExpression)object;
        }
        Dispatcher dispatcher = PolicyContext.getDispatcher(messageContext);
        return PolicyContext.getRequestEffectivePolicy(dispatcher.getWsPort(), dispatcher.getWsMethod(), null, dispatcher.getWsPort().getEndpoint().getService().getPolicyServer().getCachedPolicies());
    }

    public static NormalizedExpression getResponseEffectivePolicy(MessageContext messageContext) throws PolicyException {
        if (PolicyContext.isPolicyIgnored()) {
            return empty;
        }
        Object object = messageContext.getProperty(EFFECTIVE_RES_POLICY);
        if (object != null) {
            assert (object instanceof NormalizedExpression);
            return (NormalizedExpression)object;
        }
        Dispatcher dispatcher = PolicyContext.getDispatcher(messageContext);
        return PolicyContext.getResponseEffectivePolicy(dispatcher.getWsPort(), dispatcher.getWsMethod(), null, dispatcher.getWsPort().getEndpoint().getService().getPolicyServer().getCachedPolicies());
    }

    public static NormalizedExpression getEndpointPolicy(MessageContext messageContext) throws PolicyException {
        if (PolicyContext.isPolicyIgnored()) {
            return empty;
        }
        Dispatcher dispatcher = PolicyContext.getDispatcher(messageContext);
        if (dispatcher == null) {
            return empty;
        }
        WsPort wsPort = dispatcher.getWsPort();
        if (wsPort == null) {
            throw new PolicyException("WsPort can not be null");
        }
        PolicyServer policyServer = wsPort.getEndpoint().getService().getPolicyServer();
        return WsdlPolicySubject.getEndpointPolicySubject(policyServer, wsPort.getWsdlPort(), policyServer.getCachedPolicies());
    }

    private static Dispatcher getDispatcher(MessageContext messageContext) {
        WlMessageContext wlMessageContext = null;
        try {
            wlMessageContext = (WlMessageContext)messageContext;
        }
        catch (ClassCastException classCastException) {
            throw new AssertionError((Object)classCastException);
        }
        return wlMessageContext.getDispatcher();
    }

    public static boolean isPolicyIgnored() {
        Fiber fiber = Fiber.getCurrentIfSet();
        if (fiber == null) {
            if (ignoringStatus == null) {
                return false;
            }
            return ignoringStatus.get();
        }
        Boolean bl = (Boolean)fiber.getPacket().invocationProperties.get(IGNORE_POLICY);
        return bl != null ? bl : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPolicyIgnored(boolean bl) {
        Fiber fiber = Fiber.getCurrentIfSet();
        if (fiber == null) {
            if (ignoringStatus == null) {
                NormalizedExpression normalizedExpression = empty;
                synchronized (normalizedExpression) {
                    if (ignoringStatus == null) {
                        ignoringStatus = new ThreadLocal<Boolean>(){

                            @Override
                            protected Boolean initialValue() {
                                return Boolean.FALSE;
                            }
                        };
                    }
                }
            }
            ignoringStatus.set(bl);
        } else {
            fiber.getPacket().invocationProperties.put(IGNORE_POLICY, bl);
        }
    }
}

