/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.policy.runtime;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;
import weblogic.wsee.policy.deployment.PolicyDeployUtils;
import weblogic.wsee.policy.deployment.PolicyLoader;
import weblogic.wsee.policy.deployment.ProviderRegistry;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.framework.PolicyStatement;
import weblogic.wsee.policy.runtime.PolicyServer;
import weblogic.wsee.policy.schema.PolicySchemaValidationException;
import weblogic.wsee.policy.schema.PolicySchemaValidator;
import weblogic.wsee.util.dom.DOMParser;
import weblogic.xml.crypto.utils.DOMUtils;

public abstract class PolicyFinder {
    private static final String EXT = ".xml";

    public abstract PolicyStatement findPolicy(String var1, String var2) throws PolicyException;

    public static PolicyStatement readPolicyFromStream(String string, InputStream inputStream) throws PolicyException {
        return PolicyFinder.readPolicyFromStream(string, inputStream, false);
    }

    public static PolicyStatement readPolicyFromStream(String string, InputStream inputStream, boolean bl) throws PolicyException {
        return PolicyFinder.readPolicyFromStream(null, string, inputStream, bl);
    }

    public static PolicyStatement readPolicyFromStream(PolicyServer policyServer, String string, InputStream inputStream, boolean bl) throws PolicyException {
        if (inputStream == null) {
            throw new PolicyException("Policy stream can not be null");
        }
        PolicyLoader policyLoader = new PolicyLoader(ProviderRegistry.getTheRegistry());
        try {
            Object object;
            Document document = DOMParser.getDocument(new InputSource(inputStream));
            if (bl) {
                object = policyServer == null ? new PolicySchemaValidator() : policyServer.getPolicySchemaValidator();
                ((PolicySchemaValidator)object).validate(document);
            }
            object = policyLoader.load(document);
            if (policyServer != null) {
                object = policyServer.processAssertions(string, (PolicyStatement)object);
            }
            if (bl) {
                policyLoader.validate(string, (PolicyStatement)object);
            }
            PolicyFinder.setPolicyId(string, (PolicyStatement)object);
            Object object2 = object;
            return object2;
        }
        catch (IOException iOException) {
            throw new PolicyException("Failed to parse \"" + string + "\": " + iOException.getMessage());
        }
        catch (AssertionError assertionError) {
            throw new PolicyException("Failed to parse \"" + string + "\": " + ((Throwable)((Object)assertionError)).getMessage());
        }
        catch (PolicySchemaValidationException policySchemaValidationException) {
            throw new PolicyException("Policy not valid: ", policySchemaValidationException);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static PolicyStatement readPolicyStatementFromNode(Node node) throws PolicyException {
        PolicyLoader policyLoader = new PolicyLoader(ProviderRegistry.getTheRegistry());
        return policyLoader.load(node);
    }

    public static Map loadPolicies(URL uRL, PolicyServer policyServer) throws PolicyException {
        Map map = new HashMap();
        if (uRL == null) {
            return map;
        }
        String string = uRL.getProtocol();
        if (string.equals("file")) {
            map = PolicyFinder.loadPoliciesFromDir(uRL, policyServer);
        } else if (string.equals("zip")) {
            map = PolicyFinder.loadPolicesFromZip(uRL, policyServer);
        }
        return map;
    }

    public static Map loadPolicies(VirtualJarFile virtualJarFile, PolicyServer policyServer) throws PolicyException {
        HashMap<String, PolicyStatement> hashMap = new HashMap<String, PolicyStatement>();
        Iterator iterator = virtualJarFile.entries();
        while (iterator.hasNext()) {
            String string;
            ZipEntry zipEntry = (ZipEntry)iterator.next();
            if (zipEntry.isDirectory() || (string = zipEntry.toString()).indexOf("policies") <= -1) continue;
            String string2 = PolicyFinder.rootName(zipEntry.getName());
            PolicyStatement policyStatement = null;
            try {
                policyStatement = PolicyFinder.readPolicyFromStream(policyServer, string2, virtualJarFile.getInputStream(zipEntry), true);
            }
            catch (IOException iOException) {
                throw new PolicyException(iOException);
            }
            if (policyStatement == null) continue;
            hashMap.put(string2, policyStatement);
        }
        policyServer.addPolicies(hashMap);
        return hashMap;
    }

    private static Map loadPolicesFromZip(URL uRL, PolicyServer policyServer) throws PolicyException {
        Map map = new HashMap();
        String string = uRL.getFile().toString();
        int n = string.indexOf(".jar!");
        if (n > 0) {
            try {
                JarFile jarFile = new JarFile(string.substring(0, n + 4));
                VirtualJarFile virtualJarFile = VirtualJarFactory.createVirtualJar((JarFile)jarFile);
                map = PolicyFinder.loadPolicies(virtualJarFile, policyServer);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return map;
    }

    private static Map loadPoliciesFromDir(URL uRL, PolicyServer policyServer) throws PolicyException {
        HashMap<String, PolicyStatement> hashMap = new HashMap<String, PolicyStatement>();
        File file = new File(uRL.getFile());
        if (!file.exists() || !file.isDirectory()) {
            throw new AssertionError((Object)file.getAbsolutePath());
        }
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(PolicyFinder.EXT);
            }
        };
        File[] fileArray = file.listFiles(filenameFilter);
        for (int i = 0; i < fileArray.length; ++i) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(fileArray[i]);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new AssertionError((Object)fileNotFoundException);
            }
            String string = PolicyFinder.rootName(fileArray[i].getName());
            PolicyStatement policyStatement = PolicyFinder.readPolicyFromStream(policyServer, string, fileInputStream, true);
            if (policyStatement == null) continue;
            hashMap.put(string, policyStatement);
        }
        policyServer.addPolicies(hashMap);
        return hashMap;
    }

    private static PolicyStatement setPolicyId(String string, PolicyStatement policyStatement) {
        String string2 = policyStatement.getId();
        if (string2 == null || string2.length() == 0) {
            policyStatement.setId(PolicyDeployUtils.getXPointerId(string));
        }
        return policyStatement;
    }

    public static PolicyStatement generatePolicyId(PolicyStatement policyStatement) {
        String string = policyStatement.getId();
        if (string == null || string.length() == 0) {
            policyStatement.setId(DOMUtils.generateId());
        }
        return policyStatement;
    }

    protected static String checkFileExtension(String string) {
        if (!string.endsWith(EXT)) {
            return string + EXT;
        }
        return string;
    }

    private static String rootName(String string) {
        int n = string.lastIndexOf(47);
        n = n < 0 ? 0 : ++n;
        return string.substring(n, string.lastIndexOf("."));
    }
}

