/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.policy.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import weblogic.wsee.policy.deployment.WsdlPolicySubject;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.framework.PolicyStatement;
import weblogic.wsee.policy.runtime.BuiltinPolicyFinder;
import weblogic.wsee.policy.runtime.LibraryPolicyFinder;
import weblogic.wsee.policy.runtime.PolicyCustomizer;
import weblogic.wsee.policy.runtime.PolicyFinder;
import weblogic.wsee.policy.schema.PolicySchemaValidationException;
import weblogic.wsee.policy.schema.PolicySchemaValidator;
import weblogic.wsee.wsdl.WsdlPort;

public class PolicyServer {
    private static final boolean debug = false;
    private Map cachedPolicies = new HashMap();
    private boolean isCaching = true;
    private ArrayList policyFinders = new ArrayList();
    private PolicySchemaValidator schemaValidator;
    private ArrayList policyCustomizers = new ArrayList();
    private Map<QName, NormalizedExpression> endpointPolicies = new ConcurrentHashMap<QName, NormalizedExpression>();

    public PolicyServer() {
        this.policyFinders.add(new LibraryPolicyFinder());
        this.policyFinders.add(BuiltinPolicyFinder.getInstance());
    }

    public PolicyServer(Map map) {
        this(true, map);
    }

    public PolicyServer(boolean bl, Map map) {
        this();
        this.isCaching = bl;
        if (map != null) {
            this.cachedPolicies.putAll(map);
        }
    }

    public boolean isCaching() {
        return this.isCaching;
    }

    public Map getCachedPolicies() {
        return this.cachedPolicies;
    }

    public void addPolicies(Map map) {
        this.cachedPolicies.putAll(map);
    }

    public PolicyStatement getPolicy(String string) throws PolicyException {
        return this.getPolicy(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PolicyStatement getPolicy(String string, boolean bl) throws PolicyException {
        Map map;
        if (string == null || string.length() == 0) {
            throw new AssertionError();
        }
        PolicyStatement policyStatement = null;
        if (this.isCaching) {
            map = this.cachedPolicies;
            synchronized (map) {
                policyStatement = this.getPolicyFromCache(string);
            }
            if (policyStatement != null) {
                return policyStatement;
            }
        } else {
            policyStatement = this.getPolicyFromCache(string);
        }
        if (policyStatement == null) {
            policyStatement = this.loadPolicy(string);
        }
        if (policyStatement == null) {
            throw new PolicyException("Could not find policy named \"" + string + "\"");
        }
        if (this.isCaching) {
            map = this.cachedPolicies;
            synchronized (map) {
                if (this.getPolicyFromCache(string) == null) {
                    this.cachedPolicies.put(string, policyStatement);
                }
            }
        }
        return policyStatement;
    }

    public PolicyStatement getPolicyFromCache(String string) {
        if (string == null) {
            return null;
        }
        PolicyStatement policyStatement = (PolicyStatement)this.cachedPolicies.get(string);
        if (policyStatement == null && string.endsWith(".xml")) {
            String string2 = string.substring(0, string.lastIndexOf(46));
            policyStatement = (PolicyStatement)this.cachedPolicies.get(string2);
        }
        return policyStatement;
    }

    public PolicyStatement lookupPolicy(String string) {
        try {
            PolicyStatement policyStatement;
            String string2;
            int n;
            if (string.startsWith("policy:")) {
                string = string.substring("policy:".length());
            }
            if ((n = (string2 = string.replace('\\', '/')).lastIndexOf(47)) >= 0) {
                string2 = string2.substring(n + 1);
            }
            if ((policyStatement = this.getPolicyFromCache(string2)) != null) {
                return policyStatement;
            }
            return this.loadPolicy(string);
        }
        catch (PolicyException policyException) {
            return null;
        }
    }

    private PolicyStatement loadPolicy(String string) throws PolicyException {
        PolicyFinder policyFinder;
        PolicyStatement policyStatement = null;
        for (int i = 0; i < this.policyFinders.size() && (policyStatement = (policyFinder = (PolicyFinder)this.policyFinders.get(i)).findPolicy(string, null)) == null; ++i) {
        }
        if (policyStatement == null) {
            throw new PolicyException("Unable to find policy: \"" + string + "\", please make sure to use dynamic wsdl when initializing the service stub");
        }
        return this.processAssertions(string, policyStatement);
    }

    public void addPolicyFinder(PolicyFinder policyFinder) {
        this.policyFinders.add(policyFinder);
    }

    public void addPolicyCustomizer(PolicyCustomizer policyCustomizer) {
        this.policyCustomizers.add(policyCustomizer);
    }

    public PolicyStatement processAssertions(String string, PolicyStatement policyStatement) throws PolicyException {
        for (int i = 0; i < this.policyCustomizers.size(); ++i) {
            ((PolicyCustomizer)this.policyCustomizers.get(i)).process(string, policyStatement);
        }
        return policyStatement;
    }

    public PolicySchemaValidator getPolicySchemaValidator() throws PolicySchemaValidationException {
        if (this.schemaValidator == null) {
            this.schemaValidator = new PolicySchemaValidator();
        }
        return this.schemaValidator;
    }

    public NormalizedExpression getEndpointPolicy(WsdlPort wsdlPort) throws PolicyException {
        QName qName = wsdlPort.getName();
        NormalizedExpression normalizedExpression = this.endpointPolicies.get(qName);
        if (normalizedExpression == null) {
            normalizedExpression = WsdlPolicySubject.getEndpointPolicySubject(this, wsdlPort, this.getCachedPolicies());
        }
        return normalizedExpression;
    }

    public List getPolicyList() {
        Set set = this.cachedPolicies.keySet();
        if (null == set || set.isEmpty()) {
            return null;
        }
        Iterator iterator = set.iterator();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }
}

