/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.policy.runtime.schema;

import weblogic.wsee.policy.runtime.schema.BuiltinPolicyHelper;
import weblogic.wsee.policy.runtime.schema.BuiltinPolicyType;

public class BuiltinPolicy {
    private int id;
    private String policyName;
    private int[] catIds;
    private static int idCount = 0;

    private void init(String string) {
        this.id = idCount++;
        this.policyName = string;
    }

    public BuiltinPolicy(String string) {
        this.init(string);
    }

    public BuiltinPolicy(String string, int n) {
        this(string);
        this.addCatId(n);
    }

    public BuiltinPolicy(String string, int[] nArray) {
        this(string);
        this.catIds = nArray;
    }

    public BuiltinPolicy(BuiltinPolicyType builtinPolicyType) {
        if (null == builtinPolicyType) {
            throw new IllegalArgumentException("null BuiltinPolicyType found");
        }
        this.init(builtinPolicyType.getPolicyName());
        this.catIds = BuiltinPolicyHelper.getIntegerArray(builtinPolicyType.getCategoryArray());
    }

    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = n;
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public void setPolicyName(String string) {
        this.policyName = string;
    }

    public int[] getCatIds() {
        return this.catIds;
    }

    public void setCatIds(int[] nArray) {
        this.catIds = nArray;
    }

    public void addCatId(int n) {
        if (null == this.catIds) {
            this.catIds = new int[1];
            this.catIds[0] = n;
            return;
        }
        if (this.hasCategoryId(n)) {
            return;
        }
        int[] nArray = new int[this.catIds.length + 1];
        for (int i = 0; i < this.catIds.length; ++i) {
            nArray[i] = this.catIds[i];
        }
        nArray[this.catIds.length] = n;
        this.catIds = nArray;
    }

    public boolean hasCategoryId(int n) {
        if (null == this.catIds) {
            return false;
        }
        for (int i = 0; i < this.catIds.length; ++i) {
            if (this.catIds[i] != n) continue;
            return true;
        }
        return false;
    }

    public int getCategorySize() {
        if (null == this.catIds) {
            return 0;
        }
        return this.catIds.length;
    }
}

