/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.policy.runtime.schema;

import weblogic.wsee.policy.runtime.schema.CategoryEnum;

public class BuiltinPolicyHelper {
    private static String[] idTable = null;

    private static void init() {
        idTable = new String[BuiltinPolicyHelper.getCategorySize()];
        for (int i = 0; i < idTable.length; ++i) {
            BuiltinPolicyHelper.idTable[i] = BuiltinPolicyHelper.getCategoryString(i + 1);
        }
    }

    public static int getCategoryId(String string) {
        if (null == idTable) {
            BuiltinPolicyHelper.init();
        }
        for (int i = 0; i < idTable.length; ++i) {
            if (!idTable[i].equals(string)) continue;
            return i + 1;
        }
        throw new ArrayIndexOutOfBoundsException("Error on category = " + string);
    }

    public static int getCategoryId(CategoryEnum.Enum enum_) {
        return BuiltinPolicyHelper.getCategoryId(String.valueOf((Object)enum_));
    }

    public static String getCategoryString(int n) {
        return String.valueOf((Object)CategoryEnum.Enum.forInt(n));
    }

    public static int[] getIntegerArray(CategoryEnum.Enum[] enumArray) {
        if (null == enumArray || enumArray.length == 0) {
            return null;
        }
        int[] nArray = new int[enumArray.length];
        for (int i = 0; i < enumArray.length; ++i) {
            nArray[i] = BuiltinPolicyHelper.getCategoryId(enumArray[i]);
        }
        return nArray;
    }

    public static int getCategorySize() {
        if (null == idTable) {
            return 16;
        }
        return idTable.length;
    }
}

