/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.policy.runtime.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import weblogic.wsee.policy.runtime.schema.BuiltinPolicy;
import weblogic.wsee.policy.runtime.schema.BuiltinPolicyHelper;
import weblogic.wsee.policy.runtime.schema.BuiltinPolicyType;
import weblogic.wsee.policy.runtime.schema.CategoryEnum;

public class BuiltinPolicyList {
    private BuiltinPolicy[] builtinPolicies = null;
    private HashSet<Integer>[] categoryTbl = new HashSet[BuiltinPolicyHelper.getCategorySize()];
    private HashSet<String> cannedPolicyTable = new HashSet();
    private static final String DEFAULT_RELIABILITY_XML = "DefaultReliability.xml";
    private static final String LONG_RUNNING_RELIABILITY_XML = "LongRunningReliability.xml";

    private BuiltinPolicyList() {
        for (int i = 0; i < this.categoryTbl.length; ++i) {
            this.categoryTbl[i] = new HashSet();
        }
    }

    protected BuiltinPolicyList(BuiltinPolicyType[] builtinPolicyTypeArray) {
        this();
        if (null == builtinPolicyTypeArray) {
            throw new IllegalArgumentException("Null BuiltinPolicies");
        }
        this.builtinPolicies = new BuiltinPolicy[builtinPolicyTypeArray.length];
        for (int i = 0; i < this.builtinPolicies.length; ++i) {
            this.builtinPolicies[i] = new BuiltinPolicy(builtinPolicyTypeArray[i]);
            this.builtinPolicies[i].setId(i);
            this.addToCategoryTable(this.builtinPolicies[i]);
            this.cannedPolicyTable.add(this.builtinPolicies[i].getPolicyName());
        }
    }

    private void addBuiltinPolicy(BuiltinPolicy builtinPolicy) {
        if (null == this.builtinPolicies) {
            this.builtinPolicies = new BuiltinPolicy[1];
        } else {
            BuiltinPolicy[] builtinPolicyArray = new BuiltinPolicy[this.builtinPolicies.length + 1];
            for (int i = 0; i < this.builtinPolicies.length; ++i) {
                builtinPolicyArray[i] = this.builtinPolicies[i];
            }
            this.builtinPolicies = builtinPolicyArray;
        }
        this.builtinPolicies[this.builtinPolicies.length - 1] = builtinPolicy;
        this.addToCategoryTable(builtinPolicy);
    }

    private void addToCategoryTable(BuiltinPolicy builtinPolicy) {
        int[] nArray = builtinPolicy.getCatIds();
        for (int i = 0; i < nArray.length; ++i) {
            this.categoryTbl[nArray[i] - 1].add(new Integer(builtinPolicy.getId()));
        }
    }

    public int size() {
        return this.builtinPolicies.length;
    }

    public boolean containsPolicy(String string) {
        return this.cannedPolicyTable.contains(string);
    }

    public String[] getAllPolices() {
        String[] stringArray = new String[this.cannedPolicyTable.size()];
        ArrayList<String> arrayList = new ArrayList<String>(this.cannedPolicyTable);
        Collections.sort(arrayList);
        Iterator<String> iterator = arrayList.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            stringArray[n++] = iterator.next();
        }
        return stringArray;
    }

    public String[] getPoliciesByCategory(int n) {
        String[] stringArray = new String[this.categoryTbl[n - 1].size()];
        Iterator<Integer> iterator = this.categoryTbl[n - 1].iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            int n3 = iterator.next();
            stringArray[n2++] = this.builtinPolicies[n3].getPolicyName();
        }
        return stringArray;
    }

    public String[] getPoliciesExcludeCategory(int n) {
        String[] stringArray = this.getPoliciesByCategory(n);
        if (null == stringArray || stringArray.length == 0) {
            return this.getAllPolices();
        }
        HashSet hashSet = (HashSet)this.cannedPolicyTable.clone();
        for (int i = 0; i < stringArray.length; ++i) {
            hashSet.remove(stringArray[i]);
        }
        String[] stringArray2 = new String[hashSet.size()];
        ArrayList arrayList = new ArrayList(hashSet);
        Collections.sort(arrayList);
        Iterator iterator = arrayList.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            stringArray2[n2++] = (String)iterator.next();
        }
        return stringArray2;
    }

    public String[] getPoliciesByCategory(String string) {
        return this.getPoliciesByCategory(BuiltinPolicyHelper.getCategoryId(string));
    }

    public String[] getPoliciesByCategory(CategoryEnum.Enum enum_) {
        return this.getPoliciesByCategory(BuiltinPolicyHelper.getCategoryId(enum_));
    }

    public String[] get92CannedPolicyNames() {
        return this.getPoliciesByCategory(1);
    }

    public String[] getAllNon92CannedPolicyNames() {
        HashSet hashSet = (HashSet)this.cannedPolicyTable.clone();
        String[] stringArray = this.get92CannedPolicyNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(DEFAULT_RELIABILITY_XML) || stringArray[i].equals(LONG_RUNNING_RELIABILITY_XML)) continue;
            hashSet.remove(stringArray[i]);
        }
        String[] stringArray2 = new String[hashSet.size()];
        ArrayList arrayList = new ArrayList(hashSet);
        Collections.sort(arrayList);
        Iterator iterator = arrayList.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            stringArray2[n++] = (String)iterator.next();
        }
        return stringArray2;
    }

    public String[] getMcCannedPolicyNames() {
        return this.getPoliciesByCategory(7);
    }

    public String[] getWssp12CannedPolicyNames() {
        return this.getPoliciesByCategory(2);
    }

    public String[] getWssp12_2007_CannedPolicyNames() {
        return this.getPoliciesByCategory(3);
    }

    public String[] getSamlCannedPolicyNames() {
        return this.getPoliciesByCategory(5);
    }

    public String[] getProtectionCannedPolicyNames() {
        return this.getPoliciesByCategory(15);
    }

    public String[] getWsscCannedPolicyNames() {
        return this.getPoliciesByCategory(8);
    }

    public String[] getWssc13CannedPolicyNames() {
        return this.getPoliciesByCategory(9);
    }

    public String[] getWssc14CannedPolicyNames() {
        return this.getPoliciesByCategory(10);
    }

    public String[] getWsrmCannedPolicyNames() {
        return this.getPoliciesByCategory(4);
    }

    public String[] getWsp15CannedPolicyNames() {
        return this.getPoliciesByCategory(11);
    }

    public String[] getWss10CannedPolicyNames() {
        return this.getPoliciesByCategory(13);
    }

    public String[] getWss11CannedPolicyNames() {
        return this.getPoliciesByCategory(14);
    }

    public String[] getMtomCannedPolicyNames() {
        return this.getPoliciesByCategory(6);
    }

    public String[] getTransportCannedPolicyNames() {
        return this.getPoliciesByCategory(12);
    }

    public String[] getInternalCannedPolicyNames() {
        return this.getPoliciesByCategory(16);
    }

    public String[] getNonInternalCannedPolicyNames() {
        return this.getPoliciesExcludeCategory(16);
    }
}

