/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.policy.runtime.schema;

import com.bea.xml.XmlException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import weblogic.wsee.policy.runtime.schema.BuiltinPolicyList;
import weblogic.wsee.policy.runtime.schema.BuiltinPolicyType;
import weblogic.wsee.policy.runtime.schema.WlsBuiltinPoliciesDocument;
import weblogic.wsee.util.Verbose;

public class BuiltinPolicyListFactory {
    public static final String POLICY_LIST_FILENAME = "CannedPolicyList.xml";
    public static final String POLICY_LIST_FILEPATH = "/weblogic/wsee/policy/runtime/CannedPolicyList.xml";
    private static boolean VERBOSE = Verbose.isVerbose(BuiltinPolicyListFactory.class);
    private static BuiltinPolicyList bpList = null;
    private static boolean isErrorState = false;

    private BuiltinPolicyListFactory() {
    }

    private static URL findCannedPolicyListUrl() {
        URL uRL = BuiltinPolicyListFactory.class.getResource(POLICY_LIST_FILENAME);
        if (uRL == null) {
            Verbose.log("Error on URL of CannedPolicyList.xml");
            throw new IllegalStateException("Cannot find canned policy list file for CannedPolicyList.xml");
        }
        if (VERBOSE) {
            Verbose.log("Loading canned policy list from: " + uRL);
        }
        return uRL;
    }

    public static BuiltinPolicyList getBuiltinPolicyList() {
        if (bpList == null) {
            if (isErrorState) {
                throw new IllegalStateException("Privious error on getting policy from url =" + BuiltinPolicyListFactory.findCannedPolicyListUrl());
            }
            BuiltinPolicyListFactory.newInstance();
        }
        return bpList;
    }

    private static void newInstance() {
        try {
            InputStream inputStream = BuiltinPolicyListFactory.class.getResourceAsStream(POLICY_LIST_FILEPATH);
            if (null == inputStream) {
                isErrorState = true;
                throw new IllegalArgumentException("Null inputStream on resource: /weblogic/wsee/policy/runtime/CannedPolicyList.xml");
            }
            WlsBuiltinPoliciesDocument.WlsBuiltinPolicies wlsBuiltinPolicies = WlsBuiltinPoliciesDocument.Factory.parse(inputStream).getWlsBuiltinPolicies();
            if (wlsBuiltinPolicies.sizeOfBuiltinPolicyArray() == 0) {
                throw new IndexOutOfBoundsException("Invalid Canned Policy List");
            }
            BuiltinPolicyType[] builtinPolicyTypeArray = wlsBuiltinPolicies.getBuiltinPolicyArray();
            if (null == builtinPolicyTypeArray) {
                throw new IndexOutOfBoundsException("Invalid Canned Policy List = null");
            }
            bpList = new BuiltinPolicyList(builtinPolicyTypeArray);
            isErrorState = false;
        }
        catch (IOException iOException) {
            Verbose.log((Object)("IO Exception on getting BuiltinPolicyList on url = " + BuiltinPolicyListFactory.findCannedPolicyListUrl()), iOException);
            isErrorState = true;
            throw new IllegalArgumentException("Bad url on IO" + BuiltinPolicyListFactory.findCannedPolicyListUrl());
        }
        catch (XmlException xmlException) {
            Verbose.log("XML Exception on reading BuiltinPolicyList on url = " + BuiltinPolicyListFactory.findCannedPolicyListUrl());
            isErrorState = true;
            Verbose.log("Error message " + xmlException.getMessage());
            isErrorState = true;
            throw new IllegalArgumentException("Bad url on XML exception" + BuiltinPolicyListFactory.findCannedPolicyListUrl());
        }
    }
}

