/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.policy.schema;

import com.bea.xbean.validator.ValidatingXMLStreamReader;
import com.bea.xbean.xb.xsdschema.SchemaDocument;
import com.bea.xml.SchemaTypeLoader;
import com.bea.xml.XmlBeans;
import com.bea.xml.XmlError;
import com.bea.xml.XmlException;
import com.bea.xml.XmlObject;
import com.bea.xml.XmlOptions;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import weblogic.wsee.policy.schema.PolicySchemaValidationException;
import weblogic.wsee.policy.util.PolicyHelper;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.util.dom.DOMParser;
import weblogic.xml.dom.DOMStreamReader;

public class PolicySchemaValidator {
    private static boolean verbose = Verbose.isVerbose(PolicySchemaValidator.class);
    public static final boolean INCLUDE_WS_POLICY_15 = true;
    private static final String[] defaultXsds = new String[]{"/weblogic/wsee/policy/schema/xmldsig-core-schema.xsd", "/weblogic/wsee/policy/schema/oasis-200401-wss-wssecurity-secext-1.0.xsd", "/weblogic/wsee/policy/schema/oasis-200401-wss-wssecurity-utility-1.0.xsd", "/weblogic/wsee/security/policy/assertions/wls90-security-policy.xsd", "/weblogic/wsee/reliability/policy/schema/wsrm-policy-2005-02-06-RC1.1.xsd"};
    private static final String[] oldXsds = new String[]{"/weblogic/wsee/policy/schema/ws-policy.xsd"};
    private static final String[] newXsds = new String[]{"/weblogic/wsee/policy/schema/ws-policy15.xsd"};
    private SchemaTypeLoader sLoader;
    private SchemaTypeLoader sLoader15;

    public PolicySchemaValidator() throws PolicySchemaValidationException {
        ArrayList<InputStream> arrayList = new ArrayList<InputStream>();
        for (String string : defaultXsds) {
            arrayList.add(this.getClass().getResourceAsStream(string));
        }
        for (String string : oldXsds) {
            arrayList.add(this.getClass().getResourceAsStream(string));
        }
        this.sLoader = PolicySchemaValidator.buildSchemaTypeLoader(arrayList.toArray(new InputStream[0]));
        arrayList = new ArrayList();
        for (String string : defaultXsds) {
            arrayList.add(this.getClass().getResourceAsStream(string));
        }
        for (String string : newXsds) {
            arrayList.add(this.getClass().getResourceAsStream(string));
        }
        this.sLoader15 = PolicySchemaValidator.buildSchemaTypeLoader(arrayList.toArray(new InputStream[0]));
    }

    public void addSchema(InputStream inputStream) throws PolicySchemaValidationException {
        InputStream[] inputStreamArray = new InputStream[]{inputStream};
        SchemaTypeLoader schemaTypeLoader = PolicySchemaValidator.buildSchemaTypeLoader(inputStreamArray);
        SchemaTypeLoader[] schemaTypeLoaderArray = new SchemaTypeLoader[]{this.sLoader, schemaTypeLoader};
        this.sLoader = XmlBeans.typeLoaderUnion((SchemaTypeLoader[])schemaTypeLoaderArray);
    }

    public void validate(Document document) throws PolicySchemaValidationException {
        if (null == document) {
            throw new PolicySchemaValidationException("Bad XML, null document found");
        }
        XmlOptions xmlOptions = new XmlOptions();
        xmlOptions.setLoadLineNumbers();
        xmlOptions.setLoadMessageDigest();
        Element element = document.getDocumentElement();
        if (null == element) {
            throw new PolicySchemaValidationException("Bad XML, no element found");
        }
        SchemaTypeLoader schemaTypeLoader = null;
        schemaTypeLoader = PolicyHelper.hasWsp15NamespaceUri(element) ? this.sLoader15 : this.sLoader;
        try {
            DOMStreamReader dOMStreamReader = new DOMStreamReader(document.getDocumentElement());
            while (!dOMStreamReader.isStartElement()) {
                dOMStreamReader.next();
            }
            ArrayList arrayList = new ArrayList();
            ValidatingXMLStreamReader validatingXMLStreamReader = new ValidatingXMLStreamReader();
            validatingXMLStreamReader.init((XMLStreamReader)dOMStreamReader, true, null, schemaTypeLoader, xmlOptions, arrayList);
            while (validatingXMLStreamReader.hasNext()) {
                validatingXMLStreamReader.next();
            }
            if (!validatingXMLStreamReader.isValid()) {
                String string = "";
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    string = string + PolicySchemaValidator.stringFromError((XmlError)iterator.next());
                }
                throw new PolicySchemaValidationException(string);
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new PolicySchemaValidationException(xMLStreamException);
        }
    }

    private static SchemaTypeLoader buildSchemaTypeLoader(InputStream[] inputStreamArray) throws PolicySchemaValidationException {
        ArrayList<SchemaDocument> arrayList = new ArrayList<SchemaDocument>();
        try {
            for (InputStream inputStream : inputStreamArray) {
                arrayList.add(SchemaDocument.Factory.parse((InputStream)inputStream));
            }
            return XmlBeans.loadXsd((XmlObject[])arrayList.toArray(new XmlObject[0]));
        }
        catch (IOException iOException) {
            throw new PolicySchemaValidationException(iOException);
        }
        catch (XmlException xmlException) {
            throw new PolicySchemaValidationException(xmlException);
        }
    }

    private static String stringFromError(XmlError xmlError) {
        String string = XmlError.severityAsString((int)xmlError.getSeverity()) + ":" + xmlError.getLine() + ":" + xmlError.getColumn() + " " + xmlError.getMessage() + "\n";
        return string;
    }

    public static void main(String[] stringArray) throws IOException, PolicySchemaValidationException {
        if (stringArray.length == 0) {
            System.out.println("Usage: java PolicySchemaValidator policyfile");
        }
        long l = System.currentTimeMillis();
        PolicySchemaValidator policySchemaValidator = new PolicySchemaValidator();
        String string = stringArray[0];
        Document document = DOMParser.getDocument(string);
        System.out.println("Loading document takes  " + (System.currentTimeMillis() - l) + " ms.");
        l = System.currentTimeMillis();
        policySchemaValidator.validate(document);
        System.out.println(string + " is valid.  Validation time: " + (System.currentTimeMillis() - l) + " ms.");
    }
}

