/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.policy.util;

import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.wsee.policy.framework.DOMUtils;
import weblogic.wsee.policy.framework.PolicyAlternative;
import weblogic.wsee.policy.framework.PolicyAssertion;
import weblogic.wsee.policy.framework.PolicyConstants;
import weblogic.wsee.policy.framework.PolicyExpression;

public class PolicyHelper {
    private static final String VALUE_TRUE = Boolean.TRUE.toString();
    private static final String VALUE_FALSE = Boolean.FALSE.toString();

    public static String getOptionalPolicyNamespaceUri(Element element) {
        if (null == element) {
            return null;
        }
        String string = null;
        Boolean bl = DOMUtils.getAttributeValueAsBoolean(element, PolicyConstants.OPTIONAL);
        if (bl == null) {
            bl = DOMUtils.getAttributeValueAsBoolean(element, PolicyConstants.OPTIONAL_15);
            if (null != bl) {
                string = "http://www.w3.org/ns/ws-policy";
            }
        } else {
            string = "http://schemas.xmlsoap.org/ws/2004/09/policy";
        }
        return string;
    }

    public static Boolean getOptionalBoolean(Element element) {
        if (null == element) {
            return null;
        }
        Boolean bl = DOMUtils.getAttributeValueAsBoolean(element, PolicyConstants.OPTIONAL);
        if (bl == null) {
            bl = DOMUtils.getAttributeValueAsBoolean(element, PolicyConstants.OPTIONAL_15);
        }
        if (bl == null) {
            return null;
        }
        return bl;
    }

    public static void addOptionalAttribute(Element element, String string) {
        PolicyHelper.addOptionalAttribute(element, true, string);
    }

    public static void addOptionalAttribute(Element element, boolean bl, String string) {
        if (null == element) {
            return;
        }
        Boolean bl2 = PolicyHelper.getOptionalBoolean(element);
        if (bl2 != null) {
            return;
        }
        QName qName = null;
        String string2 = null;
        if ("http://www.w3.org/ns/ws-policy".equals(string)) {
            qName = PolicyConstants.OPTIONAL_15;
        } else if ("http://schemas.xmlsoap.org/ws/2004/09/policy".equals(string)) {
            qName = PolicyConstants.OPTIONAL;
        } else {
            Node node = element.getParentNode();
            if (node != null) {
                if ("http://schemas.xmlsoap.org/ws/2004/09/policy".equals(node.getBaseURI())) {
                    qName = PolicyConstants.OPTIONAL;
                } else if ("http://www.w3.org/ns/ws-policy".equals(node.getBaseURI())) {
                    qName = PolicyConstants.OPTIONAL_15;
                }
            } else if ("http://schemas.xmlsoap.org/ws/2004/09/policy".equals(element.getBaseURI())) {
                qName = PolicyConstants.OPTIONAL;
            } else if ("http://www.w3.org/ns/ws-policy".equals(element.getBaseURI())) {
                qName = PolicyConstants.OPTIONAL_15;
            }
        }
        if (null == qName) {
            qName = PolicyConstants.OPTIONAL;
        }
        string2 = qName == PolicyConstants.OPTIONAL ? "wsp" : "wsp15";
        if (bl) {
            DOMUtils.addPrefixedAttribute(element, qName, string2, VALUE_TRUE);
        } else {
            DOMUtils.addPrefixedAttribute(element, qName, string2, VALUE_FALSE);
        }
    }

    public static void checkOptionNamespaceUri(Element element, String string) {
        if (null == string) {
            throw new IllegalArgumentException("nsUri cannot be null");
        }
        Boolean bl = DOMUtils.getAttributeValueAsBoolean(element, PolicyConstants.OPTIONAL);
        if (bl == null) {
            return;
        }
        if ("http://schemas.xmlsoap.org/ws/2004/09/policy".equals(string)) {
            return;
        }
        String string2 = VALUE_TRUE;
        if (!bl.booleanValue()) {
            string2 = VALUE_FALSE;
        }
        element.removeAttributeNS("http://schemas.xmlsoap.org/ws/2004/09/policy", PolicyConstants.OPTIONAL.getLocalPart());
        DOMUtils.addPrefixedAttribute(element, PolicyConstants.OPTIONAL_15, "wsp15", string2);
    }

    public static boolean hasWsp15NamespaceUri(Element element) {
        Map<String, String> map = DOMUtils.getNamespaceMapping(element);
        return map.containsValue("http://www.w3.org/ns/ws-policy");
    }

    public static String getPolicyNamespaceUri(PolicyAlternative policyAlternative) {
        if (null == policyAlternative || policyAlternative.isEmpty()) {
            return "http://schemas.xmlsoap.org/ws/2004/09/policy";
        }
        Set set = policyAlternative.getAssertions();
        for (PolicyAssertion policyAssertion : set) {
            if (null == policyAssertion) continue;
            return policyAssertion.getPolicyNamespaceUri();
        }
        return "http://schemas.xmlsoap.org/ws/2004/09/policy";
    }

    public static String getPolicyNamespaceUri(Set set) {
        if (null == set || set.isEmpty()) {
            return "http://schemas.xmlsoap.org/ws/2004/09/policy";
        }
        for (PolicyAlternative policyAlternative : set) {
            if (policyAlternative == null) continue;
            return PolicyHelper.getPolicyNamespaceUri(policyAlternative);
        }
        return "http://schemas.xmlsoap.org/ws/2004/09/policy";
    }

    public static void setPolicyExpressionNs(PolicyExpression policyExpression, Node node) {
        if (null == node) {
            return;
        }
        Node node2 = node.getParentNode();
        if (null != node2 && "http://www.w3.org/ns/ws-policy".equals(node2.getNamespaceURI())) {
            policyExpression.setPolicyNamespaceUri("http://www.w3.org/ns/ws-policy");
        }
    }
}

