/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.policy.util;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.rpc.handler.MessageContext;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyAlternative;
import weblogic.wsee.policy.framework.PolicyAssertion;
import weblogic.wsee.policy.util.PolicySelectionPreference;
import weblogic.wsee.reliability.policy.RMAssertion;
import weblogic.wsee.reliability.policy11.RM11Assertion;
import weblogic.wsee.security.wss.SecurityPolicySelectionHelper;
import weblogic.wsee.security.wss.policy.SecurityPolicyArchitectureException;
import weblogic.wsee.security.wssp.SecurityPolicyAssertionInfo;
import weblogic.wsee.security.wssp.SecurityPolicyAssertionInfoFactory;
import weblogic.wsee.util.Verbose;
import weblogic.xml.crypto.wss.WSSecurityException;

public class PolicySelectionHelper {
    private static final boolean verbose = Verbose.isVerbose(PolicySelectionHelper.class);
    private static final boolean debug = false;
    static final int ANY = 0;
    static final int RM10 = 1;
    static final int RM11 = 2;
    static final int BOTH = 3;
    private PolicySelectionPreference preference = null;
    protected Set alternatives = null;
    private boolean forceWsrm10Policy = false;
    protected NormalizedExpression normalizedPolicy;

    public PolicySelectionHelper(NormalizedExpression normalizedExpression) {
        if (null == normalizedExpression) {
            throw new IllegalArgumentException("NullnormalizedPolicy found!");
        }
        this.preference = new PolicySelectionPreference();
        this.forceWsrm10Policy = false;
        this.normalizedPolicy = normalizedExpression;
        this.alternatives = normalizedExpression.getPolicyAlternatives();
    }

    public PolicySelectionHelper(NormalizedExpression normalizedExpression, MessageContext messageContext) {
        if (null == normalizedExpression) {
            throw new IllegalArgumentException("NullnormalizedPolicy found!");
        }
        this.preference = PolicySelectionPreference.getPolicySelectionPreference(messageContext);
        if (messageContext.containsProperty("weblogic.wsee.reliability.forceWSRM10Client")) {
            this.forceWsrm10Policy = true;
        }
        this.normalizedPolicy = normalizedExpression;
        this.alternatives = normalizedExpression.getPolicyAlternatives();
    }

    public PolicySelectionPreference getPolicySelectionPreference() {
        return this.preference;
    }

    public void setPolicySelectionPreference(PolicySelectionPreference policySelectionPreference) {
        this.preference = null == policySelectionPreference ? new PolicySelectionPreference() : policySelectionPreference;
    }

    public boolean isForceWsrm10Policy() {
        return this.forceWsrm10Policy;
    }

    public void setForceWsrm10Policy(boolean bl) {
        this.forceWsrm10Policy = bl;
    }

    public int getNumberOfAlternatives() {
        if (null == this.alternatives || this.alternatives.isEmpty()) {
            return 0;
        }
        return this.alternatives.size();
    }

    public boolean hasReliabilityPolicyAssertion() {
        if (this.getNumberOfAlternatives() == 0) {
            return false;
        }
        Set set = this.getReliabilityPolicyAssertion(0);
        return !set.isEmpty();
    }

    public PolicyAssertion[] getReliabilityPolicyAssertion() {
        Set set;
        if (this.getNumberOfAlternatives() == 0) {
            return null;
        }
        if (this.isForceWsrm10Policy()) {
            set = this.getReliabilityPolicyAssertion(1);
            if (set.size() == 0) {
                set.add(new RMAssertion());
            }
        } else if (this.preference.isDefaut()) {
            set = this.getReliabilityPolicyAssertion(0);
        } else if (this.preference.isInteropFirst()) {
            set = this.getReliabilityPolicyAssertion(1);
            set.addAll(this.getReliabilityPolicyAssertion(2));
        } else {
            set = this.getReliabilityPolicyAssertion(2);
            set.addAll(this.getReliabilityPolicyAssertion(1));
        }
        if (set.size() == 0) {
            return null;
        }
        PolicyAssertion[] policyAssertionArray = new PolicyAssertion[set.size()];
        Iterator iterator = set.iterator();
        for (int i = 0; i < set.size(); ++i) {
            policyAssertionArray[i] = (PolicyAssertion)iterator.next();
        }
        return policyAssertionArray;
    }

    private Set getReliabilityPolicyAssertion(int n) {
        Iterator iterator = this.alternatives.iterator();
        LinkedHashSet<PolicyAssertion> linkedHashSet = new LinkedHashSet<PolicyAssertion>();
        while (iterator.hasNext()) {
            PolicyAlternative policyAlternative = (PolicyAlternative)iterator.next();
            if (n == 0) {
                Set set = policyAlternative.getAssertions();
                for (PolicyAssertion policyAssertion : set) {
                    if (!(policyAssertion instanceof RMAssertion) && !(policyAssertion instanceof RM11Assertion)) continue;
                    linkedHashSet.add(policyAssertion);
                }
                continue;
            }
            if ((n & 1) > 0) {
                linkedHashSet.addAll(policyAlternative.getAssertions(RMAssertion.class));
            }
            if ((n & 2) <= 0) continue;
            linkedHashSet.addAll(policyAlternative.getAssertions(RM11Assertion.class));
        }
        return linkedHashSet;
    }

    public boolean hasSecurityPolicyAssertion() {
        if (this.getNumberOfAlternatives() == 0) {
            return false;
        }
        for (PolicyAlternative policyAlternative : this.alternatives) {
            SecurityPolicyAssertionInfo securityPolicyAssertionInfo = SecurityPolicyAssertionInfoFactory.getSecurityPolicyAssertionInfo(policyAlternative);
            if (securityPolicyAssertionInfo == null || !securityPolicyAssertionInfo.isMessageSecurityEnabled() && securityPolicyAssertionInfo.getTransportBindingInfo() == null) continue;
            return true;
        }
        return false;
    }

    public NormalizedExpression generateSamrtSecurityNormalizedExpression() throws SecurityPolicyArchitectureException {
        if (!this.hasSecurityPolicyAssertion()) {
            return null;
        }
        try {
            SecurityPolicySelectionHelper securityPolicySelectionHelper = new SecurityPolicySelectionHelper(this.normalizedPolicy, this.preference, true);
            return securityPolicySelectionHelper.generateSortedecurityNormalizedExpression();
        }
        catch (WSSecurityException wSSecurityException) {
            Verbose.log((Object)"Select got a WSSecurityException", wSSecurityException);
            throw new SecurityPolicyArchitectureException(wSSecurityException);
        }
    }
}

