/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.policy.util;

import java.io.Serializable;
import javax.xml.rpc.handler.MessageContext;
import weblogic.wsee.util.Verbose;

public class PolicySelectionPreference
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final boolean verbose = Verbose.isVerbose(PolicySelectionPreference.class);
    private static final boolean debug = true;
    public static final String VALIDATION_ONLY = "ValidationOnly";
    public static final String DEFAULT = "NONE";
    private static final String[] VALID_OPTIONS = new String[]{"CPS", "CSP", "PCS", "PSC", "SCP", "SPC", "ValidationOnly", "NONE"};
    private String policySelectionPrefernceString;
    public static final int SECURITY_IDX = 0;
    public static final int INTEROP_IDX = 1;
    public static final int PERFORMANCE_IDX = 2;

    public PolicySelectionPreference() {
        this.policySelectionPrefernceString = DEFAULT;
    }

    public PolicySelectionPreference(String string) {
        if (!PolicySelectionPreference.isValidPreference(string)) {
            throw new IllegalArgumentException("Input String is invalid for " + string);
        }
        this.policySelectionPrefernceString = string;
    }

    public boolean isDefaut() {
        return DEFAULT.equals(this.policySelectionPrefernceString);
    }

    public boolean isSecurityFirst() {
        return this.policySelectionPrefernceString.startsWith("S");
    }

    public boolean isPreformanceFirst() {
        return this.policySelectionPrefernceString.startsWith("P");
    }

    public boolean isInteropFirst() {
        return this.policySelectionPrefernceString.startsWith("C");
    }

    public boolean isCompatibiltyFirst() {
        return this.policySelectionPrefernceString.startsWith("C");
    }

    public String getPolicySelectionPrefernceString() {
        return this.policySelectionPrefernceString;
    }

    public static boolean isValidPreference(String string) {
        if (null == string) {
            return false;
        }
        for (int i = 0; i < VALID_OPTIONS.length; ++i) {
            if (!VALID_OPTIONS[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public static PolicySelectionPreference getPolicySelectionPreference(MessageContext messageContext) {
        if (null == messageContext) {
            return new PolicySelectionPreference();
        }
        Object object = messageContext.getProperty("weblogic.wsee.policy.selection.preference");
        if (null == object) {
            return new PolicySelectionPreference();
        }
        if (object instanceof PolicySelectionPreference) {
            return (PolicySelectionPreference)object;
        }
        return new PolicySelectionPreference((String)object);
    }

    private int factor(int n) {
        switch (n) {
            case 0: {
                return 90000;
            }
            case 1: {
                return 300;
            }
            case 2: {
                return 1;
            }
        }
        return 0;
    }

    public int calculateScore(int[] nArray) {
        if (this.isDefaut()) {
            return 1;
        }
        int n = nArray[0] * this.factor(this.policySelectionPrefernceString.indexOf("S")) + nArray[1] * this.factor(this.policySelectionPrefernceString.indexOf("C")) + nArray[2] * this.factor(this.policySelectionPrefernceString.indexOf("P"));
        String string = null;
        if (!verbose) {
            // empty if block
        }
        string = "Preferece =" + this.policySelectionPrefernceString + " sec points=" + nArray[0] + " interop points=" + nArray[1] + " performance points=" + nArray[2] + " total = " + n;
        if (verbose) {
            Verbose.log(string);
        }
        System.err.println(string);
        return n;
    }

    public PolicySelectionPreference clone() {
        return new PolicySelectionPreference(this.getPolicySelectionPrefernceString());
    }

    public String toString() {
        return this.policySelectionPrefernceString;
    }
}

