/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability;

import java.io.Serializable;
import javax.xml.rpc.JAXRPCException;
import weblogic.store.PersistentStoreException;
import weblogic.wsee.cluster.ClusterService;
import weblogic.wsee.cluster.ClusterServiceException;
import weblogic.wsee.conversation.ConversationInvokeState;
import weblogic.wsee.conversation.ConversationInvokeStateObjectHandler;
import weblogic.wsee.reliability.ReliableConversationEPR;
import weblogic.wsee.server.WsStorage;
import weblogic.wsee.server.WsStorageFactory;
import weblogic.wsee.util.Verbose;

public final class ReliableConversationMsgClusterService
implements ClusterService {
    private static final boolean verbose = Verbose.isVerbose(ReliableConversationMsgClusterService.class);
    public static final String TARGET_URI = "weblogic.wsee.reliability.conversation.msg.cluster.service";

    public String getTargetURI() {
        return TARGET_URI;
    }

    public Serializable dispatch(Serializable serializable) throws ClusterServiceException {
        if (!(serializable instanceof ReliableConversationEPR)) {
            throw new ClusterServiceException("Invalid object type: " + serializable);
        }
        ReliableConversationEPR reliableConversationEPR = (ReliableConversationEPR)serializable;
        if (verbose) {
            Verbose.log("------------------------------");
            Verbose.log("Invoking reliable message cluster service for Reliable EPR: " + reliableConversationEPR);
            Verbose.log("------------------------------");
        }
        WsStorage wsStorage = WsStorageFactory.getStorage("weblogic.wsee.conversation.store", new ConversationInvokeStateObjectHandler());
        ConversationInvokeState conversationInvokeState = new ConversationInvokeState();
        conversationInvokeState.setRmState(true);
        conversationInvokeState.setSeqId(reliableConversationEPR.getSeqId());
        conversationInvokeState.setEpr(reliableConversationEPR.getEPR());
        try {
            wsStorage.persistentPut(reliableConversationEPR.getKey(), conversationInvokeState);
        }
        catch (PersistentStoreException persistentStoreException) {
            throw new JAXRPCException((Throwable)persistentStoreException);
        }
        return null;
    }
}

