/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability;

import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import weblogic.wsee.message.MsgHeader;
import weblogic.wsee.message.MsgHeaderException;
import weblogic.wsee.message.MsgHeaderType;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public final class SAFServerHeader
extends MsgHeader {
    static final long serialVersionUID = 9156688460997770947L;
    public static final String SAFSERVER_NS = "http://www.bea.com/safserver";
    public static final String XML_TAG_SAFSERVER = "SAFServer";
    private static final String SAFSERVER_PREFIX = "safserver";
    private static final String XML_TAG_SERVER_NAME = "ServerName";
    private static final String XML_TAG_CONVERSATION_KEY = "ConversationKey";
    public static final QName NAME = new QName("http://www.bea.com/safserver", "SAFServer", "safserver");
    public static final MsgHeaderType TYPE = new MsgHeaderType();
    private String serverName;
    private String conversationKey;

    public QName getName() {
        return NAME;
    }

    public MsgHeaderType getType() {
        return TYPE;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String string) {
        this.serverName = string;
    }

    public String getConversationKey() {
        return this.conversationKey;
    }

    public void setConversationKey(String string) {
        this.conversationKey = string;
    }

    public void read(Element element) throws MsgHeaderException {
        try {
            this.serverName = DOMUtils.getValueByTagNameNS(element, SAFSERVER_NS, XML_TAG_SERVER_NAME);
            this.conversationKey = DOMUtils.getValueByTagNameNS(element, SAFSERVER_NS, XML_TAG_CONVERSATION_KEY);
        }
        catch (DOMProcessingException dOMProcessingException) {
            throw new MsgHeaderException("Could not read SAFServerHeader", (Throwable)((Object)dOMProcessingException));
        }
    }

    public void write(Element element) throws MsgHeaderException {
        if (this.serverName == null) {
            throw new MsgHeaderException("Server name is null");
        }
        DOMUtils.addNamespaceDeclaration(element, SAFSERVER_PREFIX, SAFSERVER_NS);
        DOMUtils.addValueNS(element, SAFSERVER_NS, "safserver:ServerName", this.serverName);
        DOMUtils.addValueNS(element, SAFSERVER_NS, "safserver:ConversationKey", this.conversationKey);
    }
}

