/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability;

import java.util.Map;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.runtime.PolicyContext;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability.WsrmHandler;
import weblogic.wsee.reliability.WsrmSAFManagerFactory;
import weblogic.wsee.reliability.policy.WsrmPolicyClientRuntimeHandler;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.wsdl.WsdlOperation;

public class WsrmClientHandler
extends WsrmHandler {
    private static final boolean verbose = Verbose.isVerbose(WsrmClientHandler.class);

    public boolean handleRequest(MessageContext messageContext) {
        String string;
        assert (messageContext != null);
        if (!(messageContext instanceof SOAPMessageContext)) {
            return true;
        }
        WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
        if (verbose) {
            Verbose.log("[WsrmClientHandler.handleRequest()] called");
        }
        boolean bl = true;
        Map map = (Map)wlMessageContext.getProperty("weblogic.wsee.invoke_properties");
        if (map != null && (string = (String)map.get("weblogic.wsee.sequenceid")) != null) {
            bl = false;
        }
        if (bl && wlMessageContext.containsProperty("weblogic.wsee.reliability.forceWSRM10Client")) {
            wlMessageContext.setProperty("weblogic.wsee.wsrm.RMVersion", (Object)WsrmConstants.RMVersion.RM_10);
        }
        try {
            boolean bl2 = wlMessageContext.getProperty("weblogic.wsee.async.res") != null ? new WsrmPolicyClientRuntimeHandler().processRequest(messageContext, PolicyContext.getResponseEffectivePolicy(messageContext)) : new WsrmPolicyClientRuntimeHandler().processRequest(messageContext, PolicyContext.getRequestEffectivePolicy(messageContext));
            if (!bl2) {
                return false;
            }
        }
        catch (PolicyException policyException) {
            throw new JAXRPCException(policyException.getMessage());
        }
        if (messageContext.getProperty("weblogic.wsee.ackrequest") != null) {
            if (verbose) {
                Verbose.log("Acknowledgement request");
            }
            WsrmSAFManagerFactory.getWsrmSAFSendingManager().ackRequest(wlMessageContext);
            return false;
        }
        WsdlOperation wsdlOperation = wlMessageContext.getDispatcher().getOperation();
        if (wsdlOperation != null && (wsdlOperation.getType() == 0 || wsdlOperation.getType() == 2) && wlMessageContext.getProperty("weblogic.wsee.async.invoke") == null && wlMessageContext.getProperty("weblogic.wsee.async.res") == null) {
            throw new JAXRPCException("Reliable messaging will only work with one way messages or asynchronous request/response messages.");
        }
        WsrmSAFManagerFactory.getWsrmSAFSendingManager().storeAndForward(wlMessageContext);
        return false;
    }
}

