/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import weblogic.webservice.core.soap.NameImpl;

public class WsrmConstants {
    public static final String BASE_RETRANSMISSION_INTERVAL = "weblogic.wsee.wsrm.BaseRetransmissionInterval";
    public static final String RETRANSMISSION_EXPONENTIAL_BACKOFF = "weblogic.wsee.wsrm.RetransmissionExponentialBackoff";
    public static final String NON_BUFFERED_SOURCE = "weblogic.wsee.wsrm.NonBufferedSource";
    public static final String RETRY_COUNT = "weblogic.wsee.wsrm.RetryCount";
    public static final String RETRY_DELAY = "weblogic.wsee.wsrm.RetryDelay";
    public static final String ACKNOWLEDGEMENT_INTERVAL = "weblogic.wsee.wsrm.AcknowledgementInterval";
    public static final String NON_BUFFERED_DESTINATION = "weblogic.wsee.wsrm.NonBufferedDestination";
    public static final String BUFFER_QUEUE_JNDI_NAME = "weblogic.wsee.wsrm.BufferQueueJndiName";
    public static final String BUFFER_QUEUE_MDB_RUNAS_PRINCIPAL_NAME = "weblogic.wsee.wsrm.BufferQueueMdbRunAsPrincipalName";
    public static final String INACTIVITY_TIMEOUT = "weblogic.wsee.wsrm.InactivityTimeout";
    public static final String SEQUENCE_EXPIRATION = "weblogic.wsee.wsrm.SequenceExpiration";
    public static final String TEST_SEQUENCE_SSL = "weblogic.wsee.reliability.TestSequenceSSL";
    public static final String ASYNC_FAULT = "weblogic.wsee.reliability.asyncfault";
    public static final String TEMP_ID__For_New_Sequence = "New";
    public static final String[] PROP_NAMES_FOR_RM_SOURCE_ONLY = new String[]{"weblogic.wsee.wsrm.BaseRetransmissionInterval", "weblogic.wsee.wsrm.RetransmissionExponentialBackoff"};
    public static final String[] PROP_NAMES_FOR_RM_DESTINATION_ONLY = new String[]{"weblogic.wsee.wsrm.RetryCount", "weblogic.wsee.wsrm.RetryDelay"};
    public static final String[] PROP_NAMES_FOR_RM_SOURCE_OR_DESTINATION = new String[]{"weblogic.wsee.wsrm.InactivityTimeout", "weblogic.wsee.wsrm.AcknowledgementInterval", "weblogic.wsee.wsrm.SequenceExpiration"};
    public static final String[] PROP_NAMES_FOR_RM_SOURCE;
    public static final String[] PROP_NAMES_FOR_RM_DESTINATION;
    public static final String RM_VERSION = "weblogic.wsee.wsrm.RMVersion";
    public static final String FORCE_WSRM_1_0_CLIENT = "weblogic.wsee.reliability.forceWSRM10Client";
    public static final String SEQUENCE_STR = "weblogic.wsee.wsrm.SequenceSTR";
    public static final String SEQUENCE_TRANSPORT_SECURITY = "weblogic.wsee.wsrm.SequenceTransportSecurity";

    static {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(PROP_NAMES_FOR_RM_SOURCE_ONLY));
        arrayList.addAll(Arrays.asList(PROP_NAMES_FOR_RM_SOURCE_OR_DESTINATION));
        PROP_NAMES_FOR_RM_SOURCE = arrayList.toArray(new String[arrayList.size()]);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.addAll(Arrays.asList(PROP_NAMES_FOR_RM_DESTINATION_ONLY));
        arrayList2.addAll(Arrays.asList(PROP_NAMES_FOR_RM_SOURCE_OR_DESTINATION));
        PROP_NAMES_FOR_RM_DESTINATION = arrayList2.toArray(new String[arrayList2.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DeliveryQOS {
        AtLeastOnce,
        AtMostOnce,
        ExactlyOnce;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IncompleteSequenceBehavior {
        DiscardEntireSequence,
        DiscardFollowingFirstGap,
        NoDiscard;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FaultCode {
        SENDER("Client", "Sender"),
        RECEIVER("Server", "Receiver");

        Map<SOAPVersion, String> versionToCodeMap = new HashMap<SOAPVersion, String>();

        private FaultCode(String string2, String string3) {
            this.versionToCodeMap.put(SOAPVersion.SOAP_11, string2);
            this.versionToCodeMap.put(SOAPVersion.SOAP_12, string3);
        }

        public String getCodeLocalName(SOAPVersion sOAPVersion) {
            String string = this.versionToCodeMap.get((Object)sOAPVersion);
            return string;
        }

        public String getCodeQualifiedName(SOAPVersion sOAPVersion) {
            String string = this.versionToCodeMap.get((Object)sOAPVersion);
            return sOAPVersion.getPrefix() + ":" + string;
        }

        public QName getCodeQName(SOAPVersion sOAPVersion) {
            String string = this.versionToCodeMap.get((Object)sOAPVersion);
            return new QName(sOAPVersion.getNamespaceUri(), string);
        }

        public Name getCodeName(SOAPVersion sOAPVersion) {
            String string = this.versionToCodeMap.get((Object)sOAPVersion);
            return new NameImpl(string, sOAPVersion.getPrefix(), sOAPVersion.getNamespaceUri());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HeaderElement {
        SEQUENCE(Element.SEQUENCE),
        ACK(Element.ACK),
        ACK_REQUESTED(Element.ACK_REQUESTED),
        CREATE_SEQUENCE(Element.CREATE_SEQUENCE),
        CREATE_SEQUENCE_RESPONSE(Element.CREATE_SEQUENCE_RESPONSE),
        TERMINATE_SEQUENCE(Element.TERMINATE_SEQUENCE),
        TERMINATE_SEQUENCE_RESPONSE(Element.TERMINATE_SEQUENCE_RESPONSE),
        CLOSE_SEQUENCE(Element.CLOSE_SEQUENCE),
        CLOSE_SEQUENCE_RESPONSE(Element.CLOSE_SEQUENCE_RESPONSE),
        FAULT_CODE(Element.FAULT_CODE);

        private Element elem;
        private static Set<QName> headerElementQNameSet;

        private HeaderElement(Element element) {
            this.elem = element;
        }

        public QName getQualifiedName(RMVersion rMVersion) {
            return this.elem.getQName(rMVersion);
        }

        public static Set getHeaderElementQNameSet() {
            if (headerElementQNameSet == null) {
                headerElementQNameSet = new HashSet<QName>();
                for (RMVersion rMVersion : RMVersion.values()) {
                    List list = HeaderElement.getHeaderQNameListForRMVersion(rMVersion);
                    headerElementQNameSet.addAll(list);
                }
            }
            return headerElementQNameSet;
        }

        private static List getHeaderQNameListForRMVersion(RMVersion rMVersion) {
            ArrayList<QName> arrayList = new ArrayList<QName>();
            for (HeaderElement headerElement : HeaderElement.values()) {
                arrayList.add(headerElement.getQualifiedName(rMVersion));
            }
            return arrayList;
        }

        static {
            headerElementQNameSet = HeaderElement.getHeaderElementQNameSet();
            headerElementQNameSet.add(Element.USES_SEQUENCE_STR.getQName(RMVersion.RM_11));
            headerElementQNameSet.add(Element.USES_SEQUENCE_SSL.getQName(RMVersion.RM_11));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Element {
        SEQUENCE("Sequence"),
        ACK("SequenceAcknowledgement"),
        ACK_REQUESTED("AckRequested"),
        CREATE_SEQUENCE("CreateSequence"),
        CREATE_SEQUENCE_RESPONSE("CreateSequenceResponse"),
        TERMINATE_SEQUENCE("TerminateSequence"),
        TERMINATE_SEQUENCE_RESPONSE("TerminateSequenceResponse"),
        CLOSE_SEQUENCE("CloseSequence"),
        CLOSE_SEQUENCE_RESPONSE("CloseSequenceResponse"),
        ACKS_TO("AcksTo"),
        EXPIRES("Expires"),
        OFFER("Offer"),
        ACCEPT("Accept"),
        IDENTIFIER("Identifier"),
        ACK_RANGE("AcknowledgementRange"),
        MESSAGE_NUMBER("MessageNumber"),
        LAST_MESSAGE("LastMessage"),
        NACK("Nack"),
        LOWER("Lower"),
        UPPER("Upper"),
        SEQUENCE_FAULT("SequenceFault"),
        FAULT_CODE("FaultCode"),
        ENDPOINT("Endpoint"),
        INCOMPLETE_SEQUENCE_BEHAVIOR("IncompleteSequenceBehavior"),
        NONE("None"),
        FINAL("Final"),
        LAST_MSG_NUMBER("LastMsgNumber"),
        USES_SEQUENCE_STR("UsesSequenceSTR"),
        USES_SEQUENCE_SSL("UsesSequenceSSL"),
        TEST_SEQUENCE_SSL("TestSequenceSSL"),
        TEST_SEQUENCE_SSL_SESSION_ID("SSLSessionID");

        private String elementName;

        private Element(String string2) {
            this.elementName = string2;
        }

        public String getElementName() {
            return this.elementName;
        }

        public String getQualifiedName(RMVersion rMVersion) {
            return rMVersion.getPrefix() + ":" + this.elementName;
        }

        public QName getQName(RMVersion rMVersion) {
            return new QName(rMVersion.getNamespaceUri(), this.elementName, rMVersion.getPrefix());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Action {
        ACK("SequenceAcknowledgement"),
        ACK_REQUESTED("AckRequested"),
        CREATE_SEQUENCE("CreateSequence"),
        CREATE_SEQUENCE_RESPONSE("CreateSequenceResponse"),
        CLOSE_SEQUENCE("CloseSequence"),
        CLOSE_SEQUENCE_RESPONSE("CloseSequenceResponse"),
        TERMINATE_SEQUENCE("TerminateSequence"),
        TERMINATE_SEQUENCE_RESPONSE("TerminateSequenceResponse"),
        LAST_MESSAGE("LastMessage");

        String elementName;

        private Action(String string2) {
            this.elementName = string2;
        }

        public String getElementName() {
            return this.elementName;
        }

        public String getActionURI(RMVersion rMVersion) {
            return rMVersion.getNamespaceUri() + "/" + this.elementName;
        }

        public boolean matchesAnyRMVersion(String string) {
            for (RMVersion rMVersion : RMVersion.values()) {
                if (!this.getActionURI(rMVersion).equals(string)) continue;
                return true;
            }
            return false;
        }

        public static boolean matchesAnyActionAndRMVersion(String string) {
            List<String> list = Action.getAllActionsForAllRMVersions();
            return list.contains(string);
        }

        public static List<String> getAllActionsForAllRMVersions() {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Action action : Action.values()) {
                for (RMVersion rMVersion : RMVersion.values()) {
                    StringBuffer stringBuffer = new StringBuffer(rMVersion.getNamespaceUri());
                    stringBuffer.append("/");
                    stringBuffer.append(action.elementName);
                    arrayList.add(stringBuffer.toString());
                }
            }
            return arrayList;
        }

        public static String dumpAllActionsForAllRMVersions() {
            StringBuffer stringBuffer = new StringBuffer();
            List<String> list = Action.getAllActionsForAllRMVersions();
            for (int i = 0; i < list.size(); ++i) {
                stringBuffer.append(list.get(i));
                if (i >= list.size() - 1) continue;
                stringBuffer.append(", ");
            }
            return stringBuffer.toString();
        }

        public static Action valueOfElementName(String string) {
            for (Action action : Action.values()) {
                if (!action.getElementName().equals(string)) continue;
                return action;
            }
            throw new IllegalArgumentException("No enum in " + Action.class.getName() + " with elementName: " + string);
        }

        public static VersionInfo getVersionInfo(String string) {
            VersionInfo versionInfo = new VersionInfo();
            block0: for (Action action : Action.values()) {
                for (RMVersion rMVersion : RMVersion.values()) {
                    if (!action.getActionURI(rMVersion).equals(string)) continue;
                    versionInfo.action = action;
                    versionInfo.rmVersion = rMVersion;
                    continue block0;
                }
            }
            if (versionInfo.action != null) {
                return versionInfo;
            }
            return null;
        }

        public static class VersionInfo {
            public Action action;
            public RMVersion rmVersion;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SOAPVersion {
        SOAP_11("soap", "http://schemas.xmlsoap.org/soap/envelope/"),
        SOAP_12("soap12", "http://www.w3.org/2003/05/soap-envelope");

        String prefix;
        String namespaceUri;

        private SOAPVersion(String string2, String string3) {
            this.prefix = string2;
            this.namespaceUri = string3;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getNamespaceUri() {
            return this.namespaceUri;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RMVersion {
        RM_10("wsrm", "http://schemas.xmlsoap.org/ws/2005/02/rm", "wsrmp", "http://schemas.xmlsoap.org/ws/2005/02/rm/policy"),
        RM_11("wsrm11", "http://docs.oasis-open.org/ws-rx/wsrm/200702", "wsrmp11", "http://docs.oasis-open.org/ws-rx/wsrmp/200702");

        String prefix;
        String namespaceUri;
        String policyPrefix;
        String policyNamespaceUri;

        private RMVersion(String string2, String string3, String string4, String string5) {
            this.prefix = string2;
            this.namespaceUri = string3;
            this.policyPrefix = string4;
            this.policyNamespaceUri = string5;
        }

        public static RMVersion latest() {
            return RM_11;
        }

        public static RMVersion forNamespaceUri(String string) {
            for (RMVersion rMVersion : RMVersion.values()) {
                if (!rMVersion.getNamespaceUri().equals(string)) continue;
                return rMVersion;
            }
            return RMVersion.latest();
        }

        public static RMVersion forPolicyNamespaceUri(String string) {
            for (RMVersion rMVersion : RMVersion.values()) {
                if (!rMVersion.getPolicyNamespaceUri().equals(string)) continue;
                return rMVersion;
            }
            return RMVersion.latest();
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getNamespaceUri() {
            return this.namespaceUri;
        }

        public String getPolicyNamespaceUri() {
            return this.policyNamespaceUri;
        }

        public String getPolicyPrefix() {
            return this.policyPrefix;
        }

        public boolean isLaterThan(RMVersion rMVersion) {
            return rMVersion.ordinal() < this.ordinal();
        }

        public boolean isLaterThanOrEqualTo(RMVersion rMVersion) {
            return rMVersion.ordinal() <= this.ordinal();
        }

        public boolean isBefore(RMVersion rMVersion) {
            return rMVersion.ordinal() > this.ordinal();
        }
    }
}

