/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.rpc.JAXRPCException;
import javax.xml.soap.SOAPMessage;
import weblogic.i18n.logging.NonCatalogLogger;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.messaging.saf.SAFEndpoint;
import weblogic.messaging.saf.SAFErrorAwareEndpointManager;
import weblogic.messaging.saf.SAFErrorHandler;
import weblogic.messaging.saf.SAFRequest;
import weblogic.messaging.saf.SAFResult;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.store.PersistentStoreException;
import weblogic.wsee.addressing.MessageIdHeader;
import weblogic.wsee.async.AsyncInvokeState;
import weblogic.wsee.async.AsyncInvokeStateObjectHandler;
import weblogic.wsee.async.AsyncPostCallContext;
import weblogic.wsee.async.SOAPInvokeState;
import weblogic.wsee.jws.container.Request;
import weblogic.wsee.message.soap.SoapMessageContext;
import weblogic.wsee.reliability.ReliabilityErrorContext;
import weblogic.wsee.reliability.ReliabilityErrorContextImpl;
import weblogic.wsee.reliability.ReliabilityErrorListenerRegistry;
import weblogic.wsee.reliability.WsrmPermanentTransportException;
import weblogic.wsee.reliability.WsrmSAFEndpoint;
import weblogic.wsee.server.WsStorage;
import weblogic.wsee.server.WsStorageFactory;
import weblogic.wsee.util.AccessException;
import weblogic.wsee.util.DirectInvokeUtil;
import weblogic.wsee.util.Verbose;

public class WsrmEndpointManager
implements SAFErrorAwareEndpointManager {
    private static final boolean verbose = Verbose.isVerbose(WsrmEndpointManager.class);
    private static final String ENDPOINT_MANAGER_STORE = "weblogic.wsee.endpointmanager.store";
    private static final String ENDPOINT_MANAGER_IDLIST_KEY = "weblogic.wsee.endpointmanager.idlist";
    private HashMap endpoints = new HashMap();
    private Map errorHandlers = Collections.synchronizedMap(new HashMap());
    private static AuthenticatedSubject _kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static RuntimeAccess _runtimeAccess = ManagementService.getRuntimeAccess(_kernelId);
    private ServerStateChangeListener _stateChangeListener = new ServerStateChangeListener();
    private NonCatalogLogger _logger;

    public WsrmEndpointManager() {
        _runtimeAccess.getServerRuntime().addPropertyChangeListener(this._stateChangeListener);
        this._logger = new NonCatalogLogger("WsrmEndpointManager");
    }

    public synchronized void addEndpoint(String string, SAFEndpoint sAFEndpoint) {
        this.endpoints.put(string, sAFEndpoint);
    }

    public synchronized void removeEndpoint(String string) {
        this.endpoints.remove(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SAFEndpoint getEndpoint(String string) {
        SAFEndpoint sAFEndpoint;
        String string2;
        try {
            string2 = new URI(string).getPath();
        }
        catch (URISyntaxException uRISyntaxException) {
            if (verbose) {
                Verbose.logException(uRISyntaxException);
            }
            throw new JAXRPCException("Could not parse destination URL", (Throwable)uRISyntaxException);
        }
        Object object = this;
        synchronized (object) {
            sAFEndpoint = (SAFEndpoint)this.endpoints.get(string2);
        }
        if (sAFEndpoint == null) {
            if (!string2.endsWith("/")) {
                object = string2 + "/";
                sAFEndpoint = (SAFEndpoint)this.endpoints.get(object);
            } else if (string2.endsWith("/")) {
                object = string2.substring(0, string2.length() - 1);
                sAFEndpoint = (SAFEndpoint)this.endpoints.get(object);
            }
            if (sAFEndpoint == null) {
                sAFEndpoint = new WsrmSAFEndpoint(string2);
                this.addEndpoint(string2, sAFEndpoint);
            }
        }
        return sAFEndpoint;
    }

    public void handleFailure(SAFErrorHandler sAFErrorHandler, SAFRequest sAFRequest, ArrayList arrayList) {
        this.handleFailure(sAFErrorHandler, sAFRequest, arrayList, new ArrayList());
    }

    public void handleFailure(SAFErrorHandler sAFErrorHandler, SAFRequest sAFRequest, ArrayList arrayList, ArrayList arrayList2) {
        SOAPInvokeState sOAPInvokeState = (SOAPInvokeState)sAFRequest.getPayload();
        Map map = sOAPInvokeState.getMessageContextProperties();
        String string = (String)map.get("weblogic.wsee.reliabile.errorhandler");
        String string2 = (String)map.get("weblogic.wsee.reliable.errorlistener");
        if (string == null && string2 == null) {
            Verbose.log("Messages not delivered for sequence " + sAFRequest.getConversationName() + ", Fault Codes are: ");
            Verbose.log(arrayList);
            return;
        }
        if (!this._stateChangeListener.isServerUp()) {
            SavedFailureNotification savedFailureNotification = new SavedFailureNotification(sAFErrorHandler, sAFRequest, arrayList, arrayList2);
            try {
                this.storeFailureNotification(savedFailureNotification);
            }
            catch (Exception exception) {
                Verbose.log("Messages not delivered for sequence " + sAFRequest.getConversationName() + ", Fault Codes are: ");
                Verbose.log(arrayList);
                throw new JAXRPCException(exception.toString(), (Throwable)exception);
            }
            return;
        }
        this.internalHandleFailure(sAFErrorHandler, sAFRequest, arrayList, arrayList2);
    }

    public void internalHandleFailure(SAFErrorHandler sAFErrorHandler, SAFRequest sAFRequest, ArrayList arrayList, ArrayList arrayList2) {
        Object object;
        SOAPInvokeState sOAPInvokeState = (SOAPInvokeState)sAFRequest.getPayload();
        Map map = sOAPInvokeState.getMessageContextProperties();
        String string = (String)map.get("weblogic.wsee.reliabile.errorhandler");
        String string2 = (String)map.get("weblogic.wsee.reliable.errorlistener");
        String string3 = (String)map.get("weblogic.wsee.ws.dispatch.client.OperationName");
        String string4 = (String)map.get("weblogic.wsee.stub.name");
        SOAPMessage sOAPMessage = sOAPInvokeState.getSOAPMessage();
        String string5 = this.createFailureMessage(arrayList, arrayList2);
        AsyncPostCallContext asyncPostCallContext = this.getAsyncPostCallContextForMessage(sOAPMessage);
        ReliabilityErrorContextImpl reliabilityErrorContextImpl = new ReliabilityErrorContextImpl(string3, string4, sOAPMessage, string5, arrayList2, asyncPostCallContext);
        if (string != null) {
            try {
                object = (String)map.get("weblogic.wsee.enclosing.classname");
                Class[] classArray = new Class[]{ReliabilityErrorContext.class};
                Object[] objectArray = new Object[]{reliabilityErrorContextImpl};
                String string6 = (String)map.get("weblogic.wsee.enclosing.jws.serviceuri");
                String string7 = (String)map.get("weblogic.wsee.conversation.ConversationId");
                Request request = new Request((String)object, string, classArray, objectArray);
                DirectInvokeUtil.invoke(string6, request, string7, null);
            }
            catch (JAXRPCException jAXRPCException) {
                throw jAXRPCException;
            }
            catch (Throwable throwable) {
                throw new JAXRPCException(throwable);
            }
        }
        if (string2 != null) {
            object = ReliabilityErrorListenerRegistry.getInstance().getListener(string2);
            if (object == null) {
                throw new JAXRPCException("Didn't find any registered ReliabilityErrorListener with key: " + string2);
            }
            object.onReliabilityError(reliabilityErrorContextImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AsyncPostCallContext getAsyncPostCallContextForMessage(SOAPMessage sOAPMessage) {
        AsyncInvokeState asyncInvokeState;
        String string;
        try {
            string = sOAPMessage.getSOAPPart().getEnvelope().getNamespaceURI();
        }
        catch (Exception exception) {
            throw new JAXRPCException(exception.toString(), (Throwable)exception);
        }
        boolean bl = "http://www.w3.org/2003/05/soap-envelope".equals(string);
        SoapMessageContext soapMessageContext = new SoapMessageContext(bl);
        soapMessageContext.setMessage(sOAPMessage);
        MessageIdHeader messageIdHeader = (MessageIdHeader)soapMessageContext.getHeaders().getHeader(MessageIdHeader.TYPE);
        if (messageIdHeader == null) {
            return null;
        }
        String string2 = messageIdHeader.getMessageId();
        WsStorage wsStorage = WsStorageFactory.getStorage("weblogic.wsee.async.store", new AsyncInvokeStateObjectHandler());
        try {
            asyncInvokeState = (AsyncInvokeState)wsStorage.persistentGet(string2);
            if (asyncInvokeState == null) {
                return null;
            }
        }
        catch (PersistentStoreException persistentStoreException) {
            if (verbose) {
                Verbose.logException(persistentStoreException);
            }
            throw new JAXRPCException((Throwable)persistentStoreException);
        }
        AsyncInvokeState asyncInvokeState2 = asyncInvokeState;
        synchronized (asyncInvokeState2) {
            asyncInvokeState = (AsyncInvokeState)wsStorage.get(string2);
            if (asyncInvokeState == null) {
                return null;
            }
            return asyncInvokeState.getAsyncPostCallContext();
        }
    }

    private synchronized void storeFailureNotification(SavedFailureNotification savedFailureNotification) throws PersistentStoreException {
        if (savedFailureNotification == null || savedFailureNotification.getSAFRequest() == null) {
            return;
        }
        Verbose.log("Storing/deferring failure notification in WsrmEndpointManager for message: " + savedFailureNotification.getSAFRequest().getMessageId() + " and conversation: " + savedFailureNotification.getSAFRequest().getConversationName());
        WsStorage wsStorage = WsStorageFactory.getStorage(ENDPOINT_MANAGER_STORE);
        HashSet<String> hashSet = (HashSet<String>)wsStorage.persistentGet(ENDPOINT_MANAGER_IDLIST_KEY);
        if (hashSet == null) {
            hashSet = new HashSet<String>();
        }
        String string = savedFailureNotification.getSAFRequest().getMessageId();
        hashSet.add(string);
        wsStorage.persistentPut(ENDPOINT_MANAGER_IDLIST_KEY, hashSet);
        wsStorage.persistentPut(string, savedFailureNotification);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void handleServerUp() {
        if (verbose) {
            Verbose.log("Server is now up, delivering any stored/deferred failure notification in WsrmEndpointManager");
        }
        WsStorage wsStorage = WsStorageFactory.getStorage(ENDPOINT_MANAGER_STORE);
        try {
            Set set = (Set)wsStorage.persistentGet(ENDPOINT_MANAGER_IDLIST_KEY);
            if (set == null) {
                return;
            }
            Verbose.log("Delivering " + set.size() + " stored/deferred failure notifications in WsrmEndpointManager");
            for (String string : set) {
                SavedFailureNotification savedFailureNotification = (SavedFailureNotification)wsStorage.persistentGet(string);
                if (savedFailureNotification != null) {
                    Verbose.log("Delivering stored/deferred failure notification in WsrmEndpointManager for message: " + savedFailureNotification.getSAFRequest().getMessageId() + " and conversation: " + savedFailureNotification.getSAFRequest().getConversationName());
                    try {
                        this.internalHandleFailure(savedFailureNotification.getErrorHandler(), savedFailureNotification.getSAFRequest(), savedFailureNotification.getFaultCodes(), savedFailureNotification.getErrors());
                        continue;
                    }
                    finally {
                        try {
                            wsStorage.persistentRemove(string);
                        }
                        catch (Exception exception) {
                            this._logger.error(exception.toString(), (Throwable)exception);
                        }
                        continue;
                    }
                }
                Verbose.log("[ERROR] - Didn't find stored/deferred failure notification in WsrmEndpointManager for message: " + string);
            }
        }
        catch (Exception exception) {
            this._logger.error("Could not process stored/deferred failure notifications", (Throwable)exception);
        }
        finally {
            try {
                wsStorage.persistentRemove(ENDPOINT_MANAGER_IDLIST_KEY);
            }
            catch (Exception exception) {
                this._logger.error(exception.toString(), (Throwable)exception);
            }
        }
    }

    private String createFailureMessage(ArrayList arrayList, ArrayList arrayList2) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        if (verbose) {
            Verbose.log("Handle failure called");
        }
        for (n = 0; n < arrayList.size(); ++n) {
            int n2 = (Integer)arrayList.get(n);
            if (verbose) {
                Verbose.log("Got fault " + n2 + " " + SAFResult.description[n2]);
            }
            stringBuffer.append(SAFResult.description[n2]);
            stringBuffer.append("\n");
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            Throwable throwable = (Throwable)arrayList2.get(n);
            throwable = this.unwrapError(throwable);
            if (verbose) {
                Verbose.log("Got exception from transport: " + throwable.toString());
            }
            stringBuffer.append(throwable.toString());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private Throwable unwrapError(Throwable throwable) {
        Throwable throwable2 = throwable;
        for (Throwable throwable3 = throwable; throwable3 != null; throwable3 = throwable3.getCause()) {
            if (!(throwable3 instanceof WsrmPermanentTransportException) && !(throwable3 instanceof AccessException)) continue;
            throwable2 = throwable3;
            break;
        }
        return throwable2;
    }

    public SAFErrorHandler createErrorHandlerInstance() {
        if (verbose) {
            Verbose.log("createErrorHandlerInstance is not supported for WsrmEndpointManager");
        }
        return null;
    }

    public SAFErrorHandler getErrorHandler(String string) {
        return (SAFErrorHandler)this.errorHandlers.get(string);
    }

    private static class SavedFailureNotification
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public SAFErrorHandler eh;
        public SAFRequest request;
        public ArrayList faultCodes;
        public transient ArrayList errors;

        public SavedFailureNotification(SAFErrorHandler sAFErrorHandler, SAFRequest sAFRequest, ArrayList arrayList, ArrayList arrayList2) {
            this.eh = sAFErrorHandler;
            this.request = sAFRequest;
            this.faultCodes = arrayList;
            this.errors = arrayList2;
        }

        public SAFErrorHandler getErrorHandler() {
            return this.eh;
        }

        public SAFRequest getSAFRequest() {
            return this.request;
        }

        public ArrayList getFaultCodes() {
            return this.faultCodes;
        }

        public ArrayList getErrors() {
            return this.errors;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            if (this.errors != null) {
                ArrayList arrayList = new ArrayList(this.errors);
                objectOutputStream.writeInt(arrayList.size());
                for (Throwable throwable : arrayList) {
                    try {
                        objectOutputStream.writeObject(throwable);
                    }
                    catch (Exception exception) {
                        if (verbose) {
                            Verbose.say("Error encountered writing SAF endpoint error to persistent storage. A serializable copy will be stored instead");
                            Verbose.logException(exception);
                        }
                        Exception exception2 = new Exception(throwable.toString());
                        objectOutputStream.writeObject(exception2);
                    }
                }
            }
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            int n = objectInputStream.readInt();
            this.errors = new ArrayList();
            for (int i = 0; i < n; ++i) {
                Throwable throwable = (Throwable)objectInputStream.readObject();
                this.errors.add(throwable);
            }
        }
    }

    private class ServerStateChangeListener
    implements PropertyChangeListener {
        boolean _serverUp;

        public ServerStateChangeListener() {
            this.interpretState(_runtimeAccess.getServerRuntime().getState());
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("State".equals(propertyChangeEvent.getPropertyName())) {
                this.interpretState((String)propertyChangeEvent.getNewValue());
            }
        }

        private void interpretState(String string) {
            if ("RUNNING".equals(string)) {
                this.setServerUp();
            } else {
                this.setServerDown();
            }
        }

        private void setServerDown() {
            this._serverUp = false;
        }

        private void setServerUp() {
            if (!this._serverUp) {
                this._serverUp = true;
                WsrmEndpointManager.this.handleServerUp();
            }
            this._serverUp = true;
        }

        public boolean isServerUp() {
            return this._serverUp;
        }
    }
}

