/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability;

import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import weblogic.wsee.addressing.AddressingProvider;
import weblogic.wsee.addressing.AddressingProviderFactory;
import weblogic.wsee.addressing.EndpointReference;
import weblogic.wsee.message.MsgHeader;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.message.soap.SoapMessageContext;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability.WsrmUtils;
import weblogic.wsee.reliability.faults.SequenceFaultException;
import weblogic.wsee.reliability.faults.SequenceFaultMsg;
import weblogic.wsee.reliability.faults.WsrmFaultMsg;
import weblogic.wsee.util.Verbose;

public class WsrmHelper {
    private static final boolean verbose = Verbose.isVerbose(WsrmHelper.class);

    public static void sendFault(SOAPMessageContext sOAPMessageContext, WsrmFaultMsg wsrmFaultMsg) {
        WsrmHelper.sendFault(sOAPMessageContext, wsrmFaultMsg, null);
    }

    public static void sendFault(SOAPMessageContext sOAPMessageContext, WsrmFaultMsg wsrmFaultMsg, EndpointReference endpointReference) {
        try {
            Object object;
            ((WlMessageContext)sOAPMessageContext).setFault(new SequenceFaultException(wsrmFaultMsg.getSubCodeLocalName().toString()));
            SOAPMessage sOAPMessage = WsrmHelper.getMessageFactory(sOAPMessageContext).createMessage();
            sOAPMessageContext.setMessage(sOAPMessage);
            AddressingProvider addressingProvider = AddressingProviderFactory.getInstance().getAddressingProvider((MessageContext)sOAPMessageContext);
            if (WsrmConstants.RMVersion.RM_11 == wsrmFaultMsg.getRmVersion()) {
                object = addressingProvider.createActionHeader(WsrmConstants.RMVersion.RM_11.getNamespaceUri() + "/fault");
                ((WlMessageContext)sOAPMessageContext).getHeaders().addHeader((MsgHeader)object);
            }
            if (wsrmFaultMsg instanceof SequenceFaultMsg && (object = ((SequenceFaultMsg)wsrmFaultMsg).getSequenceId()) != null && !((String)object).equals("New")) {
                if (sOAPMessageContext.getProperty("weblogic.wsee.faultto.override") == null) {
                    if (endpointReference == null) {
                        endpointReference = (EndpointReference)sOAPMessageContext.getProperty("weblogic.wsee.addressing.ReplyTo");
                    }
                    sOAPMessageContext.setProperty("weblogic.wsee.faultto.override", (Object)endpointReference);
                }
                sOAPMessageContext.setProperty("weblogic.wsee.reliability.asyncfault", (Object)"true");
            }
            wsrmFaultMsg.write(sOAPMessage);
            if (verbose) {
                WsrmUtils.printSoapMsg(sOAPMessage);
            }
        }
        catch (SOAPException sOAPException) {
            if (verbose) {
                Verbose.logException(sOAPException);
            }
            throw new JAXRPCException((Throwable)sOAPException);
        }
        catch (SequenceFaultException sequenceFaultException) {
            if (verbose) {
                Verbose.logException(sequenceFaultException);
            }
            throw new JAXRPCException("Failed to write Sequence Fault message", (Throwable)sequenceFaultException);
        }
    }

    private static MessageFactory getMessageFactory(SOAPMessageContext sOAPMessageContext) {
        return ((SoapMessageContext)sOAPMessageContext).getMessageFactory();
    }
}

