/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.wsee.policy.deployment.ProviderRegistry;
import weblogic.wsee.policy.framework.ExternalizationUtils;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.util.Verbose;

public class WsrmPayloadContext
implements Externalizable {
    private static final boolean verbose = Verbose.isVerbose(WsrmPayloadContext.class);
    private NormalizedExpression requestPolicy;
    private NormalizedExpression responsePolicy;
    private String conversationKey = null;
    private boolean waitForConversationId = false;
    private boolean startConversation = false;
    private boolean emptyLastMessage = false;
    private int retryCount = -1;
    private long retryDelay = -1L;

    public WsrmPayloadContext() {
        this.initExternalization();
    }

    public boolean isEmptyLastMessage() {
        return this.emptyLastMessage;
    }

    public void setEmptyLastMessage(boolean bl) {
        this.emptyLastMessage = bl;
    }

    public void setWaitForConversationId(boolean bl) {
        this.waitForConversationId = bl;
    }

    public boolean getWaitForConversationId() {
        return this.waitForConversationId;
    }

    public void setConversationKey(String string) {
        this.conversationKey = string;
    }

    public String getConversationKey() {
        return this.conversationKey;
    }

    public void setStartConversation(boolean bl) {
        this.startConversation = bl;
    }

    public boolean getStartConversation() {
        return this.startConversation;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        String string = objectInput.readUTF();
        if (!"9.2".equals(string)) {
            throw new IOException("Wrong version, expected: 9.2 actual: " + string);
        }
        this.requestPolicy = ExternalizationUtils.readNormalizedExpression(objectInput);
        this.responsePolicy = ExternalizationUtils.readNormalizedExpression(objectInput);
        this.waitForConversationId = objectInput.readBoolean();
        this.startConversation = objectInput.readBoolean();
        int n = objectInput.readInt();
        this.conversationKey = n > 0 ? objectInput.readUTF() : null;
        this.retryCount = objectInput.readInt();
        this.retryDelay = objectInput.readLong();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeUTF("9.2");
        ExternalizationUtils.writeNormalizedExpression(this.requestPolicy, objectOutput);
        ExternalizationUtils.writeNormalizedExpression(this.responsePolicy, objectOutput);
        objectOutput.writeBoolean(this.waitForConversationId);
        objectOutput.writeBoolean(this.startConversation);
        if (this.conversationKey != null) {
            objectOutput.writeInt(1);
            objectOutput.writeUTF(this.conversationKey);
        } else {
            objectOutput.writeInt(0);
        }
        objectOutput.writeInt(this.retryCount);
        objectOutput.writeLong(this.retryDelay);
    }

    public NormalizedExpression getResponsePolicy() {
        return this.responsePolicy;
    }

    public void setResponsePolicy(NormalizedExpression normalizedExpression) {
        this.responsePolicy = normalizedExpression;
    }

    public NormalizedExpression getRequestPolicy() {
        return this.requestPolicy;
    }

    public void setRequestPolicy(NormalizedExpression normalizedExpression) {
        this.requestPolicy = normalizedExpression;
    }

    private void initExternalization() {
        try {
            ProviderRegistry.getTheRegistry();
        }
        catch (PolicyException policyException) {
            throw new AssertionError((Object)policyException);
        }
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int n) {
        this.retryCount = n;
    }

    public long getRetryDelay() {
        return this.retryDelay;
    }

    public void setRetryDelay(long l) {
        this.retryDelay = l;
    }
}

