/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.Duration;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import weblogic.messaging.saf.SAFConversationInfo;
import weblogic.messaging.saf.SAFException;
import weblogic.wsee.addressing.ActionHeader;
import weblogic.wsee.addressing.AddressingProvider;
import weblogic.wsee.addressing.AddressingProviderFactory;
import weblogic.wsee.addressing.EndpointReference;
import weblogic.wsee.message.MsgHeader;
import weblogic.wsee.message.MsgHeaders;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.message.soap.SoapMessageContext;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability.WsrmSAFManager;
import weblogic.wsee.reliability.WsrmSAFManagerFactory;
import weblogic.wsee.reliability.WsrmSequenceContext;
import weblogic.wsee.reliability.WsrmSequenceSender;
import weblogic.wsee.reliability.faults.IllegalRMVersionFaultException;
import weblogic.wsee.reliability.headers.WsrmHeader;
import weblogic.wsee.reliability.policy.ReliabilityPolicyAssertionsFactory;
import weblogic.wsee.util.FaultUtil;
import weblogic.wsee.util.Guid;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.util.WLMessageFactory;

public class WsrmProtocolUtils {
    private static final boolean verbose = Verbose.isVerbose(WsrmProtocolUtils.class);

    public static boolean isSequenceInitialized(Map map) {
        return WsrmProtocolUtils.isSequenceInitialized(map, false);
    }

    public static boolean isSequenceInitialized(Map map, boolean bl) {
        String string = WsrmProtocolUtils.getSequenceIdFromInvokeProperties(map);
        SAFConversationInfo sAFConversationInfo = WsrmSAFManager.getConversationInfo(true, string, bl);
        if (sAFConversationInfo == null) {
            return false;
        }
        if (sAFConversationInfo.isDynamic()) {
            return sAFConversationInfo.getDynamicConversationName() != null;
        }
        return true;
    }

    private static String getSequenceIdFromInvokeProperties(Map map) {
        if (map == null) {
            throw new JAXRPCException("Null invoke properties found.");
        }
        String string = (String)map.get("weblogic.wsee.sequenceid");
        if (string == null || string.equals("PendingSeqId")) {
            throw new JAXRPCException("No reliable sequence ID found in invoke properties.");
        }
        return string;
    }

    private static SAFConversationInfo getConversationInfo(String string) {
        return WsrmSAFManager.getConversationInfo(true, string, false);
    }

    public static String waitForSequenceInitialization(Map map, long l, long l2) {
        if (WsrmProtocolUtils.isSequenceInitialized(map, true)) {
            return WsrmProtocolUtils.getSequenceId(map);
        }
        int n = 0;
        while ((long)n < l2) {
            try {
                if (verbose) {
                    Verbose.say("# Waiting for sequence initialization (" + (n + 1) + " of " + l2 + ")...");
                }
                Thread.sleep(l);
                if (WsrmProtocolUtils.isSequenceInitialized(map, true)) {
                    if (verbose) {
                        Verbose.say("# Sequence initialized: " + WsrmProtocolUtils.getSequenceId(map));
                    }
                    return WsrmProtocolUtils.getSequenceId(map);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++n;
        }
        return null;
    }

    public static void sendEmptyLastMessage(Map map, String string) {
        EndpointReference endpointReference = new EndpointReference(string);
        WsrmProtocolUtils.sendEmptyLastMessage(map, endpointReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendEmptyLastMessage(Map map, EndpointReference endpointReference) {
        SOAPMessage sOAPMessage;
        boolean bl;
        WsrmSequenceContext wsrmSequenceContext;
        Object object2;
        String string = WsrmProtocolUtils.getSequenceIdFromInvokeProperties(map);
        try {
            object2 = WsrmProtocolUtils.getConversationInfo(string);
            wsrmSequenceContext = (WsrmSequenceContext)object2.getContext();
            bl = wsrmSequenceContext.isSoap12();
        }
        catch (JAXRPCException jAXRPCException) {
            throw jAXRPCException;
        }
        catch (Exception exception) {
            throw new JAXRPCException((Throwable)exception);
        }
        object2 = new SoapMessageContext(bl);
        wsrmSequenceContext = WLMessageFactory.getInstance().getMessageFactory(((SoapMessageContext)object2).isSoap12());
        try {
            sOAPMessage = wsrmSequenceContext.createMessage();
        }
        catch (SOAPException sOAPException) {
            throw new JAXRPCException((Throwable)sOAPException);
        }
        ((SoapMessageContext)object2).setMessage(sOAPMessage);
        Object object3 = map;
        synchronized (object3) {
            for (Map.Entry object4 : map.entrySet()) {
                assert (object4.getKey() instanceof String);
                ((WlMessageContext)object2).setProperty((String)object4.getKey(), object4.getValue());
            }
        }
        object3 = WsrmProtocolUtils.getConversationInfo(string);
        WsrmSequenceContext wsrmSequenceContext2 = (WsrmSequenceContext)object3.getContext();
        if (wsrmSequenceContext2.getRmVersion() != WsrmConstants.RMVersion.RM_10) {
            throw new IllegalStateException("Cannot send empty last message on sequence that isn't using WS-RM version 1.0");
        }
        MsgHeaders msgHeaders = ((WlMessageContext)object2).getHeaders();
        Iterator iterator = endpointReference.getReferenceProperties().listHeaders();
        while (iterator.hasNext()) {
            msgHeaders.addHeader((MsgHeader)iterator.next());
        }
        iterator = endpointReference.getReferenceParameters().listHeaders();
        while (iterator.hasNext()) {
            msgHeaders.addHeader((MsgHeader)iterator.next());
        }
        ((WlMessageContext)object2).setProperty("weblogic.wsee.lastmessage", "true");
        AddressingProvider addressingProvider = AddressingProviderFactory.getInstance().getAddressingProvider((MessageContext)object2);
        ((WlMessageContext)object2).getHeaders().addHeader(addressingProvider.createToHeader(endpointReference.getAddress()));
        ((WlMessageContext)object2).getHeaders().addHeader(addressingProvider.createActionHeader(WsrmConstants.Action.LAST_MESSAGE.getActionURI(wsrmSequenceContext2.getRmVersion())));
        ((WlMessageContext)object2).getHeaders().addHeader(addressingProvider.createMessageIdHeader(Guid.generateGuid()));
        WsrmSAFManagerFactory.getWsrmSAFSendingManager().storeAndForward((WlMessageContext)object2);
        if (((SoapMessageContext)object2).hasFault()) {
            if (((WlMessageContext)object2).getFault() != null) {
                Throwable sOAPMessage2 = ((WlMessageContext)object2).getFault();
                if (sOAPMessage2 instanceof RuntimeException) {
                    throw (RuntimeException)sOAPMessage2;
                }
                throw new RuntimeException(sOAPMessage2.toString(), sOAPMessage2);
            }
            SOAPMessage sOAPMessage2 = ((SoapMessageContext)object2).getMessage();
            try {
                if (sOAPMessage2 != null && (sOAPException = sOAPMessage2.getSOAPBody()) != null && sOAPException.hasFault()) {
                    String string2 = sOAPException.getFault().getFaultCode();
                    String string3 = sOAPException.getFault().getFaultString();
                    FaultUtil.throwSOAPFaultException(string2, string3, new Exception(string3));
                }
            }
            catch (SOAPException sOAPException) {
                throw new JAXRPCException("Failed to call hasFault", (Throwable)sOAPException);
            }
        }
    }

    public static void closeSequence(Map map) {
        String string = WsrmProtocolUtils.getSequenceIdFromInvokeProperties(map);
        try {
            WsrmSequenceSender.closeSequence(string);
        }
        catch (JAXRPCException jAXRPCException) {
            throw jAXRPCException;
        }
        catch (Throwable throwable) {
            throw new JAXRPCException(throwable);
        }
    }

    public static void terminateSequence(Map map) {
        String string = WsrmProtocolUtils.getSequenceIdFromInvokeProperties(map);
        try {
            SAFConversationInfo sAFConversationInfo = WsrmProtocolUtils.getConversationInfo(string);
            WsrmSequenceSender.terminateSequence(sAFConversationInfo, false);
        }
        catch (JAXRPCException jAXRPCException) {
            throw jAXRPCException;
        }
        catch (SAFException sAFException) {
            throw new JAXRPCException((Throwable)sAFException);
        }
        catch (Throwable throwable) {
            throw new JAXRPCException(throwable);
        }
    }

    public static void reset(Map map) {
        if (map != null && map.containsKey("weblogic.wsee.sequenceid")) {
            map.remove("weblogic.wsee.sequenceid");
        }
    }

    public static String getSequenceId(Map map) {
        String string = WsrmProtocolUtils.getSequenceIdFromInvokeProperties(map);
        try {
            SAFConversationInfo sAFConversationInfo = WsrmProtocolUtils.getConversationInfo(string);
            if (sAFConversationInfo.isDynamic()) {
                return sAFConversationInfo.getDynamicConversationName();
            }
            return sAFConversationInfo.getConversationName();
        }
        catch (JAXRPCException jAXRPCException) {
            throw jAXRPCException;
        }
        catch (Throwable throwable) {
            throw new JAXRPCException(throwable);
        }
    }

    public static void setExpires(Map map, Duration duration) {
        if (map == null) {
            throw new JAXRPCException("Properties param is null");
        }
        map.put("weblogic.wsee.wsrm.sequence.expiration", duration);
    }

    public static Duration getExpires(Map map) {
        if (map == null) {
            throw new JAXRPCException("Properties param is null");
        }
        return (Duration)map.get("weblogic.wsee.wsrm.sequence.expiration");
    }

    public static void setOfferExpires(Map map, Duration duration) {
        if (map == null) {
            throw new JAXRPCException("Properties param is null");
        }
        map.put("weblogic.wsee.wsrm.offer.sequence.expiration", duration);
    }

    public static Duration getOfferExpires(Map map) {
        if (map == null) {
            throw new JAXRPCException("Properties param is null");
        }
        return (Duration)map.get("weblogic.wsee.wsrm.offer.sequence.expiration");
    }

    public static void setAnonymousAck(Map map) {
        if (map == null) {
            throw new JAXRPCException("Properties param is null");
        }
        map.put("weblogic.wsee.ackstoanon", "true");
    }

    public static boolean isAnonymousAck(Map map) {
        if (map == null) {
            throw new JAXRPCException("Properties param is null");
        }
        return map.get("weblogic.wsee.ackstoanon") != null;
    }

    public static void setLastMessage(Map map) {
        if (map == null) {
            throw new JAXRPCException("Properties param is null");
        }
        map.put("weblogic.wsee.lastmessage", "true");
    }

    public static void setFinalMessage(Map map) {
        if (map == null) {
            throw new JAXRPCException("properties param is null");
        }
        map.put("weblogic.wsee.lastmessage", "true");
    }

    public static boolean isLastMessage(Map map) {
        if (map == null) {
            throw new JAXRPCException("Properties param is null");
        }
        return map.get("weblogic.wsee.lastmessage") != null;
    }

    public static boolean isFinalMessage(Map map) {
        if (map == null) {
            throw new JAXRPCException("Properties param is null");
        }
        return map.get("weblogic.wsee.lastmessage") != null;
    }

    public static void printSoapMsg(SOAPMessage sOAPMessage) {
        Verbose.getOut().println("\n-------------------------------\n");
        try {
            sOAPMessage.writeTo((OutputStream)Verbose.getOut());
        }
        catch (IOException iOException) {
            Verbose.logException(iOException);
        }
        catch (SOAPException sOAPException) {
            Verbose.logException(sOAPException);
        }
        Verbose.getOut().println("\n\n-------------------------------\n\n");
    }

    public static WsrmConstants.RMVersion getActionVersion(WsrmConstants.Action action, String string) {
        for (WsrmConstants.RMVersion rMVersion : WsrmConstants.RMVersion.values()) {
            String string2 = action.getActionURI(rMVersion);
            if (!string2.equals(string)) continue;
            return rMVersion;
        }
        return null;
    }

    public static void checkRMVersion(String string, WsrmConstants.RMVersion rMVersion, NormalizedExpression normalizedExpression) throws IllegalRMVersionFaultException {
        List<WsrmConstants.RMVersion> list = ReliabilityPolicyAssertionsFactory.getRMPolicyVersions(normalizedExpression);
        if (!list.contains((Object)rMVersion)) {
            throw new IllegalRMVersionFaultException(string, rMVersion, list);
        }
    }

    public static WsrmConstants.SOAPVersion getSOAPVersionFromName(Name name) {
        for (WsrmConstants.SOAPVersion sOAPVersion : WsrmConstants.SOAPVersion.values()) {
            if (!sOAPVersion.getNamespaceUri().equals(name.getURI())) continue;
            return sOAPVersion;
        }
        return WsrmConstants.SOAPVersion.SOAP_11;
    }

    public static WsrmConstants.FaultCode getSOAPFaultCodeFromName(Name name) {
        WsrmConstants.SOAPVersion sOAPVersion = WsrmProtocolUtils.getSOAPVersionFromName(name);
        for (WsrmConstants.FaultCode faultCode : WsrmConstants.FaultCode.values()) {
            if (!faultCode.getCodeLocalName(sOAPVersion).equals(name.getLocalName())) continue;
            return faultCode;
        }
        return null;
    }

    public static WsrmConstants.SOAPVersion getSOAPVersionFromNamespaceUri(String string) {
        for (WsrmConstants.SOAPVersion sOAPVersion : WsrmConstants.SOAPVersion.values()) {
            if (!sOAPVersion.getNamespaceUri().equals(string)) continue;
            return sOAPVersion;
        }
        return WsrmConstants.SOAPVersion.SOAP_11;
    }

    public static WsrmConstants.RMVersion getRMVersionFromMessageContext(SOAPMessageContext sOAPMessageContext) {
        WsrmConstants.Action[] actionArray;
        WsrmConstants.RMVersion rMVersion = null;
        MsgHeaders msgHeaders = ((SoapMessageContext)sOAPMessageContext).getHeaders();
        ActionHeader actionHeader = null;
        Iterator iterator = msgHeaders.listHeaders();
        while (iterator.hasNext()) {
            actionArray = (WsrmConstants.Action[])iterator.next();
            if (actionArray instanceof ActionHeader) {
                actionHeader = (ActionHeader)actionArray;
            }
            if (!(actionArray instanceof WsrmHeader)) continue;
            rMVersion = ((WsrmHeader)actionArray).getRmVersion();
            break;
        }
        if (rMVersion == null && actionHeader != null) {
            WsrmConstants.Action action;
            actionArray = WsrmConstants.Action.values();
            int n = actionArray.length;
            for (int i = 0; i < n && (rMVersion = WsrmProtocolUtils.getActionVersion(action = actionArray[i], actionHeader.getActionURI())) == null; ++i) {
            }
        }
        if (rMVersion == null) {
            rMVersion = WsrmConstants.RMVersion.RM_10;
        }
        return rMVersion;
    }
}

