/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import weblogic.messaging.saf.SAFConversationInfo;
import weblogic.messaging.saf.SAFException;
import weblogic.messaging.saf.SAFResult;
import weblogic.wsee.addressing.EndpointReference;
import weblogic.wsee.reliability.WsrmSequenceContext;
import weblogic.wsee.reliability.WsrmSequenceSender;
import weblogic.wsee.reliability.faults.InvalidAckFaultMsg;
import weblogic.wsee.reliability.faults.SequenceFaultMsg;
import weblogic.wsee.reliability.faults.SequenceFaultMsgFactory;
import weblogic.wsee.util.Verbose;

public class WsrmReceivingSide {
    private static final boolean verbose = Verbose.isVerbose(WsrmReceivingSide.class);

    public static void sendResult(SAFResult sAFResult) {
        if (sAFResult.isSuccessful()) {
            WsrmReceivingSide.acknowledge(sAFResult);
        } else {
            WsrmReceivingSide.fault(sAFResult);
        }
    }

    private static void fault(SAFResult sAFResult) {
        block13: {
            int n;
            SAFConversationInfo sAFConversationInfo = sAFResult.getConversationInfo();
            assert (sAFConversationInfo != null);
            WsrmSequenceContext wsrmSequenceContext = (WsrmSequenceContext)sAFConversationInfo.getContext();
            assert (wsrmSequenceContext != null);
            EndpointReference endpointReference = wsrmSequenceContext.getAcksTo();
            assert (endpointReference != null);
            SequenceFaultMsgFactory sequenceFaultMsgFactory = SequenceFaultMsgFactory.getInstance();
            QName qName = sequenceFaultMsgFactory.getSAFResultCodeMapping(n = sAFResult.getResultCode());
            if (qName == null) {
                block12: {
                    if (verbose) {
                        Verbose.log("Fault " + n + " -- '" + sAFResult.getDescription() + "' is not handled by WSRM, but will be sent back to RM Source anyway");
                        SAFException sAFException = sAFResult.getSAFException();
                        Verbose.logException(sAFException);
                        try {
                            WsrmSequenceSender.sendFault(sAFConversationInfo.getConversationName(), (WsrmSequenceContext)sAFConversationInfo.getContext(), endpointReference, sAFException, wsrmSequenceContext.isSoap12());
                        }
                        catch (SAFException sAFException2) {
                            if (!verbose) break block12;
                            Verbose.logException(sAFException2);
                        }
                    }
                }
                return;
            }
            SequenceFaultMsg sequenceFaultMsg = sequenceFaultMsgFactory.createSequenceFaultMsg(qName, wsrmSequenceContext.getRmVersion());
            List list = sAFResult.getSequenceNumbers();
            if (sequenceFaultMsg instanceof InvalidAckFaultMsg) {
                InvalidAckFaultMsg invalidAckFaultMsg = (InvalidAckFaultMsg)sequenceFaultMsg;
                invalidAckFaultMsg.setSequenceId(sAFConversationInfo.getConversationName());
                invalidAckFaultMsg.acknowledgeMessages((Long)list.get(0), (Long)list.get(1));
            } else if (sequenceFaultMsg != null) {
                sequenceFaultMsg.setSequenceId(sAFConversationInfo.getConversationName());
            }
            try {
                WsrmSequenceSender.sendFault(sAFConversationInfo.getConversationName(), (WsrmSequenceContext)sAFConversationInfo.getContext(), endpointReference, sequenceFaultMsg, wsrmSequenceContext.isSoap12());
            }
            catch (SAFException sAFException) {
                if (!verbose) break block13;
                Verbose.logException(sAFException);
            }
        }
    }

    private static void acknowledge(SAFResult sAFResult) {
        block4: {
            SAFConversationInfo sAFConversationInfo = sAFResult.getConversationInfo();
            assert (sAFConversationInfo != null);
            WsrmSequenceContext wsrmSequenceContext = (WsrmSequenceContext)sAFConversationInfo.getContext();
            assert (wsrmSequenceContext != null);
            EndpointReference endpointReference = wsrmSequenceContext.getAcksTo();
            List list = sAFResult.getSequenceNumbers();
            ArrayList<Long> arrayList = new ArrayList<Long>(list);
            try {
                WsrmSequenceSender.acknowledge(sAFConversationInfo, arrayList, endpointReference, wsrmSequenceContext, wsrmSequenceContext.isSoap12());
            }
            catch (SAFException sAFException) {
                if (!verbose) break block4;
                Verbose.logException(sAFException);
            }
        }
    }
}

