/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability;

import java.io.Externalizable;
import java.io.OutputStream;
import javax.xml.rpc.JAXRPCException;
import weblogic.messaging.saf.SAFConversationInfo;
import weblogic.messaging.saf.SAFEndpoint;
import weblogic.messaging.saf.SAFException;
import weblogic.messaging.saf.SAFRequest;
import weblogic.messaging.saf.internal.SAFManagerImpl;
import weblogic.store.PersistentStoreException;
import weblogic.wsee.async.AsyncInvokeState;
import weblogic.wsee.async.AsyncInvokeStateObjectHandler;
import weblogic.wsee.async.SOAPInvokeState;
import weblogic.wsee.buffer.BufferManager;
import weblogic.wsee.reliability.WsrmPayloadContext;
import weblogic.wsee.reliability.WsrmSequenceContext;
import weblogic.wsee.server.WsStorage;
import weblogic.wsee.server.WsStorageFactory;
import weblogic.wsee.util.Verbose;

public final class WsrmSAFEndpoint
implements SAFEndpoint {
    private final String targetURI;
    private static final boolean verbose = Verbose.isVerbose(WsrmSAFEndpoint.class);
    private static final boolean soapMessageVerbose = Verbose.isVerbose(WsrmSAFEndpoint.class.getName() + "Message");
    private static final int DEFAULT_RETRY_COUNT = 3;
    private static final long DEFAULT_RETRY_DELAY = 5L;

    public WsrmSAFEndpoint(String string) {
        if (verbose) {
            Verbose.log("Created WsrmSAFEndpoint for targetURI: " + string);
        }
        this.targetURI = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deliver(SAFConversationInfo sAFConversationInfo, SAFRequest sAFRequest) throws SAFException {
        block35: {
            try {
                Object object;
                Object object2;
                Object object3;
                String string;
                long l;
                long l2;
                Externalizable externalizable;
                WsrmPayloadContext wsrmPayloadContext;
                if (verbose) {
                    Verbose.log("[WsrmSAFEndpoint.deliver()] sequence id " + sAFConversationInfo.getConversationName() + ": " + sAFRequest.getSequenceNumber());
                }
                if ((wsrmPayloadContext = (WsrmPayloadContext)sAFRequest.getPayloadContext()).isEmptyLastMessage() && verbose) {
                    Verbose.log("Empty last message on sequence id " + sAFConversationInfo.getConversationName());
                }
                if (!((externalizable = sAFRequest.getPayload()) instanceof SOAPInvokeState)) break block35;
                SOAPInvokeState sOAPInvokeState = (SOAPInvokeState)externalizable;
                String string2 = (String)sOAPInvokeState.getMessageContextProperties().get("weblogic.wsee.addressing.MessageId");
                int n = wsrmPayloadContext.getRetryCount();
                if (n < 0) {
                    n = 3;
                }
                if ((l2 = wsrmPayloadContext.getRetryDelay()) < 0L) {
                    l2 = 5L;
                }
                if (soapMessageVerbose) {
                    try {
                        Verbose.log("WsrmSAFEndpoint delivers:");
                        Verbose.getOut().println("\n-------------------------------\n");
                        sOAPInvokeState.getSOAPMessage().writeTo((OutputStream)Verbose.getOut());
                        Verbose.log("Retry count: " + n + " Retry delay: " + l2);
                        Verbose.getOut().println("\n-------------------------------\n");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (verbose) {
                    Verbose.log("Conversation name is " + sAFConversationInfo.getConversationName() + " targetURI=" + this.targetURI + " retryCount=" + n + " retryDelay=" + l2);
                }
                String string3 = null;
                if (verbose) {
                    string3 = "Unknown";
                    if (sOAPInvokeState.getMessageContextProperties().containsKey("weblogic.wsee.addressing.Action")) {
                        string3 = (String)sOAPInvokeState.getMessageContextProperties().get("weblogic.wsee.addressing.Action");
                    }
                }
                long l3 = l = (string = (String)sOAPInvokeState.getMessageContextProperties().get("weblogic.wsee.reliability.RequestMessageSeqNumber")) != null ? Long.parseLong(string) : -1L;
                if (string != null && (object3 = sAFConversationInfo.getConversationOffer()) != null) {
                    object2 = object3.getConversationName();
                    object = (WsrmSequenceContext)object3.getContext();
                    if (((WsrmSequenceContext)object).hasRequestSeqNumBeenMappedToResponseSeqNum(l)) {
                        if (verbose) {
                            Verbose.say("*** Already had mapping of requestSeqNum " + l + " action (" + string3 + ") on request sequence " + sAFConversationInfo.getConversationName() + " to response seq num on offer sequence " + (String)object2 + ". This indicates a duplicate message in the endpoint. Leaving the existing mapping in place.");
                        }
                    } else {
                        if (verbose) {
                            Verbose.say("*** Doing initial mapping of requestSeqNum " + l + " action (" + string3 + ") on request sequence " + sAFConversationInfo.getConversationName() + " to -2 on offer sequence " + (String)object2);
                        }
                        if (wsrmPayloadContext.isEmptyLastMessage()) {
                            ((WsrmSequenceContext)object).mapRequestSeqNumToResponseSeqNum(l, 0L);
                        } else {
                            ((WsrmSequenceContext)object).mapRequestSeqNumToResponseSeqNum(l, -2L);
                        }
                        SAFManagerImpl.getManager().storeConversationContextOnSendingSide((String)object2, (Externalizable)object);
                    }
                }
                if (sOAPInvokeState.getMessageContextProperties().containsKey("weblogic.wsee.addressing.RelatesTo")) {
                    object3 = (String)sOAPInvokeState.getMessageContextProperties().get("weblogic.wsee.addressing.RelatesTo");
                    if (verbose) {
                        Verbose.log("WsrmSAFEndpoint is processing async response msgId: " + string2 + " related to msgId: " + (String)object3 + " requestSeqNum " + l + " action (" + string3 + ") on request sequence " + sAFConversationInfo.getConversationName());
                    }
                    object2 = WsStorageFactory.getStorage("weblogic.wsee.async.store", new AsyncInvokeStateObjectHandler());
                    try {
                        object = (AsyncInvokeState)((WsStorage)object2).persistentGet(object3);
                        if (object == null) {
                            if (verbose) {
                                Verbose.log("Cannot find AsyncInvokeState for request message: " + (String)object3);
                            }
                            throw new JAXRPCException("Cannot retrieve request information for message " + (String)object3);
                        }
                    }
                    catch (PersistentStoreException persistentStoreException) {
                        if (verbose) {
                            Verbose.logException(persistentStoreException);
                        }
                        throw new JAXRPCException((Throwable)persistentStoreException);
                    }
                    Object object4 = object;
                    synchronized (object4) {
                        if (((AsyncInvokeState)object).getState() == AsyncInvokeState.STATE.NEW) {
                            ((AsyncInvokeState)object).setState(AsyncInvokeState.STATE.PENDING_RESPONSE);
                            if (verbose) {
                                Verbose.log("WsrmSAFEndpoint set 'pending reliable response' flag on AsyncInvokeState msgId: " + string2 + " related to msgId: " + (String)object3 + " requestSeqNum " + l + " action (" + string3 + ") on request sequence " + sAFConversationInfo.getConversationName());
                            }
                        } else if (verbose) {
                            Verbose.log("WsrmSAFEndpoint sees AsyncInvokeState is not 'new' for msgId: " + string2 + " related to msgId: " + (String)object3 + " requestSeqNum " + l + " action (" + string3 + ") on request sequence " + sAFConversationInfo.getConversationName() + ". We won't set any pending response flag here.");
                        }
                    }
                    ((WsStorage)object2).persistentPut(object3, object);
                }
                BufferManager.instance().bufferMessageUOO(this.targetURI, sOAPInvokeState, n, l2, sAFConversationInfo.getConversationName(), sAFRequest.getSequenceNumber());
                if (verbose) {
                    Verbose.log("WsrmSAFEndpoint done buffering msgId: " + string2 + " requestSeqNum " + l + " action (" + string3 + ") on request sequence " + sAFConversationInfo.getConversationName() + ". Will now proceed to ack this message back to the sender.");
                }
            }
            catch (Throwable throwable) {
                if (throwable instanceof SAFException) {
                    throw (SAFException)throwable;
                }
                throw new SAFException(throwable);
            }
        }
    }

    public String getTargetQueue() {
        return BufferManager.instance().getTargetQueue(this.targetURI).getQueueName();
    }

    public boolean isAvailable() {
        boolean bl = true;
        return bl;
    }
}

