/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability;

import java.net.Socket;
import java.security.AccessController;
import java.util.Date;
import java.util.Map;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.MessageFactory;
import weblogic.messaging.saf.SAFConversationInfo;
import weblogic.messaging.saf.SAFConversationNotAvailException;
import weblogic.messaging.saf.SAFException;
import weblogic.messaging.saf.SAFManager;
import weblogic.messaging.saf.SAFRequest;
import weblogic.messaging.saf.SAFServiceNotAvailException;
import weblogic.messaging.saf.common.SAFRequestImpl;
import weblogic.messaging.saf.internal.SAFManagerImpl;
import weblogic.protocol.LocalServerIdentity;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.servlet.internal.ServletRequestImpl;
import weblogic.wsee.addressing.ActionHeader;
import weblogic.wsee.async.AsyncUtil;
import weblogic.wsee.async.SOAPInvokeState;
import weblogic.wsee.cluster.ClusterUtil;
import weblogic.wsee.connection.transport.Transport;
import weblogic.wsee.connection.transport.servlet.HttpServerTransport;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.message.soap.SoapMessageContext;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.runtime.PolicyContext;
import weblogic.wsee.policy.runtime.PolicyServer;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability.WsrmHelper;
import weblogic.wsee.reliability.WsrmPayloadContext;
import weblogic.wsee.reliability.WsrmProtocolUtils;
import weblogic.wsee.reliability.WsrmSecurityContext;
import weblogic.wsee.reliability.WsrmSequenceContext;
import weblogic.wsee.reliability.faults.SequenceClosedFaultMsg;
import weblogic.wsee.reliability.faults.UnknownSequenceFaultMsg;
import weblogic.wsee.reliability.handshake.CloseSequenceResponseMsg;
import weblogic.wsee.reliability.handshake.TerminateSequenceResponseMsg;
import weblogic.wsee.reliability.headers.SequenceHeader;
import weblogic.wsee.reliability.headers.TestSequenceSSLHeader;
import weblogic.wsee.reliability.policy11.RM11Assertion;
import weblogic.wsee.server.ServerUtil;
import weblogic.wsee.util.Guid;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.wsdl.WsdlBindingOperation;
import weblogic.wsee.wsdl.WsdlOperation;
import weblogic.wsee.wsdl.WsdlPortType;
import weblogic.wsee.wsdl.WsdlService;

public class WsrmSAFManager {
    private static final boolean verbose = Verbose.isVerbose(WsrmSAFManager.class);
    protected static SAFManager safManager = null;

    WsrmSAFManager() {
        if (safManager == null) {
            safManager = SAFManagerImpl.getManager();
        }
    }

    protected SAFRequest createSAFRequest(SequenceHeader sequenceHeader, String string, SOAPMessageContext sOAPMessageContext, WsrmSequenceContext wsrmSequenceContext) {
        SAFRequestImpl sAFRequestImpl = new SAFRequestImpl();
        sAFRequestImpl.setConversationName(sequenceHeader.getSequenceId());
        sAFRequestImpl.setSequenceNumber(sequenceHeader.getMessageNumber());
        sAFRequestImpl.setDeliveryMode(2);
        sAFRequestImpl.setTimeToLive(0L);
        sAFRequestImpl.setTimestamp(System.currentTimeMillis());
        boolean bl = wsrmSequenceContext.getRmVersion() == WsrmConstants.RMVersion.RM_10 && sequenceHeader.isLastMessage() ? true : "true".equals(sOAPMessageContext.getProperty("weblogic.wsee.lastmessage"));
        if (bl && verbose) {
            Verbose.say("*** Setting 'End of Conversation' flag on request with message number " + sequenceHeader.getMessageNumber() + " and sequence " + sequenceHeader.getSequenceId());
        }
        sAFRequestImpl.setEndOfConversation(bl);
        if (string != null) {
            sAFRequestImpl.setMessageId(string);
        }
        this.setupSAFRequestPayload(sOAPMessageContext, sAFRequestImpl);
        this.setupSAFRequestPayloadContext(sequenceHeader, sOAPMessageContext, sAFRequestImpl, wsrmSequenceContext);
        return sAFRequestImpl;
    }

    private void setupSAFRequestPayload(SOAPMessageContext sOAPMessageContext, SAFRequest sAFRequest) {
        SOAPInvokeState sOAPInvokeState = this.createSOAPInvokeState(sOAPMessageContext);
        sAFRequest.setPayload(sOAPInvokeState);
        sAFRequest.setPayloadSize(sOAPInvokeState.getPayloadSize());
    }

    protected SOAPInvokeState createSOAPInvokeState(SOAPMessageContext sOAPMessageContext) {
        SOAPInvokeState sOAPInvokeState = new SOAPInvokeState(sOAPMessageContext, true);
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)sOAPMessageContext.getProperty("weblogic.wsee.wss.subject");
        if (authenticatedSubject != null && authenticatedSubject.getPrincipals().size() != 0) {
            sOAPInvokeState.setSubject(authenticatedSubject);
        } else {
            sOAPInvokeState.setSubject(ClusterUtil.getSubject((AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction())));
        }
        return sOAPInvokeState;
    }

    private void setupSAFRequestPayloadContext(SequenceHeader sequenceHeader, SOAPMessageContext sOAPMessageContext, SAFRequest sAFRequest, WsrmSequenceContext wsrmSequenceContext) {
        boolean bl;
        WsrmPayloadContext wsrmPayloadContext = new WsrmPayloadContext();
        boolean bl2 = bl = "true".equals(sOAPMessageContext.getProperty("weblogic.wsee.lastmessage")) || wsrmSequenceContext.getRmVersion() == WsrmConstants.RMVersion.RM_10 && sequenceHeader.isLastMessage();
        if (bl && WsrmConstants.Action.LAST_MESSAGE.getActionURI(wsrmSequenceContext.getRmVersion()).equals(((ActionHeader)((WlMessageContext)sOAPMessageContext).getHeaders().getHeader(ActionHeader.TYPE)).getActionURI())) {
            wsrmPayloadContext.setEmptyLastMessage(true);
        }
        try {
            if (wsrmPayloadContext.isEmptyLastMessage()) {
                WsrmSecurityContext wsrmSecurityContext = wsrmSequenceContext.getWsrmSecurityContext();
                assert (wsrmSecurityContext != null);
                wsrmPayloadContext.setRequestPolicy(wsrmSecurityContext.getSecurityPolicy());
                wsrmPayloadContext.setResponsePolicy(wsrmSecurityContext.getSecurityPolicy());
            } else {
                wsrmPayloadContext.setRequestPolicy(PolicyContext.getRequestEffectivePolicy((MessageContext)sOAPMessageContext));
                wsrmPayloadContext.setResponsePolicy(PolicyContext.getResponseEffectivePolicy((MessageContext)sOAPMessageContext));
            }
        }
        catch (PolicyException policyException) {
            throw new JAXRPCException(policyException.getMessage());
        }
        sAFRequest.setPayloadContext(wsrmPayloadContext);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setupSAFConversationMaxIdelTime(WlMessageContext wlMessageContext, SAFConversationInfo sAFConversationInfo) {
        String string = (String)wlMessageContext.getProperty("weblogic.wsee.wsrm.InactivityTimeout");
        if (string != null) {
            try {
                Duration duration = DatatypeFactory.newInstance().newDuration(string);
                long l = System.currentTimeMillis();
                long l2 = duration.getTimeInMillis(new Date(l));
                sAFConversationInfo.setMaximumIdleTime(l2);
                if (!verbose) return;
                Verbose.log("InactivityTimeout is " + duration + " msec");
                return;
            }
            catch (Exception exception) {
                throw new JAXRPCException(exception.toString(), (Throwable)exception);
            }
        } else {
            sAFConversationInfo.setMaximumIdleTime(0L);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setupSAFConversationTTL(Duration duration, SAFConversationInfo sAFConversationInfo) {
        if (duration != null) {
            long l = duration.getTimeInMillis(new Date());
            if (l <= 0L) throw new JAXRPCException("Invalid expiration time: " + duration.toString());
            if (verbose) {
                Verbose.log("Setting RM sequence timetolive to " + l);
            }
            sAFConversationInfo.setTimeToLive(l);
            return;
        } else {
            sAFConversationInfo.setTimeToLive(Long.MAX_VALUE);
        }
    }

    protected void setupSAFConversationQOS(WlMessageContext wlMessageContext, SAFConversationInfo sAFConversationInfo) {
        if (wlMessageContext.getProperty("weblogic.wsee.user.defined.qos") == null) {
            sAFConversationInfo.setQOS(1);
            sAFConversationInfo.setInorder(true);
        } else {
            Integer n = (Integer)wlMessageContext.getProperty("weblogic.wsee.qos.delivery");
            if (n == null) {
                sAFConversationInfo.setQOS(1);
            } else {
                sAFConversationInfo.setQOS(n);
            }
            String string = (String)wlMessageContext.getProperty("weblogic.wsee.qos.inorder");
            if (string == null) {
                sAFConversationInfo.setInorder(false);
            } else {
                sAFConversationInfo.setInorder(true);
            }
        }
        if (verbose) {
            Verbose.log("Setting QOS to " + sAFConversationInfo.getQOS());
            Verbose.log("Setting inorder to " + sAFConversationInfo.isInorder());
        }
    }

    protected boolean checkOfferNeeded(WlMessageContext wlMessageContext, WsrmConstants.RMVersion rMVersion) {
        WsdlService wsdlService = wlMessageContext.getDispatcher().getWsdlPort().getService();
        for (WsdlPortType wsdlPortType : wsdlService.getPortTypes()) {
            for (WsdlOperation wsdlOperation : wsdlPortType.getOperations().values()) {
                NormalizedExpression normalizedExpression;
                if (wsdlOperation.getOutput() == null) continue;
                if (rMVersion == WsrmConstants.RMVersion.RM_10) {
                    return true;
                }
                WsdlBindingOperation wsdlBindingOperation = wlMessageContext.getDispatcher().getWsdlPort().getBinding().getOperations().get(wsdlOperation.getName());
                PolicyServer policyServer = wlMessageContext.getDispatcher().getWsPort().getEndpoint().getService().getPolicyServer();
                Map map = policyServer.getCachedPolicies();
                if (wsdlBindingOperation == null || map == null || map.size() < 1) {
                    return true;
                }
                try {
                    normalizedExpression = PolicyContext.getResponseEffectivePolicy(wsdlOperation, wsdlBindingOperation, policyServer, map);
                }
                catch (Exception exception) {
                    throw new JAXRPCException(exception.toString(), (Throwable)exception);
                }
                RM11Assertion rM11Assertion = (RM11Assertion)normalizedExpression.getPolicyAssertion(RM11Assertion.class);
                if (rM11Assertion != null && rM11Assertion.isOptional()) continue;
                return true;
            }
        }
        return false;
    }

    protected void sendUnknownSequenceFault(String string, SOAPMessageContext sOAPMessageContext) {
        WsrmConstants.RMVersion rMVersion = WsrmProtocolUtils.getRMVersionFromMessageContext(sOAPMessageContext);
        UnknownSequenceFaultMsg unknownSequenceFaultMsg = new UnknownSequenceFaultMsg(rMVersion);
        unknownSequenceFaultMsg.setSequenceId(string);
        WsrmHelper.sendFault(sOAPMessageContext, unknownSequenceFaultMsg, null);
    }

    protected String getAsyncAddress(String string, boolean bl) {
        int n = string.indexOf(58);
        String string2 = n < 0 ? "http" : string.substring(0, n);
        return ServerUtil.getServerURL(string2) + AsyncUtil.getAsyncUri(bl, string2);
    }

    protected String generateSequenceId() {
        String string = Guid.generateGuid();
        String string2 = LocalServerIdentity.getIdentity().getServerName();
        return "uuid:" + string2 + ":" + string.substring(5, string.length());
    }

    protected static MessageFactory getMessageFactory(SOAPMessageContext sOAPMessageContext) {
        return ((SoapMessageContext)sOAPMessageContext).getMessageFactory();
    }

    protected Duration getSequenceExpirationFromContext(WlMessageContext wlMessageContext) {
        String string = (String)wlMessageContext.getProperty("weblogic.wsee.wsrm.SequenceExpiration");
        Duration duration = null;
        if (string != null && !string.equals("P0S")) {
            try {
                duration = DatatypeFactory.newInstance().newDuration(string);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.toString(), exception);
            }
        }
        return duration;
    }

    protected void handleCloseSequenceResponse(boolean bl, CloseSequenceResponseMsg closeSequenceResponseMsg) {
        String string = closeSequenceResponseMsg.getSequenceId();
        SAFConversationInfo sAFConversationInfo = this.getConversationInfo(bl, string);
        WsrmSequenceContext wsrmSequenceContext = (WsrmSequenceContext)sAFConversationInfo.getContext();
        wsrmSequenceContext.setClosed(true);
        try {
            if (bl) {
                SAFManagerImpl.getManager().storeConversationContextOnSendingSide(string, wsrmSequenceContext);
            } else {
                SAFManagerImpl.getManager().storeConversationContextOnReceivingSide(string, wsrmSequenceContext);
            }
        }
        catch (SAFException sAFException) {
            throw new JAXRPCException(sAFException.toString(), (Throwable)sAFException);
        }
    }

    protected void handleTerminateSequenceResponse(boolean bl, TerminateSequenceResponseMsg terminateSequenceResponseMsg) {
    }

    protected SAFConversationInfo getConversationInfo(boolean bl, String string) {
        return WsrmSAFManager.getConversationInfo(bl, string, true);
    }

    public static SAFConversationInfo getConversationInfo(boolean bl, String string, boolean bl2) {
        SAFConversationInfo sAFConversationInfo;
        try {
            sAFConversationInfo = bl ? safManager.getConversationInfoOnSendingSide(string) : safManager.getConversationInfoOnReceivingSide(string);
            if (sAFConversationInfo == null && !bl2) {
                throw new JAXRPCException("Unable to retrieve reliable sequence information on the " + (bl ? "sending" : "receiving") + " side for sequence: " + string);
            }
        }
        catch (SAFServiceNotAvailException sAFServiceNotAvailException) {
            throw new JAXRPCException(sAFServiceNotAvailException.toString(), (Throwable)sAFServiceNotAvailException);
        }
        catch (Throwable throwable) {
            if (verbose) {
                Verbose.logException(throwable);
            }
            if (bl2) {
                return null;
            }
            if (throwable instanceof SAFConversationNotAvailException) {
                throw new JAXRPCException("Unknown conversation: " + string);
            }
            throw new JAXRPCException("Unable to retrieve reliable sequence information on the " + (bl ? "sending" : "receiving") + " side for sequence: " + string, throwable);
        }
        return sAFConversationInfo;
    }

    protected boolean checkForSequenceClosed(SOAPMessageContext sOAPMessageContext, String string, WsrmSequenceContext wsrmSequenceContext) {
        if (wsrmSequenceContext.isClosed()) {
            try {
                SequenceClosedFaultMsg sequenceClosedFaultMsg = new SequenceClosedFaultMsg(wsrmSequenceContext.getRmVersion());
                sequenceClosedFaultMsg.setSequenceId(string);
                WsrmHelper.sendFault(sOAPMessageContext, sequenceClosedFaultMsg, wsrmSequenceContext.getAcksTo());
            }
            catch (JAXRPCException jAXRPCException) {
                throw jAXRPCException;
            }
            catch (Exception exception) {
                throw new JAXRPCException(exception.toString(), (Throwable)exception);
            }
            return true;
        }
        return false;
    }

    public static void setSSLSessionIdFromContext(WlMessageContext wlMessageContext, WsrmSecurityContext wsrmSecurityContext, boolean bl) {
        boolean bl2;
        byte[] byArray = WsrmSAFManager.getForcedSSLSessionId(wlMessageContext);
        boolean bl3 = bl2 = byArray != null;
        if (byArray == null) {
            byArray = WsrmSAFManager.getSSLSessionId(wlMessageContext);
        }
        if (verbose) {
            Verbose.say("%%%%%%%%%%%%%%%%% SETTING " + (bl2 ? "*Forced*" : "Real") + " SSL/TLS Session ID for " + (bl ? "offer" : "regular") + " sequence %%%%%%%%%%%%%%");
            Verbose.say("    SessionID: " + WsrmSAFManager.dumpByteArray(byArray));
            Verbose.say("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        }
        wsrmSecurityContext.setSSLSessionId(byArray);
        wsrmSecurityContext.setForcedSSLSessionId(bl2);
    }

    public static byte[] getForcedSSLSessionId(WlMessageContext wlMessageContext) {
        TestSequenceSSLHeader testSequenceSSLHeader = (TestSequenceSSLHeader)wlMessageContext.getHeaders().getHeader(TestSequenceSSLHeader.TYPE);
        if (testSequenceSSLHeader != null) {
            try {
                byte[] byArray = testSequenceSSLHeader.getSSLSessionId().getBytes("UTF-8");
                return byArray;
            }
            catch (Exception exception) {
                throw new JAXRPCException(exception.toString(), (Throwable)exception);
            }
        }
        return null;
    }

    public static byte[] getSSLSessionId(WlMessageContext wlMessageContext) {
        Transport transport = wlMessageContext.getDispatcher().getConnection().getTransport();
        if (!(transport instanceof HttpServerTransport)) {
            throw new JAXRPCException("Reliable endpoint has SSL/TLS security enabled, but incoming connection does not support it");
        }
        HttpServerTransport httpServerTransport = (HttpServerTransport)transport;
        if (!(httpServerTransport.getRequest() instanceof ServletRequestImpl)) {
            throw new JAXRPCException("Reliable endpoint has SSL/TLS enabled, but incoming connection has unknown HttpServletRequest type: " + httpServerTransport.getRequest());
        }
        ServletRequestImpl servletRequestImpl = (ServletRequestImpl)httpServerTransport.getRequest();
        Socket socket = servletRequestImpl.getConnection().getSocket();
        if (!(socket instanceof SSLSocket)) {
            throw new JAXRPCException("Reliable endpoint has SSL/TLS enabled, but socket from HttpServletRequest is not an SSLSocket: " + socket);
        }
        SSLSocket sSLSocket = (SSLSocket)socket;
        SSLSession sSLSession = sSLSocket.getSession();
        if (sSLSession == null) {
            throw new JAXRPCException("Reliable endpoint has SSL/TLS enabled, but socket from HttpServletRequest has no SSLSession on it");
        }
        byte[] byArray = sSLSession.getId();
        return byArray;
    }

    public static String dumpByteArray(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (byte by : byArray) {
            StringBuffer stringBuffer2 = new StringBuffer(Byte.toString(by));
            while (stringBuffer2.length() < 3) {
                stringBuffer2.insert(0, " ");
            }
            stringBuffer.append("[").append(stringBuffer2).append("] ");
        }
        return stringBuffer.toString();
    }

    public static void addTestSequenceSSLHeaderIfNeeded(WsrmSequenceContext wsrmSequenceContext, WlMessageContext wlMessageContext) {
        WsrmSecurityContext wsrmSecurityContext = wsrmSequenceContext.getWsrmSecurityContext();
        if (wsrmSecurityContext.isForcedSSLSessionId() && wlMessageContext.getHeaders().getHeader(TestSequenceSSLHeader.TYPE) == null) {
            String string;
            TestSequenceSSLHeader testSequenceSSLHeader = new TestSequenceSSLHeader(wsrmSequenceContext.getRmVersion());
            try {
                string = new String(wsrmSecurityContext.getSSLSessionId(), "UTF-8");
            }
            catch (Exception exception) {
                throw new JAXRPCException(exception.toString(), (Throwable)exception);
            }
            testSequenceSSLHeader.setSSLSessionId(string);
            wlMessageContext.getHeaders().addHeader(testSequenceSSLHeader);
        }
    }

    static {
        safManager = SAFManagerImpl.getManager();
    }
}

