/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.jws.ReliabilityBuffer;
import weblogic.messaging.saf.SAFConversationHandle;
import weblogic.messaging.saf.SAFConversationInfo;
import weblogic.messaging.saf.SAFConversationNotAvailException;
import weblogic.messaging.saf.SAFException;
import weblogic.messaging.saf.SAFManager;
import weblogic.messaging.saf.SAFRequest;
import weblogic.messaging.saf.SAFResult;
import weblogic.messaging.saf.common.SAFConversationInfoImpl;
import weblogic.messaging.saf.internal.SAFManagerImpl;
import weblogic.protocol.LocalServerIdentity;
import weblogic.wsee.addressing.ActionHeader;
import weblogic.wsee.addressing.AddressingHelper;
import weblogic.wsee.addressing.AddressingProvider;
import weblogic.wsee.addressing.AddressingProviderFactory;
import weblogic.wsee.addressing.EndpointReference;
import weblogic.wsee.addressing.RelatesToHeader;
import weblogic.wsee.async.AsyncUtil;
import weblogic.wsee.cluster.ServiceIdentityHeader;
import weblogic.wsee.jws.container.Duration;
import weblogic.wsee.message.FreeStandingMsgHeaders;
import weblogic.wsee.message.MsgHeader;
import weblogic.wsee.message.MsgHeaders;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.message.soap.SoapMessageContext;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.runtime.PolicyContext;
import weblogic.wsee.reliability.MessageRange;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability.WsrmHelper;
import weblogic.wsee.reliability.WsrmPayloadContext;
import weblogic.wsee.reliability.WsrmProtocolUtils;
import weblogic.wsee.reliability.WsrmSAFManager;
import weblogic.wsee.reliability.WsrmSecurityContext;
import weblogic.wsee.reliability.WsrmSequenceContext;
import weblogic.wsee.reliability.WsrmSequenceSender;
import weblogic.wsee.reliability.WsrmServerPayloadContext;
import weblogic.wsee.reliability.faults.InvalidAckFaultMsg;
import weblogic.wsee.reliability.faults.LastMessageNumExceededFaultMsg;
import weblogic.wsee.reliability.faults.MessageNumRolloverFaultMsg;
import weblogic.wsee.reliability.faults.SequenceFaultMsg;
import weblogic.wsee.reliability.faults.SequenceFaultMsgFactory;
import weblogic.wsee.reliability.faults.SequenceFaultMsgType;
import weblogic.wsee.reliability.faults.SequenceTerminatedFaultMsg;
import weblogic.wsee.reliability.faults.UnknownSequenceFaultMsg;
import weblogic.wsee.reliability.handshake.CloseSequenceMsg;
import weblogic.wsee.reliability.handshake.CloseSequenceResponseMsg;
import weblogic.wsee.reliability.handshake.CreateSequenceMsg;
import weblogic.wsee.reliability.handshake.CreateSequenceResponseMsg;
import weblogic.wsee.reliability.handshake.HandshakeMsgException;
import weblogic.wsee.reliability.handshake.SequenceAccept;
import weblogic.wsee.reliability.handshake.SequenceOffer;
import weblogic.wsee.reliability.handshake.TerminateSequenceMsg;
import weblogic.wsee.reliability.handshake.TerminateSequenceResponseMsg;
import weblogic.wsee.reliability.headers.AcknowledgementHeader;
import weblogic.wsee.reliability.headers.SequenceHeader;
import weblogic.wsee.reliability.headers.UsesSequenceSSLHeader;
import weblogic.wsee.reliability.headers.UsesSequenceSTRHeader;
import weblogic.wsee.reliability.headers.WsrmHeader;
import weblogic.wsee.server.WsLifeCycleEvent;
import weblogic.wsee.server.WsLifeCycleListenerRegistry;
import weblogic.wsee.util.AddressingUtil;
import weblogic.wsee.util.Guid;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.dispatch.Dispatcher;
import weblogic.wsee.wsa.wsaddressing.WSAVersion;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public final class WsrmSAFReceivingManager
extends WsrmSAFManager {
    private static final boolean verbose = Verbose.isVerbose(WsrmSAFReceivingManager.class);

    WsrmSAFReceivingManager() {
        safManager.addConversationLifecycleListener(new SAFManager.ConversationLifecycleListener(){

            public void ack(SAFConversationInfo sAFConversationInfo, long l, long l2) {
            }

            public void addToCache(boolean bl, String string, String string2, SAFConversationInfo sAFConversationInfo, int n) {
            }

            public void preClose(boolean bl, boolean bl2, SAFConversationInfo sAFConversationInfo) {
                block11: {
                    SAFConversationInfo sAFConversationInfo2;
                    if (!bl && bl2 && (sAFConversationInfo2 = sAFConversationInfo.getConversationOffer()) != null) {
                        WsrmSequenceContext wsrmSequenceContext = (WsrmSequenceContext)sAFConversationInfo2.getContext();
                        if (!wsrmSequenceContext.hasRequestSeqNumBeenMappedToResponseSeqNum(1L)) {
                            try {
                                if (verbose) {
                                    Verbose.say("*** Auto-terminating unused offer sequence " + sAFConversationInfo2.getConversationName() + " for request sequence " + sAFConversationInfo.getConversationName());
                                }
                                WsrmSAFManager.safManager.setSentLastMessageOnSendingSide(sAFConversationInfo2.getConversationName(), 0L);
                            }
                            catch (Exception exception) {
                                if (verbose) {
                                    Verbose.logException(exception);
                                }
                                break block11;
                            }
                        }
                        try {
                            if (!wsrmSequenceContext.hasFinalRequestSeqNum() && WsrmSAFManager.safManager.hasReceivedLastMessageOnReceivingSide(sAFConversationInfo.getConversationName())) {
                                long l = WsrmSAFManager.safManager.getLastMessageSequenceNumberOnReceivingSide(sAFConversationInfo.getConversationName());
                                if (verbose) {
                                    Verbose.say("*** Starting auto-terminate processing for offer sequence " + sAFConversationInfo2.getConversationName() + " since request sequence " + sAFConversationInfo.getConversationName() + " apparently never received TerminateSequence. Final request seq num is " + l);
                                }
                                wsrmSequenceContext.setFinalRequestSeqNum(l);
                                WsrmSAFManager.safManager.storeConversationContextOnSendingSide(sAFConversationInfo2.getConversationName(), wsrmSequenceContext);
                                WsrmSAFReceivingManager.this.checkForAutoTerminateOnOfferSequence(sAFConversationInfo2.getConversationName(), wsrmSequenceContext, wsrmSequenceContext.getDestination());
                            }
                        }
                        catch (Exception exception) {
                            if (verbose) {
                                Verbose.logException(exception);
                            }
                            exception.printStackTrace();
                        }
                    }
                }
            }

            public void removeFromCache(boolean bl, String string, String string2, SAFConversationInfo sAFConversationInfo, int n) {
            }
        });
    }

    private SAFConversationInfo createSAFConversationInfo(String string, WlMessageContext wlMessageContext, CreateSequenceMsg createSequenceMsg, EndpointReference endpointReference) {
        SAFConversationInfoImpl sAFConversationInfoImpl = new SAFConversationInfoImpl(2);
        EndpointReference endpointReference2 = createSequenceMsg.getAcksTo();
        if (endpointReference2 == null) {
            throw new JAXRPCException("No AcksTo header in create sequence message");
        }
        sAFConversationInfoImpl.setSourceURL(endpointReference2.getAddress());
        String string2 = (String)wlMessageContext.getProperty("weblogic.wsee.addressing.To");
        if (string2 == null) {
            throw new JAXRPCException("No To header in create sequence message");
        }
        sAFConversationInfoImpl.setDestinationURL(string2);
        this.setupSAFConversationQOS(wlMessageContext, sAFConversationInfoImpl);
        sAFConversationInfoImpl.setDestinationType(2);
        sAFConversationInfoImpl.setConversationName(string);
        sAFConversationInfoImpl.setTransportType(2);
        WsrmSequenceContext wsrmSequenceContext = this.setupSAFConversationContext(wlMessageContext, endpointReference2, sAFConversationInfoImpl, createSequenceMsg.getRmVersion());
        String string3 = (String)wlMessageContext.getProperty("weblogic.wsee.addressing.MessageId");
        if (string3 == null) {
            throw new JAXRPCException("No message ID found");
        }
        sAFConversationInfoImpl.setCreateConversationMessageID(string3);
        this.handleExpiration(createSequenceMsg, sAFConversationInfoImpl, wlMessageContext);
        this.setupSAFConversationMaxIdelTime(wlMessageContext, sAFConversationInfoImpl);
        this.setupSAFConversationOffer(wlMessageContext, createSequenceMsg, sAFConversationInfoImpl, endpointReference, wsrmSequenceContext);
        return sAFConversationInfoImpl;
    }

    private void setupSAFConversationOffer(WlMessageContext wlMessageContext, CreateSequenceMsg createSequenceMsg, SAFConversationInfo sAFConversationInfo, EndpointReference endpointReference, WsrmSequenceContext wsrmSequenceContext) {
        boolean bl = this.checkOfferNeeded(wlMessageContext, wsrmSequenceContext.getRmVersion());
        SequenceOffer sequenceOffer = createSequenceMsg.getOffer();
        if (sequenceOffer != null) {
            if (!bl && wsrmSequenceContext.getRmVersion() == WsrmConstants.RMVersion.RM_10) {
                throw new JAXRPCException("Offered sequence refused. There are no output messages defined on this endpoint, so no offer sequence is required or allowed.");
            }
            SAFConversationInfoImpl sAFConversationInfoImpl = new SAFConversationInfoImpl(2);
            String string = sequenceOffer.getSequenceId();
            sAFConversationInfoImpl.setDestinationURL(endpointReference.getAddress());
            sAFConversationInfoImpl.setQOS(sAFConversationInfo.getQOS());
            sAFConversationInfoImpl.setInorder(sAFConversationInfo.isInorder());
            sAFConversationInfoImpl.setDynamic(false);
            sAFConversationInfoImpl.setDestinationType(2);
            sAFConversationInfoImpl.setConversationName(string);
            sAFConversationInfoImpl.setTransportType(2);
            WsrmSequenceContext wsrmSequenceContext2 = new WsrmSequenceContext();
            wsrmSequenceContext2.setDestination(endpointReference);
            wsrmSequenceContext2.setRmVersion(wsrmSequenceContext.getRmVersion());
            wsrmSequenceContext2.setWsaVersion(wsrmSequenceContext.getWsaVersion());
            wsrmSequenceContext2.setSoap12(wsrmSequenceContext.isSoap12());
            wsrmSequenceContext2.setFrom(wsrmSequenceContext.getFrom());
            wsrmSequenceContext2.setAcksTo(wsrmSequenceContext.getAcksTo());
            wsrmSequenceContext2.setWsrmSecurityContext(new WsrmSecurityContext(wsrmSequenceContext.getWsrmSecurityContext()));
            sAFConversationInfoImpl.setContext(wsrmSequenceContext2);
            sAFConversationInfoImpl.setSourceURL(wsrmSequenceContext.getAcksTo().getAddress());
            this.handleOfferExpiration(sequenceOffer, sAFConversationInfoImpl);
            if (wsrmSequenceContext.getRmVersion().isLaterThanOrEqualTo(WsrmConstants.RMVersion.RM_11)) {
                if (sequenceOffer.getEndpoint() != null) {
                    boolean bl2 = AddressingProviderFactory.getInstance().getAddressingProvider(wlMessageContext).isAnonymousReferenceURI(sequenceOffer.getEndpoint().getAddress());
                    if (bl2) {
                        throw new JAXRPCException("CreateSequence/Offer/Endpoint cannot be anonymous");
                    }
                    wsrmSequenceContext2.setLifecycleEndpoint(sequenceOffer.getEndpoint());
                }
                if (wsrmSequenceContext.getWsrmSecurityContext().isForcedSSLSessionId()) {
                    try {
                        String string2 = new String(wsrmSequenceContext.getWsrmSecurityContext().getSSLSessionId(), "UTF-8");
                        string2 = string2 + "Offer";
                        wsrmSequenceContext2.getWsrmSecurityContext().setSSLSessionId(string2.getBytes("UTF-8"));
                        wsrmSequenceContext2.getWsrmSecurityContext().setForcedSSLSessionId(true);
                    }
                    catch (Exception exception) {
                        throw new JAXRPCException(exception.toString(), (Throwable)exception);
                    }
                }
            }
            sAFConversationInfo.setConversationOffer(sAFConversationInfoImpl);
        } else if (bl) {
            throw new JAXRPCException("Sequence offer required for endpoints with output messages");
        }
    }

    private WsrmSequenceContext setupSAFConversationContext(WlMessageContext wlMessageContext, EndpointReference endpointReference, SAFConversationInfo sAFConversationInfo, WsrmConstants.RMVersion rMVersion) {
        WsrmSequenceContext wsrmSequenceContext = new WsrmSequenceContext();
        wsrmSequenceContext.setRmVersion(rMVersion);
        wsrmSequenceContext.setWsaVersion(AddressingHelper.getWSAVersion(wlMessageContext));
        wsrmSequenceContext.setSoap12(AsyncUtil.isSoap12(wlMessageContext));
        wsrmSequenceContext.setWsrmSecurityContext((WsrmSecurityContext)wlMessageContext.getProperty("weblogic.wsee.wsrm.security.context"));
        if (wlMessageContext.containsProperty("weblogic.wsee.addressing.From")) {
            wsrmSequenceContext.setFrom((EndpointReference)wlMessageContext.getProperty("weblogic.wsee.addressing.From"));
        }
        wsrmSequenceContext.setAcksTo(endpointReference);
        sAFConversationInfo.setContext(wsrmSequenceContext);
        return wsrmSequenceContext;
    }

    private void handleOfferExpiration(SequenceOffer sequenceOffer, SAFConversationInfo sAFConversationInfo) {
        String string = sequenceOffer.getExpires();
        if (string != null) {
            javax.xml.datatype.Duration duration;
            try {
                duration = DatatypeFactory.newInstance().newDuration(string);
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                throw new JAXRPCException("Cannot construct DatatypeFactory " + datatypeConfigurationException.toString());
            }
            catch (Throwable throwable) {
                throw new JAXRPCException("Cannot read expiration for the offered sequence, not a valid duration type: " + string + " " + throwable.toString());
            }
            this.setupSAFConversationTTL(duration, sAFConversationInfo);
        } else {
            this.setupSAFConversationTTL(null, sAFConversationInfo);
        }
    }

    private void handleExpiration(CreateSequenceMsg createSequenceMsg, SAFConversationInfo sAFConversationInfo, WlMessageContext wlMessageContext) {
        javax.xml.datatype.Duration duration = createSequenceMsg.getExpires();
        Date date = new Date();
        this.setupSAFConversationTTL(duration, sAFConversationInfo);
        javax.xml.datatype.Duration duration2 = this.getSequenceExpirationFromContext(wlMessageContext);
        if (duration2 != null) {
            long l = duration2.getTimeInMillis(date);
            if (l <= 0L) {
                throw new JAXRPCException("Invalid expiration value in policy: " + duration2.toString());
            }
            if (verbose) {
                Verbose.log("=======Conversation timeout is: " + l + "========");
            }
            sAFConversationInfo.setConversationTimeout(l);
        }
    }

    public void deliver(SequenceHeader sequenceHeader, SOAPMessageContext sOAPMessageContext) {
        Object object;
        Object object2;
        Serializable serializable;
        WsLifeCycleListenerRegistry.getInstance().onEvent(WsLifeCycleEvent.WSRM_RECV_BEFORE_SAF);
        SOAPMessage sOAPMessage = sOAPMessageContext.getMessage();
        Dispatcher dispatcher = ((WlMessageContext)sOAPMessageContext).getDispatcher();
        this.checkAsyncReqRes(dispatcher, sOAPMessageContext);
        String string = sequenceHeader.getSequenceId();
        if (verbose) {
            serializable = (ActionHeader)((SoapMessageContext)sOAPMessageContext).getHeaders().getHeader(ActionHeader.TYPE);
            object2 = "Unknown";
            if (serializable != null) {
                object2 = ((ActionHeader)serializable).getActionURI();
            }
            object = sequenceHeader.getRmVersion() == WsrmConstants.RMVersion.RM_10 ? (sequenceHeader.isLastMessage() ? "(LAST)" : "") : "";
            Verbose.log("** Deliver reliable message with action " + (String)object2 + " seq num " + sequenceHeader.getMessageNumber() + (String)object + " on sequence " + string + " to end destination");
        }
        try {
            serializable = this.getConversationInfo(string, sOAPMessageContext);
            if (serializable == null) {
                return;
            }
            object2 = (WsrmSequenceContext)serializable.getContext();
            assert (object2 != null);
            if (this.checkForSequenceClosed(sOAPMessageContext, string, (WsrmSequenceContext)object2)) {
                return;
            }
            object = ((WsrmSequenceContext)object2).getAcksTo();
            assert (object != null);
            boolean bl = AddressingProviderFactory.getInstance().getAddressingProvider((MessageContext)sOAPMessageContext).isAnonymousReferenceURI(((EndpointReference)object).getAddress());
            this.checkAndRemoveMustUnderstand(sequenceHeader, true, sOAPMessage);
            String string2 = (String)sOAPMessageContext.getProperty("weblogic.wsee.addressing.MessageId");
            this.checkAsyncReqResOffer(dispatcher, sOAPMessageContext, (SAFConversationInfo)serializable);
            sOAPMessageContext.setProperty("weblogic.wsee.enable.rm", (Object)"true");
            long l = sequenceHeader.getMessageNumber();
            sOAPMessageContext.setProperty("weblogic.wsee.reliability.RequestMessageSeqNumber", (Object)Long.toString(l));
            sOAPMessageContext.setProperty("weblogic.wsee.reliability.RequestMessageSeqID", (Object)sequenceHeader.getSequenceId());
            String string3 = "Unknown";
            ActionHeader actionHeader = (ActionHeader)((SoapMessageContext)sOAPMessageContext).getHeaders().getHeader(ActionHeader.TYPE);
            if (actionHeader != null) {
                string3 = actionHeader.getActionURI();
            }
            sOAPMessageContext.setProperty("weblogic.wsee.reliability.RequestMessageAction", (Object)string3);
            SAFConversationInfo sAFConversationInfo = serializable.getConversationOffer();
            if (sAFConversationInfo != null) {
                if (verbose) {
                    Verbose.say("*** WsrmSAFReceivingManager.deliver() storing request offer seq ID as " + sAFConversationInfo.getConversationName() + " for request sequence " + string + " requestSeqNum " + l + " action " + string3);
                }
                sOAPMessageContext.setProperty("weblogic.wsee.reliability.RequestMessageOfferSeqID", (Object)sAFConversationInfo.getConversationName());
            } else if (verbose) {
                Verbose.say("*** WsrmSAFReceivingManager.deliver() didn't find an offer sequence related to request sequence " + string + " requestSeqNum " + l + " action " + string3);
            }
            SAFRequest sAFRequest = this.createSAFRequest(sequenceHeader, string2, sOAPMessageContext, (WsrmSequenceContext)object2);
            this.setupSAFRequestPayloadContext(sOAPMessageContext, sAFRequest);
            if (!bl) {
                if (verbose) {
                    Verbose.log("*** WsrmSAFReceivingManager.deliver() - requesting asynchronous delivery of SAFRequest on sequence: " + string + " requestSeqNum " + l + " action " + string3);
                }
                safManager.deliver((SAFConversationInfo)serializable, sAFRequest);
                if (verbose) {
                    Verbose.log("*** WsrmSAFReceivingManager.deliver() - done requesting asynchronous delivery of SAFRequest on sequence: " + string + " requestSeqNum " + l + " action " + string3);
                }
                AddressingUtil.confirmOneway((WlMessageContext)sOAPMessageContext);
                sOAPMessageContext.setProperty("weblogic.wsee.reliable.oneway.msg", (Object)"true");
            } else {
                if (verbose) {
                    Verbose.log("*** WsrmSAFReceivingManager.deliver() - requesting synchronous delivery of SAFRequest on sequence: " + string + " requestSeqNum " + l + " action " + string3);
                }
                SAFResult sAFResult = safManager.deliverSync((SAFConversationInfo)serializable, sAFRequest);
                if (verbose) {
                    Verbose.log("*** WsrmSAFReceivingManager.deliver() - done with synchronous delivery of SAFRequest on sequence: " + string + " requestSeqNum " + l + " action " + string3);
                }
                if (sAFResult.isDuplicate()) {
                    this.handleDuplicateSAFResult(string, sequenceHeader);
                }
                if (sAFResult.isSuccessful()) {
                    this.handleSuccessfulSAFResult(string, sOAPMessageContext, (EndpointReference)object, (WsrmSequenceContext)object2);
                } else {
                    this.handleFailedSAFResult(string, sAFResult, sOAPMessageContext, (EndpointReference)object);
                }
            }
        }
        catch (SAFException sAFException) {
            if (sAFException.getResultCode() == 19) {
                if (verbose) {
                    Verbose.log(sAFException.getMessage());
                }
                this.sendLastMessageNumExceededFault(string, sOAPMessageContext);
                return;
            }
            if (verbose) {
                Verbose.logException(sAFException);
            }
            throw new JAXRPCException("Delivery to SAF failed: " + sAFException.toString(), (Throwable)sAFException);
        }
        if (((WlMessageContext)sOAPMessageContext).getHeaders().getHeader(RelatesToHeader.TYPE) != null) {
            WsLifeCycleListenerRegistry.getInstance().onEvent(WsLifeCycleEvent.WSRM_SEND_AFTER_RES_TO_SAF_BEFORE_QUEUE);
        }
    }

    private void sendLastMessageNumExceededFault(String string, SOAPMessageContext sOAPMessageContext) {
        SAFConversationInfo sAFConversationInfo = this.getConversationInfo(string, sOAPMessageContext);
        if (sAFConversationInfo == null) {
            return;
        }
        WsrmSequenceContext wsrmSequenceContext = (WsrmSequenceContext)sAFConversationInfo.getContext();
        LastMessageNumExceededFaultMsg lastMessageNumExceededFaultMsg = new LastMessageNumExceededFaultMsg(wsrmSequenceContext.getRmVersion());
        lastMessageNumExceededFaultMsg.setSequenceId(string);
        WsrmHelper.sendFault(sOAPMessageContext, lastMessageNumExceededFaultMsg, ((WsrmSequenceContext)sAFConversationInfo.getContext()).getAcksTo());
    }

    private void handleFailedSAFResult(String string, SAFResult sAFResult, SOAPMessageContext sOAPMessageContext, EndpointReference endpointReference) {
        SequenceFaultMsg sequenceFaultMsg;
        if (verbose) {
            Verbose.log("Deliver message with sequence ID " + string + " failed.  Result code is " + sAFResult.getResultCode() + ", description is " + sAFResult.getDescription());
        }
        if ((sequenceFaultMsg = this.getDeliverFaultMsg(sAFResult, string, sOAPMessageContext, endpointReference)) == null) {
            throw new JAXRPCException("Deliver message with sequence ID " + string + " failed.  Result code is " + sAFResult.getResultCode() + ", description is " + sAFResult.getDescription());
        }
        WsrmHelper.sendFault(sOAPMessageContext, sequenceFaultMsg, endpointReference);
    }

    private void handleSuccessfulSAFResult(String string, SOAPMessageContext sOAPMessageContext, EndpointReference endpointReference, WsrmSequenceContext wsrmSequenceContext) {
        AcknowledgementHeader acknowledgementHeader = this.createAckHeader(string, wsrmSequenceContext);
        this.sendAck(sOAPMessageContext, acknowledgementHeader, endpointReference, wsrmSequenceContext);
    }

    private void handleDuplicateSAFResult(String string, SequenceHeader sequenceHeader) {
        if (verbose) {
            Verbose.log("Got duplicate message with sequence ID: " + string + " and message number: " + sequenceHeader.getMessageNumber());
        }
    }

    private void setupSAFRequestPayloadContext(SOAPMessageContext sOAPMessageContext, SAFRequest sAFRequest) {
        WlMessageContext wlMessageContext = (WlMessageContext)sOAPMessageContext;
        ReliabilityBufferConfig reliabilityBufferConfig = this.getReliabilityBufferConfig(wlMessageContext);
        if (reliabilityBufferConfig != null) {
            int n = reliabilityBufferConfig.getRetryCount();
            String string = reliabilityBufferConfig.getRetryDelay();
            Duration duration = new Duration(string);
            long l = duration.convertToSeconds(new Date());
            if (verbose) {
                Verbose.log("Buffer retry count " + n);
                Verbose.log("Buffer retry delay " + l);
            }
            ((WsrmPayloadContext)sAFRequest.getPayloadContext()).setRetryCount(n);
            ((WsrmPayloadContext)sAFRequest.getPayloadContext()).setRetryDelay(l);
        }
    }

    private ReliabilityBufferConfig getReliabilityBufferConfig(WlMessageContext wlMessageContext) {
        ReliabilityBufferConfig reliabilityBufferConfig;
        block11: {
            Method method;
            Object object;
            reliabilityBufferConfig = null;
            if (wlMessageContext.getDispatcher().getWsMethod() != null && (object = wlMessageContext.getDispatcher().getWsPort().getEndpoint().getJwsClass()) != null && (method = this.findMethod((Class)object, wlMessageContext.getDispatcher().getWsMethod().getMethodName())) != null) {
                ReliabilityBuffer reliabilityBuffer = method.getAnnotation(ReliabilityBuffer.class);
                if (reliabilityBuffer == null) {
                    reliabilityBuffer = ((Class)object).getAnnotation(ReliabilityBuffer.class);
                }
                if (reliabilityBuffer != null) {
                    reliabilityBufferConfig = new ReliabilityBufferConfig(reliabilityBuffer);
                }
            }
            if (reliabilityBufferConfig == null && (wlMessageContext.getProperty("weblogic.wsee.wsrm.RetryCount") != null || wlMessageContext.getProperty("weblogic.wsee.wsrm.RetryDelay") != null)) {
                block10: {
                    reliabilityBufferConfig = new ReliabilityBufferConfig();
                    if (wlMessageContext.getProperty("weblogic.wsee.wsrm.RetryCount") != null) {
                        try {
                            object = (String)wlMessageContext.getProperty("weblogic.wsee.wsrm.RetryCount");
                            reliabilityBufferConfig.setRetryCount(Integer.parseInt((String)object));
                        }
                        catch (Exception exception) {
                            if (!verbose) break block10;
                            Verbose.logException(exception);
                        }
                    }
                }
                if (wlMessageContext.getProperty("weblogic.wsee.wsrm.RetryDelay") != null) {
                    try {
                        object = (String)wlMessageContext.getProperty("weblogic.wsee.wsrm.RetryDelay");
                        reliabilityBufferConfig.setRetryDelay((String)object);
                    }
                    catch (Exception exception) {
                        if (!verbose) break block11;
                        Verbose.logException(exception);
                    }
                }
            }
        }
        return reliabilityBufferConfig;
    }

    private Method findMethod(Class clazz, String string) {
        Method[] methodArray;
        for (Method method : methodArray = clazz.getMethods()) {
            if (!method.getName().equals(string)) continue;
            return method;
        }
        return null;
    }

    private SAFConversationInfo getConversationInfo(String string, SOAPMessageContext sOAPMessageContext) {
        SAFConversationInfo sAFConversationInfo;
        try {
            sAFConversationInfo = safManager.getConversationInfoOnReceivingSide(string);
        }
        catch (Throwable throwable) {
            if (verbose) {
                Verbose.logException(throwable);
            }
            throw new JAXRPCException("Unable to retrieve reliable sequence information on the receiving side", throwable);
        }
        if (sAFConversationInfo == null) {
            this.sendUnknownSequenceFault(string, sOAPMessageContext);
        }
        return sAFConversationInfo;
    }

    private SequenceFaultMsg getDeliverFaultMsg(SAFResult sAFResult, String string, SOAPMessageContext sOAPMessageContext, EndpointReference endpointReference) {
        int n;
        SequenceFaultMsgFactory sequenceFaultMsgFactory = SequenceFaultMsgFactory.getInstance();
        QName qName = sequenceFaultMsgFactory.getSAFResultCodeMapping(n = sAFResult.getResultCode());
        if (qName == null) {
            if (verbose) {
                Verbose.log("Unknown fault code " + n + " -- " + sAFResult.getDescription());
            }
            return null;
        }
        WsrmSequenceContext wsrmSequenceContext = (WsrmSequenceContext)sAFResult.getConversationInfo().getContext();
        SequenceFaultMsg sequenceFaultMsg = sequenceFaultMsgFactory.createSequenceFaultMsg(qName, wsrmSequenceContext.getRmVersion());
        if (sequenceFaultMsg != null) {
            sequenceFaultMsg.setSequenceId(string);
        }
        if (!(sequenceFaultMsg instanceof UnknownSequenceFaultMsg)) {
            sOAPMessageContext.setProperty("weblogic.wsee.faultto.override", (Object)endpointReference);
        }
        return sequenceFaultMsg;
    }

    private void checkAsyncReqRes(Dispatcher dispatcher, SOAPMessageContext sOAPMessageContext) {
        if (dispatcher.getOperation() != null && (dispatcher.getOperation().getType() == 0 || dispatcher.getOperation().getType() == 2) && sOAPMessageContext.getProperty("weblogic.wsee.reply.anonymous") != null) {
            throw new JAXRPCException("Reliable messaging can only work with oneway or asynchronous request/response MEP.  The reply-to endpoint should not be anonymous in request/response.");
        }
    }

    private void checkAsyncReqResOffer(Dispatcher dispatcher, SOAPMessageContext sOAPMessageContext, SAFConversationInfo sAFConversationInfo) {
        if (dispatcher.getOperation() != null) {
            String string = ((EndpointReference)sOAPMessageContext.getProperty("weblogic.wsee.addressing.ReplyTo")).getAddress();
            if (dispatcher.getOperation().getType() == 0 || dispatcher.getOperation().getType() == 2) {
                if (sOAPMessageContext.getProperty("weblogic.wsee.reply.anonymous") != null) {
                    throw new JAXRPCException("Reliable messaging can only work with oneway or asynchronous request/response MEP.  The reply-to endpoint should not be anonymous in request/response.");
                }
                SAFConversationInfo sAFConversationInfo2 = sAFConversationInfo.getConversationOffer();
                if (sAFConversationInfo2 == null) {
                    WsrmSequenceContext wsrmSequenceContext = (WsrmSequenceContext)sAFConversationInfo.getContext();
                    WsrmConstants.RMVersion rMVersion = wsrmSequenceContext.getRmVersion();
                    if (rMVersion == WsrmConstants.RMVersion.RM_10) {
                        throw new JAXRPCException("offer is required for reliable request/response MEP");
                    }
                } else if (string.equals(sAFConversationInfo2.getDestinationURL())) {
                    sOAPMessageContext.setProperty("weblogic.wsee.async.res.sequence.id", (Object)sAFConversationInfo2.getConversationName());
                }
            } else {
                SAFConversationInfo sAFConversationInfo3 = sAFConversationInfo.getConversationOffer();
                if (sAFConversationInfo3 != null && string.equals(sAFConversationInfo3.getDestinationURL())) {
                    sOAPMessageContext.setProperty("weblogic.wsee.convid.sequence.id", (Object)sAFConversationInfo3.getConversationName());
                }
            }
        }
    }

    public void ackRequested(String string, SOAPMessageContext sOAPMessageContext) {
        if (verbose) {
            Verbose.log("received ack request");
        }
        try {
            SAFConversationInfo sAFConversationInfo = this.getConversationInfo(string, sOAPMessageContext);
            if (sAFConversationInfo == null) {
                return;
            }
            WsrmSequenceContext wsrmSequenceContext = (WsrmSequenceContext)sAFConversationInfo.getContext();
            assert (wsrmSequenceContext != null);
            EndpointReference endpointReference = wsrmSequenceContext.getAcksTo();
            assert (endpointReference != null);
            AcknowledgementHeader acknowledgementHeader = this.createAckHeader(string, wsrmSequenceContext);
            boolean bl = AddressingProviderFactory.getInstance().getAddressingProvider((MessageContext)sOAPMessageContext).isAnonymousReferenceURI(endpointReference.getAddress());
            WsrmServerPayloadContext wsrmServerPayloadContext = new WsrmServerPayloadContext();
            wsrmServerPayloadContext.setRequestPolicy(PolicyContext.getRequestEffectivePolicy((MessageContext)sOAPMessageContext));
            wsrmServerPayloadContext.setResponsePolicy(PolicyContext.getResponseEffectivePolicy((MessageContext)sOAPMessageContext));
            if (bl) {
                this.sendAck(sOAPMessageContext, acknowledgementHeader, endpointReference, wsrmSequenceContext);
            } else {
                List<Long> list = safManager.getAllSequenceNumberRangesOnReceivingSide(string);
                WsrmSequenceSender.acknowledge(sAFConversationInfo, list, endpointReference, wsrmSequenceContext, wsrmSequenceContext.isSoap12());
                AddressingUtil.confirmOneway((WlMessageContext)sOAPMessageContext);
                sOAPMessageContext.setProperty("weblogic.wsee.reliable.oneway.msg", (Object)"true");
            }
        }
        catch (JAXRPCException jAXRPCException) {
            throw jAXRPCException;
        }
        catch (SAFException sAFException) {
            if (verbose) {
                Verbose.logException(sAFException);
            }
            throw new JAXRPCException("SAFException", (Throwable)sAFException);
        }
        catch (Throwable throwable) {
            if (verbose) {
                Verbose.logException(throwable);
            }
            throw new JAXRPCException("Throwable", throwable);
        }
    }

    public void createSequence(SOAPMessageContext sOAPMessageContext, CreateSequenceMsg createSequenceMsg) throws SAFException {
        Object object;
        Serializable serializable;
        SoapMessageContext soapMessageContext = (SoapMessageContext)sOAPMessageContext;
        WsrmSecurityContext wsrmSecurityContext = (WsrmSecurityContext)soapMessageContext.getProperty("weblogic.wsee.wsrm.security.context");
        if (wsrmSecurityContext == null) {
            throw new JAXRPCException("No WsrmSecurityContext found on message context");
        }
        if (wsrmSecurityContext.isSecureWithSSL()) {
            serializable = (UsesSequenceSSLHeader)soapMessageContext.getHeaders().getHeader(UsesSequenceSSLHeader.TYPE);
            if (serializable != null) {
                this.checkAndRemoveMustUnderstand((WsrmHeader)serializable, false, soapMessageContext.getMessage());
            }
            WsrmSAFReceivingManager.setSSLSessionIdFromContext(soapMessageContext, wsrmSecurityContext, false);
        }
        if (wsrmSecurityContext.isSecure() && (serializable = (UsesSequenceSTRHeader)soapMessageContext.getHeaders().getHeader(UsesSequenceSTRHeader.TYPE)) != null) {
            this.checkAndRemoveMustUnderstand((WsrmHeader)serializable, false, soapMessageContext.getMessage());
        }
        serializable = (EndpointReference)soapMessageContext.getProperty("weblogic.wsee.addressing.ReplyTo");
        String string = ((EndpointReference)serializable).getAddress();
        String string2 = (String)soapMessageContext.getProperty("weblogic.wsee.addressing.MessageId");
        assert (string2 != null);
        if (this.checkDuplicateCreateSequence(string2, soapMessageContext, createSequenceMsg, string)) {
            return;
        }
        String string3 = this.generateSequenceId();
        if (verbose) {
            object = createSequenceMsg.getOffer();
            Verbose.log("Create sequence with ID " + string3 + (object != null ? " offer seq id " + ((SequenceOffer)object).getSequenceId() : ""));
        }
        object = this.createSAFConversationInfo(string3, soapMessageContext, createSequenceMsg, (EndpointReference)serializable);
        SAFConversationHandle sAFConversationHandle = safManager.registerConversationOnReceivingSide((SAFConversationInfo)object);
        long l = sAFConversationHandle.getConversationTimeout();
        WsLifeCycleListenerRegistry.getInstance().onEvent(WsLifeCycleEvent.WSRM_RECV_CREATE_SEQ);
        this.sendCreateSequenceResp(soapMessageContext, string3, l, createSequenceMsg, string);
    }

    private void checkAndRemoveMustUnderstand(WsrmHeader wsrmHeader, boolean bl, SOAPMessage sOAPMessage) throws SAFException {
        if (wsrmHeader.isMustUnderstand()) {
            Element element;
            SOAPHeader sOAPHeader;
            try {
                sOAPHeader = sOAPMessage.getSOAPHeader();
            }
            catch (SOAPException sOAPException) {
                throw new SAFException(sOAPException.toString(), sOAPException);
            }
            if (sOAPHeader == null) {
                throw new JAXRPCException("No SOAPHeader found in SOAPMessage.");
            }
            try {
                element = DOMUtils.getElementByTagNameNS((Element)sOAPHeader, wsrmHeader.getRmVersion().getNamespaceUri(), wsrmHeader.getName().getLocalPart());
            }
            catch (DOMProcessingException dOMProcessingException) {
                throw new JAXRPCException((Throwable)((Object)dOMProcessingException));
            }
            sOAPHeader.removeChild((Node)element);
        } else if (bl) {
            throw new JAXRPCException(wsrmHeader.getName() + " header must be marked mustUnderstand = \"1\"");
        }
    }

    private boolean checkDuplicateCreateSequence(String string, SOAPMessageContext sOAPMessageContext, CreateSequenceMsg createSequenceMsg, String string2) throws SAFException {
        SAFConversationInfo sAFConversationInfo;
        try {
            sAFConversationInfo = safManager.getConversationInfoOnReceivingSide(string);
        }
        catch (SAFConversationNotAvailException sAFConversationNotAvailException) {
            sAFConversationInfo = null;
        }
        if (sAFConversationInfo != null) {
            if (verbose) {
                Verbose.log("Received duplicate create sequence request");
            }
            this.sendCreateSequenceResp(sOAPMessageContext, sAFConversationInfo.getConversationName(), sAFConversationInfo.getConversationTimeout() > sAFConversationInfo.getTimeToLive() ? sAFConversationInfo.getTimeToLive() : sAFConversationInfo.getConversationTimeout(), createSequenceMsg, string2);
            return true;
        }
        return false;
    }

    private void sendCreateSequenceResp(SOAPMessageContext sOAPMessageContext, String string, long l, CreateSequenceMsg createSequenceMsg, String string2) {
        try {
            SAFConversationInfo sAFConversationInfo = this.getConversationInfo(string, sOAPMessageContext);
            WsrmSequenceContext wsrmSequenceContext = (WsrmSequenceContext)sAFConversationInfo.getContext();
            WsrmSequenceContext wsrmSequenceContext2 = null;
            if (sAFConversationInfo.getConversationOffer() != null) {
                wsrmSequenceContext2 = (WsrmSequenceContext)sAFConversationInfo.getConversationOffer().getContext();
            }
            SOAPMessage sOAPMessage = WsrmSAFReceivingManager.getMessageFactory(sOAPMessageContext).createMessage();
            sOAPMessageContext.setMessage(sOAPMessage);
            this.setCreateSequenceResponseHeader(sOAPMessageContext, wsrmSequenceContext);
            CreateSequenceResponseMsg createSequenceResponseMsg = this.setCreateSequenceResponseMsg(string, l, wsrmSequenceContext);
            this.setCreateSequenceResponseOffer(createSequenceMsg, string2, sOAPMessageContext, createSequenceResponseMsg);
            createSequenceResponseMsg.writeMsg(sOAPMessage);
            this.setCreateSequenceResponseSecurity(sOAPMessageContext);
            if (wsrmSequenceContext2 != null) {
                if (wsrmSequenceContext2.getRmVersion().isLaterThanOrEqualTo(WsrmConstants.RMVersion.RM_11)) {
                    wsrmSequenceContext2.setMainAckTo(createSequenceResponseMsg.getAccept().getAcksTo());
                }
                WsrmSAFReceivingManager.addTestSequenceSSLHeaderIfNeeded(wsrmSequenceContext2, (WlMessageContext)sOAPMessageContext);
            }
            if (verbose) {
                SequenceOffer sequenceOffer = createSequenceMsg.getOffer();
                Verbose.say("Requesting send of CreateSequenceResponse for recv side seq id " + createSequenceResponseMsg.getSequenceId() + (sequenceOffer != null ? " offer seq id " + sequenceOffer.getSequenceId() : ""));
            }
        }
        catch (HandshakeMsgException handshakeMsgException) {
            if (verbose) {
                Verbose.logException(handshakeMsgException);
            }
            throw new JAXRPCException("HandshakeMsgException", (Throwable)handshakeMsgException);
        }
        catch (SOAPException sOAPException) {
            if (verbose) {
                Verbose.logException(sOAPException);
            }
            throw new JAXRPCException("SOAPException", (Throwable)sOAPException);
        }
    }

    private void setCreateSequenceResponseSecurity(SOAPMessageContext sOAPMessageContext) {
        WsrmSecurityContext wsrmSecurityContext = (WsrmSecurityContext)sOAPMessageContext.getProperty("weblogic.wsee.wsrm.security.context");
        if (wsrmSecurityContext.isSecure()) {
            try {
                sOAPMessageContext.setProperty("weblogic.wsee.policy.effectiveResponsePolicy", (Object)wsrmSecurityContext.getSecurityPolicy());
            }
            catch (PolicyException policyException) {
                if (verbose) {
                    Verbose.logException(policyException);
                }
                throw new JAXRPCException("Policy exception", (Throwable)policyException);
            }
        }
    }

    private void setCreateSequenceResponseOffer(CreateSequenceMsg createSequenceMsg, String string, SOAPMessageContext sOAPMessageContext, CreateSequenceResponseMsg createSequenceResponseMsg) {
        SequenceOffer sequenceOffer = createSequenceMsg.getOffer();
        if (sequenceOffer != null) {
            SequenceAccept sequenceAccept = new SequenceAccept(createSequenceMsg.getRmVersion());
            EndpointReference endpointReference = this.calculateAcksToEprForAcceptedOffer(string, sOAPMessageContext);
            if (endpointReference.getReferenceParameters().getHeader(ServiceIdentityHeader.TYPE) == null) {
                ServiceIdentityHeader serviceIdentityHeader = new ServiceIdentityHeader();
                serviceIdentityHeader.setServerName(LocalServerIdentity.getIdentity().getServerName());
                serviceIdentityHeader.setServiceName("weblogic.wsee.conversation.msg.cluster.service");
                endpointReference.getReferenceParameters().addHeader(serviceIdentityHeader);
            }
            sequenceAccept.setAcksTo(endpointReference);
            createSequenceResponseMsg.setAccept(sequenceAccept);
        }
    }

    private EndpointReference calculateAcksToEprForAcceptedOffer(String string, SOAPMessageContext sOAPMessageContext) {
        URI uRI = URI.create(string);
        String string2 = uRI.getScheme();
        EndpointReference endpointReference = (EndpointReference)sOAPMessageContext.getProperty("weblogic.wsee.addressing.ServerEndpoint");
        String string3 = endpointReference.getAddress();
        int n = string3.indexOf(58);
        String string4 = string3.substring(n);
        string3 = string2 + string4;
        AddressingProvider addressingProvider = AddressingProviderFactory.getInstance().getAddressingProvider((MessageContext)sOAPMessageContext);
        EndpointReference endpointReference2 = addressingProvider.createEndpointReference(string3);
        endpointReference2.setServiceName(endpointReference.getServiceName(), endpointReference.getPortName());
        FreeStandingMsgHeaders freeStandingMsgHeaders = new FreeStandingMsgHeaders();
        MsgHeaders msgHeaders = endpointReference.getReferenceParameters();
        Iterator iterator = msgHeaders.listHeaders();
        while (iterator.hasNext()) {
            MsgHeader msgHeader = (MsgHeader)iterator.next();
            freeStandingMsgHeaders.addHeader(msgHeader);
        }
        return endpointReference2;
    }

    private CreateSequenceResponseMsg setCreateSequenceResponseMsg(String string, long l, WsrmSequenceContext wsrmSequenceContext) {
        CreateSequenceResponseMsg createSequenceResponseMsg = new CreateSequenceResponseMsg(wsrmSequenceContext.getRmVersion());
        createSequenceResponseMsg.setSequenceId(string);
        if (l != Long.MAX_VALUE) {
            try {
                javax.xml.datatype.Duration duration = DatatypeFactory.newInstance().newDuration(l);
                createSequenceResponseMsg.setExpires(duration);
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                throw new JAXRPCException((Throwable)datatypeConfigurationException);
            }
            catch (Throwable throwable) {
                throw new JAXRPCException(throwable);
            }
        }
        if (wsrmSequenceContext.getRmVersion().isLaterThanOrEqualTo(WsrmConstants.RMVersion.RM_11)) {
            createSequenceResponseMsg.setIncompleteSequenceBehavior(WsrmConstants.IncompleteSequenceBehavior.NoDiscard);
        }
        return createSequenceResponseMsg;
    }

    private void setCreateSequenceResponseHeader(SOAPMessageContext sOAPMessageContext, WsrmSequenceContext wsrmSequenceContext) {
        String string = WsrmConstants.Action.CREATE_SEQUENCE_RESPONSE.getActionURI(wsrmSequenceContext.getRmVersion());
        ((WlMessageContext)sOAPMessageContext).getHeaders().addHeader(AddressingHelper.getAddressingProvider((MessageContext)sOAPMessageContext).createActionHeader(string));
        sOAPMessageContext.getMessage().getMimeHeaders().setHeader("SOAPAction", string);
    }

    public void closeSequence(WlMessageContext wlMessageContext, CloseSequenceMsg closeSequenceMsg) {
        SoapMessageContext soapMessageContext = (SoapMessageContext)wlMessageContext;
        String string = closeSequenceMsg.getSequenceId();
        if (verbose) {
            Verbose.log("Close sequence with ID " + string);
        }
        try {
            SAFConversationInfo sAFConversationInfo = this.getConversationInfo(string, (SOAPMessageContext)wlMessageContext);
            if (sAFConversationInfo == null) {
                return;
            }
            WsrmSequenceContext wsrmSequenceContext = (WsrmSequenceContext)sAFConversationInfo.getContext();
            wsrmSequenceContext.setClosed(true);
            SAFManagerImpl.getManager().storeConversationContextOnReceivingSide(string, wsrmSequenceContext);
            this.sendCloseSequenceResp(soapMessageContext, closeSequenceMsg);
        }
        catch (Throwable throwable) {
            if (verbose) {
                Verbose.logException(throwable);
            }
            throw new JAXRPCException("Unable to terminate sequence " + string, throwable);
        }
    }

    private void sendCloseSequenceResp(SoapMessageContext soapMessageContext, CloseSequenceMsg closeSequenceMsg) {
        try {
            SAFConversationInfo sAFConversationInfo = this.getConversationInfo(closeSequenceMsg.getSequenceId(), soapMessageContext);
            WsrmSequenceContext wsrmSequenceContext = (WsrmSequenceContext)sAFConversationInfo.getContext();
            SOAPMessage sOAPMessage = WsrmSAFReceivingManager.getMessageFactory(soapMessageContext).createMessage();
            soapMessageContext.setMessage(sOAPMessage);
            this.setCloseSequenceResponseHeader(soapMessageContext, sAFConversationInfo, wsrmSequenceContext);
            CloseSequenceResponseMsg closeSequenceResponseMsg = this.setCloseSequenceResponseMsg(closeSequenceMsg.getSequenceId(), wsrmSequenceContext);
            closeSequenceResponseMsg.writeMsg(sOAPMessage);
            this.setCloseSequenceResponseSecurity(soapMessageContext);
            WsrmSAFReceivingManager.addTestSequenceSSLHeaderIfNeeded(wsrmSequenceContext, soapMessageContext);
        }
        catch (HandshakeMsgException handshakeMsgException) {
            if (verbose) {
                Verbose.logException(handshakeMsgException);
            }
            throw new JAXRPCException("HandshakeMsgException", (Throwable)handshakeMsgException);
        }
        catch (SOAPException sOAPException) {
            if (verbose) {
                Verbose.logException(sOAPException);
            }
            throw new JAXRPCException("SOAPException", (Throwable)sOAPException);
        }
    }

    private void setCloseSequenceResponseSecurity(SOAPMessageContext sOAPMessageContext) {
        WsrmSecurityContext wsrmSecurityContext = (WsrmSecurityContext)sOAPMessageContext.getProperty("weblogic.wsee.wsrm.security.context");
        if (wsrmSecurityContext != null && wsrmSecurityContext.isSecure()) {
            try {
                sOAPMessageContext.setProperty("weblogic.wsee.policy.effectiveResponsePolicy", (Object)wsrmSecurityContext.getSecurityPolicy());
            }
            catch (PolicyException policyException) {
                if (verbose) {
                    Verbose.logException(policyException);
                }
                throw new JAXRPCException("Policy exception", (Throwable)policyException);
            }
        }
    }

    private void setCloseSequenceResponseHeader(SoapMessageContext soapMessageContext, SAFConversationInfo sAFConversationInfo, WsrmSequenceContext wsrmSequenceContext) {
        String string = WsrmConstants.Action.CLOSE_SEQUENCE_RESPONSE.getActionURI(wsrmSequenceContext.getRmVersion());
        soapMessageContext.setProperty("weblogic.wsee.addressing.version", (Object)wsrmSequenceContext.getWsaVersion());
        soapMessageContext.getHeaders().addHeader(AddressingProviderFactory.getInstance().getAddressingProvider(soapMessageContext).createActionHeader(string));
        if (!wsrmSequenceContext.isSoap12()) {
            soapMessageContext.getMessage().getMimeHeaders().setHeader("SOAPAction", string);
        }
        this.setAckHeaderOnMessage(soapMessageContext, sAFConversationInfo);
    }

    private void setAckHeaderOnMessage(SoapMessageContext soapMessageContext, SAFConversationInfo sAFConversationInfo) {
        WsrmSequenceContext wsrmSequenceContext = (WsrmSequenceContext)sAFConversationInfo.getContext();
        String string = sAFConversationInfo.getConversationName();
        AcknowledgementHeader acknowledgementHeader = this.createAckHeader(string, wsrmSequenceContext);
        soapMessageContext.getHeaders().addHeader(acknowledgementHeader);
        WsrmSAFReceivingManager.addTestSequenceSSLHeaderIfNeeded(wsrmSequenceContext, soapMessageContext);
    }

    private AcknowledgementHeader createAckHeader(String string, WsrmSequenceContext wsrmSequenceContext) {
        AcknowledgementHeader acknowledgementHeader = new AcknowledgementHeader(wsrmSequenceContext.getRmVersion());
        acknowledgementHeader.setSequenceId(string);
        if (wsrmSequenceContext.isClosed()) {
            acknowledgementHeader.setFinal(true);
        }
        try {
            List<Long> list = safManager.getAllSequenceNumberRangesOnReceivingSide(string);
            if (list.size() == 0) {
                acknowledgementHeader.setNone(true);
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    Long l = list.get(i);
                    Long l2 = list.get(++i);
                    acknowledgementHeader.acknowledgeMessages(l, l2);
                }
            }
        }
        catch (SAFException sAFException) {
            throw new JAXRPCException(sAFException.toString(), (Throwable)sAFException);
        }
        return acknowledgementHeader;
    }

    private CloseSequenceResponseMsg setCloseSequenceResponseMsg(String string, WsrmSequenceContext wsrmSequenceContext) {
        CloseSequenceResponseMsg closeSequenceResponseMsg = new CloseSequenceResponseMsg(wsrmSequenceContext.getRmVersion());
        closeSequenceResponseMsg.setSequenceId(string);
        return closeSequenceResponseMsg;
    }

    public void terminateSequence(WlMessageContext wlMessageContext, TerminateSequenceMsg terminateSequenceMsg) {
        SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)wlMessageContext;
        String string = terminateSequenceMsg.getSequenceId();
        if (verbose) {
            Verbose.log("*** Terminate sequence with ID " + string);
        }
        if (terminateSequenceMsg.getRmVersion() == WsrmConstants.RMVersion.RM_10) {
            AddressingUtil.confirmOneway(wlMessageContext);
            wlMessageContext.setProperty("weblogic.wsee.reliable.oneway.msg", "true");
        }
        try {
            WsrmSequenceContext wsrmSequenceContext;
            SAFConversationInfo sAFConversationInfo = this.getConversationInfo(string, (SOAPMessageContext)wlMessageContext);
            if (sAFConversationInfo == null) {
                return;
            }
            SAFConversationInfo sAFConversationInfo2 = sAFConversationInfo.getConversationOffer();
            if (sAFConversationInfo2 != null) {
                wsrmSequenceContext = (WsrmSequenceContext)sAFConversationInfo2.getContext();
                boolean bl = wsrmSequenceContext.getRmVersion() == WsrmConstants.RMVersion.RM_10 ? safManager.hasReceivedLastMessageOnReceivingSide(string) : true;
                if (bl) {
                    this.startAutoTerminateProcessingForOffer(string, sAFConversationInfo2, terminateSequenceMsg);
                } else if (verbose) {
                    Verbose.say("** Got terminate sequence message, but do not yet have the last message for the sequence. Cannot auto-terminate");
                }
            }
            wsrmSequenceContext = (WsrmSequenceContext)sAFConversationInfo.getContext();
            assert (wsrmSequenceContext != null);
            if (wsrmSequenceContext.getRmVersion().isLaterThanOrEqualTo(WsrmConstants.RMVersion.RM_11)) {
                this.sendTerminateSequenceResp(sOAPMessageContext, terminateSequenceMsg, sAFConversationInfo);
            }
            safManager.closeConversationOnReceivingSide(sAFConversationInfo);
        }
        catch (SAFException sAFException) {
            if (verbose) {
                Verbose.logException(sAFException);
            }
            throw new JAXRPCException("Unable to terminate sequence " + string, (Throwable)sAFException);
        }
        catch (Throwable throwable) {
            if (verbose) {
                Verbose.logException(throwable);
            }
            throw new JAXRPCException("Unable to terminate sequence " + string, throwable);
        }
    }

    private void startAutoTerminateProcessingForOffer(String string, SAFConversationInfo sAFConversationInfo, TerminateSequenceMsg terminateSequenceMsg) throws SAFException {
        if (verbose) {
            Verbose.say("*** Starting auto-terminate processing for OFFER sequence: " + sAFConversationInfo.getConversationName() + " related to sequence: " + string + ". However, the offer will not be terminated until we see all responses for the final set of requests.");
        }
        String string2 = sAFConversationInfo.getConversationName();
        WsrmSequenceContext wsrmSequenceContext = (WsrmSequenceContext)sAFConversationInfo.getContext();
        long l = wsrmSequenceContext.getRmVersion() == WsrmConstants.RMVersion.RM_10 ? safManager.getLastMessageSequenceNumberOnReceivingSide(string) : terminateSequenceMsg.getLastMsgNumber();
        if (verbose) {
            Verbose.say("*** Final message on request sequence " + string + " had sequence number: " + l);
        }
        wsrmSequenceContext.setFinalRequestSeqNum(l);
        long l2 = wsrmSequenceContext.getFinalResponseSeqNum();
        if (l2 >= 0L) {
            if (verbose) {
                Verbose.say("*** Final message on request sequence " + string + " with sequence number: " + l + " was mapped to offer sequence " + string2 + " sequence number " + l2 + ". Enabling auto-terminate.");
            }
            this.enableAutoTerminateForOfferSequence(string2, l2);
        } else if (verbose) {
            Verbose.say("*** Final message on request sequence " + string + " with sequence number: " + l + " could not be mapped to a sequence number on offer sequence " + string2);
        }
    }

    public void checkForAutoTerminateOnOfferSequence(String string, WsrmSequenceContext wsrmSequenceContext, EndpointReference endpointReference) throws SAFException {
        long l;
        if (verbose) {
            String string2 = wsrmSequenceContext.dumpRequestSeqNumToResponseSeqNumMap();
            Verbose.say("*** Current request->response seq num map for offer sequence " + string + " is: " + string2);
        }
        if ((l = wsrmSequenceContext.getFinalResponseSeqNum()) >= 0L) {
            if (verbose) {
                Verbose.say("*** Found finalResponseSeqNum=" + l + " on offer sequence " + string + ". Enabling auto-terminate");
            }
            this.enableAutoTerminateForOfferSequence(string, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableAutoTerminateForOfferSequence(String string, long l) throws SAFException {
        if (verbose) {
            Verbose.say("*** In WsrmSAFReceivingManager.enableAutoTerminateForOfferSequence on offer seq " + string + " with final response seq " + l);
        }
        SAFConversationInfo sAFConversationInfo = WsrmSAFReceivingManager.getConversationInfo(true, string, false);
        WsrmSequenceContext wsrmSequenceContext = (WsrmSequenceContext)sAFConversationInfo.getContext();
        Serializable serializable = wsrmSequenceContext;
        synchronized (serializable) {
            if (wsrmSequenceContext.isOfferSequenceAutoTerminating()) {
                if (verbose) {
                    Verbose.say("*** WHOA, duplicate request to enable auto-terminate on offer sequence " + string + ". Ignoring.");
                }
                return;
            }
            wsrmSequenceContext.setOfferSequenceAutoTerminating(true);
        }
        if (wsrmSequenceContext.getRmVersion() == WsrmConstants.RMVersion.RM_10 && wsrmSequenceContext.getAcksTo() != null) {
            serializable = new HashMap();
            serializable.put("weblogic.wsee.sequenceid", string);
            WSAVersion wSAVersion = wsrmSequenceContext.getWsaVersion();
            if (wSAVersion != null) {
                serializable.put("weblogic.wsee.addressing.version", wSAVersion);
            }
            if (verbose) {
                Verbose.say("*** Asking for LastMessage to be sent on offer seq " + string);
                Verbose.say("*** Done asking for LastMessage to be sent on offer seq " + string);
            }
            WsrmProtocolUtils.sendEmptyLastMessage((Map)((Object)serializable), wsrmSequenceContext.getAcksTo());
        } else {
            if (verbose) {
                Verbose.say("*** Setting sentLastMessageOnSendingSide for offer sequence " + string + ", and 'final' seq num=" + l);
            }
            safManager.setSentLastMessageOnSendingSide(string, l);
        }
    }

    private void sendTerminateSequenceResp(SOAPMessageContext sOAPMessageContext, TerminateSequenceMsg terminateSequenceMsg, SAFConversationInfo sAFConversationInfo) {
        try {
            WsrmSequenceContext wsrmSequenceContext = (WsrmSequenceContext)sAFConversationInfo.getContext();
            SOAPMessage sOAPMessage = WsrmSAFReceivingManager.getMessageFactory(sOAPMessageContext).createMessage();
            sOAPMessageContext.setMessage(sOAPMessage);
            this.setTerminateSequenceResponseHeader((SoapMessageContext)WlMessageContext.narrow((MessageContext)sOAPMessageContext), wsrmSequenceContext, sAFConversationInfo);
            TerminateSequenceResponseMsg terminateSequenceResponseMsg = this.setTerminateSequenceResponseMsg(terminateSequenceMsg.getSequenceId(), wsrmSequenceContext);
            terminateSequenceResponseMsg.writeMsg(sOAPMessage);
            this.setTerminateSequenceResponseSecurity(sOAPMessageContext);
            WsrmSAFReceivingManager.addTestSequenceSSLHeaderIfNeeded(wsrmSequenceContext, (WlMessageContext)sOAPMessageContext);
        }
        catch (HandshakeMsgException handshakeMsgException) {
            if (verbose) {
                Verbose.logException(handshakeMsgException);
            }
            throw new JAXRPCException("HandshakeMsgException", (Throwable)handshakeMsgException);
        }
        catch (SOAPException sOAPException) {
            if (verbose) {
                Verbose.logException(sOAPException);
            }
            throw new JAXRPCException("SOAPException", (Throwable)sOAPException);
        }
    }

    private void setTerminateSequenceResponseSecurity(SOAPMessageContext sOAPMessageContext) {
        WsrmSecurityContext wsrmSecurityContext = (WsrmSecurityContext)sOAPMessageContext.getProperty("weblogic.wsee.wsrm.security.context");
        if (wsrmSecurityContext != null && wsrmSecurityContext.isSecure()) {
            try {
                sOAPMessageContext.setProperty("weblogic.wsee.policy.effectiveResponsePolicy", (Object)wsrmSecurityContext.getSecurityPolicy());
            }
            catch (PolicyException policyException) {
                if (verbose) {
                    Verbose.logException(policyException);
                }
                throw new JAXRPCException("Policy exception", (Throwable)policyException);
            }
        }
    }

    private void setTerminateSequenceResponseHeader(SoapMessageContext soapMessageContext, WsrmSequenceContext wsrmSequenceContext, SAFConversationInfo sAFConversationInfo) {
        String string = WsrmConstants.Action.TERMINATE_SEQUENCE_RESPONSE.getActionURI(wsrmSequenceContext.getRmVersion());
        soapMessageContext.setProperty("weblogic.wsee.addressing.version", (Object)wsrmSequenceContext.getWsaVersion());
        soapMessageContext.getHeaders().addHeader(AddressingProviderFactory.getInstance().getAddressingProvider(soapMessageContext).createActionHeader(string));
        soapMessageContext.getMessage().getMimeHeaders().setHeader("SOAPAction", string);
        this.setAckHeaderOnMessage(soapMessageContext, sAFConversationInfo);
    }

    private TerminateSequenceResponseMsg setTerminateSequenceResponseMsg(String string, WsrmSequenceContext wsrmSequenceContext) {
        TerminateSequenceResponseMsg terminateSequenceResponseMsg = new TerminateSequenceResponseMsg(wsrmSequenceContext.getRmVersion());
        terminateSequenceResponseMsg.setSequenceId(string);
        return terminateSequenceResponseMsg;
    }

    public void handleFault(SequenceFaultMsg sequenceFaultMsg) {
        SequenceFaultMsgType sequenceFaultMsgType = sequenceFaultMsg.getType();
        SAFConversationInfoImpl sAFConversationInfoImpl = new SAFConversationInfoImpl();
        if (UnknownSequenceFaultMsg.TYPE.equals(sequenceFaultMsgType)) {
            if (verbose) {
                Verbose.log("UnknownSequenceFault: received unknown sequence " + sequenceFaultMsg.getSequenceId());
            }
        } else if (SequenceTerminatedFaultMsg.TYPE.equals(sequenceFaultMsgType)) {
            if (verbose) {
                Verbose.log("SequenceTerminatedFault: sequence " + sequenceFaultMsg.getSequenceId() + " has been terminated on the sending side.");
            }
            sAFConversationInfoImpl.setConversationName(sequenceFaultMsg.getSequenceId());
            try {
                safManager.closeConversationOnReceivingSide(sAFConversationInfoImpl);
            }
            catch (Exception exception) {
                Verbose.logException(exception);
            }
        } else if (MessageNumRolloverFaultMsg.TYPE.equals(sequenceFaultMsgType)) {
            if (verbose) {
                Verbose.log("MessageNumRolloverFault: sequence " + sequenceFaultMsg.getSequenceId() + " has run out of message number.");
            }
            sAFConversationInfoImpl.setConversationName(sequenceFaultMsg.getSequenceId());
            try {
                safManager.closeConversationOnReceivingSide(sAFConversationInfoImpl);
            }
            catch (Exception exception) {
                Verbose.logException(exception);
            }
        } else if (InvalidAckFaultMsg.TYPE.equals(sequenceFaultMsgType)) {
            if (verbose) {
                Verbose.log("InvalidAckFaultMsg: sequence " + sequenceFaultMsg.getSequenceId() + " has invalid acknowldgements: ");
                Iterator iterator = ((InvalidAckFaultMsg)sequenceFaultMsg).listMessageRanges();
                while (iterator.hasNext()) {
                    MessageRange messageRange = (MessageRange)iterator.next();
                    Verbose.getOut().println(messageRange.lowerBounds + " -- " + messageRange.upperBounds);
                }
            }
            sAFConversationInfoImpl.setConversationName(sequenceFaultMsg.getSequenceId());
            try {
                safManager.closeConversationOnReceivingSide(sAFConversationInfoImpl);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (verbose) {
            Verbose.log("SequenceFaultMsg: " + sequenceFaultMsg.getSubCodeQualifiedName() + " " + sequenceFaultMsg.getReason());
        }
    }

    private void sendAck(SOAPMessageContext sOAPMessageContext, AcknowledgementHeader acknowledgementHeader, EndpointReference endpointReference, WsrmSequenceContext wsrmSequenceContext) {
        try {
            WlMessageContext wlMessageContext = (WlMessageContext)sOAPMessageContext;
            SOAPMessage sOAPMessage = WsrmSAFReceivingManager.getMessageFactory(sOAPMessageContext).createMessage();
            sOAPMessageContext.setMessage(sOAPMessage);
            MsgHeaders msgHeaders = wlMessageContext.getHeaders();
            Iterator iterator = endpointReference.getReferenceProperties().listHeaders();
            while (iterator.hasNext()) {
                msgHeaders.addHeader((MsgHeader)iterator.next());
            }
            iterator = endpointReference.getReferenceParameters().listHeaders();
            while (iterator.hasNext()) {
                msgHeaders.addHeader((MsgHeader)iterator.next());
            }
            AddressingProvider addressingProvider = AddressingProviderFactory.getInstance().getAddressingProvider(wlMessageContext);
            msgHeaders.addHeader(acknowledgementHeader);
            msgHeaders.addHeader(addressingProvider.createToHeader(endpointReference.getAddress()));
            msgHeaders.addHeader(addressingProvider.createReplyToHeader(addressingProvider.createAnonymousEndpointReference()));
            String string = WsrmConstants.Action.ACK.getActionURI(wsrmSequenceContext.getRmVersion());
            msgHeaders.addHeader(addressingProvider.createActionHeader(string));
            msgHeaders.addHeader(addressingProvider.createMessageIdHeader(Guid.generateGuid()));
            if (!AsyncUtil.isSoap12(wlMessageContext)) {
                sOAPMessage.getMimeHeaders().setHeader("SOAPAction", string);
            }
            WsrmSecurityContext wsrmSecurityContext = wsrmSequenceContext.getWsrmSecurityContext();
            if (wsrmSequenceContext.isSecure()) {
                try {
                    sOAPMessageContext.setProperty("weblogic.wsee.policy.effectiveResponsePolicy", (Object)wsrmSecurityContext.getSecurityPolicy());
                }
                catch (PolicyException policyException) {
                    if (verbose) {
                        Verbose.logException(policyException);
                    }
                    throw new JAXRPCException((Throwable)policyException);
                }
            }
            sOAPMessageContext.setProperty("weblogic.wsee.reliable.oneway.reply", (Object)"true");
            WsrmSAFReceivingManager.addTestSequenceSSLHeaderIfNeeded(wsrmSequenceContext, (WlMessageContext)sOAPMessageContext);
        }
        catch (SOAPException sOAPException) {
            if (verbose) {
                Verbose.logException(sOAPException);
            }
            throw new JAXRPCException((Throwable)sOAPException);
        }
    }

    public class ReliabilityBufferConfig {
        private int retryCount;
        private String retryDelay;

        public ReliabilityBufferConfig() {
            this.retryCount = 3;
            this.retryDelay = "5 seconds";
        }

        public ReliabilityBufferConfig(int n, String string) {
            this.retryCount = n;
            this.retryDelay = string;
        }

        public ReliabilityBufferConfig(ReliabilityBuffer reliabilityBuffer) {
            this.retryCount = reliabilityBuffer.retryCount();
            this.retryDelay = reliabilityBuffer.retryDelay();
        }

        public int getRetryCount() {
            return this.retryCount;
        }

        public void setRetryCount(int n) {
            this.retryCount = n;
        }

        public String getRetryDelay() {
            return this.retryDelay;
        }

        public void setRetryDelay(String string) {
            this.retryDelay = string;
        }
    }
}

