/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability;

import java.io.Externalizable;
import java.io.Serializable;
import java.security.AccessController;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.SOAPFault;
import weblogic.messaging.saf.SAFConversationInfo;
import weblogic.messaging.saf.SAFConversationNotAvailException;
import weblogic.messaging.saf.SAFException;
import weblogic.messaging.saf.SAFManager;
import weblogic.messaging.saf.SAFRequest;
import weblogic.messaging.saf.SAFTransportException;
import weblogic.messaging.saf.common.SAFConversationHandleImpl;
import weblogic.messaging.saf.common.SAFConversationInfoImpl;
import weblogic.messaging.saf.common.SAFRemoteContext;
import weblogic.messaging.saf.internal.SAFManagerImpl;
import weblogic.protocol.LocalServerIdentity;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.collections.ConcurrentHashMap;
import weblogic.wsee.addressing.ActionHeader;
import weblogic.wsee.addressing.AddressingHelper;
import weblogic.wsee.addressing.AddressingProvider;
import weblogic.wsee.addressing.AddressingProviderFactory;
import weblogic.wsee.addressing.EndpointReference;
import weblogic.wsee.addressing.MessageIdHeader;
import weblogic.wsee.addressing.ReplyToHeader;
import weblogic.wsee.addressing.ToHeader;
import weblogic.wsee.async.AsyncUtil;
import weblogic.wsee.cluster.ClusterUtil;
import weblogic.wsee.cluster.ServiceIdentityHeader;
import weblogic.wsee.connection.transport.TransportInfo;
import weblogic.wsee.conversation.ConversationPhase;
import weblogic.wsee.message.MsgHeader;
import weblogic.wsee.message.MsgHeaders;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.message.soap.SoapMessageContext;
import weblogic.wsee.reliability.MessageRange;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability.WsrmHelper;
import weblogic.wsee.reliability.WsrmPayloadContext;
import weblogic.wsee.reliability.WsrmSAFErrorHandler;
import weblogic.wsee.reliability.WsrmSAFManager;
import weblogic.wsee.reliability.WsrmSecurityContext;
import weblogic.wsee.reliability.WsrmSequenceContext;
import weblogic.wsee.reliability.WsrmSequenceSender;
import weblogic.wsee.reliability.faults.IllegalRMVersionFaultMsg;
import weblogic.wsee.reliability.faults.InvalidAckFaultMsg;
import weblogic.wsee.reliability.faults.LastMessageNumExceededFaultMsg;
import weblogic.wsee.reliability.faults.SequenceFaultMsg;
import weblogic.wsee.reliability.faults.SequenceFaultMsgType;
import weblogic.wsee.reliability.faults.SequenceRefusedFaultMsg;
import weblogic.wsee.reliability.faults.SequenceTerminatedFaultMsg;
import weblogic.wsee.reliability.faults.UnknownSequenceFaultMsg;
import weblogic.wsee.reliability.handshake.CloseSequenceResponseMsg;
import weblogic.wsee.reliability.handshake.CreateSequenceResponseMsg;
import weblogic.wsee.reliability.handshake.SequenceAccept;
import weblogic.wsee.reliability.handshake.TerminateSequenceResponseMsg;
import weblogic.wsee.reliability.headers.AcknowledgementHeader;
import weblogic.wsee.reliability.headers.SequenceHeader;
import weblogic.wsee.server.WsLifeCycleEvent;
import weblogic.wsee.server.WsLifeCycleListenerRegistry;
import weblogic.wsee.util.AddressingUtil;
import weblogic.wsee.util.Verbose;

public final class WsrmSAFSendingManager
extends WsrmSAFManager {
    private static final boolean verbose = Verbose.isVerbose(WsrmSAFSendingManager.class);

    WsrmSAFSendingManager() {
        if (verbose) {
            safManager.addConversationLifecycleListener(new SAFManager.ConversationLifecycleListener(){

                public void ack(SAFConversationInfo sAFConversationInfo, long l, long l2) {
                    if (verbose) {
                        Verbose.say("*** SAF got ACK on sequence with seq ID: " + sAFConversationInfo.getConversationName() + " dyn seq ID: " + sAFConversationInfo.getDynamicConversationName() + " low: " + l + " high: " + l2);
                        try {
                            long l3 = WsrmSAFManager.safManager.getLastAssignedSequenceValueOnSendingSide(sAFConversationInfo.getConversationName());
                            Verbose.say("*** SAF has last sent for seq ID:        " + sAFConversationInfo.getConversationName() + " dyn seq ID: " + sAFConversationInfo.getDynamicConversationName() + " seq num: " + l3);
                        }
                        catch (SAFException sAFException) {
                            Verbose.logException(sAFException);
                        }
                    }
                }

                public void addToCache(boolean bl, String string, String string2, SAFConversationInfo sAFConversationInfo, int n) {
                    if (verbose) {
                        Verbose.say("*** SAF adding (on " + (bl ? "sending" : "receiving") + " side) for " + string + " conversation " + sAFConversationInfo.getConversationName() + " under key " + string2);
                        Verbose.say("*** SAF currently tracking (on " + (bl ? "sending" : "receiving") + " side): " + n + " conversations");
                    }
                }

                public void preClose(boolean bl, boolean bl2, SAFConversationInfo sAFConversationInfo) {
                    if (verbose && bl2) {
                        Verbose.say("*** SAF closing sequence (on " + (bl ? "sending" : "receiving") + " side) with seq ID: " + sAFConversationInfo.getConversationName() + " dyn seq ID: " + sAFConversationInfo.getDynamicConversationName());
                    }
                }

                public void removeFromCache(boolean bl, String string, String string2, SAFConversationInfo sAFConversationInfo, int n) {
                    if (verbose) {
                        Verbose.say("*** SAF removing (on " + (bl ? "sending" : "receiving") + " side) for " + string + " conversation " + sAFConversationInfo.getConversationName() + " under key " + string2);
                        Verbose.say("*** SAF currently tracking (on " + (bl ? "sending" : "receiving") + " side): " + n + " conversations");
                    }
                }
            });
        }
    }

    private SAFConversationInfo createSAFConversationInfo(String string, String string2, WlMessageContext wlMessageContext) {
        SAFConversationInfoImpl sAFConversationInfoImpl = new SAFConversationInfoImpl(2);
        sAFConversationInfoImpl.setDestinationType(2);
        sAFConversationInfoImpl.setDestinationURL(string2);
        sAFConversationInfoImpl.setDynamic(true);
        sAFConversationInfoImpl.setConversationName(string);
        sAFConversationInfoImpl.setTransportType(2);
        sAFConversationInfoImpl.setErrorHandler(new WsrmSAFErrorHandler());
        sAFConversationInfoImpl.setCreateConversationMessageID(this.generateSequenceId());
        this.setupSAFConversationQOS(wlMessageContext, sAFConversationInfoImpl);
        this.setupSAFConversationContext(wlMessageContext, string2, sAFConversationInfoImpl);
        Duration duration = (Duration)wlMessageContext.getProperty("weblogic.wsee.wsrm.sequence.expiration");
        this.setupSAFConversationTTL(duration, sAFConversationInfoImpl);
        this.setupSAFConversationMaxIdelTime(wlMessageContext, sAFConversationInfoImpl);
        this.setupSAFConversationRemoteContext(wlMessageContext, sAFConversationInfoImpl);
        this.setupSAFConversationOffer(wlMessageContext, string2, sAFConversationInfoImpl);
        return sAFConversationInfoImpl;
    }

    private void setupSAFConversationRemoteContext(WlMessageContext wlMessageContext, SAFConversationInfo sAFConversationInfo) {
        String string = (String)wlMessageContext.getProperty("weblogic.wsee.wsrm.BaseRetransmissionInterval");
        Boolean bl = (Boolean)wlMessageContext.getProperty("weblogic.wsee.wsrm.RetransmissionExponentialBackoff");
        if (string != null) {
            try {
                Duration duration = DatatypeFactory.newInstance().newDuration(string);
                long l = System.currentTimeMillis();
                long l2 = duration.getTimeInMillis(new Date(l));
                if (bl != null && bl.booleanValue()) {
                    long l3 = l2 << 10;
                    sAFConversationInfo.setRemoteContext(new SAFRemoteContext(l2, l3, 2L));
                } else {
                    sAFConversationInfo.setRemoteContext(new SAFRemoteContext(l2, l2, 1L));
                }
                if (verbose) {
                    Verbose.log("SAF BaseRetransmission is " + string);
                }
            }
            catch (Exception exception) {
                throw new JAXRPCException(exception.toString(), (Throwable)exception);
            }
        }
    }

    private void setupSAFConversationContext(WlMessageContext wlMessageContext, String string, SAFConversationInfo sAFConversationInfo) {
        Serializable serializable;
        WsrmSecurityContext wsrmSecurityContext = new WsrmSecurityContext(wlMessageContext);
        EndpointReference endpointReference = (EndpointReference)wlMessageContext.getProperty("weblogic.wsee.acksto");
        AddressingProvider addressingProvider = AddressingProviderFactory.getInstance().getAddressingProvider(wlMessageContext);
        if (endpointReference == null) {
            if ("true".equals(wlMessageContext.getProperty("weblogic.wsee.ackstoanon"))) {
                endpointReference = addressingProvider.createAnonymousEndpointReference();
            } else {
                endpointReference = this.getAsyncResponseEPR(wlMessageContext, string, addressingProvider);
                if (endpointReference.getReferenceParameters().getHeader(ServiceIdentityHeader.TYPE) == null) {
                    serializable = new ServiceIdentityHeader();
                    ((ServiceIdentityHeader)serializable).setServerName(LocalServerIdentity.getIdentity().getServerName());
                    ((ServiceIdentityHeader)serializable).setServiceName("weblogic.wsee.conversation.msg.cluster.service");
                    endpointReference.getReferenceParameters().addHeader((MsgHeader)serializable);
                }
            }
        }
        serializable = new WsrmSequenceContext();
        WsrmConstants.RMVersion rMVersion = (WsrmConstants.RMVersion)((Object)wlMessageContext.getProperty("weblogic.wsee.wsrm.RMVersion"));
        if (rMVersion == null) {
            throw new JAXRPCException("No RMVersion set on request message context when sending first message of a sequence.");
        }
        ((WsrmSequenceContext)serializable).setRmVersion(rMVersion);
        ((WsrmSequenceContext)serializable).setWsaVersion(AddressingHelper.getWSAVersion(wlMessageContext));
        ((WsrmSequenceContext)serializable).setWsrmSecurityContext(wsrmSecurityContext);
        ((WsrmSequenceContext)serializable).setAcksTo(endpointReference);
        if (AsyncUtil.isSoap12(wlMessageContext)) {
            ((WsrmSequenceContext)serializable).setSoap12(true);
        }
        ((WsrmSequenceContext)serializable).setFailTo((EndpointReference)wlMessageContext.getProperty("weblogic.wsee.failto"));
        ((WsrmSequenceContext)serializable).setSecuritySubject(ClusterUtil.getSubject((AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction())));
        ((WsrmSequenceContext)serializable).setTransportInfo((TransportInfo)wlMessageContext.getProperty("weblogic.wsee.connection.transportinfo"));
        if (wlMessageContext.containsProperty("weblogic.wsee.addressing.From")) {
            ((WsrmSequenceContext)serializable).setFrom((EndpointReference)wlMessageContext.getProperty("weblogic.wsee.addressing.From"));
        }
        if (wlMessageContext.containsProperty("weblogic.wsee.reliability.TestSequenceSSL")) {
            byte[] byArray;
            String string2 = (String)wlMessageContext.getProperty("weblogic.wsee.reliability.TestSequenceSSL");
            try {
                byArray = string2.getBytes("UTF-8");
            }
            catch (Exception exception) {
                throw new JAXRPCException(exception.toString(), (Throwable)exception);
            }
            if (verbose) {
                Verbose.say("");
                Verbose.say("%%%%%%%%%%%%%%%%%%%%% *FORCING* SSL/TLS Session ID on sending-side sequence %%%%%%%%%%");
                Verbose.say(WsrmSAFManager.dumpByteArray(byArray));
                Verbose.say("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
                Verbose.say("");
            }
            ((WsrmSequenceContext)serializable).getWsrmSecurityContext().setSSLSessionId(byArray);
            ((WsrmSequenceContext)serializable).getWsrmSecurityContext().setForcedSSLSessionId(true);
        }
        sAFConversationInfo.setContext((Externalizable)serializable);
        sAFConversationInfo.setSourceURL(endpointReference.getAddress());
    }

    private EndpointReference getAsyncResponseEPR(WlMessageContext wlMessageContext, String string, AddressingProvider addressingProvider) {
        EndpointReference endpointReference;
        if (wlMessageContext.containsProperty("weblogic.wsee.async.res.epr")) {
            endpointReference = (EndpointReference)wlMessageContext.getProperty("weblogic.wsee.async.res.epr");
            endpointReference.setNamespaceURI(addressingProvider.getNamespaceURI());
        } else {
            endpointReference = addressingProvider.createEndpointReference(this.getAsyncAddress(string, AsyncUtil.isSoap12(wlMessageContext)));
        }
        return endpointReference;
    }

    private void setupSAFConversationOffer(WlMessageContext wlMessageContext, String string, SAFConversationInfo sAFConversationInfo) {
        WsrmConstants.RMVersion rMVersion = (WsrmConstants.RMVersion)((Object)wlMessageContext.getProperty("weblogic.wsee.wsrm.RMVersion"));
        if (rMVersion == null) {
            throw new JAXRPCException("No RMVersion set on request message context when sending first message of a sequence.");
        }
        if (!this.checkOfferNeeded(wlMessageContext, rMVersion)) {
            return;
        }
        SAFConversationInfoImpl sAFConversationInfoImpl = new SAFConversationInfoImpl(2);
        this.setupOfferDestination(wlMessageContext, sAFConversationInfo, sAFConversationInfoImpl);
        this.setupOfferName(wlMessageContext, sAFConversationInfoImpl);
        sAFConversationInfoImpl.setSourceURL(string);
        sAFConversationInfoImpl.setQOS(sAFConversationInfo.getQOS());
        sAFConversationInfoImpl.setDynamic(false);
        sAFConversationInfoImpl.setInorder(sAFConversationInfo.isInorder());
        sAFConversationInfoImpl.setDestinationType(2);
        sAFConversationInfoImpl.setTransportType(2);
        sAFConversationInfoImpl.setTimeoutPolicy(2);
        sAFConversationInfoImpl.setMaximumIdleTime(sAFConversationInfo.getMaximumIdleTime());
        this.setupOfferTTL(wlMessageContext, sAFConversationInfoImpl);
        sAFConversationInfo.setConversationOffer(sAFConversationInfoImpl);
    }

    private void setupOfferTTL(WlMessageContext wlMessageContext, SAFConversationInfo sAFConversationInfo) {
        Duration duration = (Duration)wlMessageContext.getProperty("weblogic.wsee.wsrm.offer.sequence.expiration");
        if (duration != null) {
            this.setupSAFConversationTTL(duration, sAFConversationInfo);
        } else {
            Duration duration2 = this.getSequenceExpirationFromContext(wlMessageContext);
            this.setupSAFConversationTTL(duration2, sAFConversationInfo);
        }
    }

    private void setupOfferName(WlMessageContext wlMessageContext, SAFConversationInfo sAFConversationInfo) {
        String string = (String)wlMessageContext.getProperty("weblogic.wsee.offer.sequence.id");
        if (string == null || string.equals("PendingOfferSeqId")) {
            string = this.generateSequenceId();
        }
        sAFConversationInfo.setConversationName(string);
    }

    private void setupOfferDestination(WlMessageContext wlMessageContext, SAFConversationInfo sAFConversationInfo, SAFConversationInfo sAFConversationInfo2) {
        ReplyToHeader replyToHeader = (ReplyToHeader)wlMessageContext.getHeaders().getHeader(ReplyToHeader.TYPE);
        assert (replyToHeader != null);
        EndpointReference endpointReference = replyToHeader.getReference();
        String string = endpointReference.getAddress();
        AddressingProvider addressingProvider = AddressingProviderFactory.getInstance().getAddressingProvider(wlMessageContext);
        if (addressingProvider.isAnonymousReferenceURI(string)) {
            string = this.getAsyncResponseEPR(wlMessageContext, sAFConversationInfo.getDestinationURL(), addressingProvider).getAddress();
        }
        sAFConversationInfo2.setDestinationURL(string);
    }

    private void verifyOrRegisterSAFConversationInfo(SequenceIdInfo sequenceIdInfo, String string, WlMessageContext wlMessageContext, String string2) {
        Object object;
        SAFConversationInfo sAFConversationInfo;
        try {
            sAFConversationInfo = safManager.getCachedConversationInfoOnSendingSide(sequenceIdInfo.seqId);
        }
        catch (SAFException sAFException) {
            throw new JAXRPCException((Throwable)sAFException);
        }
        if (sAFConversationInfo != null) {
            return;
        }
        if (sequenceIdInfo.preExisting) {
            SAFConversationNotAvailException sAFConversationNotAvailException = new SAFConversationNotAvailException("Conversation " + sequenceIdInfo.seqId + " was specified directly by the client, but has expired or has been terminated or destroyed. Please use a new conversation name.");
            sAFConversationNotAvailException.fillInStackTrace();
            throw new JAXRPCException(sAFConversationNotAvailException.toString(), (Throwable)sAFConversationNotAvailException);
        }
        if (verbose) {
            Verbose.log("** RM doing top-level register for SAF conversation (on sending side) in response to action '" + string2 + "' for sequence " + sequenceIdInfo.seqId);
        }
        sAFConversationInfo = this.createSAFConversationInfo(sequenceIdInfo.seqId, string, wlMessageContext);
        try {
            object = safManager.registerConversationOnSendingSide(sAFConversationInfo);
            assert (sequenceIdInfo.seqId.equals(object));
        }
        catch (SAFException sAFException) {
            if (verbose) {
                Verbose.logException(sAFException);
            }
            throw new JAXRPCException("Failed to register sequence", (Throwable)sAFException);
        }
        if (sAFConversationInfo.getConversationOffer() != null) {
            object = sAFConversationInfo.getConversationOffer().getConversationName();
            Map map = (Map)wlMessageContext.getProperty("weblogic.wsee.invoke_properties");
            map.put("weblogic.wsee.offer.sequence.id", object);
            if (verbose) {
                MessageIdHeader messageIdHeader = (MessageIdHeader)wlMessageContext.getHeaders().getHeader(MessageIdHeader.TYPE);
                Verbose.log("Stored offer seq ID on invokeProperties for msg ID '" + messageIdHeader.getMessageId() + "' as: " + (String)object);
            }
        } else {
            object = (Map)wlMessageContext.getProperty("weblogic.wsee.invoke_properties");
            object.put("weblogic.wsee.offer.sequence.id", null);
            if (verbose) {
                MessageIdHeader messageIdHeader = (MessageIdHeader)wlMessageContext.getHeaders().getHeader(MessageIdHeader.TYPE);
                Verbose.log("Clearing pending offer seq ID from invokeProperties for msg ID '" + messageIdHeader.getMessageId() + "'");
            }
        }
    }

    void storeAndForward(WlMessageContext wlMessageContext) {
        Object object;
        SAFConversationInfo sAFConversationInfo;
        Object object2;
        long l = System.nanoTime();
        if (verbose) {
            Verbose.say(l + " :Entering WsrmSAFSendingManager.storeAndForward(WlMessageContext)");
        }
        SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)wlMessageContext;
        if (verbose) {
            Verbose.say(l + " :Inside WsrmSAFSendingManager.storeAndForward(WlMessageContext) == 0");
        }
        MsgHeaders msgHeaders = wlMessageContext.getHeaders();
        if (verbose) {
            Verbose.say(l + " :Inside WsrmSAFSendingManager.storeAndForward(WlMessageContext) == 0.1");
        }
        ToHeader toHeader = (ToHeader)msgHeaders.getHeader(ToHeader.TYPE);
        if (verbose) {
            Verbose.say(l + " :Inside WsrmSAFSendingManager.storeAndForward(WlMessageContext) == 0.2");
        }
        String string = toHeader.getAddress();
        if (verbose) {
            Verbose.say(l + " :Inside WsrmSAFSendingManager.storeAndForward(WlMessageContext) == 0.3");
        }
        MessageIdHeader messageIdHeader = (MessageIdHeader)msgHeaders.getHeader(MessageIdHeader.TYPE);
        if (verbose) {
            Verbose.say(l + " :Inside WsrmSAFSendingManager.storeAndForward(WlMessageContext) == 0.4");
        }
        String string2 = messageIdHeader.getMessageId();
        if (verbose) {
            Verbose.say(l + " :Inside WsrmSAFSendingManager.storeAndForward(WlMessageContext) == 1");
        }
        Map map = this.getInvokeProperties(wlMessageContext);
        if (verbose) {
            Verbose.say(l + " :Inside WsrmSAFSendingManager.storeAndForward(WlMessageContext) == 1.1");
        }
        SequenceIdInfo sequenceIdInfo = this.getSequenceId(map, wlMessageContext);
        String string3 = sequenceIdInfo.seqId;
        String string4 = "Unknown";
        if (wlMessageContext.containsProperty("weblogic.wsee.addressing.Action")) {
            string4 = (String)wlMessageContext.getProperty("weblogic.wsee.addressing.Action");
            if (verbose) {
                Verbose.say(l + " :Inside WsrmSAFSendingManager.storeAndForward(WlMessageContext) == 1.2");
            }
        } else {
            object2 = (ActionHeader)((SoapMessageContext)sOAPMessageContext).getHeaders().getHeader(ActionHeader.TYPE);
            if (object2 != null) {
                string4 = ((ActionHeader)object2).getActionURI();
            }
            if (verbose) {
                Verbose.say(l + " :Inside WsrmSAFSendingManager.storeAndForward(WlMessageContext) == 1.3");
            }
        }
        if (wlMessageContext.getProperty("weblogic.wsee.async.res") == null) {
            this.verifyOrRegisterSAFConversationInfo(sequenceIdInfo, string, wlMessageContext, string4);
        } else {
            if (verbose) {
                Verbose.say(l + " :Inside WsrmSAFSendingManager.storeAndForward(WlMessageContext) == 2");
            }
            if ((object2 = (String)wlMessageContext.getProperty("weblogic.wsee.reliability.RequestMessageSeqNumber")) != null) {
                if (verbose) {
                    Verbose.say(l + " :Inside WsrmSAFSendingManager.storeAndForward(WlMessageContext) == 3");
                }
                sAFConversationInfo = WsrmSAFSendingManager.getConversationInfo(true, sequenceIdInfo.seqId, false);
                if (verbose) {
                    Verbose.say(l + " :Inside WsrmSAFSendingManager.storeAndForward(WlMessageContext) == 4");
                }
                if (sAFConversationInfo != null) {
                    object = sAFConversationInfo.getConversationName();
                    long l2 = Long.parseLong((String)object2);
                    WsrmSequenceContext wsrmSequenceContext = (WsrmSequenceContext)sAFConversationInfo.getContext();
                    if (verbose) {
                        String string5 = "normal";
                        if (wlMessageContext.containsProperty("weblogic.wsee.conversation.AsyncConvId")) {
                            string5 = "conversation ID";
                        }
                        Verbose.say(l + " :*** Doing 'pre-SAF send' mapping of request to " + string + " action(" + string4 + ") with SeqNum " + l2 + " to " + string5 + " -1 on offer sequence " + (String)object);
                    }
                    wsrmSequenceContext.mapRequestSeqNumToResponseSeqNum(l2, -1L);
                    try {
                        if (verbose) {
                            Verbose.say(l + " :Inside WsrmSAFSendingManager.storeAndForward(WlMessageContext) == 5");
                        }
                        SAFManagerImpl.getManager().storeConversationContextOnSendingSide((String)object, wsrmSequenceContext);
                        if (verbose) {
                            Verbose.say(l + " :Inside WsrmSAFSendingManager.storeAndForward(WlMessageContext) == 6");
                        }
                    }
                    catch (Exception exception) {
                        if (verbose) {
                            Verbose.say(l + " :Inside WsrmSAFSendingManager.storeAndForward(WlMessageContext) == 6.1\n");
                            Verbose.logException(exception);
                        }
                        throw new JAXRPCException(exception.toString(), (Throwable)exception);
                    }
                }
            }
        }
        if (verbose) {
            object2 = "Unknown";
            try {
                if (verbose) {
                    Verbose.say(l + " :Inside WsrmSAFSendingManager.storeAndForward(WlMessageContext) == 7");
                }
                if ((sAFConversationInfo = this.getConversationInfo(true, string3)) != null && sAFConversationInfo.getDynamicConversationName() != null) {
                    object2 = sAFConversationInfo.getDynamicConversationName();
                }
                if (verbose) {
                    Verbose.say(l + " :Inside WsrmSAFSendingManager.storeAndForward(WlMessageContext) == 8");
                }
            }
            catch (Exception exception) {
                if (verbose) {
                    Verbose.say(l + " :Inside WsrmSAFSendingManager.storeAndForward(WlMessageContext) == 8.1");
                }
                Verbose.logException(exception);
            }
            Verbose.log(l + " :SendingManager sending reliable message with action '" + string4 + "' and " + (sequenceIdInfo.preExisting ? "pre-existing" : "new") + " sender side sequence ID " + string3 + " receiver side sequence ID " + (String)object2 + " to " + string);
        }
        object2 = this.createSequenceHeader(string3, wlMessageContext, msgHeaders);
        if (verbose) {
            Verbose.say(l + " :Inside WsrmSAFSendingManager.storeAndForward(WlMessageContext) == 8.2");
        }
        sAFConversationInfo = WsrmSAFSendingManager.getConversationInfo(true, string3, false);
        if (verbose) {
            Verbose.say(l + " :Inside WsrmSAFSendingManager.storeAndForward(WlMessageContext) == 8.3");
        }
        object = (WsrmSequenceContext)sAFConversationInfo.getContext();
        if (verbose) {
            Verbose.say(l + " :Inside WsrmSAFSendingManager.storeAndForward(WlMessageContext) == 8.4");
        }
        if (this.checkForSequenceClosed(sOAPMessageContext, string3, (WsrmSequenceContext)object)) {
            SOAPFault sOAPFault;
            Object object3;
            try {
                object3 = sOAPMessageContext.getMessage().getSOAPBody();
                sOAPFault = object3.getFault();
            }
            catch (Exception exception) {
                if (verbose) {
                    Verbose.say(l + " :Inside WsrmSAFSendingManager.storeAndForward(WlMessageContext) == 8.5\n");
                    Verbose.logException(exception);
                }
                throw new JAXRPCException("Cannot send messages on a closed sequence");
            }
            object3 = new SOAPFaultException(sOAPFault.getFaultCodeAsQName(), sOAPFault.getFaultString(), sOAPFault.getFaultActor(), sOAPFault.getDetail());
            if (verbose) {
                Verbose.say(l + " :Inside WsrmSAFSendingManager.storeAndForward(WlMessageContext) == 8.6\n");
                Verbose.logException((Throwable)object3);
            }
            throw object3;
        }
        if (verbose) {
            Verbose.say(l + " :Inside WsrmSAFSendingManager.storeAndForward(WlMessageContext) == 9");
        }
        SAFRequest sAFRequest = this.createSAFRequest((SequenceHeader)object2, string2, sOAPMessageContext, (WsrmSequenceContext)object);
        if (verbose) {
            Verbose.say(l + " :Inside WsrmSAFSendingManager.storeAndForward(WlMessageContext) == 10");
        }
        this.checkConversationProtocolMsg(sOAPMessageContext, sAFRequest, map);
        try {
            if (verbose) {
                Verbose.say(l + " :Inside WsrmSAFSendingManager.storeAndForward(WlMessageContext) == 11");
            }
            safManager.send(sAFRequest);
            if (verbose) {
                Verbose.say(l + " :Inside WsrmSAFSendingManager.storeAndForward(WlMessageContext) == 12");
            }
        }
        catch (SAFException sAFException) {
            if (verbose) {
                Verbose.say(l + " :Inside WsrmSAFSendingManager.storeAndForward(WlMessageContext) == 13\n");
                Verbose.logException(sAFException);
            }
            throw new JAXRPCException(sAFException.toString(), (Throwable)sAFException);
        }
    }

    private void checkConversationProtocolMsg(SOAPMessageContext sOAPMessageContext, SAFRequest sAFRequest, Map map) {
        if (sOAPMessageContext.getProperty("weblogic.wsee.conversation.waitid") != null) {
            ((WsrmPayloadContext)sAFRequest.getPayloadContext()).setWaitForConversationId(true);
        }
        if (map.get("weblogic.wsee.conversation.key") != null) {
            ((WsrmPayloadContext)sAFRequest.getPayloadContext()).setConversationKey((String)map.get("weblogic.wsee.conversation.key"));
            if (sOAPMessageContext.getProperty("weblogic.wsee.conversation.ConversationPhase") == ConversationPhase.START) {
                ((WsrmPayloadContext)sAFRequest.getPayloadContext()).setStartConversation(true);
            }
        }
    }

    private SequenceHeader createSequenceHeader(String string, WlMessageContext wlMessageContext, MsgHeaders msgHeaders) {
        SAFConversationInfo sAFConversationInfo = WsrmSAFSendingManager.getConversationInfo(true, string, false);
        WsrmSequenceContext wsrmSequenceContext = (WsrmSequenceContext)sAFConversationInfo.getContext();
        SequenceHeader sequenceHeader = new SequenceHeader(wsrmSequenceContext.getRmVersion());
        sequenceHeader.setMessageNumber(-1L);
        sequenceHeader.setSequenceId(string);
        if (wsrmSequenceContext.getRmVersion() == WsrmConstants.RMVersion.RM_10) {
            if ("true".equals(wlMessageContext.getProperty("weblogic.wsee.lastmessage"))) {
                sequenceHeader.setLastMessage(true);
            } else {
                sequenceHeader.setLastMessage(false);
            }
        }
        msgHeaders.addHeader(sequenceHeader);
        return sequenceHeader;
    }

    private Map getInvokeProperties(WlMessageContext wlMessageContext) {
        Map map = (Map)wlMessageContext.getProperty("weblogic.wsee.invoke_properties");
        if (map == null) {
            map = new ConcurrentHashMap();
            wlMessageContext.setProperty("weblogic.wsee.invoke_properties", map);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SequenceIdInfo getSequenceId(Map map, WlMessageContext wlMessageContext) {
        SequenceIdInfo sequenceIdInfo = new SequenceIdInfo();
        sequenceIdInfo.preExisting = true;
        Map map2 = map;
        synchronized (map2) {
            sequenceIdInfo.seqId = (String)wlMessageContext.getProperty("weblogic.wsee.sequenceid");
            if (sequenceIdInfo.seqId == null) {
                sequenceIdInfo.seqId = (String)map.get("weblogic.wsee.sequenceid");
            }
            if (sequenceIdInfo.seqId == null || sequenceIdInfo.seqId.equals("PendingSeqId")) {
                sequenceIdInfo.seqId = this.generateSequenceId();
                sequenceIdInfo.preExisting = false;
            }
            map.put("weblogic.wsee.sequenceid", sequenceIdInfo.seqId);
            if (verbose) {
                MessageIdHeader messageIdHeader = (MessageIdHeader)wlMessageContext.getHeaders().getHeader(MessageIdHeader.TYPE);
                Verbose.say("Stored main sequence ID on invokeProperties for msg ID '" + messageIdHeader.getMessageId() + "' as: " + sequenceIdInfo.seqId);
            }
        }
        return sequenceIdInfo;
    }

    public void handleAck(AcknowledgementHeader acknowledgementHeader, SOAPMessageContext sOAPMessageContext, boolean bl) {
        WsLifeCycleListenerRegistry.getInstance().onEvent(WsLifeCycleEvent.WSRM_SEND_AFTER_VALIDATE_ACK_BEFORE_SAVE);
        String string = acknowledgementHeader.getSequenceId();
        EndpointReference endpointReference = (EndpointReference)sOAPMessageContext.getProperty("weblogic.wsee.addressing.FaultTo");
        assert (endpointReference != null);
        String string2 = endpointReference.getAddress();
        boolean bl2 = AddressingProviderFactory.getInstance().getAddressingProvider((MessageContext)sOAPMessageContext).isAnonymousReferenceURI(string2);
        if (!bl && !bl2) {
            AddressingUtil.confirmOneway((WlMessageContext)sOAPMessageContext);
        }
        try {
            Iterator iterator = acknowledgementHeader.listMessageRanges();
            while (iterator.hasNext()) {
                MessageRange messageRange = (MessageRange)iterator.next();
                if (verbose) {
                    Verbose.log("Calling ack " + messageRange.lowerBounds + " - " + messageRange.upperBounds);
                }
                safManager.acknowledge(string, messageRange.lowerBounds, messageRange.upperBounds);
            }
        }
        catch (SAFException sAFException) {
            block13: {
                if (verbose) {
                    Verbose.logException(sAFException);
                }
                if (bl && bl2) {
                    return;
                }
                try {
                    SAFConversationInfo sAFConversationInfo = WsrmSAFSendingManager.getConversationInfo(true, string, false);
                    WsrmSequenceContext wsrmSequenceContext = (WsrmSequenceContext)sAFConversationInfo.getContext();
                    InvalidAckFaultMsg invalidAckFaultMsg = new InvalidAckFaultMsg(wsrmSequenceContext.getRmVersion());
                    invalidAckFaultMsg.setSequenceId(string);
                    invalidAckFaultMsg.setAcknowledgementRanges(acknowledgementHeader.getAcknowledgementRanges());
                    if (!bl) {
                        WsrmHelper.sendFault(sOAPMessageContext, invalidAckFaultMsg, wsrmSequenceContext.getAcksTo());
                        return;
                    }
                    WsrmSequenceSender.sendFault(string, (WsrmSequenceContext)sAFConversationInfo.getContext(), endpointReference, invalidAckFaultMsg, AsyncUtil.isSoap12((MessageContext)sOAPMessageContext));
                }
                catch (SAFException sAFException2) {
                    if (!verbose) break block13;
                    Verbose.logException(sAFException2);
                }
            }
            return;
        }
        if (!bl) {
            sOAPMessageContext.setProperty("weblogic.wsee.reliable.oneway.msg", (Object)"true");
            if (bl2) {
                AddressingUtil.confirmOneway((WlMessageContext)sOAPMessageContext);
            }
        }
    }

    public void ackRequest(WlMessageContext wlMessageContext) {
        block9: {
            SAFConversationInfo sAFConversationInfo;
            String string = (String)wlMessageContext.getProperty("weblogic.wsee.sequenceid");
            try {
                sAFConversationInfo = safManager.getCachedConversationInfoOnSendingSide(string);
            }
            catch (SAFException sAFException) {
                throw new JAXRPCException((Throwable)sAFException);
            }
            if (sAFConversationInfo == null) {
                if (verbose) {
                    Verbose.log("Cannot find conversation info for sequence " + string);
                }
                return;
            }
            try {
                AcknowledgementHeader acknowledgementHeader = WsrmSequenceSender.ackRequest(sAFConversationInfo);
                if (verbose) {
                    if (acknowledgementHeader != null) {
                        Verbose.log(acknowledgementHeader.toString());
                    } else {
                        Verbose.log("Received null ack header, it will be sent back asynchronously");
                    }
                }
            }
            catch (SAFTransportException sAFTransportException) {
                if (!verbose) break block9;
                Verbose.logException(sAFTransportException);
            }
        }
    }

    public void handleAsyncFault(String string, String string2, Exception exception) {
        block3: {
            SAFConversationInfo sAFConversationInfo = this.getConversationInfo(true, string);
            if (sAFConversationInfo != null) {
                try {
                    safManager.handleAsyncFault(sAFConversationInfo.getConversationName(), string2, exception);
                }
                catch (SAFException sAFException) {
                    if (!verbose) break block3;
                    Verbose.logException(sAFException);
                }
            }
        }
    }

    public void handleCreateSequenceRefusedError(String string) {
        block4: {
            if (verbose) {
                Verbose.log("CreateSequenceRefusedFault: receiver refuse to create a sequence for message " + string);
            }
            try {
                SAFConversationInfo sAFConversationInfo = this.getConversationInfo(true, string);
                if (sAFConversationInfo != null) {
                    safManager.closeConversationOnSendingSide(sAFConversationInfo.getConversationName(), true);
                }
            }
            catch (SAFException sAFException) {
                if (!verbose) break block4;
                Verbose.logException(sAFException);
            }
        }
    }

    public void handleFault(SequenceFaultMsg sequenceFaultMsg) {
        block19: {
            SequenceFaultMsgType sequenceFaultMsgType = sequenceFaultMsg.getType();
            try {
                if (UnknownSequenceFaultMsg.TYPE.equals(sequenceFaultMsgType)) {
                    if (verbose) {
                        Verbose.log("UnknownSequenceFault: receiver received unknown sequence " + sequenceFaultMsg.getSequenceId());
                    }
                } else if (SequenceRefusedFaultMsg.TYPE.equals(sequenceFaultMsgType)) {
                    if (verbose) {
                        Verbose.log("SequenceRefusedFault: sequence " + sequenceFaultMsg.getSequenceId() + " has been refused.");
                    }
                    safManager.closeConversationOnSendingSide(sequenceFaultMsg.getSequenceId(), true);
                } else if (SequenceTerminatedFaultMsg.TYPE.equals(sequenceFaultMsgType)) {
                    if (verbose) {
                        Verbose.log("SequenceTerminatedFault: sequence " + sequenceFaultMsg.getSequenceId() + " has been terminated on the receiving side.");
                    }
                    safManager.closeConversationOnSendingSide(sequenceFaultMsg.getSequenceId(), true);
                } else if (LastMessageNumExceededFaultMsg.TYPE.equals(sequenceFaultMsgType)) {
                    if (verbose) {
                        Verbose.log("LastMessageNumExceededFault: receiver received a message  that exceeds the last message number for sequence " + sequenceFaultMsg.getSequenceId());
                    }
                    safManager.closeConversationOnSendingSide(sequenceFaultMsg.getSequenceId(), true);
                } else if (IllegalRMVersionFaultMsg.TYPE.equals(sequenceFaultMsgType)) {
                    SAFConversationInfo sAFConversationInfo;
                    String string = sequenceFaultMsg.getSequenceId();
                    if (verbose) {
                        Verbose.log("IllegalRMVersionFault: receiver received a message  with an unexpected RM version for sequence " + string);
                    }
                    if ((sAFConversationInfo = this.getConversationInfo(true, string)) != null) {
                        safManager.closeConversationOnSendingSide(sAFConversationInfo.getConversationName(), true);
                    }
                } else if (verbose) {
                    Verbose.log("SequenceFaultMsg: " + sequenceFaultMsg.getSubCodeQName() + " " + sequenceFaultMsg.getReason());
                }
            }
            catch (SAFException sAFException) {
                if (!verbose) break block19;
                Verbose.logException(sAFException);
            }
        }
    }

    public void createSequenceResponse(SOAPMessageContext sOAPMessageContext, CreateSequenceResponseMsg createSequenceResponseMsg) {
        String string = (String)sOAPMessageContext.getProperty("weblogic.wsee.addressing.RelatesTo");
        AddressingUtil.confirmOneway((WlMessageContext)sOAPMessageContext);
        SAFConversationInfo sAFConversationInfo = WsrmSAFSendingManager.getConversationInfo(true, string, true);
        if (sAFConversationInfo == null) {
            throw new JAXRPCException("Unknown create sequence response message. Sequence " + string);
        }
        if (sAFConversationInfo.getDynamicConversationName() != null) {
            if (verbose) {
                Verbose.log("Got duplicate create sequence response. Receiving side seq id is already set to " + sAFConversationInfo.getDynamicConversationName() + ". Ignoring.");
            }
            return;
        }
        WsrmSequenceContext wsrmSequenceContext = (WsrmSequenceContext)sAFConversationInfo.getContext();
        EndpointReference endpointReference = (EndpointReference)sOAPMessageContext.getProperty("weblogic.wsee.addressing.From");
        if (endpointReference != null && !AddressingProviderFactory.getInstance().getAddressingProvider((MessageContext)sOAPMessageContext).isAnonymousReferenceURI(endpointReference.getAddress())) {
            wsrmSequenceContext.setDestination(endpointReference);
        }
        SAFConversationInfo sAFConversationInfo2 = sAFConversationInfo.getConversationOffer();
        if (verbose) {
            Verbose.log("** Processing CreateSequenceResponse for sequence " + sAFConversationInfo.getConversationName() + (sAFConversationInfo2 != null ? " offer sequence " + sAFConversationInfo2.getConversationName() : null) + " receiver side sequence " + createSequenceResponseMsg.getSequenceId());
        }
        String string2 = createSequenceResponseMsg.getSequenceId();
        this.setOfferSequenceContext(createSequenceResponseMsg, sAFConversationInfo2, wsrmSequenceContext, (WlMessageContext)sOAPMessageContext);
        Duration duration = createSequenceResponseMsg.getExpires();
        long l = Long.MAX_VALUE;
        if (duration != null) {
            l = duration.getTimeInMillis(new Date());
        }
        WsLifeCycleListenerRegistry.getInstance().onEvent(WsLifeCycleEvent.WSRM_SEND_AFTER_CREATE_SEQ_RES_BEFORE_RM);
        SAFConversationHandleImpl sAFConversationHandleImpl = new SAFConversationHandleImpl(string2, l, sAFConversationInfo.getMaximumIdleTime(), sAFConversationInfo2, string, sAFConversationInfo.getContext());
        try {
            safManager.createConversationSucceeded(sAFConversationHandleImpl);
        }
        catch (SAFException sAFException) {
            throw new JAXRPCException((Throwable)sAFException);
        }
        WsLifeCycleListenerRegistry.getInstance().onEvent(WsLifeCycleEvent.WSRM_SEND_AFTER_RM_BEFORE_SEND);
    }

    private void setOfferSequenceContext(CreateSequenceResponseMsg createSequenceResponseMsg, SAFConversationInfo sAFConversationInfo, WsrmSequenceContext wsrmSequenceContext, WlMessageContext wlMessageContext) {
        SequenceAccept sequenceAccept = createSequenceResponseMsg.getAccept();
        if (sequenceAccept != null) {
            EndpointReference endpointReference = sequenceAccept.getAcksTo();
            if (sAFConversationInfo != null) {
                WsrmSequenceContext wsrmSequenceContext2 = new WsrmSequenceContext();
                wsrmSequenceContext2.setWsaVersion(wsrmSequenceContext.getWsaVersion());
                wsrmSequenceContext2.setRmVersion(wsrmSequenceContext.getRmVersion());
                wsrmSequenceContext2.setSoap12(wsrmSequenceContext.isSoap12());
                wsrmSequenceContext2.setFrom(wsrmSequenceContext.getFrom());
                wsrmSequenceContext2.setAcksTo(endpointReference);
                wsrmSequenceContext2.setWsrmSecurityContext(new WsrmSecurityContext(wsrmSequenceContext.getWsrmSecurityContext()));
                wsrmSequenceContext2.setTransportInfo(wsrmSequenceContext.getTransportInfo());
                if (wsrmSequenceContext.isSecureWithSSL()) {
                    WsrmSAFSendingManager.setSSLSessionIdFromContext(wlMessageContext, wsrmSequenceContext2.getWsrmSecurityContext(), true);
                }
                sAFConversationInfo.setContext(wsrmSequenceContext2);
                if (wsrmSequenceContext.getDestination() == null) {
                    wsrmSequenceContext.setDestination(endpointReference);
                }
            }
        }
    }

    public void handleCloseSequenceResponse(CloseSequenceResponseMsg closeSequenceResponseMsg) {
        super.handleCloseSequenceResponse(true, closeSequenceResponseMsg);
    }

    public void handleTerminateSequenceResponse(TerminateSequenceResponseMsg terminateSequenceResponseMsg) {
        super.handleTerminateSequenceResponse(true, terminateSequenceResponseMsg);
    }

    private class SequenceIdInfo {
        String seqId;
        boolean preExisting;

        private SequenceIdInfo() {
        }
    }
}

