/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability;

import java.io.Externalizable;
import weblogic.messaging.saf.SAFConversationHandle;
import weblogic.messaging.saf.SAFConversationInfo;
import weblogic.messaging.saf.SAFErrorAwareTransport;
import weblogic.messaging.saf.SAFRequest;
import weblogic.messaging.saf.SAFResult;
import weblogic.messaging.saf.SAFTransportException;
import weblogic.wsee.reliability.WsrmPermanentTransportException;
import weblogic.wsee.reliability.WsrmReceivingSide;
import weblogic.wsee.reliability.WsrmSequenceSender;
import weblogic.wsee.util.AccessException;
import weblogic.wsee.util.Verbose;

public final class WsrmSAFTransport
implements SAFErrorAwareTransport {
    private int type = 2;
    private static final boolean verbose = Verbose.isVerbose(WsrmSAFTransport.class);

    public void sendResult(SAFResult sAFResult) {
        assert (sAFResult != null);
        WsrmReceivingSide.sendResult(sAFResult);
    }

    public int getType() {
        return this.type;
    }

    public boolean isGapsAllowed() {
        return false;
    }

    public Externalizable send(SAFConversationInfo sAFConversationInfo, SAFRequest sAFRequest) throws SAFTransportException {
        long l = System.nanoTime();
        if (verbose) {
            Verbose.say(l + " Entering WsrmSAFTransport.send(SAFConversationInfo, SAFRequest)");
            Verbose.say(l + " SAFRequest.getSequenceNumber: " + sAFRequest.getSequenceNumber());
            Verbose.say(l + " SAFRequest.getMessageId: " + sAFRequest.getMessageId());
        }
        assert (sAFConversationInfo != null);
        assert (sAFRequest != null);
        return WsrmSequenceSender.send(sAFConversationInfo, sAFRequest);
    }

    public SAFConversationHandle createConversation(SAFConversationInfo sAFConversationInfo) throws SAFTransportException {
        assert (sAFConversationInfo != null);
        return WsrmSequenceSender.createSequence(sAFConversationInfo);
    }

    public void terminateConversation(SAFConversationInfo sAFConversationInfo) throws SAFTransportException {
        assert (sAFConversationInfo != null);
        WsrmSequenceSender.terminateSequence(sAFConversationInfo, true);
    }

    public Externalizable createSecurityToken(SAFConversationInfo sAFConversationInfo) throws SAFTransportException {
        assert (sAFConversationInfo != null);
        return WsrmSequenceSender.createSecurityToken(sAFConversationInfo);
    }

    public boolean isPermanentError(Throwable throwable) {
        long l = System.nanoTime();
        boolean bl = false;
        for (Throwable throwable2 = throwable; throwable2 != null && !bl; throwable2 = throwable2.getCause()) {
            bl = throwable2 instanceof WsrmPermanentTransportException || throwable2 instanceof AccessException;
        }
        if (verbose) {
            Verbose.say(l + " Inside WsrmSAFTransport.isPermanentError(Throwable), Throwable is:\n");
            Verbose.logException(throwable);
            Verbose.say("\n" + l + " Exiting WsrmSAFTransport.isPermanentError(Throwable) with boolean: " + bl);
        }
        return bl;
    }
}

