/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability;

import com.sun.xml.ws.api.message.Packet;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.MessageContext;
import weblogic.wsee.connection.Connection;
import weblogic.wsee.deploy.WsdlAddressInfo;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.message.soap.SoapMessageContext;
import weblogic.wsee.policy.deployment.PolicyURIs;
import weblogic.wsee.policy.deployment.ProviderRegistry;
import weblogic.wsee.policy.deployment.WsdlPolicySubject;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.policy.runtime.PolicyContext;
import weblogic.wsee.reliability.policy.ReliabilityPolicyAssertionsFactory;
import weblogic.wsee.reliability2.sequence.CreateSequencePostSecurityTokenCallback;
import weblogic.wsee.security.policy.WssPolicyUtils;
import weblogic.wsee.security.policy.assertions.SecurityPolicyAssertionFactory;
import weblogic.wsee.security.wss.SecurityPolicySelectionHelper;
import weblogic.wsee.security.wssc.sct.SCCredential;
import weblogic.wsee.security.wssp.SecurityPolicyAssertionInfoFactory;
import weblogic.wsee.security.wst.framework.WSTContext;
import weblogic.wsee.ws.WsMethod;
import weblogic.wsee.ws.WsPort;
import weblogic.wsee.ws.dispatch.Dispatcher;
import weblogic.wsee.wsdl.WsdlBinding;
import weblogic.wsee.wsdl.WsdlBindingOperation;
import weblogic.wsee.wsdl.WsdlDefinitions;
import weblogic.wsee.wsdl.WsdlDocumentation;
import weblogic.wsee.wsdl.WsdlExtension;
import weblogic.wsee.wsdl.WsdlOperation;
import weblogic.wsee.wsdl.WsdlPort;
import weblogic.wsee.wsdl.WsdlPortType;
import weblogic.wsee.wsdl.WsdlService;

public class WsrmSecurityContext
implements Externalizable {
    private static final long serialVersionUID = 662768244501161879L;
    private static final Logger LOGGER = Logger.getLogger(WsrmSecurityContext.class.getName());
    private static final String X509_POLICY = "Sign.xml";
    private static final String WSSC_POLICY = "WsscRmBootstrap.xml";
    private static final int HAS_SERVER_ENCRYPT_CERT = 1;
    private static final int HAS_SERVER_VERIFY_CERT = 2;
    private static final int HAS_SC_CREDENTIAL = 4;
    private static final int HAS_SERVICE_POLICY = 8;
    private static final int HAS_STS_ENDPOINT = 16;
    private static final int HAS_SAML_STS_ENDPOINT = 32;
    private static final int HAS_STS_ENCRYPT_CERT = 64;
    private static final int HAS_WST_CONTEXT = 128;
    private boolean secureWithX509 = false;
    private boolean secureWithWssp10Wssc = false;
    private boolean secureWithWssp12Wssc = false;
    private boolean secureWithWssp12Wssc13 = false;
    private boolean secureWithSSL = false;
    private X509Certificate serverEncryptCert = null;
    private X509Certificate serverVerifyCert = null;
    private X509Certificate stsEncryptCert = null;
    private SCCredential scCredential;
    private WSTContext wstCtx;
    private byte[] sslSessionId;
    private X509Certificate[] sslCertChain;
    private boolean forcedSslSessionId;
    private NormalizedExpression servicePolicy = null;
    private String stsEndpoint = null;
    private String samlStsEndpoint = null;
    private Object samlAttributes = null;
    private Object samlAttributesOnly = null;
    private transient NormalizedExpression cachedExpression = null;
    private transient CreateSequencePostSecurityTokenCallback jaxWsSecurityTokenCallback;
    private static final String[] SERIALIABLE_WST_PROPERTY_NAMES = new String[]{"weblogic.wsee.addressing.From", "weblogic.wsee.addressing.version", "weblogic.wsee.policy.compat.preference", "weblogic.weblogic.wsee.security.policy.WssPolicyCtx", "weblogic.wsee.security.wst_bootstrap_policy", "weblogic.wsee.wst.saml.sts_endpoint_uri", "weblogic.wsee.security.bst.stsEncryptCert", "weblogic.wsee.security.trust_soap_version", "weblogic.wsee.security.wst_onbehalfof_user", "weblogic.wsee.security.trust_version", "weblogic.wsee.security.message_age", "weblogic.wsee.wssc.sct.lifetime", "weblogic.wsee.security.bst.serverEncryptCert", "weblogic.wsee.security.bst.serverVerifyCert", "javax.xml.rpc.session.maintain", "weblogic.wsee.transport.jms.url", "javax.xml.rpc.security.auth.username", "javax.xml.rpc.security.auth.password", "weblogic.wsee.transport.jms.messagetype", "weblogic.wsee.jaxws.framework.jaxrpc.SOAPMessageContext.JAX_WS_RUNTIME", "weblogic.wsee.security.wst.enforceAsyncTrustExchange", "javax.xml.rpc.service.endpoint.address"};
    private static final String[] NON_SERIALIABLE_WST_PROPERTY_NAMES = new String[]{"weblogic.wsee.security.wss.TrustManager", "weblogic.wsee.security.wst_transportinfo", "weblogic.wsee.security.wst_ssladapter", "weblogic.wsee.security.wssc.sct.scCredentialProactiveRequestor", "weblogic.wsee.jaxws.framework.jaxrpc.SOAPMessageContext.ASYNC_CLIENT_FEATURE", "weblogic.wsee.jaxws.framework.jaxrpc.SOAPMessageContext.SERVICE"};
    private boolean requireUpdateWSTCtx = false;

    public WsrmSecurityContext() {
    }

    public WsrmSecurityContext(WsrmSecurityContext wsrmSecurityContext) {
        this.secureWithX509 = wsrmSecurityContext.secureWithX509;
        this.secureWithWssp10Wssc = wsrmSecurityContext.secureWithWssp10Wssc;
        this.secureWithWssp12Wssc = wsrmSecurityContext.secureWithWssp12Wssc;
        this.secureWithWssp12Wssc13 = wsrmSecurityContext.secureWithWssp12Wssc13;
        this.secureWithSSL = wsrmSecurityContext.secureWithSSL;
        this.serverEncryptCert = wsrmSecurityContext.serverEncryptCert;
        this.serverVerifyCert = wsrmSecurityContext.serverVerifyCert;
        this.scCredential = wsrmSecurityContext.scCredential;
        this.wstCtx = wsrmSecurityContext.wstCtx;
        this.sslSessionId = wsrmSecurityContext.sslSessionId;
        this.sslCertChain = wsrmSecurityContext.sslCertChain;
        this.cachedExpression = wsrmSecurityContext.cachedExpression;
        this.servicePolicy = wsrmSecurityContext.servicePolicy;
        this.forcedSslSessionId = wsrmSecurityContext.forcedSslSessionId;
        this.jaxWsSecurityTokenCallback = wsrmSecurityContext.jaxWsSecurityTokenCallback;
        this.stsEndpoint = wsrmSecurityContext.stsEndpoint;
        this.stsEncryptCert = wsrmSecurityContext.stsEncryptCert;
        this.samlStsEndpoint = wsrmSecurityContext.samlStsEndpoint;
    }

    public WsrmSecurityContext(MessageContext messageContext) {
        try {
            this.setSecurityPolicyProperties(messageContext);
        }
        catch (PolicyException policyException) {
            throw new JAXRPCException((Throwable)policyException);
        }
        this.setMessageContextProperties(messageContext);
        messageContext.setProperty("weblogic.wsee.wsrm.security.context", (Object)this);
    }

    public WsrmSecurityContext(NormalizedExpression normalizedExpression, boolean bl) {
        try {
            this.setSecurityPolicyProperties(normalizedExpression, bl);
        }
        catch (PolicyException policyException) {
            throw new JAXRPCException((Throwable)policyException);
        }
    }

    private void setSecurityPolicyProperties(MessageContext messageContext) throws PolicyException {
        WsdlPolicySubject wsdlPolicySubject = WssPolicyUtils.getWsdlPolicySubject(messageContext);
        if (wsdlPolicySubject != null) {
            NormalizedExpression normalizedExpression = PolicyContext.getEndpointPolicy(messageContext);
            boolean bl = messageContext.containsProperty("weblogic.wsee.wsrm.SequenceTransportSecurity");
            this.setSecurityPolicyProperties(normalizedExpression, bl);
        }
    }

    private void setSecurityPolicyProperties(NormalizedExpression normalizedExpression, boolean bl) throws PolicyException {
        SecurityPolicySelectionHelper securityPolicySelectionHelper;
        try {
            securityPolicySelectionHelper = new SecurityPolicySelectionHelper(normalizedExpression, true);
        }
        catch (Exception exception) {
            throw new PolicyException(exception.toString(), exception);
        }
        if (SecurityPolicyAssertionFactory.isWSTEnabled(normalizedExpression)) {
            this.servicePolicy = normalizedExpression;
            this.secureWithWssp10Wssc = true;
        } else if (securityPolicySelectionHelper.secureConversation13Requirement() > 0) {
            this.servicePolicy = normalizedExpression;
            this.secureWithWssp12Wssc13 = true;
        } else if (securityPolicySelectionHelper.secureConversationRequirement() > 0) {
            this.servicePolicy = normalizedExpression;
            this.secureWithWssp12Wssc = true;
        } else if (SecurityPolicyAssertionInfoFactory.hasTransportSecurityPolicy(normalizedExpression) && (ReliabilityPolicyAssertionsFactory.hasSSLTLSPolicy(normalizedExpression) || bl)) {
            this.servicePolicy = normalizedExpression;
            this.secureWithSSL = true;
        } else if (SecurityPolicyAssertionFactory.hasSecurityPolicy(normalizedExpression)) {
            this.secureWithX509 = true;
        }
    }

    private void setMessageContextProperties(MessageContext messageContext) {
        Object object;
        Object object2;
        Object object3 = messageContext.getProperty("weblogic.wsee.security.bst.serverEncryptCert");
        if (object3 != null) {
            if (!(object3 instanceof X509Certificate)) {
                throw new JAXRPCException("weblogic.wsee.security.bst.serverEncryptCert must be an instanceof X509Certificate");
            }
            this.setServerEncryptCert((X509Certificate)object3);
        }
        if ((object2 = messageContext.getProperty("weblogic.wsee.security.bst.serverVerifyCert")) != null) {
            if (!(object2 instanceof X509Certificate)) {
                throw new JAXRPCException("weblogic.wsee.security.bst.serverVerifyCert must be an instanceof X509Certificate");
            }
            this.setServerVerifyCert((X509Certificate)object2);
        }
        if ((object = messageContext.getProperty("weblogic.wsee.security.bst.stsEncryptCert")) != null) {
            if (!(this.stsEncryptCert instanceof X509Certificate)) {
                throw new JAXRPCException("weblogic.wsee.security.bst.stsEncryptCert must be an instanceof X509Certificate");
            }
            this.setStsEncryptCert(this.stsEncryptCert);
        }
        Object object4 = messageContext.getProperty("weblogic.wsee.wst.sts_endpoint_uri");
    }

    public void setStsEndpoint(String string) {
        this.stsEndpoint = string;
    }

    public String getStsEndpoint() {
        return this.stsEndpoint;
    }

    public void setJaxWsSecurityTokenCallback(CreateSequencePostSecurityTokenCallback createSequencePostSecurityTokenCallback) {
        this.jaxWsSecurityTokenCallback = createSequencePostSecurityTokenCallback;
    }

    public void removeCreateSequencePostSecurityTokenCallback() {
        this.jaxWsSecurityTokenCallback = null;
    }

    public Map newInitializedMap() throws PolicyException {
        HashMap hashMap = new HashMap();
        this.setMap(hashMap);
        return hashMap;
    }

    public void setMap(Map map) throws PolicyException {
        map.put("weblogic.weblogic.wsee.security.policy.WssPolicyCtx", WssPolicyUtils.getContext());
        if (this.isSecureWithWssc()) {
            if (this.getSCCredential() != null) {
                map.put("weblogic.wsee.wssc.sct", this.getSCCredential());
            }
            if (this.getWSTContext() != null) {
                map.put("weblogic.wsee.security.wst.framework.WSTContext", this.getWSTContext());
            }
        }
        if (this.getServerEncryptCert() != null) {
            map.put("weblogic.wsee.security.bst.serverEncryptCert", this.getServerEncryptCert());
        }
        if (this.getStsEncryptCert() != null) {
            map.put("weblogic.wsee.security.bst.stsEncryptCert", this.getStsEncryptCert());
        }
        if (this.getServerVerifyCert() != null) {
            map.put("weblogic.wsee.security.bst.serverVerifyCert", this.getServerVerifyCert());
        }
        if (this.jaxWsSecurityTokenCallback != null) {
            map.put(CreateSequencePostSecurityTokenCallback.PROPERTY_NAME, this.jaxWsSecurityTokenCallback);
        }
        if (this.stsEndpoint != null) {
            map.put("weblogic.wsee.wst.sts_endpoint_uri", this.stsEndpoint);
        }
        if (this.samlStsEndpoint != null) {
            map.put("weblogic.wsee.wst.saml.sts_endpoint_uri", this.samlStsEndpoint);
        }
        if (this.samlAttributes != null) {
            map.put("weblogic.wsee.security.saml.attributies", this.samlAttributes);
        }
        if (this.samlAttributesOnly != null) {
            map.put("oracle.contextelement.saml2.AttributeOnly", this.samlAttributesOnly);
        }
    }

    public boolean update(Map map) {
        Object object;
        Serializable serializable;
        boolean bl = false;
        if (map == null) {
            return bl;
        }
        if (this.isSecureWithWssc()) {
            serializable = (SCCredential)map.get("weblogic.wsee.wssc.sct");
            if (this.getSCCredential() == null) {
                this.setSCCredential((SCCredential)serializable);
                bl = true;
            } else if (!this.getSCCredential().getExpires().equals(serializable.getExpires())) {
                this.setSCCredential((SCCredential)serializable);
                bl = true;
            }
            object = (WSTContext)map.get("weblogic.wsee.security.wst.framework.WSTContext");
            if (object != null && !object.equals(this.getWSTContext())) {
                this.setWSTContext((WSTContext)object);
                bl = true;
            }
            this.updateWSTContext(map);
        }
        if ((serializable = (X509Certificate)map.get("weblogic.wsee.security.bst.serverEncryptCert")) != null && this.getServerEncryptCert() == null) {
            this.setServerEncryptCert((X509Certificate)serializable);
            bl = true;
        }
        if ((serializable = (X509Certificate)map.get("weblogic.wsee.security.bst.stsEncryptCert")) != null && this.getStsEncryptCert() == null) {
            this.setServerEncryptCert((X509Certificate)serializable);
            bl = true;
        }
        if ((serializable = (X509Certificate)map.get("weblogic.wsee.security.bst.serverVerifyCert")) != null && this.getServerVerifyCert() == null) {
            this.setServerVerifyCert((X509Certificate)serializable);
            bl = true;
        }
        if (!((object = (String)map.get("weblogic.wsee.wst.sts_endpoint_uri")) == null || this.stsEndpoint != null && ((String)object).equals(this.stsEndpoint))) {
            this.stsEndpoint = object;
            bl = true;
        }
        if (!((object = (String)map.get("weblogic.wsee.wst.sts_endpoint_uri")) == null || this.samlStsEndpoint != null && ((String)object).equals(this.stsEndpoint))) {
            this.samlStsEndpoint = object;
            bl = true;
        }
        return bl;
    }

    public boolean update(Packet packet) {
        if (packet == null) {
            return false;
        }
        Map map = packet.invocationProperties;
        return this.update(map);
    }

    public NormalizedExpression getSecurityPolicy() throws PolicyException {
        if (this.servicePolicy != null) {
            return this.servicePolicy;
        }
        if (this.cachedExpression == null) {
            if (this.secureWithX509) {
                this.cachedExpression = WssPolicyUtils.getPolicy(X509_POLICY);
            } else if (this.secureWithWssp10Wssc) {
                this.cachedExpression = WssPolicyUtils.getPolicy(WSSC_POLICY);
            }
        }
        return this.cachedExpression;
    }

    public boolean isSecure() {
        return this.secureWithWssp10Wssc || this.secureWithX509 || this.secureWithWssp12Wssc || this.secureWithWssp12Wssc13;
    }

    public SCCredential getSCCredential() {
        return this.scCredential;
    }

    public void setSCCredential(SCCredential sCCredential) {
        this.scCredential = sCCredential;
    }

    public WSTContext getWSTContext() {
        return this.wstCtx;
    }

    public void setWSTContext(WSTContext wSTContext) {
        this.wstCtx = wSTContext;
    }

    public byte[] getSSLSessionId() {
        return this.sslSessionId;
    }

    public void setSSLSessionId(byte[] byArray) {
        this.sslSessionId = byArray;
    }

    public void setSSLCertChain(X509Certificate[] x509CertificateArray) {
        this.sslCertChain = x509CertificateArray;
    }

    public X509Certificate[] getSSLCertChain() {
        return this.sslCertChain;
    }

    public boolean isForcedSSLSessionId() {
        return this.forcedSslSessionId;
    }

    public void setForcedSSLSessionId(boolean bl) {
        this.forcedSslSessionId = bl;
    }

    public boolean isSecureWithX509() {
        return this.secureWithX509;
    }

    public void setSecureWithX509(boolean bl) {
        this.secureWithX509 = bl;
    }

    public boolean isSecureWithWssc() {
        return this.secureWithWssp10Wssc || this.secureWithWssp12Wssc || this.secureWithWssp12Wssc13;
    }

    public boolean isSecureWithWssp10Wssc() {
        return this.secureWithWssp10Wssc;
    }

    public boolean isSecureWithWssp12Wssc() {
        return this.secureWithWssp12Wssc;
    }

    public boolean isSecureWithWssp12Wssc13() {
        return this.secureWithWssp12Wssc13;
    }

    public boolean isSecureWithSSL() {
        return this.secureWithSSL;
    }

    public void setSecureWithSSL(boolean bl) {
        this.secureWithSSL = bl;
    }

    public void setServerEncryptCert(X509Certificate x509Certificate) {
        this.serverEncryptCert = x509Certificate;
    }

    public X509Certificate getServerEncryptCert() {
        return this.serverEncryptCert;
    }

    public void setStsEncryptCert(X509Certificate x509Certificate) {
        this.stsEncryptCert = x509Certificate;
    }

    public X509Certificate getStsEncryptCert() {
        return this.stsEncryptCert;
    }

    public void setServerVerifyCert(X509Certificate x509Certificate) {
        this.serverVerifyCert = x509Certificate;
    }

    public X509Certificate getServerVerifyCert() {
        return this.serverVerifyCert;
    }

    public String getSamlStsEndpoint() {
        return this.samlStsEndpoint;
    }

    public void setSamlStsEndpoint(String string) {
        this.samlStsEndpoint = string;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeUTF("10.3+");
        objectOutput.writeBoolean(this.secureWithX509);
        objectOutput.writeBoolean(this.secureWithWssp10Wssc);
        objectOutput.writeBoolean(this.secureWithWssp12Wssc);
        objectOutput.writeBoolean(this.secureWithWssp12Wssc13);
        objectOutput.writeBoolean(this.secureWithSSL);
        if (this.sslSessionId != null) {
            objectOutput.writeInt(this.sslSessionId.length);
            objectOutput.write(this.sslSessionId);
        } else {
            objectOutput.writeInt(0);
        }
        objectOutput.writeBoolean(this.forcedSslSessionId);
        objectOutput.writeObject(this.sslCertChain);
        int n = 0;
        if (this.serverEncryptCert != null) {
            n |= 1;
        }
        if (this.serverVerifyCert != null) {
            n |= 2;
        }
        if (this.scCredential != null) {
            n |= 4;
        }
        if (this.wstCtx != null) {
            n |= 0x80;
        }
        if (this.servicePolicy != null) {
            n |= 8;
        }
        if (this.stsEndpoint != null) {
            n |= 0x10;
        }
        if (this.samlStsEndpoint != null) {
            n |= 0x20;
        }
        if (this.stsEncryptCert != null) {
            n |= 0x40;
        }
        objectOutput.writeInt(n);
        if (this.serverEncryptCert != null) {
            objectOutput.writeObject(this.serverEncryptCert);
        }
        if (this.serverVerifyCert != null) {
            objectOutput.writeObject(this.serverVerifyCert);
        }
        if (this.scCredential != null) {
            objectOutput.writeObject(this.scCredential);
        }
        if (this.wstCtx != null) {
            this.writeWSTContext(objectOutput, this.wstCtx);
        }
        if (this.servicePolicy != null) {
            objectOutput.writeObject(this.servicePolicy);
        }
        if (this.stsEndpoint != null) {
            objectOutput.writeObject(this.stsEndpoint);
        }
        if (this.stsEncryptCert != null) {
            objectOutput.writeObject(this.stsEncryptCert);
        }
        if (this.samlStsEndpoint != null) {
            objectOutput.writeObject(this.samlStsEndpoint);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n;
        String string = objectInput.readUTF();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!"9.2".equals(string)) {
            if ("9.5".equals(string)) {
                bl = true;
            } else if ("10.3".equals(string)) {
                bl2 = true;
            } else if ("10.3+".equals(string)) {
                bl3 = true;
            } else {
                throw new IOException("Unknown/unsupported version found: " + string);
            }
        }
        this.secureWithX509 = objectInput.readBoolean();
        this.secureWithWssp10Wssc = objectInput.readBoolean();
        this.secureWithWssp12Wssc = bl || bl2 || bl3 ? objectInput.readBoolean() : false;
        if (bl2 || bl3) {
            this.secureWithWssp12Wssc13 = objectInput.readBoolean();
            this.secureWithSSL = objectInput.readBoolean();
            n = objectInput.readInt();
            if (n > 0) {
                this.sslSessionId = new byte[n];
                objectInput.readFully(this.sslSessionId);
            }
            this.forcedSslSessionId = objectInput.readBoolean();
        }
        if (bl3) {
            this.sslCertChain = (X509Certificate[])objectInput.readObject();
        }
        if (((n = objectInput.readInt()) & 1) != 0) {
            this.serverEncryptCert = (X509Certificate)objectInput.readObject();
        }
        if ((n & 2) != 0) {
            this.serverVerifyCert = (X509Certificate)objectInput.readObject();
        }
        if ((n & 4) != 0) {
            this.scCredential = (SCCredential)objectInput.readObject();
        }
        if ((n & 0x80) != 0) {
            this.wstCtx = this.readWSTContext(objectInput);
        }
        if ((n & 8) != 0) {
            if (this.secureWithWssp12Wssc13) {
                try {
                    ProviderRegistry.getTheRegistry();
                }
                catch (Exception exception) {
                    throw new IOException("Error doing policy assertion registration: " + exception.toString());
                }
            }
            this.servicePolicy = (NormalizedExpression)objectInput.readObject();
        }
        if ((n & 0x10) != 0) {
            this.stsEndpoint = (String)objectInput.readObject();
        }
        if ((n & 0x40) != 0) {
            this.stsEncryptCert = (X509Certificate)objectInput.readObject();
        }
        if ((n & 0x20) != 0) {
            this.samlStsEndpoint = (String)objectInput.readObject();
        }
    }

    private void writeWSTContext(ObjectOutput objectOutput, WSTContext wSTContext) throws IOException {
        Object object;
        objectOutput.writeObject(wSTContext);
        MessageContext messageContext = wSTContext.getMessageContext();
        SoapMessageContext soapMessageContext = (SoapMessageContext)messageContext;
        objectOutput.writeBoolean(soapMessageContext.isSoap12());
        List list = (List)messageContext.getProperty("weblogic.wsee.security.wss.CredentialProviderList");
        this.writeCredentialProviders(objectOutput, list);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Writes credential provider list while serializing WST context: " + list);
        }
        objectOutput.writeBoolean((object = messageContext.getProperty("weblogic.wsee.security.trust_claim")) != null);
        if (object != null) {
            if (object instanceof Serializable) {
                objectOutput.writeObject(object);
            } else {
                objectOutput.writeObject(new Object());
            }
        }
        Dispatcher dispatcher = soapMessageContext.getDispatcher();
        QName qName = null;
        if (dispatcher != null && dispatcher.getWsdlPort() != null) {
            qName = dispatcher.getWsdlPort().getName();
        }
        objectOutput.writeBoolean(qName != null);
        if (qName != null) {
            objectOutput.writeObject(qName);
        }
        for (int i = 0; i < SERIALIABLE_WST_PROPERTY_NAMES.length; ++i) {
            Object object2 = messageContext.getProperty(SERIALIABLE_WST_PROPERTY_NAMES[i]);
            objectOutput.writeBoolean(object2 != null);
            if (object2 == null) continue;
            objectOutput.writeObject(object2);
        }
    }

    private void writeCredentialProviders(ObjectOutput objectOutput, List list) throws IOException {
        ArrayList arrayList = new ArrayList();
        if (list != null && !list.isEmpty()) {
            for (Object e : list) {
                if (!(e instanceof Serializable)) continue;
                arrayList.add(e);
                if (!LOGGER.isLoggable(Level.FINEST)) continue;
                LOGGER.log(Level.FINEST, "Detects a serializable credential provider while serializing WST context: " + e);
            }
        }
        objectOutput.writeBoolean(!arrayList.isEmpty());
        if (!arrayList.isEmpty()) {
            objectOutput.writeObject(arrayList);
        }
    }

    private WSTContext readWSTContext(ObjectInput objectInput) throws ClassNotFoundException, IOException {
        WSTContext wSTContext = (WSTContext)objectInput.readObject();
        boolean bl = objectInput.readBoolean();
        SoapMessageContext soapMessageContext = new SoapMessageContext(bl);
        wSTContext.setMessageContext(soapMessageContext);
        if (objectInput.readBoolean()) {
            soapMessageContext.setProperty("weblogic.wsee.security.wss.CredentialProviderList", objectInput.readObject());
        }
        if (objectInput.readBoolean()) {
            soapMessageContext.setProperty("weblogic.wsee.security.trust_claim", objectInput.readObject());
        }
        if (objectInput.readBoolean()) {
            Dispatcher dispatcher = this.readDispatcher(objectInput);
            soapMessageContext.setDispatcher(dispatcher);
        }
        for (int i = 0; i < SERIALIABLE_WST_PROPERTY_NAMES.length; ++i) {
            if (!objectInput.readBoolean()) continue;
            Object object = objectInput.readObject();
            soapMessageContext.setProperty(SERIALIABLE_WST_PROPERTY_NAMES[i], object);
        }
        this.requireUpdateWSTCtx = true;
        return wSTContext;
    }

    private Dispatcher readDispatcher(ObjectInput objectInput) throws ClassNotFoundException, IOException {
        final QName qName = (QName)objectInput.readObject();
        return new Dispatcher(){

            public WsdlBindingOperation getBindingOperation() {
                return null;
            }

            public Connection getConnection() {
                return null;
            }

            public WlMessageContext getContext() {
                return null;
            }

            public Map getInParams() {
                return null;
            }

            public WsdlOperation getOperation() {
                return null;
            }

            public QName getOperationName() {
                return null;
            }

            public Map getOutParams() {
                return null;
            }

            public QName getPortName() {
                return qName;
            }

            public QName getServiceName() {
                return null;
            }

            public WsMethod getWsMethod() {
                return null;
            }

            public WsPort getWsPort() {
                return null;
            }

            public WsdlPort getWsdlPort() {
                return new WsdlPort(){

                    @Override
                    public WsdlBinding getBinding() {
                        return null;
                    }

                    @Override
                    public WsdlDefinitions getDefinitions() {
                        return null;
                    }

                    @Override
                    public QName getName() {
                        return qName;
                    }

                    @Override
                    public PolicyURIs getPolicyUris() {
                        return null;
                    }

                    @Override
                    public WsdlAddressInfo.PortAddress getPortAddress() {
                        return null;
                    }

                    @Override
                    public WsdlPortType getPortType() {
                        return null;
                    }

                    @Override
                    public WsdlService getService() {
                        return null;
                    }

                    @Override
                    public String getTransport() {
                        return null;
                    }

                    @Override
                    public void setPolicyUris(PolicyURIs policyURIs) {
                    }

                    @Override
                    public void setPortAddress(WsdlAddressInfo.PortAddress portAddress) {
                    }

                    @Override
                    public WsdlExtension getExtension(String string) {
                        return null;
                    }

                    @Override
                    public List<WsdlExtension> getExtensionList(String string) {
                        return null;
                    }

                    @Override
                    public Map<String, List<WsdlExtension>> getExtensions() {
                        return null;
                    }

                    @Override
                    public void putExtension(WsdlExtension wsdlExtension) {
                    }

                    @Override
                    public WsdlDocumentation getDocumentation() {
                        return null;
                    }
                };
            }

            public boolean isSOAP12() {
                return false;
            }

            public void setInParams(Map map) {
            }

            public void setOutParams(Map map) {
            }

            public void setWsPort(WsPort wsPort) {
            }
        };
    }

    private void updateWSTContext(Map map) {
        if (!this.requireUpdateWSTCtx) {
            return;
        }
        if (this.wstCtx == null || this.wstCtx.getMessageContext() == null) {
            return;
        }
        MessageContext messageContext = this.wstCtx.getMessageContext();
        for (int i = 0; i < NON_SERIALIABLE_WST_PROPERTY_NAMES.length; ++i) {
            if (map.containsKey(NON_SERIALIABLE_WST_PROPERTY_NAMES[i])) {
                messageContext.setProperty(NON_SERIALIABLE_WST_PROPERTY_NAMES[i], map.get(NON_SERIALIABLE_WST_PROPERTY_NAMES[i]));
            }
            if (!LOGGER.isLoggable(Level.FINEST)) continue;
            LOGGER.log(Level.FINEST, "Updates a non-serializable property for WST original message context after un-serializing WST context: " + NON_SERIALIABLE_WST_PROPERTY_NAMES[i] + " = [" + map.get(NON_SERIALIABLE_WST_PROPERTY_NAMES[i]) + "]");
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Updates all non-serializable properties for original WST message context after un-serializing WST context");
        }
        this.requireUpdateWSTCtx = false;
    }
}

