/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import weblogic.apache.xml.serialize.OutputFormat;
import weblogic.apache.xml.serialize.XMLSerializer;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.wsee.addressing.EndpointReference;
import weblogic.wsee.connection.transport.TransportInfo;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability.WsrmSecurityContext;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.wsa.wsaddressing.WSAVersion;
import weblogic.xml.dom.DOMUtils;

public class WsrmSequenceContext
implements Externalizable {
    private static final long serialVersionUID = 2444005226852640334L;
    private static final boolean verbose = Verbose.isVerbose(WsrmSequenceContext.class);
    private WSAVersion wsaVersion = WSAVersion.latest();
    private WsrmConstants.RMVersion rmVersion = WsrmConstants.RMVersion.latest();
    private EndpointReference from = null;
    private EndpointReference lifecycleEndpoint = null;
    private EndpointReference acksTo = null;
    private EndpointReference mainAckTo = null;
    private EndpointReference failTo = null;
    private boolean secure = false;
    private boolean isSoap12 = false;
    private WsrmSecurityContext securityCtx = null;
    private AuthenticatedSubject subject;
    private TransportInfo transportInfo;
    private Map<Long, Long> requestSeqNumToResponseSeqNumMap;
    private Long finalRequestSeqNum;
    public EndpointReference destination;
    private boolean closed;
    private boolean sequenceCreator = false;
    private transient boolean offerAutoTerminating;
    static final int HAS_SUBJECT = 1;
    static final int HAS_SECURITY_CTX = 2;
    static final int HAS_TRANSPORT_INFO = 4;
    static final int HAS_REQRES_MAP = 8;
    static final int HAS_FINAL_REQUEST_SEQ_NUM = 16;
    static final int HAS_DESTINATION = 32;
    static final int HAS_RMVERSION = 64;
    static final int HAS_FROM = 128;
    static final int HAS_LIFECYCLE_ENDPOINT = 256;
    static final int HAS_CLOSED = 512;
    static final int HAS_WSAVERSION = 1024;
    static final int HAS_MAINACKTO = 2048;
    static final int HAS_SEQUENCE_CREATOR = 4096;

    public WsrmConstants.RMVersion getRmVersion() {
        return this.rmVersion;
    }

    public void setRmVersion(WsrmConstants.RMVersion rMVersion) {
        this.rmVersion = rMVersion;
    }

    public WSAVersion getWsaVersion() {
        return this.wsaVersion;
    }

    public void setWsaVersion(WSAVersion wSAVersion) {
        this.wsaVersion = wSAVersion;
    }

    public boolean isSecure() {
        if (this.securityCtx != null) {
            return this.securityCtx.isSecure();
        }
        return this.secure;
    }

    public void setSecure(boolean bl) {
        this.secure = bl;
    }

    public boolean isSecureWithSSL() {
        if (this.securityCtx != null) {
            return this.securityCtx.isSecureWithSSL();
        }
        return false;
    }

    public boolean isSoap12() {
        return this.isSoap12;
    }

    public void setSoap12(boolean bl) {
        this.isSoap12 = bl;
    }

    public EndpointReference getFrom() {
        return this.from;
    }

    public void setFrom(EndpointReference endpointReference) {
        this.from = endpointReference;
    }

    public EndpointReference getLifecycleEndpoint() {
        return this.lifecycleEndpoint;
    }

    public void setLifecycleEndpoint(EndpointReference endpointReference) {
        this.lifecycleEndpoint = endpointReference;
    }

    public void setAcksTo(EndpointReference endpointReference) {
        this.acksTo = endpointReference;
    }

    public EndpointReference getAcksTo() {
        return this.acksTo;
    }

    public EndpointReference getMainAckTo() {
        return this.mainAckTo;
    }

    public void setMainAckTo(EndpointReference endpointReference) {
        this.mainAckTo = endpointReference;
    }

    public void setFailTo(EndpointReference endpointReference) {
        this.failTo = endpointReference;
    }

    public EndpointReference getFailTo() {
        return this.failTo;
    }

    public void setSecuritySubject(AuthenticatedSubject authenticatedSubject) {
        this.subject = authenticatedSubject;
    }

    public AuthenticatedSubject getSecuritySubject() {
        return this.subject;
    }

    public void setWsrmSecurityContext(WsrmSecurityContext wsrmSecurityContext) {
        this.securityCtx = wsrmSecurityContext;
    }

    public WsrmSecurityContext getWsrmSecurityContext() {
        return this.securityCtx;
    }

    public void setTransportInfo(TransportInfo transportInfo) {
        this.transportInfo = transportInfo instanceof Serializable ? transportInfo : null;
    }

    public TransportInfo getTransportInfo() {
        return this.transportInfo;
    }

    public boolean isSequenceCreator() {
        return this.sequenceCreator;
    }

    public void setSequenceCreator(boolean bl) {
        this.sequenceCreator = bl;
    }

    public synchronized boolean isOfferSequenceAutoTerminating() {
        return this.offerAutoTerminating;
    }

    public void setOfferSequenceAutoTerminating(boolean bl) {
        if (this.offerAutoTerminating) {
            throw new IllegalStateException("Attempt to set offerSequenceTerminating more than once for this sequence. Sorry, I don't know what sequence that is at this point in the call stack.");
        }
        this.offerAutoTerminating = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mapRequestSeqNumToResponseSeqNum(long l, long l2) {
        this.verifyRequestSeqNumToResponseSeqNumMap();
        Map<Long, Long> map = this.requestSeqNumToResponseSeqNumMap;
        synchronized (map) {
            if (verbose) {
                Verbose.say("*** Mapping request message sequence number to response sequence number: " + l + "->" + l2);
            }
            this.requestSeqNumToResponseSeqNumMap.put(l, l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRequestSeqNumBeenMappedToResponseSeqNum(long l) {
        this.verifyRequestSeqNumToResponseSeqNumMap();
        Map<Long, Long> map = this.requestSeqNumToResponseSeqNumMap;
        synchronized (map) {
            return this.requestSeqNumToResponseSeqNumMap.containsKey(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getResponseSeqNumFromRequestSeqNum(long l) {
        this.verifyRequestSeqNumToResponseSeqNumMap();
        Map<Long, Long> map = this.requestSeqNumToResponseSeqNumMap;
        synchronized (map) {
            if (this.requestSeqNumToResponseSeqNumMap.containsKey(l)) {
                return this.requestSeqNumToResponseSeqNumMap.get(l);
            }
        }
        return -2L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dumpRequestSeqNumToResponseSeqNumMap() {
        this.verifyRequestSeqNumToResponseSeqNumMap();
        Map<Long, Long> map = this.requestSeqNumToResponseSeqNumMap;
        synchronized (map) {
            long l = -1L;
            for (Long l2 : this.requestSeqNumToResponseSeqNumMap.keySet()) {
                if (l2 <= l) continue;
                l = l2;
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (long i = 1L; i <= l; ++i) {
                long l3 = -2L;
                if (this.requestSeqNumToResponseSeqNumMap.containsKey(i)) {
                    l3 = this.requestSeqNumToResponseSeqNumMap.get(i);
                }
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(i).append(">>").append(l3);
            }
            return stringBuffer.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFinalRequestSeqNum(long l) {
        this.verifyRequestSeqNumToResponseSeqNumMap();
        WsrmSequenceContext wsrmSequenceContext = this;
        synchronized (wsrmSequenceContext) {
            this.finalRequestSeqNum = l;
        }
    }

    public synchronized boolean hasFinalRequestSeqNum() {
        return this.finalRequestSeqNum != null;
    }

    public synchronized long getFinalRequestSeqNum() {
        return this.finalRequestSeqNum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyRequestSeqNumToResponseSeqNumMap() {
        if (this.requestSeqNumToResponseSeqNumMap == null) {
            WsrmSequenceContext wsrmSequenceContext = this;
            synchronized (wsrmSequenceContext) {
                if (this.requestSeqNumToResponseSeqNumMap == null) {
                    this.requestSeqNumToResponseSeqNumMap = new HashMap<Long, Long>();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFinalResponseSeqNum() {
        if (this.hasFinalRequestSeqNum()) {
            long l = -1L;
            this.verifyRequestSeqNumToResponseSeqNumMap();
            Map<Long, Long> map = this.requestSeqNumToResponseSeqNumMap;
            synchronized (map) {
                for (long l2 : this.requestSeqNumToResponseSeqNumMap.values()) {
                    if (l2 < 0L) {
                        l = -1L;
                        break;
                    }
                    if (l2 <= l) continue;
                    l = l2;
                }
            }
            if (l >= 0L) {
                if (verbose) {
                    Verbose.say("*** Final response message sequence number is: " + l);
                }
                return l;
            }
            if (verbose) {
                Verbose.say("*** Final response message sequence number could not be determined");
            }
            return -1L;
        }
        return -1L;
    }

    public EndpointReference getDestination() {
        return this.destination;
    }

    public void setDestination(EndpointReference endpointReference) {
        this.destination = endpointReference;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean bl) {
        this.closed = bl;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n;
        if (verbose) {
            Verbose.say("WsrmSequenceContext in readExternal");
        }
        objectInput.readUTF();
        this.secure = objectInput.readBoolean();
        this.isSoap12 = objectInput.readBoolean();
        int n2 = objectInput.readInt();
        if (n2 <= 0) {
            throw new IOException("AcksTo endpoint reference cannot be read");
        }
        this.acksTo = this.readEndpt(objectInput, n2);
        n2 = objectInput.readInt();
        if (n2 > 0) {
            this.failTo = this.readEndpt(objectInput, n2);
        }
        if (((n = objectInput.readInt()) & 1) != 0) {
            this.subject = (AuthenticatedSubject)objectInput.readObject();
        }
        if ((n & 2) != 0) {
            this.securityCtx = (WsrmSecurityContext)objectInput.readObject();
        }
        if ((n & 4) != 0) {
            this.transportInfo = (TransportInfo)objectInput.readObject();
        }
        if ((n & 8) != 0) {
            this.requestSeqNumToResponseSeqNumMap = (Map)objectInput.readObject();
        }
        if ((n & 0x10) != 0) {
            this.finalRequestSeqNum = objectInput.readLong();
        }
        if ((n & 0x20) != 0 && (n2 = objectInput.readInt()) > 0) {
            this.destination = this.readEndpt(objectInput, n2);
        }
        if ((n & 0x40) != 0) {
            this.rmVersion = (WsrmConstants.RMVersion)((Object)objectInput.readObject());
        }
        if ((n & 0x80) != 0) {
            n2 = objectInput.readInt();
            this.from = this.readEndpt(objectInput, n2);
        }
        if ((n & 0x100) != 0) {
            n2 = objectInput.readInt();
            this.lifecycleEndpoint = this.readEndpt(objectInput, n2);
        }
        if ((n & 0x200) != 0) {
            this.closed = objectInput.readBoolean();
        }
        this.wsaVersion = (n & 0x400) != 0 ? (WSAVersion)((Object)objectInput.readObject()) : WSAVersion.MemberSubmission;
        if ((n & 0x800) != 0 && (n2 = objectInput.readInt()) > 0) {
            this.mainAckTo = this.readEndpt(objectInput, n2);
        }
        if ((n & 0x1000) != 0) {
            this.sequenceCreator = objectInput.readBoolean();
        }
        if (verbose) {
            Verbose.say("WsrmSequenceContext finished readExternal");
        }
    }

    private EndpointReference readEndpt(ObjectInput objectInput, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; i += n2) {
            n2 = objectInput.read(byArray, i, n - i);
        }
        if (verbose) {
            Verbose.log("Reading Endpoint:");
            for (int i = 0; i < byArray.length; ++i) {
                Verbose.getOut().print((char)byArray[i]);
            }
            Verbose.getOut().println();
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(byteArrayInputStream);
            EndpointReference endpointReference = new EndpointReference();
            endpointReference.read(document.getDocumentElement());
            return endpointReference;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException(parserConfigurationException.toString());
        }
        catch (SAXException sAXException) {
            throw new IOException(sAXException.toString());
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        this.doWriteExternal(objectOutput);
        if (verbose) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWriteExternal(ObjectOutput objectOutput) throws IOException {
        if (verbose) {
            Verbose.say("WsrmSequenceContext in writeExternal");
        }
        objectOutput.writeUTF("10.3");
        objectOutput.writeBoolean(this.secure);
        objectOutput.writeBoolean(this.isSoap12);
        if (this.acksTo == null) {
            throw new IOException("AcksTo endpoint reference is not set");
        }
        this.writeEndpt(this.acksTo, objectOutput);
        if (this.failTo != null) {
            this.writeEndpt(this.failTo, objectOutput);
        } else {
            objectOutput.writeInt(0);
        }
        int n = 0;
        if (this.subject != null) {
            n |= 1;
        }
        if (this.securityCtx != null) {
            n |= 2;
        }
        if (this.transportInfo != null) {
            n |= 4;
        }
        Object object = this;
        synchronized (object) {
            if (this.requestSeqNumToResponseSeqNumMap != null) {
                n |= 8;
            }
            if (this.finalRequestSeqNum != null) {
                n |= 0x10;
            }
        }
        if (this.destination != null) {
            n |= 0x20;
        }
        if (this.rmVersion != null) {
            n |= 0x40;
        }
        if (this.from != null) {
            n |= 0x80;
        }
        if (this.lifecycleEndpoint != null) {
            n |= 0x100;
        }
        n |= 0x200;
        if (this.wsaVersion != null) {
            n |= 0x400;
        }
        if (this.mainAckTo != null) {
            n |= 0x800;
        }
        objectOutput.writeInt(n |= 0x1000);
        if (this.subject != null) {
            objectOutput.writeObject(this.subject);
        }
        if (this.securityCtx != null) {
            objectOutput.writeObject(this.securityCtx);
        }
        if (this.transportInfo != null) {
            objectOutput.writeObject(this.transportInfo);
        }
        if ((n & 8) != 0) {
            object = this.requestSeqNumToResponseSeqNumMap;
            synchronized (object) {
                objectOutput.writeObject(this.requestSeqNumToResponseSeqNumMap);
            }
        }
        if ((n & 0x10) != 0) {
            object = this;
            synchronized (object) {
                if (this.finalRequestSeqNum != null) {
                    objectOutput.writeLong(this.finalRequestSeqNum);
                }
            }
        }
        if ((n & 0x20) != 0) {
            this.writeEndpt(this.destination, objectOutput);
        }
        if (this.rmVersion != null) {
            objectOutput.writeObject((Object)this.rmVersion);
        }
        if (this.from != null) {
            this.writeEndpt(this.from, objectOutput);
        }
        if (this.lifecycleEndpoint != null) {
            this.writeEndpt(this.lifecycleEndpoint, objectOutput);
        }
        objectOutput.writeBoolean(this.closed);
        if (this.wsaVersion != null) {
            objectOutput.writeObject((Object)this.wsaVersion);
        }
        if (this.mainAckTo != null) {
            this.writeEndpt(this.mainAckTo, objectOutput);
        }
        objectOutput.writeBoolean(this.sequenceCreator);
        if (verbose) {
            Verbose.say("WsrmSequenceContext finished writeExternal");
        }
    }

    private void writeEndpt(EndpointReference endpointReference, ObjectOutput objectOutput) throws IOException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElementNS(this.rmVersion.getNamespaceUri(), WsrmConstants.Element.ACKS_TO.getQualifiedName(this.rmVersion));
            DOMUtils.addNamespaceDeclaration(element, this.rmVersion.getPrefix(), this.rmVersion.getNamespaceUri());
            endpointReference.write(element);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputFormat outputFormat = new OutputFormat("XML", null, false);
            XMLSerializer xMLSerializer = new XMLSerializer((OutputStream)byteArrayOutputStream, outputFormat);
            xMLSerializer.serialize(element);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            if (verbose) {
                Verbose.log("Writing Endpoint:");
                for (int i = 0; i < byArray.length; ++i) {
                    Verbose.getOut().print((char)byArray[i]);
                }
                Verbose.getOut().println();
            }
            objectOutput.writeInt(byArray.length);
            objectOutput.write(byArray);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException(parserConfigurationException.toString());
        }
    }
}

