/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability;

import java.io.Externalizable;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.net.ssl.SSLHandshakeException;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weblogic.messaging.saf.SAFConversationHandle;
import weblogic.messaging.saf.SAFConversationInfo;
import weblogic.messaging.saf.SAFException;
import weblogic.messaging.saf.SAFRequest;
import weblogic.messaging.saf.SAFTransportException;
import weblogic.messaging.saf.common.SAFConversationHandleImpl;
import weblogic.messaging.saf.internal.SAFManagerImpl;
import weblogic.protocol.LocalServerIdentity;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.store.PersistentStoreException;
import weblogic.wsee.addressing.ActionHeader;
import weblogic.wsee.addressing.AddressingHelper;
import weblogic.wsee.addressing.AddressingProvider;
import weblogic.wsee.addressing.AddressingProviderFactory;
import weblogic.wsee.addressing.EndpointReference;
import weblogic.wsee.addressing.FaultToHeader;
import weblogic.wsee.addressing.FromHeader;
import weblogic.wsee.addressing.MessageIdHeader;
import weblogic.wsee.addressing.ReplyToHeader;
import weblogic.wsee.addressing.ToHeader;
import weblogic.wsee.async.AsyncInvokeState;
import weblogic.wsee.async.AsyncInvokeStateObjectHandler;
import weblogic.wsee.async.AsyncUtil;
import weblogic.wsee.async.SOAPInvokeState;
import weblogic.wsee.cluster.ServiceIdentityHeader;
import weblogic.wsee.connection.Connection;
import weblogic.wsee.connection.ConnectionException;
import weblogic.wsee.connection.ConnectionFactory;
import weblogic.wsee.connection.transport.Transport;
import weblogic.wsee.connection.transport.TransportInfo;
import weblogic.wsee.connection.transport.http.HTTPClientTransport;
import weblogic.wsee.connection.transport.https.HttpsTransportInfo;
import weblogic.wsee.connection.transport.https.SSLAdapter;
import weblogic.wsee.conversation.ConversationInvokeState;
import weblogic.wsee.conversation.ConversationInvokeStateObjectHandler;
import weblogic.wsee.jaxrpc.soapfault.SOAPFaultUtil;
import weblogic.wsee.message.MsgHeader;
import weblogic.wsee.message.MsgHeaderFactory;
import weblogic.wsee.message.MsgHeaders;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.message.soap.SoapMessageContext;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.framework.PolicyException;
import weblogic.wsee.reliability.SAFServerHeader;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability.WsrmPayloadContext;
import weblogic.wsee.reliability.WsrmPermanentTransportException;
import weblogic.wsee.reliability.WsrmSAFManager;
import weblogic.wsee.reliability.WsrmSAFManagerFactory;
import weblogic.wsee.reliability.WsrmSAFReceivingManager;
import weblogic.wsee.reliability.WsrmSAFSendingManager;
import weblogic.wsee.reliability.WsrmSecurityContext;
import weblogic.wsee.reliability.WsrmSequenceContext;
import weblogic.wsee.reliability.faults.CreateSequenceRefusedFaultMsg;
import weblogic.wsee.reliability.faults.SequenceFaultException;
import weblogic.wsee.reliability.faults.SequenceFaultMsg;
import weblogic.wsee.reliability.faults.SequenceFaultMsgFactory;
import weblogic.wsee.reliability.handshake.CloseSequenceMsg;
import weblogic.wsee.reliability.handshake.CloseSequenceResponseMsg;
import weblogic.wsee.reliability.handshake.CreateSequenceMsg;
import weblogic.wsee.reliability.handshake.CreateSequenceResponseMsg;
import weblogic.wsee.reliability.handshake.HandshakeMsgException;
import weblogic.wsee.reliability.handshake.SequenceAccept;
import weblogic.wsee.reliability.handshake.SequenceOffer;
import weblogic.wsee.reliability.handshake.TerminateSequenceMsg;
import weblogic.wsee.reliability.handshake.TerminateSequenceResponseMsg;
import weblogic.wsee.reliability.handshake.WsrmServerHandshakeHandler;
import weblogic.wsee.reliability.headers.AckRequestedHeader;
import weblogic.wsee.reliability.headers.AcknowledgementHeader;
import weblogic.wsee.reliability.headers.SequenceHeader;
import weblogic.wsee.reliability.headers.UsesSequenceSSLHeader;
import weblogic.wsee.reliability.headers.UsesSequenceSTRHeader;
import weblogic.wsee.reliability.headers.WsrmHeader;
import weblogic.wsee.security.configuration.WssConfigurationException;
import weblogic.wsee.security.policy.WssPolicyUtils;
import weblogic.wsee.security.wssc.base.sct.SCTokenBase;
import weblogic.wsee.security.wssc.base.sct.SCTokenHandlerBase;
import weblogic.wsee.security.wssc.sct.SCCredential;
import weblogic.wsee.security.wssc.v200502.sct.SCTHelper;
import weblogic.wsee.security.wssc.v200502.sct.SCTokenHandler;
import weblogic.wsee.server.WsLifeCycleEvent;
import weblogic.wsee.server.WsLifeCycleListenerRegistry;
import weblogic.wsee.server.WsStorage;
import weblogic.wsee.server.WsStorageFactory;
import weblogic.wsee.util.Guid;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.util.WLMessageFactory;
import weblogic.wsee.ws.dispatch.client.MimeHeaderHandler;
import weblogic.wsee.ws.dispatch.server.ConnectionHandler;
import weblogic.wsee.wsa.wsaddressing.WSAVersion;
import weblogic.wsee.wsa.wsaddressing.WSAddressingConstants;
import weblogic.xml.crypto.wss.WSSConstants;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss.provider.SecurityTokenReference;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WsrmSequenceSender {
    private static final boolean verbose = Verbose.isVerbose(WsrmSequenceSender.class);
    private static WsStorage storage = WsStorageFactory.getStorage("weblogic.wsee.async.store", new AsyncInvokeStateObjectHandler());

    public static Externalizable send(SAFConversationInfo sAFConversationInfo, SAFRequest sAFRequest) throws SAFTransportException {
        Object object;
        long l = System.nanoTime();
        if (verbose) {
            Verbose.say(l + " Entering WsrmSequenceSender.send(SAFConversationInfo,SAFRequest)");
        }
        long l2 = sAFRequest.getSequenceNumber();
        WsrmSequenceContext wsrmSequenceContext = (WsrmSequenceContext)sAFConversationInfo.getContext();
        WsrmPayloadContext wsrmPayloadContext = (WsrmPayloadContext)sAFRequest.getPayloadContext();
        EndpointReference endpointReference = WsrmSequenceSender.getConversationEPR(wsrmPayloadContext);
        SOAPInvokeState sOAPInvokeState = (SOAPInvokeState)sAFRequest.getPayload();
        if (sOAPInvokeState == null) {
            throw new SAFTransportException("No payload found.");
        }
        SOAPMessage sOAPMessage = sOAPInvokeState.getClonedSOAPMessage();
        AddressingProvider addressingProvider = AddressingProviderFactory.getInstance().getAddressingProvider(sOAPInvokeState.getMessageContextProperties());
        try {
            object = sOAPMessage.getSOAPHeader();
            if (object == null) {
                throw new SAFTransportException("No SOAPHeader found in SOAPMessage.");
            }
            if (wsrmPayloadContext != null && wsrmPayloadContext.getStartConversation()) {
                WsrmSequenceSender.setStartConversationHdrs(object, wsrmPayloadContext, addressingProvider);
            }
            if (WSAVersion.MemberSubmission.equals((Object)addressingProvider.getWSAVersion())) {
                WsrmSequenceSender.removeFromHeader(object);
            }
            WsrmSequenceSender.applyConversationEPRToContinueMsg(endpointReference, object);
            WsrmSequenceSender.adjustSequenceHeaders(object, l2, sAFConversationInfo);
        }
        catch (DOMProcessingException dOMProcessingException) {
            if (verbose) {
                Verbose.logException((Throwable)((Object)dOMProcessingException));
            }
            throw new SAFTransportException("DOMProcessingException", (Throwable)((Object)dOMProcessingException));
        }
        catch (SOAPException sOAPException) {
            if (verbose) {
                Verbose.logException(sOAPException);
            }
            throw new SAFTransportException("SOAPException", sOAPException);
        }
        object = WsrmSequenceSender.createSendSoapContext(wsrmSequenceContext, sOAPInvokeState, sOAPMessage, wsrmPayloadContext);
        if (verbose) {
            Verbose.say(l + " Inside WsrmSequenceSender.send(SAFConversationInfo,SAFRequest) == 1");
        }
        boolean bl = WsrmSequenceSender.checkForAutoTerminateOnOfferSequence(sOAPInvokeState, (SoapMessageContext)object, wsrmSequenceContext, sAFConversationInfo, l2);
        if (verbose) {
            Verbose.say(l + " Inside WsrmSequenceSender.send(SAFConversationInfo,SAFRequest) == 2");
        }
        SoapMessageContext soapMessageContext = WsrmSequenceSender.sendMessageWithSubject((SOAPMessageContext)object, sAFConversationInfo.getDestinationURL(), sAFConversationInfo, wsrmSequenceContext);
        if (verbose) {
            Verbose.say(l + " Inside WsrmSequenceSender.send(SAFConversationInfo,SAFRequest) == 3");
        }
        if (soapMessageContext != null) {
            WsrmSequenceSender.handleSyncSendResponse(soapMessageContext, wsrmSequenceContext, sAFConversationInfo);
        }
        if (bl |= WsrmSequenceSender.updateRenewedToken((SoapMessageContext)object, wsrmSequenceContext) != null) {
            if (verbose) {
                Verbose.say(l + " Inside WsrmSequenceSender.send(SAFConversationInfo,SAFRequest) == 4");
            }
            return wsrmSequenceContext;
        }
        return null;
    }

    private static boolean checkForAutoTerminateOnOfferSequence(SOAPInvokeState sOAPInvokeState, SoapMessageContext soapMessageContext, WsrmSequenceContext wsrmSequenceContext, SAFConversationInfo sAFConversationInfo, long l) throws SAFTransportException {
        String string;
        long l2;
        boolean bl = false;
        ActionHeader actionHeader = (ActionHeader)soapMessageContext.getHeaders().getHeader(ActionHeader.TYPE);
        if (actionHeader != null && WsrmConstants.Action.LAST_MESSAGE.getActionURI(wsrmSequenceContext.getRmVersion()).equals(actionHeader.getActionURI())) {
            if (verbose) {
                Verbose.log("WsrmSequenceSender processing empty LastMessage message. Check for auto-terminate bypassed, as we know the current sequence is now ready to be terminated.");
            }
            return bl;
        }
        if (sOAPInvokeState.getMessageContextProperties().containsKey("weblogic.wsee.async.res") && (l2 = Long.parseLong(string = (String)sOAPInvokeState.getMessageContextProperties().get("weblogic.wsee.reliability.RequestMessageSeqNumber"))) > 0L) {
            Object object;
            boolean bl2 = false;
            if (sOAPInvokeState.getMessageContextProperties().containsKey("weblogic.wsee.conversation.AsyncConvId")) {
                bl2 = true;
            }
            if (verbose) {
                object = bl2 ? "conversation ID" : "actual response";
                Verbose.say("*** Doing " + (String)object + " mapping of requestSeqNum " + l2 + " to " + l + " on offer sequence " + WsrmSequenceSender.getSequenceIdFromConversationInfo(sAFConversationInfo));
            }
            wsrmSequenceContext.mapRequestSeqNumToResponseSeqNum(l2, l);
            bl = true;
            object = WsrmSAFManagerFactory.getWsrmSAFReceivingManager();
            try {
                EndpointReference endpointReference = (EndpointReference)sOAPInvokeState.getMessageContextProperties().get("weblogic.wsee.addressing.ReplyTo");
                if (endpointReference == null || AddressingHelper.isAnonymousReferenceURI(endpointReference.getAddress())) {
                    endpointReference = new EndpointReference(sAFConversationInfo.getDestinationURL());
                }
                ((WsrmSAFReceivingManager)object).checkForAutoTerminateOnOfferSequence(WsrmSequenceSender.getSequenceIdFromConversationInfo(sAFConversationInfo), wsrmSequenceContext, endpointReference);
            }
            catch (SAFException sAFException) {
                throw new SAFTransportException(sAFException.toString(), sAFException);
            }
        }
        return bl;
    }

    private static SoapMessageContext createSendSoapContext(WsrmSequenceContext wsrmSequenceContext, SOAPMessage sOAPMessage) {
        SoapMessageContext soapMessageContext = new SoapMessageContext(wsrmSequenceContext.isSoap12());
        if (wsrmSequenceContext.getFrom() != null) {
            soapMessageContext.setProperty("weblogic.wsee.addressing.From", wsrmSequenceContext.getFrom());
        }
        soapMessageContext.setMessage(sOAPMessage);
        WsrmSequenceSender.setWSAVersion(soapMessageContext, wsrmSequenceContext.getWsaVersion());
        return soapMessageContext;
    }

    private static SoapMessageContext createSendSoapContext(WsrmSequenceContext wsrmSequenceContext, SOAPInvokeState sOAPInvokeState, SOAPMessage sOAPMessage, WsrmPayloadContext wsrmPayloadContext) {
        SoapMessageContext soapMessageContext = new SoapMessageContext(wsrmSequenceContext.isSoap12());
        for (String string : sOAPInvokeState.getMessageContextProperties().keySet()) {
            soapMessageContext.setProperty(string, sOAPInvokeState.getMessageContextProperties().get(string));
        }
        soapMessageContext.setMessage(sOAPMessage);
        if (wsrmPayloadContext != null) {
            soapMessageContext.setProperty("weblogic.wsee.policy.effectiveRequestPolicy", wsrmPayloadContext.getRequestPolicy());
            soapMessageContext.setProperty("weblogic.wsee.policy.effectiveResponsePolicy", wsrmPayloadContext.getResponsePolicy());
            soapMessageContext.setProperty("weblogic.weblogic.wsee.security.policy.WssPolicyCtx", WssPolicyUtils.getContext());
        }
        if (wsrmSequenceContext.getWsrmSecurityContext().isSecureWithWssc()) {
            soapMessageContext.setProperty("weblogic.wsee.wssc.sct", wsrmSequenceContext.getWsrmSecurityContext().getSCCredential());
        }
        return soapMessageContext;
    }

    private static void applyConversationEPRToContinueMsg(EndpointReference endpointReference, SOAPHeader sOAPHeader) throws DOMProcessingException {
        if (endpointReference != null && DOMUtils.getOptionalElementByTagNameNS((Element)sOAPHeader, "http://www.openuri.org/2002/04/soap/conversation/", "ContinueHeader") == null) {
            MsgHeader msgHeader;
            Iterator iterator = endpointReference.getReferenceProperties().listHeaders();
            while (iterator.hasNext()) {
                msgHeader = (MsgHeader)iterator.next();
                msgHeader.writeToParent((Element)sOAPHeader);
            }
            iterator = endpointReference.getReferenceParameters().listHeaders();
            while (iterator.hasNext()) {
                msgHeader = (MsgHeader)iterator.next();
                msgHeader.writeToParent((Element)sOAPHeader);
            }
        }
    }

    private static Externalizable updateRenewedToken(SoapMessageContext soapMessageContext, WsrmSequenceContext wsrmSequenceContext) {
        if (!wsrmSequenceContext.getWsrmSecurityContext().isSecureWithWssc()) {
            return null;
        }
        SCCredential sCCredential = wsrmSequenceContext.getWsrmSecurityContext().getSCCredential();
        if (sCCredential == null) {
            throw new JAXRPCException("No credential found for RM sequence");
        }
        SCCredential sCCredential2 = (SCCredential)soapMessageContext.getProperty("weblogic.wsee.wssc.sct");
        if (sCCredential2 == null) {
            throw new JAXRPCException("No credential found sending message");
        }
        if (!sCCredential.getExpires().equals(sCCredential2.getExpires())) {
            WsLifeCycleListenerRegistry.getInstance().onEvent(WsLifeCycleEvent.WSRM_SEND_AFTER_RENEW_RES_BEFORE_SAVE);
            wsrmSequenceContext.getWsrmSecurityContext().setSCCredential(sCCredential2);
            return wsrmSequenceContext;
        }
        return null;
    }

    private static void saveMCForAsyncResponse(SoapMessageContext soapMessageContext) {
        if (soapMessageContext.getProperty("weblogic.wsee.async.res") == null && soapMessageContext.getProperty("weblogic.wsee.async.invoke") != null) {
            MessageIdHeader messageIdHeader = (MessageIdHeader)soapMessageContext.getHeaders().getHeader(MessageIdHeader.TYPE);
            assert (messageIdHeader != null);
            String string = messageIdHeader.getMessageId();
            try {
                AsyncInvokeState asyncInvokeState = (AsyncInvokeState)storage.persistentGet(string);
                if (asyncInvokeState != null) {
                    if (verbose) {
                        Verbose.log("Updating AsyncInvokeState MessageContext field for request " + messageIdHeader.getMessageId() + " prior to sending it as a sequence message");
                    }
                    asyncInvokeState.setMessageContext(soapMessageContext);
                    storage.persistentPut(string, asyncInvokeState);
                }
            }
            catch (PersistentStoreException persistentStoreException) {
                if (verbose) {
                    Verbose.logException(persistentStoreException);
                }
                throw new JAXRPCException((Throwable)persistentStoreException);
            }
        }
    }

    private static void handleSyncSendResponse(SoapMessageContext soapMessageContext, WsrmSequenceContext wsrmSequenceContext, SAFConversationInfo sAFConversationInfo) throws SAFTransportException {
        SOAPBody sOAPBody;
        WsrmSequenceSender.handleResponseSecurity(soapMessageContext, wsrmSequenceContext, sAFConversationInfo);
        SOAPMessage sOAPMessage = soapMessageContext.getMessage();
        try {
            sOAPBody = sOAPMessage.getSOAPBody();
        }
        catch (SOAPException sOAPException) {
            if (verbose) {
                Verbose.logException(sOAPException);
            }
            throw new SAFTransportException("SOAPException", true, sOAPException);
        }
        if (sOAPBody == null) {
            throw new SAFTransportException("Empty reply body");
        }
        if (!sOAPBody.hasFault()) {
            MsgHeaders msgHeaders = soapMessageContext.getHeaders();
            assert (msgHeaders != null);
            AcknowledgementHeader acknowledgementHeader = (AcknowledgementHeader)msgHeaders.getHeader(AcknowledgementHeader.TYPE);
            if (acknowledgementHeader != null) {
                FaultToHeader faultToHeader = (FaultToHeader)msgHeaders.getHeader(FaultToHeader.TYPE);
                if (faultToHeader != null) {
                    soapMessageContext.setProperty("weblogic.wsee.addressing.FaultTo", faultToHeader.getReference());
                } else {
                    ReplyToHeader replyToHeader = (ReplyToHeader)msgHeaders.getHeader(ReplyToHeader.TYPE);
                    if (replyToHeader != null) {
                        soapMessageContext.setProperty("weblogic.wsee.addressing.FaultTo", replyToHeader.getReference());
                    } else {
                        FromHeader fromHeader = (FromHeader)msgHeaders.getHeader(FromHeader.TYPE);
                        if (fromHeader != null) {
                            soapMessageContext.setProperty("weblogic.wsee.addressing.FaultTo", fromHeader.getReference());
                        } else {
                            soapMessageContext.setProperty("weblogic.wsee.addressing.FaultTo", AddressingProviderFactory.getInstance().getAddressingProvider(soapMessageContext).createAnonymousEndpointReference());
                        }
                    }
                }
                WsrmSAFManagerFactory.getWsrmSAFSendingManager().handleAck(acknowledgementHeader, soapMessageContext, true);
                return;
            }
            if (verbose) {
                Verbose.log("Got unknown response back from sending a reliable message");
            }
        } else {
            block18: {
                try {
                    SequenceFaultMsg sequenceFaultMsg = SequenceFaultMsgFactory.getInstance().parseSoapFault(sOAPMessage, wsrmSequenceContext.getRmVersion());
                    if (verbose) {
                        Verbose.log("Found fault: " + sequenceFaultMsg.getSubCodeQualifiedName());
                    }
                    WsrmSAFManagerFactory.getWsrmSAFSendingManager().handleFault(sequenceFaultMsg);
                }
                catch (SequenceFaultException sequenceFaultException) {
                    if (!verbose) break block18;
                    SOAPFault sOAPFault = sOAPBody.getFault();
                    Verbose.log("Received a fault message: " + sOAPFault.getFaultString());
                }
            }
            throw new SAFTransportException("Send failed, received a fault message");
        }
    }

    private static boolean handleResponseSecurity(SoapMessageContext soapMessageContext, WsrmSequenceContext wsrmSequenceContext, SAFConversationInfo sAFConversationInfo) {
        GenericHandler genericHandler;
        if (wsrmSequenceContext == null) {
            return false;
        }
        if (!wsrmSequenceContext.isSecure()) {
            return true;
        }
        try {
            WsrmSecurityContext wsrmSecurityContext = wsrmSequenceContext.getWsrmSecurityContext();
            soapMessageContext.setProperty("weblogic.wsee.policy.effectiveResponsePolicy", wsrmSecurityContext.getSecurityPolicy());
            soapMessageContext.setProperty("weblogic.weblogic.wsee.security.policy.WssPolicyCtx", WssPolicyUtils.getContext());
            if (wsrmSecurityContext.isSecureWithWssc()) {
                soapMessageContext.setProperty("weblogic.wsee.wssc.sct", wsrmSecurityContext.getSCCredential());
            }
        }
        catch (PolicyException policyException) {
            if (verbose) {
                Verbose.logException(policyException);
            }
            throw new JAXRPCException("Policy exception", (Throwable)policyException);
        }
        boolean bl = AsyncUtil.getWssClientHandler(wsrmSequenceContext).handleResponse((MessageContext)soapMessageContext);
        if (bl && (genericHandler = AsyncUtil.getWssClientPolicyHandler(wsrmSequenceContext)) != null) {
            bl = genericHandler.handleResponse((MessageContext)soapMessageContext);
        }
        if (!bl) {
            return false;
        }
        try {
            WsrmServerHandshakeHandler.validateCredential(sAFConversationInfo, soapMessageContext);
        }
        catch (Throwable throwable) {
            if (verbose) {
                Verbose.logException(throwable);
            }
            return false;
        }
        return true;
    }

    private static void adjustSequenceHeaders(SOAPHeader sOAPHeader, long l, SAFConversationInfo sAFConversationInfo) throws DOMProcessingException {
        block5: {
            Node node;
            Node node2;
            WsrmSequenceContext wsrmSequenceContext = (WsrmSequenceContext)sAFConversationInfo.getContext();
            WsrmConstants.RMVersion rMVersion = wsrmSequenceContext.getRmVersion();
            Element element = DOMUtils.getElementByTagNameNS((Element)sOAPHeader, rMVersion.getNamespaceUri(), WsrmConstants.Element.SEQUENCE.getElementName());
            Element element2 = DOMUtils.getElementByTagNameNS(element, rMVersion.getNamespaceUri(), WsrmConstants.Element.MESSAGE_NUMBER.getElementName());
            NodeList nodeList = element2.getChildNodes();
            assert (nodeList.getLength() == 1);
            int n = 0;
            if (n < nodeList.getLength() && ((node2 = nodeList.item(n)).getNodeType() == 3 || node2.getNodeType() == 4)) {
                node2.setNodeValue(Long.toString(l));
            }
            if (!sAFConversationInfo.isDynamic()) break block5;
            Element element3 = DOMUtils.getElementByTagNameNS(element, rMVersion.getNamespaceUri(), WsrmConstants.Element.IDENTIFIER.getElementName());
            nodeList = element3.getChildNodes();
            assert (nodeList.getLength() == 1);
            int n2 = 0;
            if (n2 < nodeList.getLength() && ((node = nodeList.item(n2)).getNodeType() == 3 || node.getNodeType() == 4)) {
                if (verbose) {
                    Verbose.log("Map sender side conversation name " + node.getNodeValue() + " to receiver side conversation name " + sAFConversationInfo.getDynamicConversationName());
                }
                node.setNodeValue(sAFConversationInfo.getDynamicConversationName());
            }
        }
    }

    private static void setStartConversationHdrs(SOAPHeader sOAPHeader, WsrmPayloadContext wsrmPayloadContext, AddressingProvider addressingProvider) throws DOMProcessingException {
        String string = addressingProvider.getNamespaceURI();
        Element element = DOMUtils.getElementByTagNameNS((Element)sOAPHeader, string, "ReplyTo");
        Element element2 = DOMUtils.getElementByTagNameNS(element, string, "ReferenceParameters");
        if (DOMUtils.getOptionalElementByTagNameNS(element2, "http://www.bea.com/safserver", "SAFServer") == null) {
            SAFServerHeader sAFServerHeader = new SAFServerHeader();
            sAFServerHeader.setServerName(LocalServerIdentity.getIdentity().getServerName());
            sAFServerHeader.setConversationKey(wsrmPayloadContext.getConversationKey());
            sAFServerHeader.writeToParent(element2);
        }
    }

    private static EndpointReference getConversationEPR(WsrmPayloadContext wsrmPayloadContext) throws SAFTransportException {
        if (wsrmPayloadContext != null && wsrmPayloadContext.getWaitForConversationId()) {
            EndpointReference endpointReference;
            WsStorage wsStorage = WsStorageFactory.getStorage("weblogic.wsee.conversation.store", new ConversationInvokeStateObjectHandler());
            try {
                ConversationInvokeState conversationInvokeState = (ConversationInvokeState)wsStorage.persistentGet(wsrmPayloadContext.getConversationKey());
                if (conversationInvokeState == null || (endpointReference = conversationInvokeState.getEpr()) == null) {
                    throw new SAFTransportException("Conversational message can only be sent after conversation ID has been sent back from the server.  This exception is expected and should not be a cause for concern.");
                }
            }
            catch (PersistentStoreException persistentStoreException) {
                if (verbose) {
                    Verbose.logException(persistentStoreException);
                }
                throw new JAXRPCException((Throwable)persistentStoreException);
            }
            return endpointReference;
        }
        return null;
    }

    public static AcknowledgementHeader ackRequest(SAFConversationInfo sAFConversationInfo) throws SAFTransportException {
        SoapMessageContext soapMessageContext;
        WsrmSequenceContext wsrmSequenceContext = (WsrmSequenceContext)sAFConversationInfo.getContext();
        boolean bl = wsrmSequenceContext.isSoap12();
        SOAPMessage sOAPMessage = WsrmSequenceSender.createSOAPMessage(bl);
        SoapMessageContext soapMessageContext2 = new SoapMessageContext(bl);
        soapMessageContext2.setMessage(sOAPMessage);
        if (wsrmSequenceContext.getAcksTo() != null) {
            WsrmSequenceSender.setWSAVersion(soapMessageContext2, wsrmSequenceContext.getWsaVersion());
        }
        String string = WsrmSequenceSender.getLifecycleEndpointAddress(wsrmSequenceContext, sAFConversationInfo);
        WsrmSequenceSender.setupAckRequestAddressingHeaders(wsrmSequenceContext, string, soapMessageContext2, sAFConversationInfo, sOAPMessage);
        AckRequestedHeader ackRequestedHeader = new AckRequestedHeader(wsrmSequenceContext.getRmVersion());
        String string2 = WsrmSequenceSender.getSequenceIdFromConversationInfo(sAFConversationInfo);
        ackRequestedHeader.setSequenceId(string2);
        soapMessageContext2.getHeaders().addHeader(ackRequestedHeader);
        if (verbose) {
            Verbose.log("Send acknowledgement request to " + string);
        }
        if ((soapMessageContext = WsrmSequenceSender.sendMessageWithSubject(soapMessageContext2, string, sAFConversationInfo, wsrmSequenceContext)) != null) {
            SOAPBody sOAPBody;
            SOAPMessage sOAPMessage2 = soapMessageContext.getMessage();
            try {
                sOAPBody = sOAPMessage2.getSOAPBody();
            }
            catch (SOAPException sOAPException) {
                if (verbose) {
                    Verbose.logException(sOAPException);
                }
                throw new SAFTransportException("SOAPException", true, sOAPException);
            }
            if (sOAPBody == null) {
                throw new SAFTransportException("Empty reply body");
            }
            if (!sOAPBody.hasFault()) {
                MsgHeaders msgHeaders = soapMessageContext.getHeaders();
                assert (msgHeaders != null);
                AcknowledgementHeader acknowledgementHeader = (AcknowledgementHeader)msgHeaders.getHeader(AcknowledgementHeader.TYPE);
                return acknowledgementHeader;
            }
            throw new SAFTransportException("Ack request reply has fault");
        }
        return null;
    }

    private static void setupAckRequestAddressingHeaders(WsrmSequenceContext wsrmSequenceContext, String string, SoapMessageContext soapMessageContext, SAFConversationInfo sAFConversationInfo, SOAPMessage sOAPMessage) {
        AddressingProvider addressingProvider = AddressingProviderFactory.getInstance().getAddressingProvider(soapMessageContext);
        ToHeader toHeader = addressingProvider.createToHeader(string);
        String string2 = WsrmConstants.Action.ACK_REQUESTED.getActionURI(wsrmSequenceContext.getRmVersion());
        ActionHeader actionHeader = addressingProvider.createActionHeader(string2);
        soapMessageContext.getHeaders().addHeader(toHeader);
        soapMessageContext.getHeaders().addHeader(actionHeader);
        soapMessageContext.getHeaders().addHeader(addressingProvider.createMessageIdHeader(Guid.generateGuid()));
        soapMessageContext.getHeaders().addHeader(addressingProvider.createFromHeader(addressingProvider.createEndpointReference(sAFConversationInfo.getSourceURL())));
        if (!AsyncUtil.isSoap12(soapMessageContext)) {
            sOAPMessage.getMimeHeaders().setHeader("SOAPAction", string2);
        }
    }

    public static Externalizable createSecurityToken(SAFConversationInfo sAFConversationInfo) throws SAFTransportException {
        try {
            WsrmSequenceContext wsrmSequenceContext = (WsrmSequenceContext)sAFConversationInfo.getContext();
            wsrmSequenceContext.setSequenceCreator(true);
            WsrmSecurityContext wsrmSecurityContext = wsrmSequenceContext.getWsrmSecurityContext();
            if (wsrmSecurityContext.isSecureWithWssc()) {
                if (wsrmSecurityContext.getSCCredential() != null) {
                    return null;
                }
                if (wsrmSecurityContext.isSecureWithWssp12Wssc13()) {
                    WsrmSequenceSender.performWSSC13Handshake(wsrmSequenceContext, sAFConversationInfo.getDestinationURL());
                } else {
                    WsrmSequenceSender.performWSSCHandshake(wsrmSequenceContext, sAFConversationInfo.getDestinationURL());
                }
                return wsrmSequenceContext;
            }
        }
        catch (Exception exception) {
            if (verbose) {
                Verbose.logException(exception);
            }
            if (exception instanceof SAFTransportException) {
                throw (SAFTransportException)exception;
            }
            throw (RuntimeException)exception;
        }
        return null;
    }

    public static SAFConversationHandle createSequence(SAFConversationInfo sAFConversationInfo) throws SAFTransportException {
        try {
            WsLifeCycleListenerRegistry.getInstance().onEvent(WsLifeCycleEvent.WSRM_SEND_AFTER_RSTR_BEFORE_CREATE_SEQ);
            WsrmSequenceContext wsrmSequenceContext = (WsrmSequenceContext)sAFConversationInfo.getContext();
            boolean bl = wsrmSequenceContext.isSoap12();
            SOAPMessage sOAPMessage = WsrmSequenceSender.createSOAPMessage(bl);
            SoapMessageContext soapMessageContext = WsrmSequenceSender.createSendSoapContext(wsrmSequenceContext, sOAPMessage);
            if (wsrmSequenceContext.getAcksTo() != null) {
                WsrmSequenceSender.setWSAVersion(soapMessageContext, wsrmSequenceContext.getAcksTo().getNamespaceURI());
            }
            String string = sAFConversationInfo.getDestinationURL();
            String string2 = sAFConversationInfo.getCreateConversationMessageID();
            WsrmSequenceSender.setupCreateSequenceAddressingHeaders(wsrmSequenceContext, soapMessageContext, string, string2, sOAPMessage);
            CreateSequenceMsg createSequenceMsg = new CreateSequenceMsg(wsrmSequenceContext.getRmVersion());
            createSequenceMsg.setAcksTo(wsrmSequenceContext.getAcksTo());
            WsrmSequenceSender.setupCreateSequenceSecurity(wsrmSequenceContext, createSequenceMsg, soapMessageContext);
            WsrmSequenceSender.setupCreateSequenceExpires(sAFConversationInfo, createSequenceMsg);
            SAFConversationInfo sAFConversationInfo2 = sAFConversationInfo.getConversationOffer();
            AddressingProvider addressingProvider = AddressingProviderFactory.getInstance().getAddressingProvider(soapMessageContext);
            if (sAFConversationInfo2 != null) {
                WsrmSequenceSender.setupCreateSequenceOffer(sAFConversationInfo2, createSequenceMsg, soapMessageContext);
            } else {
                soapMessageContext.getHeaders().addHeader(addressingProvider.createReplyToHeader(wsrmSequenceContext.getAcksTo()));
            }
            if (verbose) {
                Verbose.log("Send create to " + string);
            }
            try {
                createSequenceMsg.writeMsg(sOAPMessage);
            }
            catch (HandshakeMsgException handshakeMsgException) {
                if (verbose) {
                    Verbose.logException(handshakeMsgException);
                }
                throw new SAFTransportException("Failed to write Create Sequence message body", handshakeMsgException);
            }
            WsrmSequenceSender.applySecurity(soapMessageContext, wsrmSequenceContext);
            SoapMessageContext soapMessageContext2 = WsrmSequenceSender.sendMessageWithSubject(soapMessageContext, string, sAFConversationInfo, wsrmSequenceContext);
            WsLifeCycleListenerRegistry.getInstance().onEvent(WsLifeCycleEvent.WSRM_SEND_AFTER_CREATE_SEQ_BEFORE_RES);
            if (soapMessageContext2 == null) {
                return null;
            }
            return WsrmSequenceSender.handleSyncCreateSequenceResponse(soapMessageContext2, wsrmSequenceContext, sAFConversationInfo, sAFConversationInfo2, string2);
        }
        catch (Exception exception) {
            if (verbose) {
                Verbose.logException(exception);
            }
            if (exception instanceof SAFTransportException) {
                throw (SAFTransportException)exception;
            }
            throw (RuntimeException)exception;
        }
    }

    private static SAFConversationHandle handleSyncCreateSequenceResponse(SoapMessageContext soapMessageContext, WsrmSequenceContext wsrmSequenceContext, SAFConversationInfo sAFConversationInfo, SAFConversationInfo sAFConversationInfo2, String string) throws SAFTransportException {
        WsrmSequenceSender.handleResponseSecurity(soapMessageContext, wsrmSequenceContext, sAFConversationInfo);
        SOAPMessage sOAPMessage = soapMessageContext.getMessage();
        try {
            SOAPBody sOAPBody = sOAPMessage.getSOAPBody();
            if (sOAPBody == null) {
                throw new SAFTransportException("Empty body for create sequence response message");
            }
            Element element = DOMUtils.getOptionalElementByTagNameNS((Element)sOAPBody, wsrmSequenceContext.getRmVersion().getNamespaceUri(), WsrmConstants.Element.CREATE_SEQUENCE_RESPONSE.getElementName());
            if (element != null) {
                return WsrmSequenceSender.handleCreateSequenceResponseElement(element, sAFConversationInfo2, sAFConversationInfo, string, wsrmSequenceContext);
            }
            WsrmSequenceSender.handleCreateSequenceResponseFault(sOAPBody, wsrmSequenceContext);
            return null;
        }
        catch (SOAPException sOAPException) {
            if (verbose) {
                Verbose.logException(sOAPException);
            }
            throw new SAFTransportException("SOAPException", sOAPException);
        }
        catch (DOMProcessingException dOMProcessingException) {
            if (verbose) {
                Verbose.logException((Throwable)((Object)dOMProcessingException));
            }
            throw new SAFTransportException("DOMProcessingException", (Throwable)((Object)dOMProcessingException));
        }
    }

    private static void handleCreateSequenceResponseFault(SOAPBody sOAPBody, WsrmSequenceContext wsrmSequenceContext) {
        SOAPFault sOAPFault = sOAPBody.getFault();
        if (sOAPFault == null) {
            throw new JAXRPCException("Protocol failure in create sequence");
        }
        if (sOAPFault.getFaultCodeAsQName().equals(new CreateSequenceRefusedFaultMsg(new Exception(), wsrmSequenceContext.getRmVersion()).getSubCodeQName())) {
            throw new JAXRPCException("Create sequence refused by the receiving side");
        }
        throw new JAXRPCException("Create sequence failed, received a fault message: " + sOAPFault.getFaultString());
    }

    private static SAFConversationHandle handleCreateSequenceResponseElement(Element element, SAFConversationInfo sAFConversationInfo, SAFConversationInfo sAFConversationInfo2, String string, WsrmSequenceContext wsrmSequenceContext) {
        Object object;
        CreateSequenceResponseMsg createSequenceResponseMsg = new CreateSequenceResponseMsg(wsrmSequenceContext.getRmVersion());
        createSequenceResponseMsg.read(element);
        String string2 = createSequenceResponseMsg.getSequenceId();
        SequenceAccept sequenceAccept = createSequenceResponseMsg.getAccept();
        if (sequenceAccept != null) {
            object = sequenceAccept.getAcksTo();
            if (sAFConversationInfo != null) {
                WsrmSequenceContext wsrmSequenceContext2 = new WsrmSequenceContext();
                wsrmSequenceContext2.setRmVersion(wsrmSequenceContext.getRmVersion());
                wsrmSequenceContext2.setWsaVersion(wsrmSequenceContext.getWsaVersion());
                wsrmSequenceContext2.setFrom(wsrmSequenceContext.getFrom());
                wsrmSequenceContext2.setAcksTo((EndpointReference)object);
                sAFConversationInfo.setContext(wsrmSequenceContext2);
            }
        }
        object = createSequenceResponseMsg.getExpires();
        long l = Long.MAX_VALUE;
        if (object != null) {
            l = ((Duration)object).getTimeInMillis(new Date());
        }
        WsLifeCycleListenerRegistry.getInstance().onEvent(WsLifeCycleEvent.WSRM_SEND_AFTER_CREATE_SEQ_RES_BEFORE_RM);
        return new SAFConversationHandleImpl(string2, l, sAFConversationInfo2.getMaximumIdleTime(), sAFConversationInfo, string, wsrmSequenceContext);
    }

    private static void setupCreateSequenceOffer(SAFConversationInfo sAFConversationInfo, CreateSequenceMsg createSequenceMsg, SoapMessageContext soapMessageContext) {
        Object object;
        SequenceOffer sequenceOffer = new SequenceOffer(createSequenceMsg.getRmVersion());
        sequenceOffer.setSequenceId(WsrmSequenceSender.getSequenceIdFromConversationInfo(sAFConversationInfo));
        long l = sAFConversationInfo.getTimeToLive();
        if (l != Long.MAX_VALUE) {
            try {
                object = DatatypeFactory.newInstance().newDuration(l);
                sequenceOffer.setExpires(((Duration)object).toString());
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                throw new JAXRPCException((Throwable)datatypeConfigurationException);
            }
            catch (Throwable throwable) {
                throw new JAXRPCException(throwable);
            }
        }
        if (createSequenceMsg.getRmVersion().isLaterThanOrEqualTo(WsrmConstants.RMVersion.RM_11)) {
            sequenceOffer.setEndpoint(createSequenceMsg.getAcksTo());
            sequenceOffer.setIncompleteSequenceBehavior(WsrmConstants.IncompleteSequenceBehavior.NoDiscard);
        }
        createSequenceMsg.setOffer(sequenceOffer);
        object = AddressingProviderFactory.getInstance().getAddressingProvider(soapMessageContext);
        EndpointReference endpointReference = object.createEndpointReference(sAFConversationInfo.getDestinationURL());
        ServiceIdentityHeader serviceIdentityHeader = new ServiceIdentityHeader();
        serviceIdentityHeader.setServerName(LocalServerIdentity.getIdentity().getServerName());
        serviceIdentityHeader.setServiceName("weblogic.wsee.conversation.msg.cluster.service");
        endpointReference.getReferenceParameters().addHeader(serviceIdentityHeader);
        soapMessageContext.getHeaders().addHeader(object.createReplyToHeader(endpointReference));
    }

    private static void setupCreateSequenceSecurity(WsrmSequenceContext wsrmSequenceContext, CreateSequenceMsg createSequenceMsg, SoapMessageContext soapMessageContext) {
        WsrmSecurityContext wsrmSecurityContext;
        block5: {
            wsrmSecurityContext = wsrmSequenceContext.getWsrmSecurityContext();
            if (wsrmSecurityContext.isSecureWithWssc()) {
                try {
                    SCTokenHandlerBase sCTokenHandlerBase = wsrmSecurityContext.isSecureWithWssp12Wssc13() ? new weblogic.wsee.security.wssc.v13.sct.SCTokenHandler() : new SCTokenHandler();
                    SCTokenBase sCTokenBase = (SCTokenBase)sCTokenHandlerBase.getSecurityToken("NO-VALUE-TYPE", wsrmSecurityContext.getSCCredential(), null);
                    SecurityTokenReference securityTokenReference = sCTokenHandlerBase.getSTR(WSSConstants.REFERENCE_QNAME, sCTokenBase.getValueType(), sCTokenBase);
                    createSequenceMsg.setSecurityTokenReference(securityTokenReference);
                    if (createSequenceMsg.getRmVersion().isLaterThanOrEqualTo(WsrmConstants.RMVersion.RM_11)) {
                        soapMessageContext.getHeaders().addHeader(new UsesSequenceSTRHeader(createSequenceMsg.getRmVersion()));
                    }
                }
                catch (WSSecurityException wSSecurityException) {
                    if (!verbose) break block5;
                    Verbose.logException(wSSecurityException);
                }
            }
        }
        if (wsrmSecurityContext.isSecureWithSSL() && createSequenceMsg.getRmVersion().isLaterThanOrEqualTo(WsrmConstants.RMVersion.RM_11)) {
            soapMessageContext.getHeaders().addHeader(new UsesSequenceSSLHeader(createSequenceMsg.getRmVersion()));
        }
    }

    private static void setupCreateSequenceExpires(SAFConversationInfo sAFConversationInfo, CreateSequenceMsg createSequenceMsg) {
        long l = sAFConversationInfo.getTimeToLive();
        if (l != Long.MAX_VALUE) {
            try {
                Duration duration = DatatypeFactory.newInstance().newDuration(l);
                createSequenceMsg.setExpires(duration);
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                throw new JAXRPCException((Throwable)datatypeConfigurationException);
            }
            catch (Throwable throwable) {
                throw new JAXRPCException(throwable);
            }
        }
    }

    private static void setupCreateSequenceAddressingHeaders(WsrmSequenceContext wsrmSequenceContext, SoapMessageContext soapMessageContext, String string, String string2, SOAPMessage sOAPMessage) {
        AddressingProvider addressingProvider = AddressingProviderFactory.getInstance().getAddressingProvider(soapMessageContext);
        soapMessageContext.getHeaders().addHeader(addressingProvider.createToHeader(string));
        soapMessageContext.getHeaders().addHeader(addressingProvider.createFaultToHeader(addressingProvider.createAnonymousEndpointReference()));
        soapMessageContext.getHeaders().addHeader(addressingProvider.createMessageIdHeader(string2));
        String string3 = WsrmConstants.Action.CREATE_SEQUENCE.getActionURI(wsrmSequenceContext.getRmVersion());
        soapMessageContext.getHeaders().addHeader(addressingProvider.createActionHeader(string3));
        if (!AsyncUtil.isSoap12(soapMessageContext)) {
            sOAPMessage.getMimeHeaders().setHeader("SOAPAction", string3);
        }
    }

    private static boolean applySecurity(SoapMessageContext soapMessageContext, WsrmSequenceContext wsrmSequenceContext) throws SAFTransportException {
        if (wsrmSequenceContext == null || !wsrmSequenceContext.isSecure()) {
            return false;
        }
        try {
            WsrmSecurityContext wsrmSecurityContext = wsrmSequenceContext.getWsrmSecurityContext();
            NormalizedExpression normalizedExpression = wsrmSecurityContext.getSecurityPolicy();
            soapMessageContext.setProperty("weblogic.wsee.policy.effectiveRequestPolicy", normalizedExpression);
            if (verbose) {
                Verbose.log(normalizedExpression);
            }
            soapMessageContext.setProperty("weblogic.wsee.policy.effectiveResponsePolicy", normalizedExpression);
            soapMessageContext.setProperty("weblogic.weblogic.wsee.security.policy.WssPolicyCtx", WssPolicyUtils.getContext());
            soapMessageContext.setProperty("weblogic.wsee.security.wss.CredentialProviderList", WssPolicyUtils.getCredentialProviders());
            if (wsrmSecurityContext.isSecureWithWssc()) {
                soapMessageContext.setProperty("weblogic.wsee.wssc.sct", wsrmSecurityContext.getSCCredential());
            }
        }
        catch (PolicyException policyException) {
            if (verbose) {
                Verbose.logException(policyException);
            }
            throw new SAFTransportException("Failed to set policy for create sequence", policyException);
        }
        catch (WssConfigurationException wssConfigurationException) {
            if (verbose) {
                Verbose.logException(wssConfigurationException);
            }
            throw new SAFTransportException("Failed to set policy for create sequence", wssConfigurationException);
        }
        return true;
    }

    public static void closeSequence(String string) throws SAFTransportException {
        String string2;
        SoapMessageContext soapMessageContext;
        WsrmSequenceContext wsrmSequenceContext;
        SAFConversationInfo sAFConversationInfo;
        block14: {
            sAFConversationInfo = WsrmSAFManager.getConversationInfo(true, string, false);
            wsrmSequenceContext = (WsrmSequenceContext)sAFConversationInfo.getContext();
            boolean bl = wsrmSequenceContext.isSoap12();
            SOAPMessage sOAPMessage = WsrmSequenceSender.createSOAPMessage(bl);
            soapMessageContext = new SoapMessageContext(bl);
            soapMessageContext.setMessage(sOAPMessage);
            WsrmSequenceSender.setWSAVersion(soapMessageContext, wsrmSequenceContext.getWsaVersion());
            string2 = WsrmSequenceSender.getLifecycleEndpointAddress(wsrmSequenceContext, sAFConversationInfo);
            String string3 = WsrmConstants.Action.CLOSE_SEQUENCE.getActionURI(wsrmSequenceContext.getRmVersion());
            WsrmSequenceSender.setupEndOfLifeAddressingHeaders(string3, string2, soapMessageContext, sOAPMessage, wsrmSequenceContext);
            if (verbose) {
                Verbose.log("Map sender side conversation name " + sAFConversationInfo.getConversationName() + " to receiver side conversation name " + sAFConversationInfo.getDynamicConversationName());
            }
            CloseSequenceMsg closeSequenceMsg = new CloseSequenceMsg(wsrmSequenceContext.getRmVersion(), sAFConversationInfo.getDynamicConversationName());
            if (wsrmSequenceContext.getRmVersion().isLaterThanOrEqualTo(WsrmConstants.RMVersion.RM_11)) {
                long l;
                try {
                    l = SAFManagerImpl.getManager().getLastAssignedSequenceValueOnSendingSide(string);
                }
                catch (SAFException sAFException) {
                    throw new JAXRPCException(sAFException.toString(), (Throwable)sAFException);
                }
                closeSequenceMsg.setLastMsgNumber(l);
            }
            try {
                closeSequenceMsg.writeMsg(sOAPMessage);
            }
            catch (HandshakeMsgException handshakeMsgException) {
                if (verbose) {
                    Verbose.logException(handshakeMsgException);
                }
                throw new SAFTransportException("Failed to write CloseSequence message body", handshakeMsgException);
            }
            if (verbose) {
                Verbose.log("Close sequence " + string + " to " + string2);
            }
            WsrmSequenceSender.applySecurity(soapMessageContext, wsrmSequenceContext);
            wsrmSequenceContext.setClosed(true);
            try {
                SAFManagerImpl.getManager().storeConversationContextOnSendingSide(string, wsrmSequenceContext);
            }
            catch (SAFException sAFException) {
                if (!verbose) break block14;
                Verbose.logException(sAFException);
            }
        }
        SoapMessageContext soapMessageContext2 = WsrmSequenceSender.sendMessageWithSubject(soapMessageContext, string2, sAFConversationInfo, wsrmSequenceContext);
        if (wsrmSequenceContext.getRmVersion().isBefore(WsrmConstants.RMVersion.RM_11)) {
            if (soapMessageContext2 != null && verbose) {
                Verbose.log("Got unexpected reply from close sequence message");
            }
        } else if (soapMessageContext2 != null) {
            WsrmSequenceSender.handleSyncCloseSequenceResponse(soapMessageContext2, string, wsrmSequenceContext, sAFConversationInfo);
        }
    }

    private static void handleSyncCloseSequenceResponse(SoapMessageContext soapMessageContext, String string, WsrmSequenceContext wsrmSequenceContext, SAFConversationInfo sAFConversationInfo) throws SAFTransportException {
        block9: {
            WsrmSequenceSender.handleResponseSecurity(soapMessageContext, wsrmSequenceContext, sAFConversationInfo);
            SOAPMessage sOAPMessage = soapMessageContext.getMessage();
            try {
                SOAPBody sOAPBody;
                block10: {
                    sOAPBody = sOAPMessage.getSOAPBody();
                    if (sOAPBody == null) {
                        throw new SAFTransportException("Empty body for close sequence response message");
                    }
                    Element element = DOMUtils.getOptionalElementByTagNameNS((Element)sOAPBody, wsrmSequenceContext.getRmVersion().getNamespaceUri(), WsrmConstants.Element.CLOSE_SEQUENCE_RESPONSE.getElementName());
                    if (element != null) {
                        CloseSequenceResponseMsg closeSequenceResponseMsg = new CloseSequenceResponseMsg(wsrmSequenceContext.getRmVersion());
                        closeSequenceResponseMsg.read(element);
                        WsrmSAFManagerFactory.getWsrmSAFSendingManager().handleCloseSequenceResponse(closeSequenceResponseMsg);
                        break block9;
                    }
                    wsrmSequenceContext.setClosed(false);
                    try {
                        SAFManagerImpl.getManager().storeConversationContextOnSendingSide(string, wsrmSequenceContext);
                    }
                    catch (SAFException sAFException) {
                        if (!verbose) break block10;
                        Verbose.logException(sAFException);
                    }
                }
                WsrmSequenceSender.handleCloseSequenceResponseFault(sOAPBody);
            }
            catch (SOAPException sOAPException) {
                if (verbose) {
                    Verbose.logException(sOAPException);
                }
                throw new SAFTransportException("SOAPException", sOAPException);
            }
            catch (DOMProcessingException dOMProcessingException) {
                if (verbose) {
                    Verbose.logException((Throwable)((Object)dOMProcessingException));
                }
                throw new SAFTransportException("DOMProcessingException", (Throwable)((Object)dOMProcessingException));
            }
        }
    }

    private static void handleCloseSequenceResponseFault(SOAPBody sOAPBody) {
        SOAPFault sOAPFault = sOAPBody.getFault();
        if (sOAPFault == null) {
            throw new JAXRPCException("Protocol failure in close sequence");
        }
        throw new JAXRPCException("Close sequence failed, received a fault message: " + sOAPFault.getFaultString());
    }

    public static void terminateSequence(SAFConversationInfo sAFConversationInfo, boolean bl) throws SAFTransportException {
        if (!bl) {
            WsrmSequenceSender.terminateAndDestroyConversationWithSAF(sAFConversationInfo);
            return;
        }
        WsrmSequenceContext wsrmSequenceContext = (WsrmSequenceContext)sAFConversationInfo.getContext();
        boolean bl2 = wsrmSequenceContext.isSoap12();
        SOAPMessage sOAPMessage = WsrmSequenceSender.createSOAPMessage(bl2);
        SoapMessageContext soapMessageContext = new SoapMessageContext(bl2);
        soapMessageContext.setMessage(sOAPMessage);
        WsrmSequenceSender.setWSAVersion(soapMessageContext, wsrmSequenceContext.getWsaVersion());
        String string = WsrmSequenceSender.getLifecycleEndpointAddress(wsrmSequenceContext, sAFConversationInfo);
        String string2 = WsrmConstants.Action.TERMINATE_SEQUENCE.getActionURI(wsrmSequenceContext.getRmVersion());
        WsrmSequenceSender.setupEndOfLifeAddressingHeaders(string2, string, soapMessageContext, sOAPMessage, wsrmSequenceContext);
        String string3 = WsrmSequenceSender.getSequenceIdFromConversationInfo(sAFConversationInfo);
        if (sAFConversationInfo.isDynamic() && sAFConversationInfo.getDynamicConversationName() != null && verbose) {
            Verbose.log("Map sender side conversation name " + sAFConversationInfo.getConversationName() + " to receiver side conversation name " + sAFConversationInfo.getDynamicConversationName());
        }
        TerminateSequenceMsg terminateSequenceMsg = new TerminateSequenceMsg(wsrmSequenceContext.getRmVersion(), string3);
        if (wsrmSequenceContext.getRmVersion().isLaterThanOrEqualTo(WsrmConstants.RMVersion.RM_11)) {
            long l;
            try {
                l = SAFManagerImpl.getManager().getLastAssignedSequenceValueOnSendingSide(sAFConversationInfo.getConversationName());
            }
            catch (SAFException sAFException) {
                throw new JAXRPCException(sAFException.toString(), (Throwable)sAFException);
            }
            terminateSequenceMsg.setLastMsgNumber(l);
        }
        try {
            terminateSequenceMsg.writeMsg(sOAPMessage);
        }
        catch (HandshakeMsgException handshakeMsgException) {
            if (verbose) {
                Verbose.logException(handshakeMsgException);
            }
            throw new SAFTransportException("Failed to write Terminate Sequence message body", handshakeMsgException);
        }
        if (verbose) {
            Verbose.log("Terminate sequence " + string3 + " to " + string);
        }
        WsrmSequenceSender.applySecurity(soapMessageContext, wsrmSequenceContext);
        SoapMessageContext soapMessageContext2 = WsrmSequenceSender.sendMessageWithSubject(soapMessageContext, string, sAFConversationInfo, wsrmSequenceContext);
        if (wsrmSequenceContext.getRmVersion().isBefore(WsrmConstants.RMVersion.RM_11)) {
            if (soapMessageContext2 != null && verbose) {
                Verbose.log("Got unexpected reply from terminate sequence message");
            }
        } else if (soapMessageContext2 != null) {
            WsrmSequenceSender.handleSyncTerminateSequenceResponse(soapMessageContext2, wsrmSequenceContext, sAFConversationInfo);
        }
    }

    private static String getSequenceIdFromConversationInfo(SAFConversationInfo sAFConversationInfo) {
        String string;
        if (sAFConversationInfo.isDynamic() && sAFConversationInfo.getDynamicConversationName() != null) {
            string = sAFConversationInfo.getDynamicConversationName();
            if (verbose) {
                Verbose.log("Map sender side conversation name " + sAFConversationInfo.getConversationName() + " to receiver side conversation name " + sAFConversationInfo.getDynamicConversationName());
            }
        } else {
            string = sAFConversationInfo.getConversationName();
        }
        return string;
    }

    private static void terminateAndDestroyConversationWithSAF(SAFConversationInfo sAFConversationInfo) {
        try {
            SAFManagerImpl.getManager().closeConversationOnSendingSide(sAFConversationInfo.getConversationName(), true);
        }
        catch (SAFException sAFException) {
            throw new JAXRPCException(sAFException.toString(), (Throwable)sAFException);
        }
    }

    private static void handleSyncTerminateSequenceResponse(SoapMessageContext soapMessageContext, WsrmSequenceContext wsrmSequenceContext, SAFConversationInfo sAFConversationInfo) throws SAFTransportException {
        WsrmSequenceSender.handleResponseSecurity(soapMessageContext, wsrmSequenceContext, sAFConversationInfo);
        SOAPMessage sOAPMessage = soapMessageContext.getMessage();
        try {
            SOAPBody sOAPBody = sOAPMessage.getSOAPBody();
            if (sOAPBody == null) {
                throw new SAFTransportException("Empty body for terminate sequence response message");
            }
            Element element = DOMUtils.getOptionalElementByTagNameNS((Element)sOAPBody, wsrmSequenceContext.getRmVersion().getNamespaceUri(), WsrmConstants.Element.TERMINATE_SEQUENCE_RESPONSE.getElementName());
            if (element != null) {
                TerminateSequenceResponseMsg terminateSequenceResponseMsg = new TerminateSequenceResponseMsg(wsrmSequenceContext.getRmVersion());
                terminateSequenceResponseMsg.read(element);
                WsrmSAFManagerFactory.getWsrmSAFSendingManager().handleTerminateSequenceResponse(terminateSequenceResponseMsg);
            } else {
                WsrmSequenceSender.handleTerminateSequenceResponseFault(sOAPBody);
            }
        }
        catch (SOAPException sOAPException) {
            if (verbose) {
                Verbose.logException(sOAPException);
            }
            throw new SAFTransportException("SOAPException", sOAPException);
        }
        catch (DOMProcessingException dOMProcessingException) {
            if (verbose) {
                Verbose.logException((Throwable)((Object)dOMProcessingException));
            }
            throw new SAFTransportException("DOMProcessingException", (Throwable)((Object)dOMProcessingException));
        }
    }

    private static void handleTerminateSequenceResponseFault(SOAPBody sOAPBody) {
        SOAPFault sOAPFault = sOAPBody.getFault();
        if (sOAPFault == null) {
            throw new JAXRPCException("Protocol failure in terminate sequence");
        }
        throw new JAXRPCException("Terminate sequence failed, received a fault message: " + sOAPFault.getFaultString());
    }

    private static String getLifecycleEndpointAddress(WsrmSequenceContext wsrmSequenceContext, SAFConversationInfo sAFConversationInfo) {
        String string = wsrmSequenceContext.getLifecycleEndpoint() != null ? wsrmSequenceContext.getLifecycleEndpoint().getAddress() : sAFConversationInfo.getDestinationURL();
        return string;
    }

    private static void setupEndOfLifeAddressingHeaders(String string, String string2, SoapMessageContext soapMessageContext, SOAPMessage sOAPMessage, WsrmSequenceContext wsrmSequenceContext) {
        EndpointReference endpointReference;
        AddressingProvider addressingProvider = AddressingProviderFactory.getInstance().getAddressingProvider(soapMessageContext);
        ToHeader toHeader = addressingProvider.createToHeader(string2);
        ActionHeader actionHeader = addressingProvider.createActionHeader();
        actionHeader.setActionURI(string);
        soapMessageContext.getHeaders().addHeader(toHeader);
        soapMessageContext.getHeaders().addHeader(actionHeader);
        soapMessageContext.getHeaders().addHeader(addressingProvider.createMessageIdHeader(Guid.generateGuid()));
        soapMessageContext.getHeaders().addHeader(addressingProvider.createFromHeader(addressingProvider.createAnonymousEndpointReference()));
        if (!AsyncUtil.isSoap12(soapMessageContext)) {
            sOAPMessage.getMimeHeaders().setHeader("SOAPAction", string);
        }
        if (wsrmSequenceContext.getRmVersion().isLaterThanOrEqualTo(WsrmConstants.RMVersion.RM_11)) {
            endpointReference = wsrmSequenceContext.getMainAckTo();
            if (endpointReference == null) {
                endpointReference = wsrmSequenceContext.getAcksTo();
            }
            soapMessageContext.getHeaders().addHeader(addressingProvider.createReplyToHeader(endpointReference));
        }
        if ((endpointReference = wsrmSequenceContext.getLifecycleEndpoint()) == null) {
            endpointReference = wsrmSequenceContext.getDestination();
        }
        if (endpointReference != null) {
            WsrmSequenceSender.addReferenceHeaders(endpointReference, soapMessageContext);
        }
    }

    public static void acknowledge(SAFConversationInfo sAFConversationInfo, List<Long> list, EndpointReference endpointReference, WsrmSequenceContext wsrmSequenceContext, boolean bl) throws SAFTransportException, SAFException {
        block13: {
            SOAPMessage sOAPMessage;
            Object object;
            String string = WsrmSequenceSender.getSequenceIdFromConversationInfo(sAFConversationInfo);
            String string2 = endpointReference.getAddress();
            if (AddressingHelper.isAnonymousReferenceURI(string2)) {
                if (verbose) {
                    Verbose.log("Skip sending acknowledgement, encountered anonymous URI");
                }
                return;
            }
            SOAPMessage sOAPMessage2 = WsrmSequenceSender.createSOAPMessage(bl);
            SoapMessageContext soapMessageContext = WsrmSequenceSender.createSendSoapContext(wsrmSequenceContext, sOAPMessage2);
            WsrmSequenceSender.setWSAVersion(soapMessageContext, endpointReference.getNamespaceURI());
            WsrmSequenceSender.addReferenceHeaders(endpointReference, soapMessageContext);
            WsrmSequenceSender.setupAckAddressingHeaders(wsrmSequenceContext, string, list, soapMessageContext, string2, sOAPMessage2);
            if (verbose) {
                object = null;
                sOAPMessage = list.iterator();
                while (sOAPMessage.hasNext()) {
                    long l = sOAPMessage.next();
                    long l2 = sOAPMessage.next();
                    object = (String)object + "< sequenceNumberLow=" + l + " sequenceNumberHigh=" + l2 + "> ";
                }
                Verbose.log("Send acknowledge to " + string2 + " with sequence id = " + string + " sequence range: " + (String)object);
            }
            WsrmSequenceSender.applySecurity(soapMessageContext, wsrmSequenceContext);
            object = WsrmSequenceSender.sendMessage(soapMessageContext, string2, sAFConversationInfo, wsrmSequenceContext);
            WsLifeCycleListenerRegistry.getInstance().onEvent(WsLifeCycleEvent.WSRM_RECV_AFTER_ACK);
            if (object != null) {
                SOAPBody sOAPBody;
                sOAPMessage = ((SoapMessageContext)object).getMessage();
                try {
                    sOAPBody = sOAPMessage.getSOAPBody();
                }
                catch (SOAPException sOAPException) {
                    if (verbose) {
                        Verbose.logException(sOAPException);
                    }
                    throw new SAFTransportException("SOAPException", true, sOAPException);
                }
                if (sOAPBody == null) {
                    throw new SAFTransportException("Empty reply body");
                }
                if (!sOAPBody.hasFault()) {
                    throw new SAFTransportException("Got a message back that is not a fault message.");
                }
                try {
                    SequenceFaultMsg sequenceFaultMsg = SequenceFaultMsgFactory.getInstance().parseSoapFault(sOAPMessage, wsrmSequenceContext.getRmVersion());
                    if (verbose) {
                        Verbose.log("Found fault: " + sequenceFaultMsg.getSubCodeQualifiedName());
                    }
                    WsrmSAFManagerFactory.getWsrmSAFReceivingManager().handleFault(sequenceFaultMsg);
                }
                catch (SequenceFaultException sequenceFaultException) {
                    if (!verbose) break block13;
                    SOAPFault sOAPFault = sOAPBody.getFault();
                    Verbose.log("Received a fault message: " + sOAPFault.getFaultString());
                }
            }
        }
    }

    private static void setupAckAddressingHeaders(WsrmSequenceContext wsrmSequenceContext, String string, List list, SoapMessageContext soapMessageContext, String string2, SOAPMessage sOAPMessage) {
        Object object;
        AcknowledgementHeader acknowledgementHeader = (AcknowledgementHeader)MsgHeaderFactory.getInstance().createMsgHeader(WsrmHeader.getQName(AcknowledgementHeader.class, wsrmSequenceContext.getRmVersion()));
        acknowledgementHeader.setSequenceId(string);
        if (wsrmSequenceContext.isClosed()) {
            acknowledgementHeader.setFinal(true);
        }
        if (list.isEmpty()) {
            acknowledgementHeader.setNone(true);
        } else {
            object = list.iterator();
            while (object.hasNext()) {
                long l = (Long)object.next();
                long l2 = (Long)object.next();
                acknowledgementHeader.acknowledgeMessages(l, l2);
            }
        }
        object = AddressingProviderFactory.getInstance().getAddressingProvider(soapMessageContext);
        soapMessageContext.getHeaders().addHeader(acknowledgementHeader);
        soapMessageContext.getHeaders().addHeader(object.createToHeader(string2));
        soapMessageContext.getHeaders().addHeader(object.createFromHeader(object.createAnonymousEndpointReference()));
        soapMessageContext.getHeaders().addHeader(object.createFaultToHeader(object.createAnonymousEndpointReference()));
        String string3 = WsrmConstants.Action.ACK.getActionURI(wsrmSequenceContext.getRmVersion());
        soapMessageContext.getHeaders().addHeader(object.createActionHeader(string3));
        if (!AsyncUtil.isSoap12(soapMessageContext)) {
            sOAPMessage.getMimeHeaders().setHeader("SOAPAction", string3);
        }
    }

    private static SoapMessageContext sendMessageWithSubject(final SOAPMessageContext sOAPMessageContext, final String string, final SAFConversationInfo sAFConversationInfo, final WsrmSequenceContext wsrmSequenceContext) throws SAFTransportException {
        AuthenticatedSubject authenticatedSubject = null;
        if (wsrmSequenceContext != null) {
            authenticatedSubject = wsrmSequenceContext.getSecuritySubject();
        }
        if (authenticatedSubject == null) {
            return WsrmSequenceSender.sendMessage(sOAPMessageContext, string, sAFConversationInfo, wsrmSequenceContext);
        }
        try {
            return (SoapMessageContext)SecurityServiceManager.runAs((AuthenticatedSubject)((AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction())), (AuthenticatedSubject)authenticatedSubject, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws SAFTransportException {
                    return WsrmSequenceSender.sendMessage(sOAPMessageContext, string, sAFConversationInfo, wsrmSequenceContext);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof SAFTransportException) {
                throw (SAFTransportException)exception;
            }
            throw new SAFTransportException(exception.getMessage());
        }
    }

    private static final void performWSSCHandshake(WsrmSequenceContext wsrmSequenceContext, String string) throws SAFTransportException {
        WsrmSecurityContext wsrmSecurityContext = wsrmSequenceContext.getWsrmSecurityContext();
        if (wsrmSecurityContext.isSecureWithWssc()) {
            boolean bl = wsrmSequenceContext.isSoap12();
            SOAPMessage sOAPMessage = WsrmSequenceSender.createSOAPMessage(bl);
            final SoapMessageContext soapMessageContext = WsrmSequenceSender.createSendSoapContext(wsrmSequenceContext, sOAPMessage);
            soapMessageContext.setProperty("javax.xml.rpc.service.endpoint.address", string);
            try {
                X509Certificate x509Certificate;
                NormalizedExpression normalizedExpression = wsrmSecurityContext.getSecurityPolicy();
                soapMessageContext.setProperty("weblogic.wsee.policy.effectiveRequestPolicy", normalizedExpression);
                soapMessageContext.setProperty("weblogic.wsee.policy.effectiveResponsePolicy", normalizedExpression);
                X509Certificate x509Certificate2 = wsrmSecurityContext.getServerEncryptCert();
                if (x509Certificate2 != null) {
                    soapMessageContext.setProperty("weblogic.wsee.security.bst.serverEncryptCert", x509Certificate2);
                }
                if ((x509Certificate = wsrmSecurityContext.getServerVerifyCert()) != null) {
                    soapMessageContext.setProperty("weblogic.wsee.security.bst.serverVerifyCert", x509Certificate);
                }
                SCTokenBase sCTokenBase = (SCTokenBase)SecurityServiceManager.runAs((AuthenticatedSubject)((AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction())), (AuthenticatedSubject)wsrmSequenceContext.getSecuritySubject(), (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() {
                        return SCTHelper.performWSSCHandshake(soapMessageContext);
                    }
                });
                wsrmSecurityContext.setSCCredential(sCTokenBase.getCredential());
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new HandshakeMsgException(privilegedActionException.getMessage(), privilegedActionException);
            }
            catch (PolicyException policyException) {
                throw new HandshakeMsgException(policyException.getMessage(), policyException);
            }
        }
    }

    private static final void performWSSC13Handshake(WsrmSequenceContext wsrmSequenceContext, String string) throws SAFTransportException {
        WsrmSecurityContext wsrmSecurityContext = wsrmSequenceContext.getWsrmSecurityContext();
        if (wsrmSecurityContext.isSecureWithWssp12Wssc13()) {
            boolean bl = wsrmSequenceContext.isSoap12();
            SOAPMessage sOAPMessage = WsrmSequenceSender.createSOAPMessage(bl);
            final SoapMessageContext soapMessageContext = WsrmSequenceSender.createSendSoapContext(wsrmSequenceContext, sOAPMessage);
            soapMessageContext.setProperty("javax.xml.rpc.service.endpoint.address", string);
            try {
                X509Certificate x509Certificate;
                NormalizedExpression normalizedExpression = wsrmSecurityContext.getSecurityPolicy();
                soapMessageContext.setProperty("weblogic.wsee.policy.effectiveRequestPolicy", normalizedExpression);
                soapMessageContext.setProperty("weblogic.wsee.policy.effectiveResponsePolicy", normalizedExpression);
                X509Certificate x509Certificate2 = wsrmSecurityContext.getServerEncryptCert();
                if (x509Certificate2 != null) {
                    soapMessageContext.setProperty("weblogic.wsee.security.bst.serverEncryptCert", x509Certificate2);
                }
                if ((x509Certificate = wsrmSecurityContext.getServerVerifyCert()) != null) {
                    soapMessageContext.setProperty("weblogic.wsee.security.bst.serverVerifyCert", x509Certificate);
                }
                SCTokenBase sCTokenBase = (SCTokenBase)SecurityServiceManager.runAs((AuthenticatedSubject)((AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction())), (AuthenticatedSubject)wsrmSequenceContext.getSecuritySubject(), (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() {
                        return weblogic.wsee.security.wssc.v13.sct.SCTHelper.performWSSCHandshake(soapMessageContext);
                    }
                });
                wsrmSecurityContext.setSCCredential(sCTokenBase.getCredential());
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new HandshakeMsgException(privilegedActionException.getMessage(), privilegedActionException);
            }
            catch (PolicyException policyException) {
                throw new HandshakeMsgException(policyException.getMessage(), policyException);
            }
        }
    }

    private static SoapMessageContext sendMessage(SOAPMessageContext sOAPMessageContext, String string, SAFConversationInfo sAFConversationInfo, WsrmSequenceContext wsrmSequenceContext) throws SAFTransportException {
        WsrmSecurityContext wsrmSecurityContext;
        Connection connection = WsrmSequenceSender.establishConnection(string, ((SoapMessageContext)sOAPMessageContext).isSoap12());
        assert (sOAPMessageContext.getMessage() != null);
        sOAPMessageContext.setProperty("javax.xml.rpc.service.endpoint.address", (Object)string);
        String string2 = WsrmSequenceSender.getSequenceIdFromConversationInfo(sAFConversationInfo);
        ActionHeader actionHeader = (ActionHeader)((SoapMessageContext)sOAPMessageContext).getHeaders().getHeader(ActionHeader.TYPE);
        if (actionHeader != null && !AsyncUtil.isSoap12((MessageContext)sOAPMessageContext)) {
            sOAPMessageContext.getMessage().getMimeHeaders().setHeader("SOAPAction", actionHeader.getActionURI());
        }
        HTTPClientTransport hTTPClientTransport = (HTTPClientTransport)connection.getTransport();
        String string3 = "Unknown";
        if (sOAPMessageContext.containsProperty("weblogic.wsee.addressing.Action")) {
            string3 = (String)sOAPMessageContext.getProperty("weblogic.wsee.addressing.Action");
        } else if (actionHeader != null) {
            string3 = actionHeader.getActionURI();
        }
        SequenceHeader sequenceHeader = (SequenceHeader)((SoapMessageContext)sOAPMessageContext).getHeaders().getHeader(SequenceHeader.TYPE);
        if (verbose) {
            if (sequenceHeader != null) {
                Verbose.log("** Sending sequence message with action " + string3 + " seq num " + sequenceHeader.getMessageNumber() + " on sequence " + sAFConversationInfo.getConversationName() + (sAFConversationInfo.getDynamicConversationName() != null ? " receive side sequence " + sAFConversationInfo.getDynamicConversationName() : "") + " to: " + string);
            } else {
                Verbose.log("** Sending message with action " + string3 + " on sequence " + sAFConversationInfo.getConversationName() + (sAFConversationInfo.getDynamicConversationName() != null ? " receive side sequence " + sAFConversationInfo.getDynamicConversationName() : "") + " to: " + string);
            }
        }
        int n = 0;
        try {
            WsrmSequenceSender.setTransportInfoIntoMessageContext(wsrmSequenceContext, sOAPMessageContext);
            new MimeHeaderHandler().handleRequest((MessageContext)sOAPMessageContext);
            WsrmSAFSendingManager.addTestSequenceSSLHeaderIfNeeded(wsrmSequenceContext, (WlMessageContext)sOAPMessageContext);
            if (wsrmSequenceContext != null && wsrmSequenceContext.isSecure()) {
                if (sOAPMessageContext.getProperty("weblogic.wsee.async.res") != null || !wsrmSequenceContext.isSequenceCreator()) {
                    AsyncUtil.getWssServerHandler(wsrmSequenceContext).handleResponse((MessageContext)sOAPMessageContext);
                } else {
                    AsyncUtil.getWssClientHandler(wsrmSequenceContext).handleRequest((MessageContext)sOAPMessageContext);
                }
                if (((SoapMessageContext)sOAPMessageContext).getFault() != null) {
                    Throwable throwable = ((SoapMessageContext)sOAPMessageContext).getFault();
                    if (verbose) {
                        Verbose.logException(throwable);
                    }
                    throw new SAFTransportException("Send failed", throwable);
                }
                WsrmSequenceSender.saveMCForAsyncResponse((SoapMessageContext)sOAPMessageContext);
            }
            wsrmSecurityContext = null;
            if (wsrmSequenceContext != null) {
                wsrmSecurityContext = wsrmSequenceContext.getWsrmSecurityContext();
            }
            WsrmSequenceSender.setTransportInfoIntoMessageContext(wsrmSequenceContext, sOAPMessageContext);
            ConnectionHandler.verifySSLAdapterOnMessageContextIfNeeded((MessageContext)sOAPMessageContext);
            hTTPClientTransport.setConnectionTimeout(30000);
            connection.send((MessageContext)sOAPMessageContext);
            hTTPClientTransport.confirmOneway(true);
            if (wsrmSecurityContext != null && wsrmSecurityContext.isSecureWithSSL() && wsrmSecurityContext.getSSLSessionId() == null) {
                byte[] byArray = WsrmSequenceSender.getSSLSessionId(connection, true);
                if (verbose) {
                    Verbose.say("");
                    Verbose.say("%%%%%%%%%%%%%%%%%%%%% Setting SSL/WLS Session ID on sending-side sequence %%%%%%%%%%");
                    WsrmSAFManager.dumpByteArray(byArray);
                    Verbose.say("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
                    Verbose.say("");
                }
                wsrmSequenceContext.getWsrmSecurityContext().setSSLSessionId(byArray);
            }
            n = hTTPClientTransport.getResponseCode();
        }
        catch (IOException iOException) {
            block31: {
                if (verbose) {
                    if (sequenceHeader != null) {
                        Verbose.say("Unable to send sequence message on sequence " + sequenceHeader.getSequenceId() + " and message number " + sequenceHeader.getMessageNumber() + " to destination " + string + ": " + iOException.toString());
                    } else {
                        Verbose.say("Unable to send message on sequence " + string2 + " to dest " + string + ": " + iOException.toString());
                    }
                    Verbose.logException(iOException);
                }
                if (iOException instanceof SSLHandshakeException) {
                    WsrmPermanentTransportException wsrmPermanentTransportException = new WsrmPermanentTransportException(iOException.toString(), iOException);
                    throw new SAFTransportException(wsrmPermanentTransportException.toString(), wsrmPermanentTransportException);
                }
                try {
                    n = hTTPClientTransport.getResponseCode();
                }
                catch (Exception exception) {
                    if (!verbose) break block31;
                    Verbose.logException(exception);
                }
            }
            if (n == 500) {
                WsrmSequenceSender.throwSOAPFaultExceptionFromConnectionInfo(n, connection, sOAPMessageContext);
            }
            throw new SAFTransportException("Send failed", iOException);
        }
        if (n == 200) {
            try {
                connection.receive((MessageContext)sOAPMessageContext);
                wsrmSecurityContext = sOAPMessageContext.getMessage();
                assert (wsrmSecurityContext != null);
            }
            catch (IOException iOException) {
                if (verbose) {
                    Verbose.logException(iOException);
                }
                throw new SAFTransportException("Receive failed", true, iOException);
            }
            if (verbose) {
                Verbose.getOut().println("\n\n");
                Verbose.log("Got sync message response in WsrmSequenceSender.sendMessage");
            }
            return (SoapMessageContext)sOAPMessageContext;
        }
        return null;
    }

    private static void setTransportInfoIntoMessageContext(WsrmSequenceContext wsrmSequenceContext, SOAPMessageContext sOAPMessageContext) {
        TransportInfo transportInfo;
        if (wsrmSequenceContext != null && sOAPMessageContext.getProperty("weblogic.wsee.connection.transportinfo") == null && (transportInfo = wsrmSequenceContext.getTransportInfo()) != null) {
            SSLAdapter sSLAdapter;
            sOAPMessageContext.setProperty("weblogic.wsee.connection.transportinfo", (Object)transportInfo);
            if (sOAPMessageContext.getProperty("weblogic.wsee.client.ssladapter") == null && transportInfo instanceof HttpsTransportInfo && (sSLAdapter = ((HttpsTransportInfo)transportInfo).getSSLAdapter()) != null) {
                sOAPMessageContext.setProperty("weblogic.wsee.client.ssladapter", (Object)sSLAdapter);
            }
        }
    }

    private static byte[] getSSLSessionId(Connection connection, boolean bl) {
        if (connection == null) {
            throw new JAXRPCException("Target service has SSL/TLS security enabled, but client connection is null");
        }
        Transport transport = connection.getTransport();
        if (!(transport instanceof HTTPClientTransport)) {
            throw new JAXRPCException("Target service has SSL/TLS security enabled, but client connection doesn't support SSL: " + transport);
        }
        HTTPClientTransport hTTPClientTransport = (HTTPClientTransport)transport;
        byte[] byArray = hTTPClientTransport.getSSLSessionId();
        if (byArray == null && bl) {
            throw new JAXRPCException("Target service has SSL/TLS security enabled, but client connection didn't have the SSLSession set");
        }
        return byArray;
    }

    private static void throwSOAPFaultExceptionFromConnectionInfo(int n, Connection connection, SOAPMessageContext sOAPMessageContext) throws SAFTransportException {
        if (verbose) {
            Verbose.say("Got HTTP " + n + " error, trying to read detailed WS-RM error information");
        }
        try {
            connection.receive((MessageContext)sOAPMessageContext);
            SOAPMessage sOAPMessage = sOAPMessageContext.getMessage();
            if (verbose) {
                Verbose.getOut().println("\n\n");
                Verbose.log("Got HTTP " + n + " message fault response in WsrmSequenceSender.sendMessage");
            }
            try {
                SequenceFaultMsgFactory.getInstance().parseSoapFault(sOAPMessage);
                SOAPFault sOAPFault = sOAPMessage.getSOAPBody().getFault();
                SOAPFaultException sOAPFaultException = new SOAPFaultException(sOAPFault.getFaultCodeAsQName(), sOAPFault.getFaultString(), sOAPFault.getFaultActor(), sOAPFault.getDetail());
                throw new WsrmPermanentTransportException(sOAPFaultException.toString(), sOAPFaultException);
            }
            catch (SequenceFaultException sequenceFaultException) {
                return;
            }
        }
        catch (WsrmPermanentTransportException wsrmPermanentTransportException) {
            throw new SAFTransportException(wsrmPermanentTransportException.toString(), wsrmPermanentTransportException);
        }
        catch (Exception exception) {
            if (verbose) {
                Verbose.logException(exception);
                Verbose.say("Ignoring prior exception generated during an attempt to get specific error from HTTP, and throwing generic HTTP exception instead");
            }
            return;
        }
    }

    public static void sendFault(String string, WsrmSequenceContext wsrmSequenceContext, EndpointReference endpointReference, Exception exception, boolean bl) throws SAFTransportException {
        MessageFactory messageFactory = WLMessageFactory.getInstance().getMessageFactory(bl);
        SOAPMessage sOAPMessage = SOAPFaultUtil.exception2Fault(messageFactory, exception);
        WsrmSequenceSender.sendFault(string, wsrmSequenceContext, endpointReference, sOAPMessage, bl);
    }

    public static void sendFault(String string, WsrmSequenceContext wsrmSequenceContext, EndpointReference endpointReference, SequenceFaultMsg sequenceFaultMsg, boolean bl) throws SAFTransportException {
        SOAPMessage sOAPMessage = WsrmSequenceSender.createSOAPMessage(bl);
        sequenceFaultMsg.write(sOAPMessage);
        WsrmSequenceSender.sendFault(string, wsrmSequenceContext, endpointReference, sOAPMessage, bl);
    }

    public static void sendFault(String string, WsrmSequenceContext wsrmSequenceContext, EndpointReference endpointReference, SOAPMessage sOAPMessage, boolean bl) throws SAFTransportException {
        Object object;
        if (AddressingHelper.isAnonymousReferenceURI(endpointReference.getAddress())) {
            if (verbose) {
                Verbose.log("Skip sending fault, encountered anonymous URI");
            }
            return;
        }
        SoapMessageContext soapMessageContext = new SoapMessageContext(bl);
        WsrmSequenceSender.setWSAVersion(soapMessageContext, wsrmSequenceContext.getWsaVersion());
        soapMessageContext.setMessage(sOAPMessage);
        WsrmSequenceSender.addReferenceHeaders(endpointReference, soapMessageContext);
        String string2 = endpointReference.getAddress();
        WsrmSequenceSender.setupFaultAddressingHeaders(soapMessageContext, string2, sOAPMessage);
        if (soapMessageContext.getProperty("weblogic.wsee.connection.transportinfo") == null && (object = wsrmSequenceContext.getTransportInfo()) != null) {
            SSLAdapter sSLAdapter;
            soapMessageContext.setProperty("weblogic.wsee.connection.transportinfo", object);
            if (soapMessageContext.getProperty("weblogic.wsee.client.ssladapter") == null && object instanceof HttpsTransportInfo && (sSLAdapter = ((HttpsTransportInfo)object).getSSLAdapter()) != null) {
                soapMessageContext.setProperty("weblogic.wsee.client.ssladapter", sSLAdapter);
            }
        }
        new MimeHeaderHandler().handleRequest(soapMessageContext);
        WsrmSequenceSender.applySecurity(soapMessageContext, wsrmSequenceContext);
        if (wsrmSequenceContext.getWsrmSecurityContext().isSecureWithWssc() && !AsyncUtil.getWssClientHandler(wsrmSequenceContext).handleRequest((MessageContext)soapMessageContext)) {
            throw new JAXRPCException(soapMessageContext.getFault());
        }
        if (verbose) {
            Verbose.log("Send fault to " + endpointReference.getAddress() + " with sequence id = " + string);
        }
        object = WsrmSequenceSender.establishConnection(string2, bl);
        try {
            object.send(soapMessageContext);
            object.getTransport().confirmOneway();
        }
        catch (IOException iOException) {
            if (verbose) {
                Verbose.logException(iOException);
            }
            throw new SAFTransportException("Send failed", iOException);
        }
    }

    private static void setupFaultAddressingHeaders(SoapMessageContext soapMessageContext, String string, SOAPMessage sOAPMessage) {
        AddressingProvider addressingProvider = AddressingProviderFactory.getInstance().getAddressingProvider(soapMessageContext);
        soapMessageContext.getHeaders().addHeader(addressingProvider.createToHeader(string));
        soapMessageContext.getHeaders().addHeader(addressingProvider.createActionHeader(WSAddressingConstants.FAULT_ACTION_URI));
        soapMessageContext.getHeaders().addHeader(addressingProvider.createFromHeader(addressingProvider.createAnonymousEndpointReference()));
        soapMessageContext.getHeaders().addHeader(addressingProvider.createFaultToHeader(addressingProvider.createAnonymousEndpointReference()));
        if (!AsyncUtil.isSoap12(soapMessageContext)) {
            sOAPMessage.getMimeHeaders().setHeader("SOAPAction", WSAddressingConstants.FAULT_ACTION_URI);
        }
        soapMessageContext.setProperty("javax.xml.rpc.service.endpoint.address", string);
    }

    private static void addReferenceHeaders(EndpointReference endpointReference, SoapMessageContext soapMessageContext) {
        Iterator iterator = endpointReference.getReferenceProperties().listHeaders();
        while (iterator.hasNext()) {
            soapMessageContext.getHeaders().addHeader((MsgHeader)iterator.next());
        }
        iterator = endpointReference.getReferenceParameters().listHeaders();
        while (iterator.hasNext()) {
            soapMessageContext.getHeaders().addHeader((MsgHeader)iterator.next());
        }
    }

    private static Connection establishConnection(String string, boolean bl) throws SAFTransportException {
        int n = string.indexOf(58);
        String string2 = n < 0 ? "http" : string.substring(0, n);
        try {
            return ConnectionFactory.instance().createClientConnection(string2, bl ? "SOAP12" : "SOAP11");
        }
        catch (ConnectionException connectionException) {
            if (verbose) {
                Verbose.logException(connectionException);
            }
            throw new SAFTransportException("ConnectionException", connectionException);
        }
    }

    private static SOAPMessage createSOAPMessage(boolean bl) throws SAFTransportException {
        MessageFactory messageFactory = WLMessageFactory.getInstance().getMessageFactory(bl);
        try {
            return messageFactory.createMessage();
        }
        catch (SOAPException sOAPException) {
            if (verbose) {
                Verbose.logException(sOAPException);
            }
            throw new SAFTransportException("Create SOAP Message failed", sOAPException);
        }
    }

    private static void setWSAVersion(SoapMessageContext soapMessageContext, String string) {
        soapMessageContext.setProperty("weblogic.wsee.addressing.version", (Object)AddressingHelper.getWSAVersion(string));
    }

    private static void setWSAVersion(SoapMessageContext soapMessageContext, WSAVersion wSAVersion) {
        soapMessageContext.setProperty("weblogic.wsee.addressing.version", (Object)wSAVersion);
    }

    private static void removeFromHeader(SOAPHeader sOAPHeader) throws DOMProcessingException {
        Element element = DOMUtils.getOptionalElementByTagNameNS((Element)sOAPHeader, "http://schemas.xmlsoap.org/ws/2004/08/addressing", "From");
        if (element == null) {
            return;
        }
        element.getParentNode().removeChild(element);
    }
}

