/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability;

import javax.xml.datatype.DatatypeFactory;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.MessageContext;
import weblogic.j2ee.descriptor.wl.PortComponentBean;
import weblogic.j2ee.descriptor.wl.ReliabilityConfigBean;
import weblogic.wsee.jws.container.Duration;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.reliability.WsrmHandler;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.ws.WsPort;

public class WsrmServerConfigHandler
extends WsrmHandler {
    private static final boolean verbose = Verbose.isVerbose(WsrmServerConfigHandler.class);

    public boolean handleRequest(MessageContext messageContext) {
        if (!(messageContext instanceof WlMessageContext)) {
            return true;
        }
        WlMessageContext wlMessageContext = (WlMessageContext)messageContext;
        WsPort wsPort = wlMessageContext.getDispatcher().getWsPort();
        PortComponentBean portComponentBean = wsPort.getPortComponent();
        ReliabilityConfigBean reliabilityConfigBean = portComponentBean.getReliabilityConfig();
        if (reliabilityConfigBean == null) {
            return true;
        }
        this.handleInactivityTimeout(reliabilityConfigBean, wlMessageContext);
        this.handleAcknowledgementInterval(reliabilityConfigBean, wlMessageContext);
        this.handleSequenceExpiration(reliabilityConfigBean, wlMessageContext);
        this.handleBufferRetryCount(reliabilityConfigBean, wlMessageContext);
        this.handleBufferRetryDelay(reliabilityConfigBean, wlMessageContext);
        this.handleBaseRetransmissionInterval(reliabilityConfigBean, wlMessageContext);
        this.handleRetransmissionExponentialBackoff(reliabilityConfigBean, wlMessageContext);
        return true;
    }

    private void handleInactivityTimeout(ReliabilityConfigBean reliabilityConfigBean, WlMessageContext wlMessageContext) {
        String string = reliabilityConfigBean.getInactivityTimeout();
        if (string != null) {
            wlMessageContext.setProperty("weblogic.wsee.wsrm.InactivityTimeout", string);
            if (verbose) {
                Verbose.say("InactivityTimeout is " + string);
            }
        }
    }

    private void handleAcknowledgementInterval(ReliabilityConfigBean reliabilityConfigBean, WlMessageContext wlMessageContext) {
        String string = reliabilityConfigBean.getAcknowledgementInterval();
        if (string != null) {
            wlMessageContext.setProperty("weblogic.wsee.wsrm.AcknowledgementInterval", string);
            if (verbose) {
                Verbose.say("AcknowledgementInterval is " + string);
            }
        }
    }

    private void handleSequenceExpiration(ReliabilityConfigBean reliabilityConfigBean, WlMessageContext wlMessageContext) {
        String string = reliabilityConfigBean.getSequenceExpiration();
        if (string != null) {
            wlMessageContext.setProperty("weblogic.wsee.wsrm.SequenceExpiration", string);
            if (verbose) {
                Verbose.log("Sequence expires at " + string);
            }
        }
    }

    private void handleBufferRetryCount(ReliabilityConfigBean reliabilityConfigBean, WlMessageContext wlMessageContext) {
        int n = reliabilityConfigBean.getBufferRetryCount();
        wlMessageContext.setProperty("weblogic.wsee.wsrm.RetryCount", Long.toString(n));
    }

    private void handleBufferRetryDelay(ReliabilityConfigBean reliabilityConfigBean, WlMessageContext wlMessageContext) {
        String string = reliabilityConfigBean.getBufferRetryDelay();
        if (string != null) {
            try {
                javax.xml.datatype.Duration duration = DatatypeFactory.newInstance().newDuration(string);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(duration.getYears()).append("y");
                stringBuffer.append(duration.getMonths()).append("m");
                stringBuffer.append(duration.getDays()).append("d");
                stringBuffer.append(duration.getHours()).append("h");
                stringBuffer.append(duration.getMinutes()).append("m");
                stringBuffer.append(duration.getSeconds()).append("s");
                Duration duration2 = new Duration(stringBuffer.toString());
                wlMessageContext.setProperty("weblogic.wsee.wsrm.RetryDelay", duration2.toString());
                if (verbose) {
                    Verbose.log("BufferRetryDelay is " + duration2.toString() + " msec");
                }
            }
            catch (Exception exception) {
                throw new JAXRPCException(exception.toString(), (Throwable)exception);
            }
        }
    }

    private void handleBaseRetransmissionInterval(ReliabilityConfigBean reliabilityConfigBean, WlMessageContext wlMessageContext) {
        String string = reliabilityConfigBean.getBaseRetransmissionInterval();
        if (string != null) {
            wlMessageContext.setProperty("weblogic.wsee.wsrm.BaseRetransmissionInterval", string);
            if (verbose) {
                Verbose.log("BaseRetransmission is " + string);
            }
        }
    }

    private void handleRetransmissionExponentialBackoff(ReliabilityConfigBean reliabilityConfigBean, WlMessageContext wlMessageContext) {
        boolean bl = reliabilityConfigBean.getRetransmissionExponentialBackoff();
        if (bl) {
            wlMessageContext.setProperty("weblogic.wsee.wsrm.RetransmissionExponentialBackoff", bl);
        } else {
            wlMessageContext.removeProperty("weblogic.wsee.wsrm.RetransmissionExponentialBackoff");
        }
        if (verbose) {
            Verbose.log("RetransmissionExponentialBackoff is " + bl);
        }
    }
}

