/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability;

import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import weblogic.wsee.addressing.RelatesToHeader;
import weblogic.wsee.async.AsyncUtil;
import weblogic.wsee.message.MsgHeaders;
import weblogic.wsee.message.WlMessageContext;
import weblogic.wsee.message.soap.SoapMessageContext;
import weblogic.wsee.policy.framework.NormalizedExpression;
import weblogic.wsee.policy.runtime.PolicyContext;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability.WsrmHandler;
import weblogic.wsee.reliability.WsrmSAFManagerFactory;
import weblogic.wsee.reliability.WsrmSequenceContext;
import weblogic.wsee.reliability.faults.IllegalRMVersionFaultException;
import weblogic.wsee.reliability.faults.UnknownSequenceFaultException;
import weblogic.wsee.reliability.faults.WSRMRequiredFaultMsg;
import weblogic.wsee.reliability.handshake.SAFConversationInfoNotFoundException;
import weblogic.wsee.reliability.handshake.WsrmServerHandshakeHandler;
import weblogic.wsee.reliability.headers.SequenceHeader;
import weblogic.wsee.reliability.policy.WsrmPolicyServiceRuntimeHandler;
import weblogic.wsee.server.WsLifeCycleEvent;
import weblogic.wsee.server.WsLifeCycleListenerRegistry;
import weblogic.wsee.util.Verbose;
import weblogic.wsee.util.WLMessageFactory;

public class WsrmServerHandler
extends WsrmHandler {
    private static final boolean verbose = Verbose.isVerbose(WsrmServerHandler.class);

    public boolean handleRequest(MessageContext messageContext) {
        boolean bl;
        boolean bl2;
        if (!(messageContext instanceof SOAPMessageContext)) {
            return true;
        }
        SOAPMessageContext sOAPMessageContext = (SOAPMessageContext)messageContext;
        WlMessageContext wlMessageContext = WlMessageContext.narrow(messageContext);
        MsgHeaders msgHeaders = wlMessageContext.getHeaders();
        if (msgHeaders == null) {
            return true;
        }
        try {
            new WsrmPolicyServiceRuntimeHandler().processRequest((MessageContext)sOAPMessageContext, this.getEffectivePolicy(messageContext));
        }
        catch (Exception exception) {
            throw new JAXRPCException(exception.toString(), (Throwable)exception);
        }
        try {
            bl2 = this.handleSequenceMsg(msgHeaders, sOAPMessageContext);
        }
        catch (SAFConversationInfoNotFoundException sAFConversationInfoNotFoundException) {
            return false;
        }
        catch (Exception exception) {
            sOAPMessageContext.setProperty("weblogic.wsee.reliable.oneway.reply", (Object)true);
            ((SoapMessageContext)sOAPMessageContext).setFault(exception);
            return false;
        }
        boolean bl3 = bl = wlMessageContext.getProperty("weblogic.wsee.rm.mandatory") == null;
        if (!bl && !bl2) {
            WsrmConstants.RMVersion rMVersion = (WsrmConstants.RMVersion)((Object)sOAPMessageContext.getProperty("weblogic.wsee.wsrm.RMVersion"));
            if (rMVersion == null) {
                rMVersion = WsrmConstants.RMVersion.latest();
            }
            if (rMVersion == WsrmConstants.RMVersion.RM_10) {
                throw new JAXRPCException("This endpoint requires reliable messaging");
            }
            WSRMRequiredFaultMsg wSRMRequiredFaultMsg = new WSRMRequiredFaultMsg(rMVersion);
            boolean bl4 = AsyncUtil.isSoap12((MessageContext)sOAPMessageContext);
            MessageFactory messageFactory = WLMessageFactory.getInstance().getMessageFactory(bl4);
            try {
                SOAPMessage sOAPMessage = messageFactory.createMessage();
                sOAPMessageContext.setMessage(sOAPMessage);
                wSRMRequiredFaultMsg.write(sOAPMessage);
            }
            catch (SOAPException sOAPException) {
                if (verbose) {
                    Verbose.logException(sOAPException);
                }
                throw new JAXRPCException("Create SOAP Message failed", (Throwable)sOAPException);
            }
        }
        if (bl2) {
            messageContext.setProperty("weblogic.wsee.queued.invoke", (Object)"true");
            return false;
        }
        return true;
    }

    private boolean handleSequenceMsg(MsgHeaders msgHeaders, SOAPMessageContext sOAPMessageContext) {
        SequenceHeader sequenceHeader = (SequenceHeader)msgHeaders.getHeader(SequenceHeader.TYPE);
        if (sequenceHeader != null) {
            WsrmSequenceContext wsrmSequenceContext;
            String string = sequenceHeader.getSequenceId();
            if (verbose) {
                Verbose.log("Sequence received with ID: " + string + ", Message #: " + sequenceHeader.getMessageNumber());
            }
            NormalizedExpression normalizedExpression = this.getEffectivePolicy((MessageContext)sOAPMessageContext);
            try {
                wsrmSequenceContext = WsrmServerHandshakeHandler.checkRMVersionMatchWithCreateSequence(false, string, sequenceHeader.getRmVersion(), (MessageContext)sOAPMessageContext, normalizedExpression);
            }
            catch (IllegalRMVersionFaultException illegalRMVersionFaultException) {
                WsrmServerHandshakeHandler.sendIllegalRMVersionFault(illegalRMVersionFaultException, sOAPMessageContext);
                return true;
            }
            catch (UnknownSequenceFaultException unknownSequenceFaultException) {
                WsrmServerHandshakeHandler.sendUnknownSequenceFault(unknownSequenceFaultException, sOAPMessageContext);
                return true;
            }
            if (wsrmSequenceContext.isSecureWithSSL()) {
                WsrmServerHandshakeHandler.validateSSLSessionId(wsrmSequenceContext.getWsrmSecurityContext(), (WlMessageContext)sOAPMessageContext);
            }
            if (wsrmSequenceContext.isSecure()) {
                WsrmServerHandshakeHandler.validateCredential(false, string, sequenceHeader.getRmVersion(), (MessageContext)sOAPMessageContext);
            }
            if (msgHeaders.getHeader(RelatesToHeader.TYPE) != null) {
                WsLifeCycleListenerRegistry.getInstance().onEvent(WsLifeCycleEvent.WSRM_SEND_AFTER_RES_WSRM_SEC_VALIDATION);
            }
            WsrmSAFManagerFactory.getWsrmSAFReceivingManager().deliver(sequenceHeader, sOAPMessageContext);
            if (!((WlMessageContext)sOAPMessageContext).hasFault() && verbose) {
                Verbose.log("Sequence delivered");
            }
            return true;
        }
        return false;
    }

    private NormalizedExpression getEffectivePolicy(MessageContext messageContext) {
        NormalizedExpression normalizedExpression;
        try {
            normalizedExpression = messageContext.containsProperty("weblogic.wsee.async.res") ? PolicyContext.getResponseEffectivePolicy(messageContext) : PolicyContext.getRequestEffectivePolicy(messageContext);
        }
        catch (Exception exception) {
            throw new JAXRPCException(exception.toString(), (Throwable)exception);
        }
        return normalizedExpression;
    }
}

