/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import weblogic.apache.xml.serialize.OutputFormat;
import weblogic.apache.xml.serialize.XMLSerializer;
import weblogic.wsee.addressing.EndpointReference;
import weblogic.wsee.reliability.WsrmPayloadContext;
import weblogic.wsee.util.Verbose;

public class WsrmServerPayloadContext
extends WsrmPayloadContext {
    private static final boolean verbose = Verbose.isVerbose(WsrmServerPayloadContext.class);
    private EndpointReference fromEndpt;
    private EndpointReference faultToEndpt;

    public void setFaultTo(EndpointReference endpointReference) {
        this.faultToEndpt = endpointReference;
    }

    public void setFrom(EndpointReference endpointReference) {
        this.fromEndpt = endpointReference;
    }

    public EndpointReference getFaultTo() {
        return this.faultToEndpt;
    }

    public EndpointReference getFrom() {
        return this.fromEndpt;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        int n = objectInput.readInt();
        this.fromEndpt = n > 0 ? this.readEndpt(objectInput, n) : null;
        n = objectInput.readInt();
        this.faultToEndpt = n > 0 ? this.readEndpt(objectInput, n) : null;
    }

    private EndpointReference readEndpt(ObjectInput objectInput, int n) throws IOException, ClassNotFoundException {
        byte[] byArray = new byte[n];
        int n2 = 0;
        for (int i = 0; i < n; i += n2) {
            n2 = objectInput.read(byArray, i, n - i);
        }
        if (verbose) {
            Verbose.log("Reading Endpoint:");
            for (int i = 0; i < byArray.length; ++i) {
                Verbose.getOut().print((char)byArray[i]);
            }
            Verbose.getOut().println();
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(byteArrayInputStream);
            EndpointReference endpointReference = new EndpointReference();
            endpointReference.read(document.getDocumentElement());
            return endpointReference;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException(parserConfigurationException.toString());
        }
        catch (SAXException sAXException) {
            throw new IOException(sAXException.toString());
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        if (this.fromEndpt != null) {
            this.writeEndpt(this.fromEndpt, objectOutput);
        } else {
            objectOutput.writeInt(0);
        }
        if (this.faultToEndpt != null) {
            this.writeEndpt(this.faultToEndpt, objectOutput);
        } else {
            objectOutput.writeInt(0);
        }
    }

    private void writeEndpt(EndpointReference endpointReference, ObjectOutput objectOutput) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputFormat outputFormat = new OutputFormat("XML", null, false);
        XMLSerializer xMLSerializer = new XMLSerializer((OutputStream)byteArrayOutputStream, outputFormat);
        xMLSerializer.serialize(endpointReference.getEndptElement());
        byte[] byArray = byteArrayOutputStream.toByteArray();
        if (verbose) {
            Verbose.log("Writing Endpoint:");
            for (int i = 0; i < byArray.length; ++i) {
                Verbose.getOut().print((char)byArray[i]);
            }
            Verbose.getOut().println();
        }
        objectOutput.writeInt(byArray.length);
        objectOutput.write(byArray);
    }
}

