/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.datatype.Duration;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.Stub;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import weblogic.wsee.jaxrpc.StubImpl;
import weblogic.wsee.reliability.WsrmProtocolUtils;
import weblogic.wsee.util.Verbose;

public class WsrmUtils {
    public static boolean isSequenceInitialized(Stub stub) {
        Map map = WsrmUtils.getInvokePropertiesFromStub(stub);
        return WsrmProtocolUtils.isSequenceInitialized(map);
    }

    public static String waitForSequenceInitialization(Stub stub, long l, long l2) {
        Map map = WsrmUtils.getInvokePropertiesFromStub(stub);
        return WsrmProtocolUtils.waitForSequenceInitialization(map, l, l2);
    }

    public static void sendEmptyLastMessage(Stub stub) {
        Map map = WsrmUtils.getInvokePropertiesFromStub(stub);
        String string = (String)stub._getProperty("javax.xml.rpc.service.endpoint.address");
        WsrmProtocolUtils.sendEmptyLastMessage(map, string);
    }

    private static Map getInvokePropertiesFromStub(Stub stub) {
        if (stub == null) {
            throw new JAXRPCException("Stub is null");
        }
        Map map = (Map)stub._getProperty("weblogic.wsee.invoke_properties");
        if (map == null) {
            throw new JAXRPCException("No invoke properties found on the stub.");
        }
        return map;
    }

    public static void closeSequence(Stub stub) {
        Map map = WsrmUtils.getInvokePropertiesFromStub(stub);
        WsrmProtocolUtils.closeSequence(map);
    }

    public static void terminateSequence(Stub stub) {
        Map map = WsrmUtils.getInvokePropertiesFromStub(stub);
        WsrmProtocolUtils.terminateSequence(map);
    }

    public static void reset(Stub stub) {
        Map map = (Map)stub._getProperty("weblogic.wsee.invoke_properties");
        WsrmProtocolUtils.reset(map);
    }

    public static String getSequenceId(Stub stub) {
        Map map = WsrmUtils.getInvokePropertiesFromStub(stub);
        return WsrmProtocolUtils.getSequenceId(map);
    }

    public static void setExpires(Stub stub, Duration duration) {
        Map map = WsrmUtils.getPropertiesFromStub(stub);
        WsrmProtocolUtils.setExpires(map, duration);
        WsrmUtils.setPropertiesOntoStub(map, stub);
    }

    private static Map getPropertiesFromStub(Stub stub) {
        if (stub == null) {
            throw new JAXRPCException("Stub is null");
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Iterator iterator = stub._getPropertyNames();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object object = stub._getProperty(string);
            if (object == null) continue;
            hashMap.put(string, object);
        }
        return hashMap;
    }

    private static void setPropertiesOntoStub(Map map, Stub stub) {
        if (stub == null) {
            throw new JAXRPCException("Stub is null");
        }
        Iterator iterator = stub._getPropertyNames();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (map.containsKey(string)) {
                Object v = map.get(string);
                stub._setProperty(string, v);
                continue;
            }
            if (!(stub instanceof StubImpl)) continue;
            ((StubImpl)stub)._removeProperty(string);
        }
    }

    public static Duration getExpires(Stub stub) {
        return WsrmProtocolUtils.getExpires(WsrmUtils.getPropertiesFromStub(stub));
    }

    public static void setOfferExpires(Stub stub, Duration duration) {
        Map map = WsrmUtils.getPropertiesFromStub(stub);
        WsrmProtocolUtils.setOfferExpires(map, duration);
        WsrmUtils.setPropertiesOntoStub(map, stub);
    }

    public static Duration getOfferExpires(Stub stub) {
        return WsrmProtocolUtils.getOfferExpires(WsrmUtils.getPropertiesFromStub(stub));
    }

    public static void setAnonymousAck(Stub stub) {
        Map map = WsrmUtils.getPropertiesFromStub(stub);
        WsrmProtocolUtils.setAnonymousAck(map);
        WsrmUtils.setPropertiesOntoStub(map, stub);
    }

    public static boolean isAnonymousAck(Stub stub) {
        return WsrmProtocolUtils.isAnonymousAck(WsrmUtils.getPropertiesFromStub(stub));
    }

    public static void setLastMessage(Stub stub) {
        Map map = WsrmUtils.getPropertiesFromStub(stub);
        WsrmProtocolUtils.setLastMessage(map);
        WsrmUtils.setPropertiesOntoStub(map, stub);
    }

    public static boolean isLastMessage(Stub stub) {
        return WsrmProtocolUtils.isLastMessage(WsrmUtils.getPropertiesFromStub(stub));
    }

    public static void setFinalMessage(Stub stub) {
        Map map = WsrmUtils.getPropertiesFromStub(stub);
        WsrmProtocolUtils.setFinalMessage(map);
        WsrmUtils.setPropertiesOntoStub(map, stub);
    }

    public static boolean isFinalMessage(Stub stub) {
        return WsrmProtocolUtils.isFinalMessage(WsrmUtils.getPropertiesFromStub(stub));
    }

    public static void printSoapMsg(SOAPMessage sOAPMessage) {
        Verbose.getOut().println("\n-------------------------------\n");
        try {
            sOAPMessage.writeTo((OutputStream)Verbose.getOut());
        }
        catch (IOException iOException) {
            Verbose.logException(iOException);
        }
        catch (SOAPException sOAPException) {
            Verbose.logException(sOAPException);
        }
        Verbose.getOut().println("\n\n-------------------------------\n\n");
    }
}

