/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability.faults;

import java.util.Iterator;
import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Element;
import weblogic.wsee.jaxrpc.soapfault.SOAPFaultUtil;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability.WsrmProtocolUtils;
import weblogic.wsee.reliability.faults.SequenceFaultException;
import weblogic.wsee.reliability.faults.SequenceFaultMsgType;
import weblogic.wsee.reliability.faults.WsrmFaultMsg;

public class CreateSequenceRefusedFaultMsg
extends WsrmFaultMsg {
    public static final String SUBCODE_LOCAL_NAME = "CreateSequenceRefused";
    public static final SequenceFaultMsgType TYPE = new SequenceFaultMsgType();
    private final Exception exception;

    public CreateSequenceRefusedFaultMsg(Exception exception, WsrmConstants.RMVersion rMVersion) {
        super(rMVersion, WsrmConstants.FaultCode.SENDER, SUBCODE_LOCAL_NAME, "The create sequence request has been refused by the RM Destination.", TYPE);
        this.exception = exception;
    }

    public void read(SOAPMessage sOAPMessage) throws SequenceFaultException {
        try {
            SOAPBody sOAPBody = sOAPMessage.getSOAPBody();
            if (sOAPBody == null) {
                throw new SequenceFaultException("No body in SOAP message");
            }
            if (!sOAPBody.hasFault()) {
                throw new SequenceFaultException("No SOAP fault in SOAP message");
            }
            SOAPFault sOAPFault = sOAPBody.getFault();
            SOAPEnvelope sOAPEnvelope = sOAPMessage.getSOAPPart().getEnvelope();
            String string = sOAPEnvelope.getNamespaceURI();
            WsrmConstants.SOAPVersion sOAPVersion = WsrmProtocolUtils.getSOAPVersionFromNamespaceUri(string);
            if (sOAPVersion == WsrmConstants.SOAPVersion.SOAP_11) {
                String string2 = sOAPFault.getFaultCodeAsName().getLocalName();
                if (!this.getSubCodeLocalName().equals(string2)) {
                    throw new SequenceFaultException("Wrong subcode for CreateSequenceRefusedFault");
                }
            } else {
                Iterator iterator = sOAPFault.getFaultSubcodes();
                boolean bl = false;
                while (iterator.hasNext() && !bl) {
                    QName qName = (QName)iterator.next();
                    if (!this.getSubCodeQName().equals(qName)) continue;
                    bl = true;
                }
                if (!bl) {
                    throw new SequenceFaultException("Wrong subcode for CreateSequenceRefusedFault");
                }
            }
            this.reason = sOAPFault.getFaultString();
        }
        catch (SOAPException sOAPException) {
            throw new SequenceFaultException("SOAPException", sOAPException);
        }
    }

    public void write(SOAPMessage sOAPMessage) throws SequenceFaultException {
        try {
            SOAPEnvelope sOAPEnvelope = sOAPMessage.getSOAPPart().getEnvelope();
            String string = sOAPEnvelope.getNamespaceURI();
            SOAPBody sOAPBody = sOAPMessage.getSOAPBody();
            if (sOAPBody == null) {
                throw new SequenceFaultException("No body in SOAP message");
            }
            if (this.code == null) {
                throw new SequenceFaultException("Fault code is not set");
            }
            SOAPFault sOAPFault = sOAPBody.addFault();
            WsrmConstants.SOAPVersion sOAPVersion = WsrmProtocolUtils.getSOAPVersionFromNamespaceUri(string);
            if (sOAPVersion == WsrmConstants.SOAPVersion.SOAP_11) {
                Name name = sOAPEnvelope.createName(this.getSubCodeLocalName(), this.getRmVersion().getPrefix(), this.getRmVersion().getNamespaceUri());
                sOAPFault.setFaultCode(name);
            } else {
                sOAPFault.setFaultCode(sOAPEnvelope.createName(this.getCodeLocalName(sOAPVersion), sOAPEnvelope.getPrefix(), sOAPEnvelope.getNamespaceURI()));
                sOAPFault.appendFaultSubcode(this.getSubCodeQName());
            }
            if (this.reason != null) {
                sOAPFault.setFaultString(this.reason, Locale.US);
            }
            this.writeDetail(sOAPFault);
        }
        catch (SOAPException sOAPException) {
            throw new SequenceFaultException("SOAPException", sOAPException);
        }
    }

    public SequenceFaultMsgType getType() {
        return TYPE;
    }

    public void writeDetail(SOAPFault sOAPFault) throws SOAPException {
        if (this.exception != null) {
            Detail detail = sOAPFault.addDetail();
            SOAPFaultUtil.fillDetail((Throwable)this.exception, detail, false);
        }
    }

    public void writeDetail(Element element) throws SequenceFaultException {
    }

    public void readDetail(Element element) throws SequenceFaultException {
    }
}

