/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability.faults;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability.faults.SequenceFaultMsg;
import weblogic.wsee.reliability.faults.SequenceFaultMsgType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IllegalRMVersionFaultMsg
extends SequenceFaultMsg {
    public static final SequenceFaultMsgType TYPE = new SequenceFaultMsgType();
    private List<WsrmConstants.RMVersion> _allowed;
    private WsrmConstants.RMVersion _actual;

    public IllegalRMVersionFaultMsg(WsrmConstants.RMVersion rMVersion) {
        this(rMVersion, new ArrayList<WsrmConstants.RMVersion>());
    }

    public IllegalRMVersionFaultMsg(WsrmConstants.RMVersion rMVersion, List<WsrmConstants.RMVersion> list) {
        super(rMVersion, WsrmConstants.FaultCode.SENDER, "IllegalRMVersion", IllegalRMVersionFaultMsg.getFaultString(rMVersion, list), TYPE);
        this._actual = rMVersion;
    }

    static String getFaultString(WsrmConstants.RMVersion rMVersion, List<WsrmConstants.RMVersion> list) {
        return "Illegal WS-RM version found '" + (Object)((Object)rMVersion) + "'. Allowed versions are: " + IllegalRMVersionFaultMsg.getAllowedRMVersionStringFromList(list);
    }

    private static StringBuffer getAllowedRMVersionStringFromList(List<WsrmConstants.RMVersion> list) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<WsrmConstants.RMVersion> iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append((Object)iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(",");
        }
        return stringBuffer;
    }

    public void setAllowed(List<WsrmConstants.RMVersion> list) {
        this._allowed = list;
    }

    public List<WsrmConstants.RMVersion> getAllowed() {
        return this._allowed;
    }

    public WsrmConstants.RMVersion getActual() {
        return this._actual;
    }
}

