/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability.faults;

import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import weblogic.wsee.reliability.MessageRange;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability.faults.SequenceFaultException;
import weblogic.wsee.reliability.faults.SequenceFaultMsg;
import weblogic.wsee.reliability.faults.SequenceFaultMsgType;
import weblogic.wsee.util.Verbose;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvalidAckFaultMsg
extends SequenceFaultMsg {
    public static final SequenceFaultMsgType TYPE = new SequenceFaultMsgType();
    private static final boolean verbose = Verbose.isVerbose(InvalidAckFaultMsg.class);
    private SortedSet<MessageRange> ranges = new TreeSet<MessageRange>();
    private String seqId = null;
    private long nack = 0L;
    private boolean nackSet = false;

    public InvalidAckFaultMsg(WsrmConstants.RMVersion rMVersion) {
        super(rMVersion, WsrmConstants.FaultCode.SENDER, "InvalidAcknowledgement", "The SequenceAcknowledgement violates the cumulative acknowledgement invariant.", TYPE);
    }

    public void setNack(long l) {
        this.nack = l;
        this.nackSet = true;
    }

    public long getNack() {
        return this.nack;
    }

    public void acknowledgeMessages(long l, long l2) {
        this.ranges.add(new MessageRange(l, l2));
    }

    public void clear() {
        this.ranges.clear();
    }

    public Iterator listMessageRanges() {
        return this.ranges.iterator();
    }

    public void setAcknowledgementRanges(SortedSet<MessageRange> sortedSet) {
        this.ranges = sortedSet;
    }

    public SortedSet getAcknowledgementRanges() {
        return this.ranges;
    }

    @Override
    public void writeDetail(Element element) throws SequenceFaultException {
        if (this.seqId == null) {
            throw new SequenceFaultException("Sequence ID is not set");
        }
        DOMUtils.addNamespaceDeclaration(element, this.getRmVersion().getPrefix(), this.getRmVersion().getNamespaceUri());
        Element element2 = element.getOwnerDocument().createElementNS(this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.ACK.getQualifiedName(this.getRmVersion()));
        DOMUtils.addNamespaceDeclaration(element2, "wsu", "http://schemas.xmlsoap.org/ws/2002/07/utility");
        element.appendChild(element2);
        DOMUtils.addValueNS(element2, this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.IDENTIFIER.getQualifiedName(this.getRmVersion()), this.seqId);
        if (this.nackSet) {
            DOMUtils.addValueNS(element2, this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.NACK.getQualifiedName(this.getRmVersion()), Long.toString(this.nack));
        }
        Iterator iterator = this.listMessageRanges();
        while (iterator.hasNext()) {
            MessageRange messageRange = (MessageRange)iterator.next();
            Element element3 = element2.getOwnerDocument().createElementNS(this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.ACK_RANGE.getQualifiedName(this.getRmVersion()));
            element3.setAttributeNS(null, WsrmConstants.Element.LOWER.getQualifiedName(this.getRmVersion()), Long.toString(messageRange.lowerBounds));
            element3.setAttributeNS(null, WsrmConstants.Element.UPPER.getQualifiedName(this.getRmVersion()), Long.toString(messageRange.upperBounds));
            element2.appendChild(element3);
        }
    }

    @Override
    public void readDetail(Element element) throws SequenceFaultException {
        try {
            block8: {
                Element element2 = DOMUtils.getElementByTagNameNS(element, this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.ACK.getElementName());
                this.seqId = DOMUtils.getValueByTagNameNS(element2, this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.IDENTIFIER.getElementName());
                String string = DOMUtils.getOptionalValueByTagNameNS(element2, this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.NACK.getElementName());
                if (string != null) {
                    try {
                        this.nack = Long.parseLong(string);
                        this.nackSet = true;
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (!verbose) break block8;
                        Verbose.logException(numberFormatException);
                    }
                }
            }
            NodeList nodeList = element.getElementsByTagNameNS(this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.ACK_RANGE.getElementName());
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element3 = (Element)nodeList.item(i);
                long l = 0L;
                String string = element3.getAttributeNS(null, WsrmConstants.Element.LOWER.getElementName());
                if (string != null) {
                    l = Long.parseLong(string);
                }
                long l2 = 0L;
                String string2 = element3.getAttributeNS(null, WsrmConstants.Element.UPPER.getElementName());
                if (string2 != null) {
                    l2 = Long.parseLong(string2);
                }
                this.acknowledgeMessages(l, l2);
            }
        }
        catch (DOMProcessingException dOMProcessingException) {
            throw new SequenceFaultException("DOMProcessingException", (Throwable)((Object)dOMProcessingException));
        }
    }
}

