/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wsee.reliability.faults;

import java.util.Locale;
import javax.xml.soap.Detail;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.wsee.reliability.WsrmConstants;
import weblogic.wsee.reliability.WsrmProtocolUtils;
import weblogic.wsee.reliability.faults.SequenceFaultException;
import weblogic.wsee.reliability.faults.SequenceFaultMsgType;
import weblogic.wsee.reliability.faults.WsrmFaultMsg;
import weblogic.wsee.util.Verbose;
import weblogic.xml.dom.DOMProcessingException;
import weblogic.xml.dom.DOMUtils;

public abstract class SequenceFaultMsg
extends WsrmFaultMsg {
    private static final boolean verbose = Verbose.isVerbose(SequenceFaultMsg.class);
    private String seqId;

    public SequenceFaultMsg(WsrmConstants.RMVersion rMVersion, WsrmConstants.FaultCode faultCode, String string, String string2, SequenceFaultMsgType sequenceFaultMsgType) {
        super(rMVersion, faultCode, string, string2, sequenceFaultMsgType);
    }

    public void setSequenceId(String string) {
        this.seqId = string;
    }

    public String getSequenceId() {
        return this.seqId;
    }

    public void read(SOAPMessage sOAPMessage) throws SequenceFaultException {
        assert (sOAPMessage != null);
        try {
            SOAPHeader sOAPHeader = sOAPMessage.getSOAPHeader();
            if (sOAPHeader == null) {
                throw new SequenceFaultException("No header in SOAP message");
            }
            SOAPBody sOAPBody = sOAPMessage.getSOAPBody();
            if (sOAPBody == null) {
                throw new SequenceFaultException("No body in SOAP message");
            }
            if (!sOAPBody.hasFault()) {
                throw new SequenceFaultException("No SOAP fault in SOAP message");
            }
            SOAPFault sOAPFault = sOAPBody.getFault();
            this.code = WsrmProtocolUtils.getSOAPFaultCodeFromName(sOAPFault.getFaultCodeAsName());
            SOAPEnvelope sOAPEnvelope = sOAPMessage.getSOAPPart().getEnvelope();
            String string = sOAPEnvelope.getNamespaceURI();
            boolean bl = "http://www.w3.org/2003/05/soap-envelope".equals(string);
            if (bl) {
                Detail detail = sOAPFault.getDetail();
                if (detail != null) {
                    this.readDetail((Element)detail);
                }
            } else {
                Element element = DOMUtils.getElementByTagNameNS((Element)sOAPHeader, this.getRmVersion().getNamespaceUri(), WsrmConstants.Element.SEQUENCE_FAULT.getElementName());
                this.readDetail(element);
            }
            this.reason = sOAPFault.getFaultString();
        }
        catch (SOAPException sOAPException) {
            if (verbose) {
                Verbose.logException(sOAPException);
            }
            throw new SequenceFaultException("SOAPException", sOAPException);
        }
        catch (DOMProcessingException dOMProcessingException) {
            if (verbose) {
                Verbose.logException((Throwable)((Object)dOMProcessingException));
            }
            throw new SequenceFaultException("DOMProcessingException", (Throwable)((Object)dOMProcessingException));
        }
    }

    public void write(SOAPMessage sOAPMessage) throws SequenceFaultException {
        try {
            WsrmConstants.RMVersion rMVersion;
            String string;
            boolean bl;
            SOAPEnvelope sOAPEnvelope = sOAPMessage.getSOAPPart().getEnvelope();
            String string2 = sOAPEnvelope.getNamespaceURI();
            WsrmConstants.SOAPVersion sOAPVersion = WsrmProtocolUtils.getSOAPVersionFromNamespaceUri(string2);
            SOAPHeader sOAPHeader = sOAPMessage.getSOAPHeader();
            if (sOAPHeader == null) {
                throw new SequenceFaultException("No header in SOAP message");
            }
            SOAPBody sOAPBody = sOAPMessage.getSOAPBody();
            if (sOAPBody == null) {
                throw new SequenceFaultException("No body in SOAP message");
            }
            if (this.code == null) {
                throw new SequenceFaultException("Fault code is not set");
            }
            SOAPFault sOAPFault = sOAPBody.addFault();
            sOAPFault.setFaultCode(sOAPEnvelope.createName(this.getCodeLocalName(sOAPVersion), sOAPEnvelope.getPrefix(), string2));
            if (this.reason != null) {
                sOAPFault.setFaultString(this.reason, Locale.US);
            }
            boolean bl2 = bl = (string = DOMUtils.getNamespaceURI((Element)sOAPHeader, (rMVersion = this.getRmVersion()).getPrefix())) == null || string.length() == 0;
            if (bl) {
                DOMUtils.addNamespaceDeclaration((Element)sOAPHeader, rMVersion.getPrefix(), rMVersion.getNamespaceUri());
            }
            if (sOAPVersion == WsrmConstants.SOAPVersion.SOAP_11) {
                Element element = sOAPHeader.getOwnerDocument().createElementNS(rMVersion.getNamespaceUri(), WsrmConstants.Element.SEQUENCE_FAULT.getQualifiedName(rMVersion));
                DOMUtils.addValueNS(element, rMVersion.getNamespaceUri(), WsrmConstants.Element.FAULT_CODE.getQualifiedName(rMVersion), this.getSubCodeQualifiedName());
                this.writeDetail(element);
                sOAPHeader.appendChild((Node)element);
            } else {
                string = DOMUtils.getNamespaceURI((Element)sOAPFault, rMVersion.getPrefix());
                boolean bl3 = bl = string == null || string.length() == 0;
                if (bl) {
                    DOMUtils.addNamespaceDeclaration((Element)sOAPFault, rMVersion.getPrefix(), rMVersion.getNamespaceUri());
                }
                sOAPFault.appendFaultSubcode(this.getSubCodeQName());
                Detail detail = sOAPFault.addDetail();
                this.writeDetail((Element)detail);
            }
        }
        catch (SOAPException sOAPException) {
            if (verbose) {
                Verbose.logException(sOAPException);
            }
            throw new SequenceFaultException("SOAPException", sOAPException);
        }
    }

    public void writeDetail(Element element) throws SequenceFaultException {
        if (this.seqId == null) {
            throw new SequenceFaultException("Sequence ID is not set");
        }
        DOMUtils.addNamespaceDeclaration(element, this.getRmVersion().getPrefix(), this.getRmVersion().getNamespaceUri());
        WsrmConstants.Element element2 = WsrmConstants.Element.IDENTIFIER;
        DOMUtils.addValueNS(element, this.getRmVersion().getNamespaceUri(), element2.getQualifiedName(this.getRmVersion()), this.seqId);
    }

    public void readDetail(Element element) throws SequenceFaultException {
        try {
            WsrmConstants.Element element2 = WsrmConstants.Element.IDENTIFIER;
            this.seqId = DOMUtils.getValueByTagNameNS(element, this.getRmVersion().getNamespaceUri(), element2.getElementName());
        }
        catch (DOMProcessingException dOMProcessingException) {
            throw new SequenceFaultException("DOMProcessingException", (Throwable)((Object)dOMProcessingException));
        }
    }

    public String toString() {
        return this.getReason() + ": " + this.seqId;
    }
}

